/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Optional;
import com.gradleware.tooling.toolingmodel.OmniAccessRule;
import com.gradleware.tooling.toolingmodel.OmniClasspathAttribute;
import com.gradleware.tooling.toolingmodel.OmniExternalDependency;
import com.gradleware.tooling.toolingmodel.OmniGradleModuleVersion;
import com.gradleware.tooling.toolingmodel.repository.internal.AbstractOmniClasspathEntry;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniGradleModuleVersion;
import com.gradleware.tooling.toolingmodel.repository.internal.ForwardCompatibilityConverter;
import com.gradleware.tooling.toolingmodel.repository.internal.compatibility.ForwardCompatibilityClasspathEntry;
import com.gradleware.tooling.toolingmodel.util.Maybe;
import java.io.File;
import java.util.List;
import org.gradle.tooling.model.ExternalDependency;
import org.gradle.tooling.model.GradleModuleVersion;
import org.gradle.tooling.model.eclipse.EclipseClasspathEntry;
import org.gradle.tooling.model.eclipse.EclipseExternalDependency;

public final class DefaultOmniExternalDependency
extends AbstractOmniClasspathEntry
implements OmniExternalDependency {
    private final File file;
    private final File source;
    private final File javadoc;
    private final Maybe<OmniGradleModuleVersion> gradleModuleVersion;
    private final boolean exported;

    private DefaultOmniExternalDependency(File file, File source, File javadoc, Maybe<OmniGradleModuleVersion> gradleModuleVersion, boolean exported, Optional<List<OmniClasspathAttribute>> attributes, Optional<List<OmniAccessRule>> accessRules) {
        super(attributes, accessRules);
        this.file = file;
        this.source = source;
        this.javadoc = javadoc;
        this.gradleModuleVersion = gradleModuleVersion;
        this.exported = exported;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public File getSource() {
        return this.source;
    }

    @Override
    public File getJavadoc() {
        return this.javadoc;
    }

    @Override
    public Maybe<OmniGradleModuleVersion> getGradleModuleVersion() {
        return this.gradleModuleVersion;
    }

    @Override
    public boolean isExported() {
        return this.exported;
    }

    public static DefaultOmniExternalDependency from(EclipseExternalDependency externalDependency) {
        ForwardCompatibilityClasspathEntry compatibilityDependency = ForwardCompatibilityConverter.convert(externalDependency, ForwardCompatibilityClasspathEntry.class);
        return new DefaultOmniExternalDependency(externalDependency.getFile(), externalDependency.getSource(), externalDependency.getJavadoc(), DefaultOmniExternalDependency.getGradleModuleVersion((ExternalDependency)externalDependency), DefaultOmniExternalDependency.getIsExported((ExternalDependency)externalDependency), DefaultOmniExternalDependency.getClasspathAttributes((EclipseClasspathEntry)externalDependency), DefaultOmniExternalDependency.getAccessRules(compatibilityDependency));
    }

    private static Maybe<OmniGradleModuleVersion> getGradleModuleVersion(ExternalDependency externalDependency) {
        try {
            GradleModuleVersion gav = externalDependency.getGradleModuleVersion();
            return Maybe.of(DefaultOmniGradleModuleVersion.from(gav));
        }
        catch (Exception ignore) {
            return Maybe.absent();
        }
    }

    private static boolean getIsExported(ExternalDependency externalDependency) {
        try {
            return externalDependency.isExported();
        }
        catch (Exception ignore) {
            return true;
        }
    }
}

