/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.util.progress;

import org.eclipse.buildship.core.util.progress.ToolingApiCommand;
import org.eclipse.buildship.core.util.progress.ToolingApiInvoker;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;

public abstract class ToolingApiWorkspaceJob
extends WorkspaceJob {
    private final CancellationTokenSource tokenSource = GradleConnector.newCancellationTokenSource();
    private final String workName;
    private final boolean notifyUserAboutBuildFailures;

    protected ToolingApiWorkspaceJob(String name) {
        this(name, true);
    }

    protected ToolingApiWorkspaceJob(String name, boolean notifyUserAboutBuildFailures) {
        super(name);
        this.workName = name;
        this.notifyUserAboutBuildFailures = notifyUserAboutBuildFailures;
    }

    protected CancellationToken getToken() {
        return this.tokenSource.token();
    }

    public final IStatus runInWorkspace(final IProgressMonitor monitor) throws CoreException {
        ToolingApiInvoker invoker = new ToolingApiInvoker(this.workName, this.notifyUserAboutBuildFailures);
        return invoker.invoke(new ToolingApiCommand(){

            @Override
            public void run() throws Exception {
                ToolingApiWorkspaceJob.this.runToolingApiJobInWorkspace(monitor);
            }
        }, monitor);
    }

    protected abstract void runToolingApiJobInWorkspace(IProgressMonitor var1) throws Exception;

    protected void canceling() {
        this.tokenSource.cancel();
    }

    public boolean belongsTo(Object family) {
        return "org.eclipse.buildship.core.jobs".equals(family);
    }
}

