/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.gradle;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.ModelRepositoryProvider;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.console.ProcessStreamsProvider;
import org.eclipse.buildship.core.gradle.LoadEclipseGradleBuildJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public final class LoadEclipseGradleBuildsJob
extends Job {
    private final ModelRepositoryProvider modelRepositoryProvider;
    private final ProcessStreamsProvider processStreamsProvider;
    private final FetchStrategy modelFetchStrategy;
    private final ImmutableSet<ProjectConfiguration> configurations;
    private final FutureCallback<OmniEclipseGradleBuild> resultHandler;

    public LoadEclipseGradleBuildsJob(ModelRepositoryProvider modelRepositoryProvider, ProcessStreamsProvider processStreamsProvider, FetchStrategy modelFetchStrategy, Set<ProjectConfiguration> configurations, FutureCallback<OmniEclipseGradleBuild> resultHandler) {
        super("Loading tasks of all projects");
        this.modelRepositoryProvider = (ModelRepositoryProvider)Preconditions.checkNotNull((Object)modelRepositoryProvider);
        this.processStreamsProvider = (ProcessStreamsProvider)Preconditions.checkNotNull((Object)processStreamsProvider);
        this.modelFetchStrategy = (FetchStrategy)Preconditions.checkNotNull((Object)modelFetchStrategy);
        this.configurations = ImmutableSet.copyOf(configurations);
        this.resultHandler = (FutureCallback)Preconditions.checkNotNull(resultHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(final IProgressMonitor monitor) {
        monitor.beginTask("Load tasks of all projects", this.configurations.size());
        try {
            final CountDownLatch latch = new CountDownLatch(this.configurations.size());
            JobChangeAdapter jobListener = new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    latch.countDown();
                    monitor.worked(1);
                }
            };
            for (ProjectConfiguration configuration : this.configurations) {
                LoadEclipseGradleBuildJob loadProjectJob = new LoadEclipseGradleBuildJob(this.modelRepositoryProvider, this.processStreamsProvider, this.modelFetchStrategy, configuration, this.resultHandler);
                loadProjectJob.addJobChangeListener((IJobChangeListener)jobListener);
                loadProjectJob.schedule();
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Status status = new Status(4, "org.eclipse.buildship.core", "Loading the tasks of all projects failed.", (Throwable)e);
                monitor.done();
                return status;
            }
            IStatus iStatus = monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected void canceling() {
        Job.getJobManager().cancel((Object)LoadEclipseGradleBuildJob.class.getName());
    }

    public boolean belongsTo(Object family) {
        return this.getJobFamilyName().equals(family);
    }

    public boolean shouldRun() {
        return Job.getJobManager().find((Object)this.getJobFamilyName()).length <= 1;
    }

    private String getJobFamilyName() {
        return LoadEclipseGradleBuildsJob.class.getName();
    }
}

