/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.workspace.GradleClasspathContainer;
import org.eclipse.buildship.core.workspace.WorkspaceOperations;
import org.eclipse.buildship.core.workspace.internal.ResourceFilter;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public final class DefaultWorkspaceOperations
implements WorkspaceOperations {
    @Override
    public ImmutableList<IProject> getAllProjects() {
        return ImmutableList.copyOf((Object[])ResourcesPlugin.getWorkspace().getRoot().getProjects());
    }

    @Override
    public Optional<IProject> findProjectByName(final String name) {
        return FluentIterable.from(this.getAllProjects()).firstMatch((Predicate)new Predicate<IProject>(){

            public boolean apply(IProject project) {
                return project.getName().equals(name);
            }
        });
    }

    @Override
    public Optional<IProjectDescription> findProjectInFolder(File location, IProgressMonitor monitor) {
        if (location == null || !location.exists()) {
            return Optional.absent();
        }
        File dotProjectFile = new File(location, ".project");
        if (!dotProjectFile.exists() || !dotProjectFile.isFile()) {
            return Optional.absent();
        }
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            FileInputStream dotProjectStream = new FileInputStream(dotProjectFile);
            IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((InputStream)dotProjectStream);
            this.setProjectDescriptionLocationURI(location, description, workspace);
            return Optional.of((Object)description);
        }
        catch (Exception e) {
            String message = String.format("Cannot open existing Eclipse project from %s.", dotProjectFile.getAbsolutePath());
            throw new GradlePluginsRuntimeException(message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteAllProjects(IProgressMonitor monitor) {
        monitor = (IProgressMonitor)MoreObjects.firstNonNull((Object)monitor, (Object)new NullProgressMonitor());
        monitor.beginTask("Delete all Eclipse projects from workspace", 100);
        try {
            ImmutableList<IProject> allProjects = this.getAllProjects();
            for (IProject project : allProjects) {
                try {
                    project.delete(false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 100 / allProjects.size()));
                }
                catch (Exception e) {
                    String message = String.format("Cannot delete project %s.", project.getName());
                    throw new GradlePluginsRuntimeException(message, e);
                    return;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IProject createProject(String name, File location, List<File> filteredSubFolders, List<String> natureIds, IProgressMonitor monitor) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)location);
        Preconditions.checkNotNull(natureIds);
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Project name must not be empty.");
        Preconditions.checkArgument((boolean)location.exists(), (Object)String.format("Project location %s must exist.", location));
        Preconditions.checkArgument((boolean)location.isDirectory(), (Object)String.format("Project location %s must be a directory.", location));
        monitor = (IProgressMonitor)MoreObjects.firstNonNull((Object)monitor, (Object)new NullProgressMonitor());
        monitor.beginTask(String.format("Create Eclipse project %s", name), 4 + natureIds.size());
        try {
            Preconditions.checkState((!this.findProjectByName(name).isPresent() ? 1 : 0) != 0, (Object)String.format("Workspace already contains project with name %s.", name));
            monitor.worked(1);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProjectDescription projectDescription = workspace.newProjectDescription(name);
            this.setProjectDescriptionLocationURI(location, projectDescription, workspace);
            projectDescription.setComment(String.format("Project %s created by Buildship.", name));
            IProject project = workspace.getRoot().getProject(name);
            project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ResourceFilter.attachFilters(project, filteredSubFolders, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            for (String natureId : natureIds) {
                this.addNature(project, natureId, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            IProject iProject = project;
            return iProject;
        }
        catch (Exception e) {
            String message = String.format("Cannot create Eclipse project %s.", name);
            throw new GradlePluginsRuntimeException(message, e);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IProject includeProject(IProjectDescription projectDescription, List<File> filteredSubFolders, List<String> extraNatureIds, IProgressMonitor monitor) {
        Preconditions.checkNotNull((Object)projectDescription);
        Preconditions.checkNotNull(extraNatureIds);
        monitor = (IProgressMonitor)MoreObjects.firstNonNull((Object)monitor, (Object)new NullProgressMonitor());
        monitor.beginTask(String.format("Include existing Eclipse project %s", projectDescription.getName()), 2 + extraNatureIds.size());
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(projectDescription.getName());
            project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ResourceFilter.attachFilters(project, filteredSubFolders, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            for (String natureId : extraNatureIds) {
                this.addNature(project, natureId, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            IProject iProject = project;
            return iProject;
        }
        catch (Exception e) {
            String message = String.format("Cannot include existing Eclipse project %s.", projectDescription.getName());
            throw new GradlePluginsRuntimeException(message, e);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IJavaProject createJavaProject(IProject project, IPath jrePath, IProgressMonitor monitor) {
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkNotNull((Object)jrePath);
        Preconditions.checkArgument((boolean)project.isAccessible(), (Object)"Project must be open.");
        monitor = (IProgressMonitor)MoreObjects.firstNonNull((Object)monitor, (Object)new NullProgressMonitor());
        monitor.beginTask(String.format("Create Eclipse Java project %s", project.getName()), 17);
        try {
            this.addNature(project, "org.eclipse.jdt.core.javanature", (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            IJavaProject javaProject = JavaCore.create((IProject)project);
            monitor.worked(5);
            this.setClasspathOnProject(javaProject, jrePath, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
            IFolder outputFolder = this.createOutputFolder(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            javaProject.setOutputLocation(outputFolder.getFullPath(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            javaProject.save((IProgressMonitor)new SubProgressMonitor(monitor, 2), true);
            IJavaProject iJavaProject = javaProject;
            return iJavaProject;
        }
        catch (Exception e) {
            String message = String.format("Cannot create Eclipse Java project %s.", project.getName());
            throw new GradlePluginsRuntimeException(message, e);
        }
        finally {
            monitor.done();
        }
    }

    private void addNature(IProject project, String natureId, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Add nature %s to Eclipse project %s", natureId, project.getName()), 1);
        try {
            IProjectDescription description = project.getDescription();
            ImmutableList currentNatureIds = ImmutableList.copyOf((Object[])description.getNatureIds());
            if (currentNatureIds.contains(natureId)) {
                return;
            }
            ImmutableList newIds = ImmutableList.builder().addAll((Iterable)currentNatureIds).add((Object)natureId).build();
            description.setNatureIds((String[])newIds.toArray((Object[])new String[newIds.size()]));
            project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (CoreException e) {
            String message = String.format("Cannot add nature %s to Eclipse project %s.", natureId, project.getName());
            throw new GradlePluginsRuntimeException(message, (Exception)((Object)e));
        }
        finally {
            monitor.done();
        }
    }

    private IFolder createOutputFolder(IProject project, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Create output folder for Eclipse project %s", project.getName()), 1);
        try {
            IFolder outputFolder = project.getFolder("bin");
            if (!outputFolder.exists()) {
                outputFolder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            IFolder iFolder = outputFolder;
            return iFolder;
        }
        catch (Exception e) {
            String message = String.format("Cannot create output folder for Eclipse project %s.", project.getName());
            throw new GradlePluginsRuntimeException(message, e);
        }
        finally {
            monitor.done();
        }
    }

    private void setClasspathOnProject(IJavaProject javaProject, IPath jrePath, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Configure sources and classpath for Eclipse project %s", javaProject.getProject().getName()), 10);
        try {
            ImmutableList.Builder entries = ImmutableList.builder();
            entries.add((Object)JavaCore.newContainerEntry((IPath)jrePath));
            monitor.worked(1);
            entries.add((Object)GradleClasspathContainer.newClasspathEntry());
            monitor.worked(1);
            ImmutableList entriesArray = entries.build();
            javaProject.setRawClasspath(entriesArray.toArray(new IClasspathEntry[entriesArray.size()]), (IProgressMonitor)new SubProgressMonitor(monitor, 6));
        }
        catch (Exception e) {
            String message = String.format("Cannot configure sources and classpath for Eclipse project %s.", javaProject.getProject().getName());
            throw new GradlePluginsRuntimeException(message, e);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void refresh(IProject project, IProgressMonitor monitor) {
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkArgument((boolean)project.isAccessible(), (Object)"Project must be open.");
        monitor = (IProgressMonitor)MoreObjects.firstNonNull((Object)monitor, (Object)new NullProgressMonitor());
        monitor.beginTask(String.format("Refresh Eclipse project %s", project.getName()), 1);
        try {
            project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (Exception e) {
            String message = String.format("Cannot refresh Eclipse project %s.", project.getName());
            throw new GradlePluginsRuntimeException(message, e);
        }
        finally {
            monitor.done();
        }
    }

    private void setProjectDescriptionLocationURI(File location, IProjectDescription projectDescription, IWorkspace workspace) {
        IPath locationPath = Path.fromOSString((String)location.getPath());
        IPath rootLocationPath = workspace.getRoot().getLocation();
        if (rootLocationPath.equals(locationPath) || rootLocationPath.equals(locationPath.removeLastSegments(1))) {
            locationPath = null;
        }
        projectDescription.setLocation(locationPath);
    }
}

