/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingclient.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingclient.LongRunningOperationPromise;
import com.gradleware.tooling.toolingclient.ModelRequest;
import com.gradleware.tooling.toolingclient.internal.BaseRequest;
import com.gradleware.tooling.toolingclient.internal.ExecutableToolingClient;
import com.gradleware.tooling.toolingclient.internal.InspectableModelRequest;
import org.gradle.tooling.model.gradle.BuildInvocations;
import org.gradle.tooling.model.gradle.ProjectPublications;

final class DefaultModelRequest<T>
extends BaseRequest<T, DefaultModelRequest<T>>
implements InspectableModelRequest<T> {
    private static final Class<?>[] UNSUPPORTED_MODEL_TYPES = new Class[]{BuildInvocations.class, ProjectPublications.class};
    private final Class<T> modelType;
    private ImmutableList<String> tasks;

    DefaultModelRequest(ExecutableToolingClient toolingClient, Class<T> modelType) {
        super(toolingClient);
        this.modelType = (Class)Preconditions.checkNotNull(modelType);
        this.tasks = ImmutableList.of();
        this.ensureModelIsBuildScoped(modelType);
    }

    private void ensureModelIsBuildScoped(Class<T> modelType) {
        for (Class<?> unsupportedModelType : UNSUPPORTED_MODEL_TYPES) {
            if (unsupportedModelType != modelType) continue;
            throw new IllegalArgumentException(String.format("%s model does not support the Build scope", modelType.getSimpleName()));
        }
    }

    @Override
    public Class<T> getModelType() {
        return this.modelType;
    }

    @Override
    public DefaultModelRequest<T> tasks(String ... tasks) {
        this.tasks = ImmutableList.copyOf((Object[])tasks);
        return this.getThis();
    }

    @Override
    public String[] getTasks() {
        return (String[])this.tasks.toArray((Object[])new String[this.tasks.size()]);
    }

    @Override
    public <S> ModelRequest<S> deriveForModel(Class<S> modelType) {
        return ((DefaultModelRequest)this.copy(new DefaultModelRequest<S>(this.getToolingClient(), modelType))).tasks(this.getTasks());
    }

    @Override
    public T executeAndWait() {
        return this.getToolingClient().executeAndWait(this);
    }

    @Override
    public LongRunningOperationPromise<T> execute() {
        return this.getToolingClient().execute(this);
    }

    @Override
    DefaultModelRequest<T> getThis() {
        return this;
    }
}

