/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Arrays;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;

final class EclipseVmUtil {
    private static final String VM_ID_PREFIX = "org.eclipse.buildship.core.vm.";

    public static IVMInstall findOrRegisterStandardVM(String version, File location) {
        Preconditions.checkNotNull((Object)version);
        Preconditions.checkNotNull((Object)location);
        return EclipseVmUtil.findOrRegisterVM(version, location);
    }

    private static IVMInstall findOrRegisterVM(String version, File location) {
        Optional<IVMInstall> vm = EclipseVmUtil.findRegisteredVM(version);
        return vm.isPresent() ? (IVMInstall)vm.get() : EclipseVmUtil.registerNewVM("Java SE " + version, location);
    }

    private static Optional<IVMInstall> findRegisteredVM(String version) {
        Optional<IExecutionEnvironment> possibleExecutionEnvironment = EclipseVmUtil.findExecutionEnvironment(version);
        if (!possibleExecutionEnvironment.isPresent()) {
            return Optional.absent();
        }
        IExecutionEnvironment executionEnvironment = (IExecutionEnvironment)possibleExecutionEnvironment.get();
        IVMInstall defaultVm = executionEnvironment.getDefaultVM();
        if (defaultVm != null) {
            return Optional.of((Object)defaultVm);
        }
        IVMInstall firstVm = (IVMInstall)Iterables.getFirst(Arrays.asList(executionEnvironment.getCompatibleVMs()), null);
        return Optional.fromNullable((Object)firstVm);
    }

    public static Optional<IExecutionEnvironment> findExecutionEnvironment(String version) {
        String executionEnvironmentId = EclipseVmUtil.getExecutionEnvironmentId(version);
        for (IExecutionEnvironment executionEnvironment : JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments()) {
            if (!executionEnvironment.getId().equals(executionEnvironmentId)) continue;
            return Optional.of((Object)executionEnvironment);
        }
        return Optional.absent();
    }

    private static String getExecutionEnvironmentId(String version) {
        if ("1.1".equals(version)) {
            return "JRE-1.1";
        }
        if (Arrays.asList("1.5", "1.4", "1.3", "1.2").contains(version)) {
            return "J2SE-" + version;
        }
        return "JavaSE-" + version;
    }

    private static IVMInstall registerNewVM(String name, File location) {
        IVMInstallType installType = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
        String vmId = EclipseVmUtil.generateUniqueVMId(installType);
        VMStandin vm = new VMStandin(installType, vmId);
        vm.setName(name);
        vm.setInstallLocation(location);
        return vm.convertToRealVM();
    }

    private static String generateUniqueVMId(IVMInstallType type) {
        int counter = 1;
        String vmId = VM_ID_PREFIX + counter;
        while (type.findVMInstall(vmId) != null) {
            vmId = VM_ID_PREFIX + ++counter;
        }
        return vmId;
    }

    private EclipseVmUtil() {
    }
}

