/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingclient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.events.test.TestOperationDescriptor;

public final class TestConfig {
    private final ImmutableList<String> jvmTestClasses;
    private final ImmutableMap<String, Collection<String>> jvmTestMethods;
    private final ImmutableList<? extends TestOperationDescriptor> tests;

    private TestConfig(List<String> jvmTestClasses, Map<String, Collection<String>> jvmTestMethods, List<? extends TestOperationDescriptor> tests) {
        this.jvmTestClasses = ImmutableList.copyOf(jvmTestClasses);
        this.jvmTestMethods = ImmutableMap.copyOf(jvmTestMethods);
        this.tests = ImmutableList.copyOf(tests);
        this.checkNotAllEmpty(jvmTestClasses, jvmTestMethods, tests);
    }

    private void checkNotAllEmpty(List<String> jvmTestClasses, Map<String, Collection<String>> jvmTestMethods, List<? extends TestOperationDescriptor> tests) {
        Preconditions.checkArgument((!jvmTestClasses.isEmpty() || !jvmTestMethods.isEmpty() || !tests.isEmpty() ? 1 : 0) != 0, (Object)"Either JVM test classes, JVM test methods, test operations, or any combination of them must be specified.");
    }

    public void apply(TestLauncher testLauncher) {
        Preconditions.checkNotNull((Object)testLauncher);
        testLauncher.withJvmTestClasses(this.jvmTestClasses);
        for (String jvmTestClass : this.jvmTestMethods.keySet()) {
            testLauncher.withJvmTestMethods(jvmTestClass, (Iterable)this.jvmTestMethods.get((Object)jvmTestClass));
        }
        testLauncher.withTests(this.tests);
    }

    public static TestConfig forJvmTestClasses(String ... jvmTestClasses) {
        return new Builder().jvmTestClasses(jvmTestClasses).build();
    }

    public static TestConfig forJvmTestClasses(Iterable<String> jvmTestClasses) {
        return new Builder().jvmTestClasses(jvmTestClasses).build();
    }

    public static TestConfig forJvmTestMethods(String jvmTestClass, String ... jvmTestMethods) {
        return new Builder().jvmTestMethods(jvmTestClass, jvmTestMethods).build();
    }

    public static TestConfig forJvmTestMethods(String jvmTestClass, Iterable<String> jvmTestMethods) {
        return new Builder().jvmTestMethods(jvmTestClass, jvmTestMethods).build();
    }

    public static TestConfig forTests(TestOperationDescriptor ... tests) {
        return new Builder().tests(tests).build();
    }

    public static TestConfig forTests(Iterable<? extends TestOperationDescriptor> tests) {
        return new Builder().tests(tests).build();
    }

    public static final class Builder {
        private final ImmutableList.Builder<String> jvmTestClasses = ImmutableList.builder();
        private final ArrayListMultimap<String, String> jvmTestMethods = ArrayListMultimap.create();
        private final ImmutableList.Builder<TestOperationDescriptor> tests = ImmutableList.builder();

        public Builder jvmTestClasses(String ... jvmTestClasses) {
            this.jvmTestClasses.addAll(Arrays.asList(jvmTestClasses));
            return this;
        }

        public Builder jvmTestClasses(Iterable<String> jvmTestClasses) {
            this.jvmTestClasses.addAll(jvmTestClasses);
            return this;
        }

        public Builder jvmTestMethods(String jvmTestClass, String ... jvmTestMethods) {
            this.jvmTestMethods.putAll((Object)jvmTestClass, Arrays.asList(jvmTestMethods));
            return this;
        }

        public Builder jvmTestMethods(String jvmTestClass, Iterable<String> jvmTestMethods) {
            this.jvmTestMethods.putAll((Object)jvmTestClass, jvmTestMethods);
            return this;
        }

        public Builder tests(TestOperationDescriptor ... tests) {
            this.tests.addAll(Arrays.asList(tests));
            return this;
        }

        public Builder tests(Iterable<? extends TestOperationDescriptor> tests) {
            this.tests.addAll(tests);
            return this;
        }

        public TestConfig build() {
            return new TestConfig((List)this.jvmTestClasses.build(), this.jvmTestMethods.asMap(), (List)this.tests.build());
        }
    }
}

