/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.imageprovider;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ListResourceBundle;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public enum FordiacImage {
    MISSING,
    ICON_4DIAC_16,
    ICON_4DIAC_32,
    ICON_4DIAC_FORTE,
    ICON_ADAPTER_LIST,
    ICON_ADAPTER_TYPE,
    ICON_ADD_STATE,
    ICON_ALGORITHM,
    ICON_APPLICATION,
    ICON_ATTRIBUTE_DECLARATION,
    ICON_BASIC_FB,
    ICON_BUILD_FORTE,
    ICON_BULK_EDITOR,
    ICON_CLEAR_DEVICE,
    ICON_CLEAR_FORCE,
    ICON_CLEAR_FORCE_DISABLED,
    ICON_COMPOSITE_FB,
    ICON_DATA,
    ICON_DATA_INPUT,
    ICON_DATA_TYPE,
    ICON_DATA_OUTPUT,
    ICON_DELETE_RESOURCE,
    ICON_DEVICE,
    ICON_DEVICE_RESTART,
    ICON_DISCOVER,
    ICON_DOCUMENTATION_EDITOR,
    ICON_EC_ACTION,
    ICON_ECC,
    ICON_EC_STATE,
    ICON_EVENT,
    ICON_EVENT_INPUT,
    ICON_EVENT_OUTPUT,
    ICON_EXPAND_ALL,
    ICON_EXPORT,
    ICON_FB,
    ICON_FB_TYPE,
    ICON_FB_NETWORK,
    ICON_FIRMWARE_RESOURCE,
    ICON_FMU,
    ICON_FORCE_VALUE,
    ICON_FUNCTION,
    ICON_GLOBAL_CONST,
    ICON_GROUP,
    ICON_HIDE_DATA,
    ICON_HIDE_EVENT,
    ICON_INTERFACE_EDITOR,
    ICON_INTERFACE_LIST,
    ICON_KILL_DEVICE,
    ICON_RUNTIME_LAUNCHER,
    ICON_LAUNCH_CONFIG_OVERLAY,
    ICON_LEFT_INPUT_PRIMITIVE,
    ICON_LEFT_OUTPUT_PRIMITIVE,
    ICON_LINKED_LIBRARY,
    ICON_LINK_OUTPUT,
    ICON_LINK_INPUT,
    ICON_LOCKED_STATE,
    ICON_MONITORING_DECORATOR,
    ICON_NEW_4DIAC_PROJECT,
    ICON_NEW_APPLICATION,
    ICON_NEW_FUNCTIONBLOCK,
    ICON_NEW_SYSTEM,
    ICON_PIN,
    ICON_PINNED,
    ICON_PLUGS,
    ICON_PROPERTIES,
    ICON_REFRESH,
    ICON_REMOVE_WATCH,
    ICON_RESOURCE,
    ICON_RIGHT_INPUT_PRIMITIVE,
    ICON_RIGHT_OUTPUT_PRIMITIVE,
    ICON_SEGMENT,
    ICON_SERVICE,
    ICON_SERVICE_SEQUENCE,
    ICON_SIFB,
    ICON_SIMPLE_FB,
    ICON_SUB_APP,
    ICON_SUB_APP_TYPE,
    ICON_SOCKETS,
    ICON_START,
    ICON_START_MONITORING,
    ICON_STOP,
    ICON_STOP_FORTE,
    ICON_SYSTEM,
    ICON_SYSTEM_CONFIGURATION,
    ICON_SYSTEM_EXPLORER,
    ICON_SYSTEM_PERSPECTIVE,
    ICON_TYPE_NAVIGATOR,
    ICON_TRANSACTION,
    ICON_TRIGGER_EVENT,
    ICON_WATCHES_VIEW,
    ICON_WATCHPOINT,
    ICON_WATCHPOINT_DISABLED,
    ICON_WATCHPOINT_DISABLED_OVERLAY,
    ICON_WATCHPOINT_FORCE_DISABLED_OVERLAY,
    ICON_WATCHPOINT_FORCE_OVERLAY,
    ICON_WATCHPOINT_OVERLAY,
    ICON_WATCH_INTERFACE_ELEMENTS,
    ICON_WHOLE_WORD,
    ICON_ZOOM_100,
    ICON_ZOOM_PAGE,
    ICON_TesterTemplate,
    OVERLAY_DISTRIBUTED_NATURE;

    private static final String IMAGES_DIRECTORY = "images";
    private static final String FORDIAC_IMAGE_PROPERTIES = "fordiacimages";
    private static ResourceBundle fordiacImageProperties;
    private static Bundle bundle;

    static {
        fordiacImageProperties = FordiacImage.getFordiacImageProperties();
        bundle = null;
    }

    private static final ResourceBundle getFordiacImageProperties() {
        try {
            return ResourceBundle.getBundle(FORDIAC_IMAGE_PROPERTIES);
        }
        catch (MissingResourceException e) {
            FordiacLogHelper.logWarning("Unable to load fordiacimages.properties from image-fragment.", e);
            return new ListResourceBundle(){

                @Override
                protected Object[][] getContents() {
                    return new Object[0][];
                }
            };
        }
    }

    private static synchronized Bundle getBundle() {
        if (bundle == null) {
            bundle = FrameworkUtil.getBundle(FordiacImage.class);
        }
        return bundle;
    }

    public Image getImage() {
        Image image = JFaceResources.getImageRegistry().get(this.name());
        if (image == null) {
            image = FordiacImage.addImageDescriptor(this.name()) ? JFaceResources.getImageRegistry().get(this.name()) : FordiacImage.getErrorImage();
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor() {
        ImageDescriptor id = JFaceResources.getImageRegistry().getDescriptor(this.name());
        if (id == null) {
            id = FordiacImage.addImageDescriptor(this.name()) ? JFaceResources.getImageRegistry().getDescriptor(this.name()) : FordiacImage.getErrorImageDescriptor();
        }
        return id;
    }

    public InputStream getImageAsInputStream() throws IOException {
        URL fileLocation = FordiacImage.getImageURL(this.name());
        if (fileLocation != null) {
            return fileLocation.openConnection().getInputStream();
        }
        return MISSING.getImageAsInputStream();
    }

    private static boolean addImageDescriptor(String name) {
        try {
            URL fileLocation = FordiacImage.getImageURL(name);
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)fileLocation);
            JFaceResources.getImageRegistry().put(name, id);
        }
        catch (IllegalArgumentException | MissingResourceException e) {
            FordiacLogHelper.logError("Could not load image", e);
            return false;
        }
        return true;
    }

    private static URL getImageURL(String name) {
        String fileName = fordiacImageProperties.getString(name);
        return FileLocator.find((Bundle)FordiacImage.getBundle(), (IPath)new Path("images/" + fileName), null);
    }

    private static Image getErrorImage() {
        ISharedImages si = PlatformUI.getWorkbench().getSharedImages();
        return si.getImage("IMG_OBJS_ERROR_TSK");
    }

    private static ImageDescriptor getErrorImageDescriptor() {
        ISharedImages si = PlatformUI.getWorkbench().getSharedImages();
        return si.getImageDescriptor("IMG_OBJS_ERROR_TSK");
    }

    public static DecorationOverlayIcon createOverlayImage(Image image, ImageDescriptor imageDescriptor) {
        return FordiacImage.createOverlayImage(image, imageDescriptor, 0);
    }

    public static DecorationOverlayIcon createOverlayImage(Image image, ImageDescriptor imageDescriptor, int quadrant) {
        return new DecorationOverlayIcon(image, imageDescriptor, quadrant);
    }
}

