/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextalgorithm.scoping;

import com.google.common.base.Function;
import com.google.inject.Inject;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.STMethod;
import org.eclipse.fordiac.ide.structuredtextcore.resource.LibraryElementXtextResource;
import org.eclipse.fordiac.ide.structuredtextcore.scoping.STCoreImportedNamespaceAwareLocalScopeProvider;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.MultimapBasedSelectable;

public class STAlgorithmImportedNamespaceAwareLocalScopeProvider
extends STCoreImportedNamespaceAwareLocalScopeProvider {
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;

    public List<ImportNormalizer> internalGetImportedNamespaceResolvers(EObject context, boolean ignoreCase) {
        CompilerInfo compilerInfo;
        List result = super.internalGetImportedNamespaceResolvers(context, ignoreCase);
        if (context.eContainer() == null && (compilerInfo = STAlgorithmImportedNamespaceAwareLocalScopeProvider.getCompilerInfo(context)) != null) {
            QualifiedName name;
            String packageName = compilerInfo.getPackageName();
            if (packageName != null && !packageName.isEmpty() && (name = this.getQualifiedNameConverter().toQualifiedName(packageName)) != null && !name.isEmpty()) {
                result.add(this.doCreateImportNormalizer(name, true, ignoreCase));
            }
            result.addAll(super.internalGetImportedNamespaceResolvers((EObject)compilerInfo, ignoreCase));
        }
        return result;
    }

    protected static CompilerInfo getCompilerInfo(EObject context) {
        Resource resource = context.eResource();
        if (resource instanceof LibraryElementXtextResource) {
            LibraryElementXtextResource libraryElementXtextResource = (LibraryElementXtextResource)resource;
            return STAlgorithmImportedNamespaceAwareLocalScopeProvider.getCompilerInfo(libraryElementXtextResource.getInternalLibraryElement());
        }
        return null;
    }

    protected static CompilerInfo getCompilerInfo(LibraryElement libraryElement) {
        if (libraryElement != null) {
            return libraryElement.getCompilerInfo();
        }
        return null;
    }

    protected ISelectable internalGetAllDescriptions(Resource resource) {
        Iterable allContents = () -> Spliterators.iterator(new STAlgorithmResourceContentsSpliterator(resource));
        Iterable allDescriptions = Scopes.scopedElementsFor(allContents, (Function)this.qualifiedNameProvider);
        return new MultimapBasedSelectable(allDescriptions);
    }

    public boolean isRelativeImport() {
        return false;
    }

    protected static class STAlgorithmResourceContentsSpliterator
    implements Spliterator<EObject> {
        private final TreeIterator<EObject> delegate;

        public STAlgorithmResourceContentsSpliterator(Resource resource) {
            this.delegate = EcoreUtil.getAllContents((Resource)resource, (boolean)false);
        }

        @Override
        public boolean tryAdvance(Consumer<? super EObject> action) {
            while (this.delegate.hasNext()) {
                EObject eObject = (EObject)this.delegate.next();
                if (this.filter(eObject)) {
                    action.accept((EObject)eObject);
                    return true;
                }
                this.delegate.prune();
            }
            return false;
        }

        protected boolean filter(EObject eObject) {
            return !(eObject instanceof STAlgorithm) && !(eObject instanceof STMethod) && !(eObject instanceof FBNetwork);
        }

        @Override
        public Spliterator<EObject> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 1297;
        }
    }
}

