/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.fordiac.ide.model.data.AnyBitType;
import org.eclipse.fordiac.ide.model.data.AnyCharType;
import org.eclipse.fordiac.ide.model.data.AnyCharsType;
import org.eclipse.fordiac.ide.model.data.AnyDateType;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.AnyDurationType;
import org.eclipse.fordiac.ide.model.data.AnyElementaryType;
import org.eclipse.fordiac.ide.model.data.AnyIntType;
import org.eclipse.fordiac.ide.model.data.AnyMagnitudeType;
import org.eclipse.fordiac.ide.model.data.AnyNumType;
import org.eclipse.fordiac.ide.model.data.AnyRealType;
import org.eclipse.fordiac.ide.model.data.AnySignedType;
import org.eclipse.fordiac.ide.model.data.AnyStringType;
import org.eclipse.fordiac.ide.model.data.AnyType;
import org.eclipse.fordiac.ide.model.data.AnyUnsignedType;
import org.eclipse.fordiac.ide.model.data.ArrayType;
import org.eclipse.fordiac.ide.model.data.BoolType;
import org.eclipse.fordiac.ide.model.data.ByteType;
import org.eclipse.fordiac.ide.model.data.CharType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.DateAndTimeType;
import org.eclipse.fordiac.ide.model.data.DateType;
import org.eclipse.fordiac.ide.model.data.DintType;
import org.eclipse.fordiac.ide.model.data.DwordType;
import org.eclipse.fordiac.ide.model.data.EnumeratedType;
import org.eclipse.fordiac.ide.model.data.EnumeratedValue;
import org.eclipse.fordiac.ide.model.data.IntType;
import org.eclipse.fordiac.ide.model.data.LdateType;
import org.eclipse.fordiac.ide.model.data.LdtType;
import org.eclipse.fordiac.ide.model.data.LintType;
import org.eclipse.fordiac.ide.model.data.LrealType;
import org.eclipse.fordiac.ide.model.data.LtimeType;
import org.eclipse.fordiac.ide.model.data.LtodType;
import org.eclipse.fordiac.ide.model.data.LwordType;
import org.eclipse.fordiac.ide.model.data.RealType;
import org.eclipse.fordiac.ide.model.data.SintType;
import org.eclipse.fordiac.ide.model.data.StringType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.data.TimeOfDayType;
import org.eclipse.fordiac.ide.model.data.TimeType;
import org.eclipse.fordiac.ide.model.data.UdintType;
import org.eclipse.fordiac.ide.model.data.UintType;
import org.eclipse.fordiac.ide.model.data.UlintType;
import org.eclipse.fordiac.ide.model.data.UsintType;
import org.eclipse.fordiac.ide.model.data.WcharType;
import org.eclipse.fordiac.ide.model.data.WordType;
import org.eclipse.fordiac.ide.model.data.WstringType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.Messages;
import org.eclipse.fordiac.ide.model.eval.value.AnyBitValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyCharValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyCharsValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyDateValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyDerivedValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyDurationValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyElementaryValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyIntValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyMagnitudeValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyNumValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyRealValue;
import org.eclipse.fordiac.ide.model.eval.value.AnySignedValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyStringValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyUnsignedValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyValue;
import org.eclipse.fordiac.ide.model.eval.value.ArrayValue;
import org.eclipse.fordiac.ide.model.eval.value.BoolValue;
import org.eclipse.fordiac.ide.model.eval.value.ByteValue;
import org.eclipse.fordiac.ide.model.eval.value.CharValue;
import org.eclipse.fordiac.ide.model.eval.value.DIntValue;
import org.eclipse.fordiac.ide.model.eval.value.DWordValue;
import org.eclipse.fordiac.ide.model.eval.value.DateAndTimeValue;
import org.eclipse.fordiac.ide.model.eval.value.DateValue;
import org.eclipse.fordiac.ide.model.eval.value.EnumValue;
import org.eclipse.fordiac.ide.model.eval.value.FBValue;
import org.eclipse.fordiac.ide.model.eval.value.IntValue;
import org.eclipse.fordiac.ide.model.eval.value.LDateAndTimeValue;
import org.eclipse.fordiac.ide.model.eval.value.LDateValue;
import org.eclipse.fordiac.ide.model.eval.value.LIntValue;
import org.eclipse.fordiac.ide.model.eval.value.LRealValue;
import org.eclipse.fordiac.ide.model.eval.value.LTimeOfDayValue;
import org.eclipse.fordiac.ide.model.eval.value.LTimeValue;
import org.eclipse.fordiac.ide.model.eval.value.LWordValue;
import org.eclipse.fordiac.ide.model.eval.value.RealValue;
import org.eclipse.fordiac.ide.model.eval.value.SIntValue;
import org.eclipse.fordiac.ide.model.eval.value.StringValue;
import org.eclipse.fordiac.ide.model.eval.value.StructValue;
import org.eclipse.fordiac.ide.model.eval.value.TimeOfDayValue;
import org.eclipse.fordiac.ide.model.eval.value.TimeValue;
import org.eclipse.fordiac.ide.model.eval.value.UDIntValue;
import org.eclipse.fordiac.ide.model.eval.value.UIntValue;
import org.eclipse.fordiac.ide.model.eval.value.ULIntValue;
import org.eclipse.fordiac.ide.model.eval.value.USIntValue;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.WCharValue;
import org.eclipse.fordiac.ide.model.eval.value.WStringValue;
import org.eclipse.fordiac.ide.model.eval.value.WordValue;
import org.eclipse.fordiac.ide.model.eval.variable.ArrayVariable;
import org.eclipse.fordiac.ide.model.eval.variable.StructVariable;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.value.TypedValue;
import org.eclipse.fordiac.ide.model.value.TypedValueConverter;

public final class ValueOperations {
    public static Value abs(Value value) {
        Value value2 = value;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LRealValue.class, RealValue.class, LIntValue.class, DIntValue.class, IntValue.class, SIntValue.class, ULIntValue.class, UDIntValue.class, UIntValue.class, USIntValue.class, LTimeValue.class, TimeValue.class}, (Object)value2, 0)) {
            case 0 -> {
                LRealValue lrealValue = (LRealValue)value2;
                yield LRealValue.toLRealValue(Math.abs(lrealValue.doubleValue()));
            }
            case 1 -> {
                RealValue realValue = (RealValue)value2;
                yield RealValue.toRealValue(Math.abs(realValue.floatValue()));
            }
            case 2 -> {
                LIntValue lintValue = (LIntValue)value2;
                yield LIntValue.toLIntValue(Math.abs(lintValue.longValue()));
            }
            case 3 -> {
                DIntValue dintValue = (DIntValue)value2;
                yield DIntValue.toDIntValue(Math.abs(dintValue.intValue()));
            }
            case 4 -> {
                IntValue intValue = (IntValue)value2;
                yield IntValue.toIntValue((short)Math.abs(intValue.shortValue()));
            }
            case 5 -> {
                SIntValue sintValue = (SIntValue)value2;
                yield SIntValue.toSIntValue((byte)Math.abs(sintValue.byteValue()));
            }
            case 6 -> {
                ULIntValue ulintValue;
                yield ulintValue = (ULIntValue)value2;
            }
            case 7 -> {
                UDIntValue udintValue = (UDIntValue)value2;
                yield udintValue;
            }
            case 8 -> {
                UIntValue uintValue = (UIntValue)value2;
                yield uintValue;
            }
            case 9 -> {
                USIntValue usintValue = (USIntValue)value2;
                yield usintValue;
            }
            case 10 -> {
                LTimeValue ltimeValue = (LTimeValue)value2;
                yield LTimeValue.toLTimeValue(ltimeValue.longValue());
            }
            case 11 -> {
                TimeValue timeValue = (TimeValue)value2;
                yield TimeValue.toTimeValue(timeValue.longValue());
            }
            default -> throw ValueOperations.createUnsupportedUnaryOperationException(Messages.ValueOperations_Absolute, value);
        };
    }

    public static Value negate(Value value) {
        Value value2 = value;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LRealValue.class, RealValue.class, LIntValue.class, DIntValue.class, IntValue.class, SIntValue.class, ULIntValue.class, UDIntValue.class, UIntValue.class, USIntValue.class, LTimeValue.class, TimeValue.class}, (Object)value2, 0)) {
            case 0 -> {
                LRealValue lrealValue = (LRealValue)value2;
                yield LRealValue.toLRealValue(-lrealValue.doubleValue());
            }
            case 1 -> {
                RealValue realValue = (RealValue)value2;
                yield RealValue.toRealValue(-realValue.floatValue());
            }
            case 2 -> {
                LIntValue lintValue = (LIntValue)value2;
                yield LIntValue.toLIntValue(-lintValue.longValue());
            }
            case 3 -> {
                DIntValue dintValue = (DIntValue)value2;
                yield DIntValue.toDIntValue(-dintValue.intValue());
            }
            case 4 -> {
                IntValue intValue = (IntValue)value2;
                yield IntValue.toIntValue(-intValue.shortValue());
            }
            case 5 -> {
                SIntValue sintValue = (SIntValue)value2;
                yield SIntValue.toSIntValue(-sintValue.byteValue());
            }
            case 6 -> {
                ULIntValue ulintValue = (ULIntValue)value2;
                yield ULIntValue.toULIntValue(-ulintValue.longValue());
            }
            case 7 -> {
                UDIntValue udintValue = (UDIntValue)value2;
                yield UDIntValue.toUDIntValue(-udintValue.intValue());
            }
            case 8 -> {
                UIntValue uintValue = (UIntValue)value2;
                yield UIntValue.toUIntValue(-uintValue.shortValue());
            }
            case 9 -> {
                USIntValue usintValue = (USIntValue)value2;
                yield USIntValue.toUSIntValue(-usintValue.byteValue());
            }
            case 10 -> {
                LTimeValue ltimeValue = (LTimeValue)value2;
                yield LTimeValue.toLTimeValue(-ltimeValue.longValue());
            }
            case 11 -> {
                TimeValue timeValue = (TimeValue)value2;
                yield TimeValue.toTimeValue(-timeValue.longValue());
            }
            default -> throw ValueOperations.createUnsupportedUnaryOperationException(Messages.ValueOperations_Negate, value);
        };
    }

    public static Value bitwiseNot(Value value) {
        Value value2 = value;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LWordValue.class, DWordValue.class, WordValue.class, ByteValue.class, BoolValue.class}, (Object)value2, 0)) {
            case 0 -> {
                LWordValue lwordValue = (LWordValue)value2;
                yield LWordValue.toLWordValue(lwordValue.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
            }
            case 1 -> {
                DWordValue dwordValue = (DWordValue)value2;
                yield DWordValue.toDWordValue(~dwordValue.intValue());
            }
            case 2 -> {
                WordValue wordValue = (WordValue)value2;
                yield WordValue.toWordValue((short)(~wordValue.intValue()));
            }
            case 3 -> {
                ByteValue byteValue = (ByteValue)value2;
                yield ByteValue.toByteValue((byte)(~byteValue.intValue()));
            }
            case 4 -> {
                BoolValue boolValue = (BoolValue)value2;
                yield BoolValue.toBoolValue(!boolValue.boolValue());
            }
            default -> throw ValueOperations.createUnsupportedUnaryOperationException(Messages.ValueOperations_Not, value);
        };
    }

    public static Value reverseBytes(Value value) {
        Value value2 = value;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LRealValue.class, RealValue.class, LIntValue.class, DIntValue.class, IntValue.class, SIntValue.class, ULIntValue.class, UDIntValue.class, UIntValue.class, USIntValue.class, LTimeValue.class, TimeValue.class, LWordValue.class, DWordValue.class, WordValue.class, ByteValue.class, BoolValue.class, StringValue.class, CharValue.class, WStringValue.class, WCharValue.class, LDateValue.class, DateValue.class, LTimeOfDayValue.class, TimeOfDayValue.class, LDateAndTimeValue.class, DateAndTimeValue.class, ArrayValue.class, StructValue.class}, (Object)value2, 0)) {
            case 0 -> {
                LRealValue lrealValue = (LRealValue)value2;
                yield LRealValue.toLRealValue(Double.longBitsToDouble(Long.reverseBytes(Double.doubleToRawLongBits(lrealValue.doubleValue()))));
            }
            case 1 -> {
                RealValue realValue = (RealValue)value2;
                yield RealValue.toRealValue(Float.intBitsToFloat(Integer.reverseBytes(Float.floatToRawIntBits(realValue.floatValue()))));
            }
            case 2 -> {
                LIntValue lintValue = (LIntValue)value2;
                yield LIntValue.toLIntValue(Long.reverseBytes(lintValue.longValue()));
            }
            case 3 -> {
                DIntValue dintValue = (DIntValue)value2;
                yield DIntValue.toDIntValue(Integer.reverseBytes(dintValue.intValue()));
            }
            case 4 -> {
                IntValue intValue = (IntValue)value2;
                yield IntValue.toIntValue(Short.reverseBytes(intValue.shortValue()));
            }
            case 5 -> {
                SIntValue sintValue;
                yield sintValue = (SIntValue)value2;
            }
            case 6 -> {
                ULIntValue ulintValue = (ULIntValue)value2;
                yield ULIntValue.toULIntValue(Long.reverseBytes(ulintValue.longValue()));
            }
            case 7 -> {
                UDIntValue udintValue = (UDIntValue)value2;
                yield UDIntValue.toUDIntValue(Integer.reverseBytes(udintValue.intValue()));
            }
            case 8 -> {
                UIntValue uintValue = (UIntValue)value2;
                yield UIntValue.toUIntValue(Short.reverseBytes(uintValue.shortValue()));
            }
            case 9 -> {
                USIntValue usintValue = (USIntValue)value2;
                yield usintValue;
            }
            case 10 -> {
                LTimeValue ltimeValue = (LTimeValue)value2;
                yield LTimeValue.toLTimeValue(Long.reverseBytes(ltimeValue.longValue()));
            }
            case 11 -> {
                TimeValue timeValue = (TimeValue)value2;
                yield TimeValue.toTimeValue(Long.reverseBytes(timeValue.longValue()));
            }
            case 12 -> {
                LWordValue lwordValue = (LWordValue)value2;
                yield LWordValue.toLWordValue(Long.reverseBytes(lwordValue.longValue()));
            }
            case 13 -> {
                DWordValue dwordValue = (DWordValue)value2;
                yield DWordValue.toDWordValue(Integer.reverseBytes(dwordValue.intValue()));
            }
            case 14 -> {
                WordValue wordValue = (WordValue)value2;
                yield WordValue.toWordValue(Short.reverseBytes(wordValue.shortValue()));
            }
            case 15 -> {
                ByteValue byteValue = (ByteValue)value2;
                yield byteValue;
            }
            case 16 -> {
                BoolValue boolValue = (BoolValue)value2;
                yield boolValue;
            }
            case 17 -> {
                StringValue stringValue = (StringValue)value2;
                yield stringValue;
            }
            case 18 -> {
                CharValue charValue = (CharValue)value2;
                yield charValue;
            }
            case 19 -> {
                WStringValue wstringValue = (WStringValue)value2;
                yield WStringValue.toWStringValue(new String(wstringValue.stringValue().getBytes(StandardCharsets.UTF_16BE), StandardCharsets.UTF_16LE));
            }
            case 20 -> {
                WCharValue wcharValue = (WCharValue)value2;
                yield WCharValue.toWCharValue(Character.reverseBytes(wcharValue.charValue()));
            }
            case 21 -> {
                LDateValue ldateValue = (LDateValue)value2;
                yield ldateValue;
            }
            case 22 -> {
                DateValue dateValue = (DateValue)value2;
                yield dateValue;
            }
            case 23 -> {
                LTimeOfDayValue ltimeOfDayValue = (LTimeOfDayValue)value2;
                yield ltimeOfDayValue;
            }
            case 24 -> {
                TimeOfDayValue timeOfDayValue = (TimeOfDayValue)value2;
                yield timeOfDayValue;
            }
            case 25 -> {
                LDateAndTimeValue ldateAndTimeValue = (LDateAndTimeValue)value2;
                yield ldateAndTimeValue;
            }
            case 26 -> {
                DateAndTimeValue dateAndTimeValue = (DateAndTimeValue)value2;
                yield dateAndTimeValue;
            }
            case 27 -> {
                ArrayValue arrayValue = (ArrayValue)value2;
                ArrayVariable temp = new ArrayVariable("TEMP", arrayValue.getType(), arrayValue);
                temp.forEach(variable -> variable.setValue(ValueOperations.reverseBytes(variable.getValue())));
                yield temp.getValue();
            }
            case 28 -> {
                StructValue structValue = (StructValue)value2;
                StructVariable temp = new StructVariable("TEMP", structValue.getType(), structValue);
                temp.forEach(variable -> variable.setValue(ValueOperations.reverseBytes(variable.getValue())));
                yield temp.getValue();
            }
            default -> throw ValueOperations.createUnsupportedUnaryOperationException(Messages.ValueOperations_ReverseBytes, value);
        };
    }

    public static Value sqrt(Value value) {
        Value value2 = value;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LRealValue.class, RealValue.class}, (Object)value2, 0)) {
            case 0 -> {
                LRealValue lrealValue = (LRealValue)value2;
                yield LRealValue.toLRealValue(Math.sqrt(lrealValue.doubleValue()));
            }
            case 1 -> {
                RealValue realValue = (RealValue)value2;
                yield RealValue.toRealValue((float)Math.sqrt(realValue.floatValue()));
            }
            default -> throw ValueOperations.createUnsupportedUnaryOperationException(Messages.ValueOperations_Sqrt, value);
        };
    }

    public static Value add(Value first, Value second) {
        if (first instanceof AnyMagnitudeValue) {
            AnyMagnitudeValue firstAnyMagnitudeValue = (AnyMagnitudeValue)first;
            if (second instanceof AnyMagnitudeValue) {
                AnyMagnitudeValue secondAnyMagnitudeValue = (AnyMagnitudeValue)second;
                return ValueOperations.add(firstAnyMagnitudeValue, secondAnyMagnitudeValue);
            }
        } else if (first instanceof AnyDateValue) {
            AnyDateValue firstAnyDateValue = (AnyDateValue)first;
            if (second instanceof TimeValue) {
                TimeValue secondTimeValue = (TimeValue)second;
                return ValueOperations.add(firstAnyDateValue, secondTimeValue);
            }
            if (second instanceof LTimeValue) {
                LTimeValue secondLTimeValue = (LTimeValue)second;
                return ValueOperations.add(firstAnyDateValue, secondLTimeValue);
            }
        }
        throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Add, first, second);
    }

    private static AnyMagnitudeValue add(AnyMagnitudeValue first, AnyMagnitudeValue second) {
        DataType dataType = ValueOperations.resultType((DataType)first.getType(), (DataType)second.getType());
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LrealType.class, RealType.class, LintType.class, DintType.class, IntType.class, SintType.class, UlintType.class, UdintType.class, UintType.class, UsintType.class, LtimeType.class, TimeType.class}, (Object)dataType, 0)) {
            case 0 -> {
                LrealType unused = (LrealType)dataType;
                yield LRealValue.toLRealValue(first.doubleValue() + second.doubleValue());
            }
            case 1 -> {
                RealType unused = (RealType)dataType;
                yield RealValue.toRealValue(first.floatValue() + second.floatValue());
            }
            case 2 -> {
                LintType unused = (LintType)dataType;
                yield LIntValue.toLIntValue(first.longValue() + second.longValue());
            }
            case 3 -> {
                DintType unused = (DintType)dataType;
                yield DIntValue.toDIntValue(first.intValue() + second.intValue());
            }
            case 4 -> {
                IntType unused = (IntType)dataType;
                yield IntValue.toIntValue((short)(first.shortValue() + second.shortValue()));
            }
            case 5 -> {
                SintType unused = (SintType)dataType;
                yield SIntValue.toSIntValue((byte)(first.byteValue() + second.byteValue()));
            }
            case 6 -> {
                UlintType unused = (UlintType)dataType;
                yield ULIntValue.toULIntValue(first.longValue() + second.longValue());
            }
            case 7 -> {
                UdintType unused = (UdintType)dataType;
                yield UDIntValue.toUDIntValue(first.intValue() + second.intValue());
            }
            case 8 -> {
                UintType unused = (UintType)dataType;
                yield UIntValue.toUIntValue((short)(first.shortValue() + second.shortValue()));
            }
            case 9 -> {
                UsintType unused = (UsintType)dataType;
                yield USIntValue.toUSIntValue((byte)(first.byteValue() + second.byteValue()));
            }
            case 10 -> {
                LtimeType unused = (LtimeType)dataType;
                yield LTimeValue.toLTimeValue(first.longValue() + second.longValue());
            }
            case 11 -> {
                TimeType unused = (TimeType)dataType;
                yield TimeValue.toTimeValue(first.longValue() + second.longValue());
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Add, first, second);
        };
    }

    private static AnyDateValue add(AnyDateValue first, TimeValue second) {
        AnyDateValue anyDateValue = first;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TimeOfDayValue.class, LTimeOfDayValue.class, DateAndTimeValue.class, LDateAndTimeValue.class}, (Object)anyDateValue, 0)) {
            case 0 -> {
                TimeOfDayValue timeOfDayValue = (TimeOfDayValue)anyDateValue;
                yield TimeOfDayValue.toTimeOfDayValue(first.toNanos() + second.longValue());
            }
            case 1 -> {
                LTimeOfDayValue ltimeOfDayValue = (LTimeOfDayValue)anyDateValue;
                yield LTimeOfDayValue.toLTimeOfDayValue(first.toNanos() + second.longValue());
            }
            case 2 -> {
                DateAndTimeValue dateAndTimeValue = (DateAndTimeValue)anyDateValue;
                yield DateAndTimeValue.toDateAndTimeValue(first.toNanos() + second.longValue());
            }
            case 3 -> {
                LDateAndTimeValue ldateAndTimeValue = (LDateAndTimeValue)anyDateValue;
                yield LDateAndTimeValue.toLDateAndTimeValue(first.toNanos() + second.longValue());
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Add, first, second);
        };
    }

    private static AnyDateValue add(AnyDateValue first, LTimeValue second) {
        AnyDateValue anyDateValue = first;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TimeOfDayValue.class, LTimeOfDayValue.class, DateAndTimeValue.class, LDateAndTimeValue.class}, (Object)anyDateValue, 0)) {
            case 0 -> {
                TimeOfDayValue timeOfDayValue = (TimeOfDayValue)anyDateValue;
                yield LTimeOfDayValue.toLTimeOfDayValue(first.toNanos() + second.longValue());
            }
            case 1 -> {
                LTimeOfDayValue ltimeOfDayValue = (LTimeOfDayValue)anyDateValue;
                yield LTimeOfDayValue.toLTimeOfDayValue(first.toNanos() + second.longValue());
            }
            case 2 -> {
                DateAndTimeValue dateAndTimeValue = (DateAndTimeValue)anyDateValue;
                yield LDateAndTimeValue.toLDateAndTimeValue(first.toNanos() + second.longValue());
            }
            case 3 -> {
                LDateAndTimeValue ldateAndTimeValue = (LDateAndTimeValue)anyDateValue;
                yield LDateAndTimeValue.toLDateAndTimeValue(first.toNanos() + second.longValue());
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Add, first, second);
        };
    }

    public static Value subtract(Value first, Value second) {
        if (first instanceof AnyMagnitudeValue) {
            AnyMagnitudeValue firstAnyMagnitudeValue = (AnyMagnitudeValue)first;
            if (second instanceof AnyMagnitudeValue) {
                AnyMagnitudeValue secondAnyMagnitudeValue = (AnyMagnitudeValue)second;
                return ValueOperations.subtract(firstAnyMagnitudeValue, secondAnyMagnitudeValue);
            }
        } else if (first instanceof AnyDateValue) {
            AnyDateValue firstAnyDateValue = (AnyDateValue)first;
            if (second instanceof LTimeValue) {
                LTimeValue secondLTimeValue = (LTimeValue)second;
                return ValueOperations.subtract(firstAnyDateValue, secondLTimeValue);
            }
            if (second instanceof TimeValue) {
                TimeValue secondTimeValue = (TimeValue)second;
                return ValueOperations.subtract(firstAnyDateValue, secondTimeValue);
            }
            if (second instanceof AnyDateValue) {
                AnyDateValue secondAnyDateValue = (AnyDateValue)second;
                return ValueOperations.subtract(firstAnyDateValue, secondAnyDateValue);
            }
        }
        throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Subtract, first, second);
    }

    private static AnyMagnitudeValue subtract(AnyMagnitudeValue first, AnyMagnitudeValue second) {
        DataType dataType = ValueOperations.resultType((DataType)first.getType(), (DataType)second.getType());
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LrealType.class, RealType.class, LintType.class, DintType.class, IntType.class, SintType.class, UlintType.class, UdintType.class, UintType.class, UsintType.class, LtimeType.class, TimeType.class}, (Object)dataType, 0)) {
            case 0 -> {
                LrealType unused = (LrealType)dataType;
                yield LRealValue.toLRealValue(first.doubleValue() - second.doubleValue());
            }
            case 1 -> {
                RealType unused = (RealType)dataType;
                yield RealValue.toRealValue(first.floatValue() - second.floatValue());
            }
            case 2 -> {
                LintType unused = (LintType)dataType;
                yield LIntValue.toLIntValue(first.longValue() - second.longValue());
            }
            case 3 -> {
                DintType unused = (DintType)dataType;
                yield DIntValue.toDIntValue(first.intValue() - second.intValue());
            }
            case 4 -> {
                IntType unused = (IntType)dataType;
                yield IntValue.toIntValue((short)(first.shortValue() - second.shortValue()));
            }
            case 5 -> {
                SintType unused = (SintType)dataType;
                yield SIntValue.toSIntValue((byte)(first.byteValue() - second.byteValue()));
            }
            case 6 -> {
                UlintType unused = (UlintType)dataType;
                yield ULIntValue.toULIntValue(first.longValue() - second.longValue());
            }
            case 7 -> {
                UdintType unused = (UdintType)dataType;
                yield UDIntValue.toUDIntValue(first.intValue() - second.intValue());
            }
            case 8 -> {
                UintType unused = (UintType)dataType;
                yield UIntValue.toUIntValue((short)(first.shortValue() - second.shortValue()));
            }
            case 9 -> {
                UsintType unused = (UsintType)dataType;
                yield USIntValue.toUSIntValue((byte)(first.byteValue() - second.byteValue()));
            }
            case 10 -> {
                LtimeType unused = (LtimeType)dataType;
                yield LTimeValue.toLTimeValue(first.longValue() - second.longValue());
            }
            case 11 -> {
                TimeType unused = (TimeType)dataType;
                yield TimeValue.toTimeValue(first.longValue() - second.longValue());
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Subtract, first, second);
        };
    }

    private static AnyDateValue subtract(AnyDateValue first, TimeValue second) {
        AnyDateValue anyDateValue = first;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TimeOfDayValue.class, LTimeOfDayValue.class, DateAndTimeValue.class, LDateAndTimeValue.class}, (Object)anyDateValue, 0)) {
            case 0 -> {
                TimeOfDayValue timeOfDayValue = (TimeOfDayValue)anyDateValue;
                yield TimeOfDayValue.toTimeOfDayValue(first.toNanos() - second.longValue());
            }
            case 1 -> {
                LTimeOfDayValue ltimeOfDayValue = (LTimeOfDayValue)anyDateValue;
                yield LTimeOfDayValue.toLTimeOfDayValue(first.toNanos() - second.longValue());
            }
            case 2 -> {
                DateAndTimeValue dateAndTimeValue = (DateAndTimeValue)anyDateValue;
                yield DateAndTimeValue.toDateAndTimeValue(first.toNanos() - second.longValue());
            }
            case 3 -> {
                LDateAndTimeValue ldateAndTimeValue = (LDateAndTimeValue)anyDateValue;
                yield LDateAndTimeValue.toLDateAndTimeValue(first.toNanos() - second.longValue());
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Subtract, first, second);
        };
    }

    private static AnyDateValue subtract(AnyDateValue first, LTimeValue second) {
        AnyDateValue anyDateValue = first;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TimeOfDayValue.class, LTimeOfDayValue.class, DateAndTimeValue.class, LDateAndTimeValue.class}, (Object)anyDateValue, 0)) {
            case 0 -> {
                TimeOfDayValue timeOfDayValue = (TimeOfDayValue)anyDateValue;
                yield LTimeOfDayValue.toLTimeOfDayValue(first.toNanos() - second.longValue());
            }
            case 1 -> {
                LTimeOfDayValue ltimeOfDayValue = (LTimeOfDayValue)anyDateValue;
                yield LTimeOfDayValue.toLTimeOfDayValue(first.toNanos() - second.longValue());
            }
            case 2 -> {
                DateAndTimeValue dateAndTimeValue = (DateAndTimeValue)anyDateValue;
                yield LDateAndTimeValue.toLDateAndTimeValue(first.toNanos() - second.longValue());
            }
            case 3 -> {
                LDateAndTimeValue ldateAndTimeValue = (LDateAndTimeValue)anyDateValue;
                yield LDateAndTimeValue.toLDateAndTimeValue(first.toNanos() - second.longValue());
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Subtract, first, second);
        };
    }

    private static AnyDurationValue subtract(AnyDateValue first, AnyDateValue second) {
        DataType dataType = ValueOperations.resultType((DataType)first.getType(), (DataType)second.getType());
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DateType.class, TimeOfDayType.class, DateAndTimeType.class, LdateType.class, LtodType.class, LdtType.class}, (Object)dataType, 0)) {
            case 0 -> {
                DateType unused = (DateType)dataType;
                yield TimeValue.toTimeValue(first.toNanos() - second.toNanos());
            }
            case 1 -> {
                TimeOfDayType unused = (TimeOfDayType)dataType;
                yield TimeValue.toTimeValue(first.toNanos() - second.toNanos());
            }
            case 2 -> {
                DateAndTimeType unused = (DateAndTimeType)dataType;
                yield TimeValue.toTimeValue(first.toNanos() - second.toNanos());
            }
            case 3 -> {
                LdateType unused = (LdateType)dataType;
                yield LTimeValue.toLTimeValue(first.toNanos() - second.toNanos());
            }
            case 4 -> {
                LtodType unused = (LtodType)dataType;
                yield LTimeValue.toLTimeValue(first.toNanos() - second.toNanos());
            }
            case 5 -> {
                LdtType unused = (LdtType)dataType;
                yield LTimeValue.toLTimeValue(first.toNanos() - second.toNanos());
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Subtract, first, second);
        };
    }

    public static Value multiply(Value first, Value second) {
        if (first instanceof AnyMagnitudeValue) {
            AnyMagnitudeValue firstAnyMagnitudeValue = (AnyMagnitudeValue)first;
            if (second instanceof AnyMagnitudeValue) {
                AnyMagnitudeValue secondAnyMagnitudeValue = (AnyMagnitudeValue)second;
                return ValueOperations.multiply(firstAnyMagnitudeValue, secondAnyMagnitudeValue);
            }
        }
        throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Multiply, first, second);
    }

    private static AnyMagnitudeValue multiply(AnyMagnitudeValue first, AnyMagnitudeValue second) {
        DataType dataType = ValueOperations.resultType((DataType)first.getType(), (DataType)second.getType());
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LrealType.class, RealType.class, LintType.class, DintType.class, IntType.class, SintType.class, UlintType.class, UdintType.class, UintType.class, UsintType.class, LtimeType.class, TimeType.class}, (Object)dataType, 0)) {
            case 0 -> {
                LrealType unused = (LrealType)dataType;
                yield LRealValue.toLRealValue(first.doubleValue() * second.doubleValue());
            }
            case 1 -> {
                RealType unused = (RealType)dataType;
                yield RealValue.toRealValue(first.floatValue() * second.floatValue());
            }
            case 2 -> {
                LintType unused = (LintType)dataType;
                yield LIntValue.toLIntValue(first.longValue() * second.longValue());
            }
            case 3 -> {
                DintType unused = (DintType)dataType;
                yield DIntValue.toDIntValue(first.intValue() * second.intValue());
            }
            case 4 -> {
                IntType unused = (IntType)dataType;
                yield IntValue.toIntValue((short)(first.shortValue() * second.shortValue()));
            }
            case 5 -> {
                SintType unused = (SintType)dataType;
                yield SIntValue.toSIntValue((byte)(first.byteValue() * second.byteValue()));
            }
            case 6 -> {
                UlintType unused = (UlintType)dataType;
                yield ULIntValue.toULIntValue(first.longValue() * second.longValue());
            }
            case 7 -> {
                UdintType unused = (UdintType)dataType;
                yield UDIntValue.toUDIntValue(first.intValue() * second.intValue());
            }
            case 8 -> {
                UintType unused = (UintType)dataType;
                yield UIntValue.toUIntValue((short)(first.shortValue() * second.shortValue()));
            }
            case 9 -> {
                UsintType unused = (UsintType)dataType;
                yield USIntValue.toUSIntValue((byte)(first.byteValue() * second.byteValue()));
            }
            case 10 -> {
                LtimeType unused = (LtimeType)dataType;
                if (second instanceof AnyRealValue) {
                    yield LTimeValue.toLTimeValue((long)(first.doubleValue() * second.doubleValue()));
                }
                yield LTimeValue.toLTimeValue(first.longValue() * second.longValue());
            }
            case 11 -> {
                TimeType unused = (TimeType)dataType;
                if (second instanceof AnyRealValue) {
                    yield TimeValue.toTimeValue((long)(first.doubleValue() * second.doubleValue()));
                }
                yield TimeValue.toTimeValue(first.longValue() * second.longValue());
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Multiply, first, second);
        };
    }

    public static Value divideBy(Value first, Value second) {
        if (first instanceof AnyMagnitudeValue) {
            AnyMagnitudeValue firstAnyMagnitudeValue = (AnyMagnitudeValue)first;
            if (second instanceof AnyMagnitudeValue) {
                AnyMagnitudeValue secondAnyMagnitudeValue = (AnyMagnitudeValue)second;
                return ValueOperations.divideBy(firstAnyMagnitudeValue, secondAnyMagnitudeValue);
            }
        }
        throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Divide, first, second);
    }

    private static AnyMagnitudeValue divideBy(AnyMagnitudeValue first, AnyMagnitudeValue second) {
        DataType dataType = ValueOperations.resultType((DataType)first.getType(), (DataType)second.getType());
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LrealType.class, RealType.class, LintType.class, DintType.class, IntType.class, SintType.class, UlintType.class, UdintType.class, UintType.class, UsintType.class, LtimeType.class, TimeType.class}, (Object)dataType, 0)) {
            case 0 -> {
                LrealType unused = (LrealType)dataType;
                yield LRealValue.toLRealValue(first.doubleValue() / second.doubleValue());
            }
            case 1 -> {
                RealType unused = (RealType)dataType;
                yield RealValue.toRealValue(first.floatValue() / second.floatValue());
            }
            case 2 -> {
                LintType unused = (LintType)dataType;
                yield LIntValue.toLIntValue(first.longValue() / second.longValue());
            }
            case 3 -> {
                DintType unused = (DintType)dataType;
                yield DIntValue.toDIntValue(first.intValue() / second.intValue());
            }
            case 4 -> {
                IntType unused = (IntType)dataType;
                yield IntValue.toIntValue((short)(first.shortValue() / second.shortValue()));
            }
            case 5 -> {
                SintType unused = (SintType)dataType;
                yield SIntValue.toSIntValue((byte)(first.byteValue() / second.byteValue()));
            }
            case 6 -> {
                UlintType unused = (UlintType)dataType;
                yield ULIntValue.toULIntValue(Long.divideUnsigned(first.longValue(), second.longValue()));
            }
            case 7 -> {
                UdintType unused = (UdintType)dataType;
                yield UDIntValue.toUDIntValue(Integer.divideUnsigned(first.intValue(), second.intValue()));
            }
            case 8 -> {
                UintType unused = (UintType)dataType;
                yield UIntValue.toUIntValue((short)Integer.divideUnsigned(first.intValue(), second.intValue()));
            }
            case 9 -> {
                UsintType unused = (UsintType)dataType;
                yield USIntValue.toUSIntValue((byte)Integer.divideUnsigned(first.intValue(), second.intValue()));
            }
            case 10 -> {
                LtimeType unused = (LtimeType)dataType;
                if (second instanceof AnyRealValue) {
                    if (second.doubleValue() == 0.0) {
                        throw new ArithmeticException(Messages.ValueOperations_DivisionByZero);
                    }
                    yield LTimeValue.toLTimeValue((long)(first.doubleValue() / second.doubleValue()));
                }
                yield LTimeValue.toLTimeValue(first.longValue() / second.longValue());
            }
            case 11 -> {
                TimeType unused = (TimeType)dataType;
                if (second instanceof AnyRealValue) {
                    if (second.doubleValue() == 0.0) {
                        throw new ArithmeticException(Messages.ValueOperations_DivisionByZero);
                    }
                    yield TimeValue.toTimeValue((long)(first.doubleValue() / second.doubleValue()));
                }
                yield TimeValue.toTimeValue(first.longValue() / second.longValue());
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Divide, first, second);
        };
    }

    public static Value remainderBy(Value first, Value second) {
        if (first instanceof AnyIntValue) {
            AnyIntValue firstAnyIntValue = (AnyIntValue)first;
            if (second instanceof AnyIntValue) {
                AnyIntValue secondAnyIntValue = (AnyIntValue)second;
                return ValueOperations.remainderBy(firstAnyIntValue, secondAnyIntValue);
            }
        }
        throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Remainder, first, second);
    }

    private static AnyIntValue remainderBy(AnyIntValue first, AnyIntValue second) {
        if (second.longValue() == 0L) {
            return (AnyIntValue)ValueOperations.defaultValue((LibraryElement)ValueOperations.resultType((DataType)first.getType(), (DataType)second.getType()));
        }
        DataType dataType = ValueOperations.resultType((DataType)first.getType(), (DataType)second.getType());
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LintType.class, DintType.class, IntType.class, SintType.class, UlintType.class, UdintType.class, UintType.class, UsintType.class}, (Object)dataType, 0)) {
            case 0 -> {
                LintType unused = (LintType)dataType;
                yield LIntValue.toLIntValue(first.longValue() % second.longValue());
            }
            case 1 -> {
                DintType unused = (DintType)dataType;
                yield DIntValue.toDIntValue(first.intValue() % second.intValue());
            }
            case 2 -> {
                IntType unused = (IntType)dataType;
                yield IntValue.toIntValue((short)(first.shortValue() % second.shortValue()));
            }
            case 3 -> {
                SintType unused = (SintType)dataType;
                yield SIntValue.toSIntValue((byte)(first.byteValue() % second.byteValue()));
            }
            case 4 -> {
                UlintType unused = (UlintType)dataType;
                yield ULIntValue.toULIntValue(Long.remainderUnsigned(first.longValue(), second.longValue()));
            }
            case 5 -> {
                UdintType unused = (UdintType)dataType;
                yield UDIntValue.toUDIntValue(Integer.remainderUnsigned(first.intValue(), second.intValue()));
            }
            case 6 -> {
                UintType unused = (UintType)dataType;
                yield UIntValue.toUIntValue((short)Integer.remainderUnsigned(first.intValue(), second.intValue()));
            }
            case 7 -> {
                UsintType unused = (UsintType)dataType;
                yield USIntValue.toUSIntValue((byte)Integer.remainderUnsigned(first.intValue(), second.intValue()));
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Remainder, first, second);
        };
    }

    public static Value power(Value first, Value second) {
        if (first instanceof AnyNumValue) {
            AnyNumValue firstAnyNumValue = (AnyNumValue)first;
            if (second instanceof AnyNumValue) {
                AnyNumValue secondAnyNumValue = (AnyNumValue)second;
                return ValueOperations.power(firstAnyNumValue, secondAnyNumValue);
            }
        }
        throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Power, first, second);
    }

    private static AnyNumValue power(AnyNumValue first, AnyNumValue second) {
        AnyNumValue anyNumValue = first;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RealValue.class, LRealValue.class}, (Object)anyNumValue, 0)) {
            case 0 -> {
                RealValue realValue = (RealValue)anyNumValue;
                yield RealValue.toRealValue((float)Math.pow(first.floatValue(), second.floatValue()));
            }
            case 1 -> {
                LRealValue lrealValue = (LRealValue)anyNumValue;
                yield LRealValue.toLRealValue(Math.pow(first.doubleValue(), second.doubleValue()));
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Power, first, second);
        };
    }

    public static Value bitwiseAnd(Value first, Value second) {
        if (first instanceof AnyBitValue) {
            AnyBitValue firstAnyBitValue = (AnyBitValue)first;
            if (second instanceof AnyBitValue) {
                AnyBitValue secondAnyBitValue = (AnyBitValue)second;
                return ValueOperations.bitwiseAnd(firstAnyBitValue, secondAnyBitValue);
            }
        }
        throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_And, first, second);
    }

    private static AnyBitValue bitwiseAnd(AnyBitValue first, AnyBitValue second) {
        DataType dataType = ValueOperations.resultType((DataType)first.getType(), (DataType)second.getType());
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LwordType.class, DwordType.class, WordType.class, ByteType.class, BoolType.class}, (Object)dataType, 0)) {
            case 0 -> {
                LwordType unused = (LwordType)dataType;
                yield LWordValue.toLWordValue(first.longValue() & second.longValue());
            }
            case 1 -> {
                DwordType unused = (DwordType)dataType;
                yield DWordValue.toDWordValue(first.intValue() & second.intValue());
            }
            case 2 -> {
                WordType unused = (WordType)dataType;
                yield WordValue.toWordValue((short)(first.shortValue() & second.shortValue()));
            }
            case 3 -> {
                ByteType unused = (ByteType)dataType;
                yield ByteValue.toByteValue((byte)(first.byteValue() & second.byteValue()));
            }
            case 4 -> {
                BoolType unused = (BoolType)dataType;
                yield BoolValue.toBoolValue(first.boolValue() && second.boolValue());
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_And, first, second);
        };
    }

    public static Value bitwiseOr(Value first, Value second) {
        if (first instanceof AnyBitValue) {
            AnyBitValue firstAnyBitValue = (AnyBitValue)first;
            if (second instanceof AnyBitValue) {
                AnyBitValue secondAnyBitValue = (AnyBitValue)second;
                return ValueOperations.bitwiseOr(firstAnyBitValue, secondAnyBitValue);
            }
        }
        throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Or, first, second);
    }

    private static AnyBitValue bitwiseOr(AnyBitValue first, AnyBitValue second) {
        DataType dataType = ValueOperations.resultType((DataType)first.getType(), (DataType)second.getType());
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LwordType.class, DwordType.class, WordType.class, ByteType.class, BoolType.class}, (Object)dataType, 0)) {
            case 0 -> {
                LwordType unused = (LwordType)dataType;
                yield LWordValue.toLWordValue(first.longValue() | second.longValue());
            }
            case 1 -> {
                DwordType unused = (DwordType)dataType;
                yield DWordValue.toDWordValue(first.intValue() | second.intValue());
            }
            case 2 -> {
                WordType unused = (WordType)dataType;
                yield WordValue.toWordValue((short)(first.shortValue() | second.shortValue()));
            }
            case 3 -> {
                ByteType unused = (ByteType)dataType;
                yield ByteValue.toByteValue((byte)(first.byteValue() | second.byteValue()));
            }
            case 4 -> {
                BoolType unused = (BoolType)dataType;
                yield BoolValue.toBoolValue(first.boolValue() || second.boolValue());
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Or, first, second);
        };
    }

    public static Value bitwiseXor(Value first, Value second) {
        if (first instanceof AnyBitValue) {
            AnyBitValue firstAnyBitValue = (AnyBitValue)first;
            if (second instanceof AnyBitValue) {
                AnyBitValue secondAnyBitValue = (AnyBitValue)second;
                return ValueOperations.bitwiseXor(firstAnyBitValue, secondAnyBitValue);
            }
        }
        throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Xor, first, second);
    }

    private static AnyBitValue bitwiseXor(AnyBitValue first, AnyBitValue second) {
        DataType dataType = ValueOperations.resultType((DataType)first.getType(), (DataType)second.getType());
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LwordType.class, DwordType.class, WordType.class, ByteType.class, BoolType.class}, (Object)dataType, 0)) {
            case 0 -> {
                LwordType unused = (LwordType)dataType;
                yield LWordValue.toLWordValue(first.longValue() ^ second.longValue());
            }
            case 1 -> {
                DwordType unused = (DwordType)dataType;
                yield DWordValue.toDWordValue(first.intValue() ^ second.intValue());
            }
            case 2 -> {
                WordType unused = (WordType)dataType;
                yield WordValue.toWordValue((short)(first.shortValue() ^ second.shortValue()));
            }
            case 3 -> {
                ByteType unused = (ByteType)dataType;
                yield ByteValue.toByteValue((byte)(first.byteValue() ^ second.byteValue()));
            }
            case 4 -> {
                BoolType unused = (BoolType)dataType;
                yield BoolValue.toBoolValue(first.boolValue() ^ second.boolValue());
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Xor, first, second);
        };
    }

    public static Value shiftLeft(Value first, Value second) {
        if (first instanceof AnyBitValue) {
            AnyBitValue firstAnyBitValue = (AnyBitValue)first;
            if (second instanceof AnyIntValue) {
                AnyIntValue secondAnyIntValue = (AnyIntValue)second;
                return ValueOperations.shiftLeft(firstAnyBitValue, secondAnyIntValue);
            }
        }
        throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_ShiftLeft, first, second);
    }

    private static AnyBitValue shiftLeft(AnyBitValue first, AnyIntValue second) {
        AnyBitValue anyBitValue = first;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LWordValue.class, DWordValue.class, WordValue.class, ByteValue.class}, (Object)anyBitValue, 0)) {
            case 0 -> {
                LWordValue lwordValue = (LWordValue)anyBitValue;
                yield LWordValue.toLWordValue(first.longValue() << second.intValue());
            }
            case 1 -> {
                DWordValue dwordValue = (DWordValue)anyBitValue;
                yield DWordValue.toDWordValue(first.intValue() << second.intValue());
            }
            case 2 -> {
                WordValue wordValue = (WordValue)anyBitValue;
                yield WordValue.toWordValue((short)(first.shortValue() << second.intValue()));
            }
            case 3 -> {
                ByteValue byteValue = (ByteValue)anyBitValue;
                yield ByteValue.toByteValue((byte)(first.byteValue() << second.intValue()));
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_ShiftLeft, first, second);
        };
    }

    public static Value shiftRight(Value first, Value second) {
        if (first instanceof AnyBitValue) {
            AnyBitValue firstAnyBitValue = (AnyBitValue)first;
            if (second instanceof AnyIntValue) {
                AnyIntValue secondAnyIntValue = (AnyIntValue)second;
                return ValueOperations.shiftRight(firstAnyBitValue, secondAnyIntValue);
            }
        }
        throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_ShiftRight, first, second);
    }

    private static AnyBitValue shiftRight(AnyBitValue first, AnyIntValue second) {
        AnyBitValue anyBitValue = first;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LWordValue.class, DWordValue.class, WordValue.class, ByteValue.class}, (Object)anyBitValue, 0)) {
            case 0 -> {
                LWordValue lwordValue = (LWordValue)anyBitValue;
                yield LWordValue.toLWordValue(first.longValue() >>> second.intValue());
            }
            case 1 -> {
                DWordValue dwordValue = (DWordValue)anyBitValue;
                yield DWordValue.toDWordValue(first.intValue() >>> second.intValue());
            }
            case 2 -> {
                WordValue wordValue = (WordValue)anyBitValue;
                yield WordValue.toWordValue((short)(first.intValue() >>> second.intValue()));
            }
            case 3 -> {
                ByteValue byteValue = (ByteValue)anyBitValue;
                yield ByteValue.toByteValue((byte)(first.intValue() >>> second.intValue()));
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_ShiftRight, first, second);
        };
    }

    public static Value rotateLeft(Value first, Value second) {
        if (first instanceof AnyBitValue) {
            AnyBitValue firstAnyBitValue = (AnyBitValue)first;
            if (second instanceof AnyIntValue) {
                AnyIntValue secondAnyIntValue = (AnyIntValue)second;
                return ValueOperations.rotateLeft(firstAnyBitValue, secondAnyIntValue);
            }
        }
        throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_RotateLeft, first, second);
    }

    private static AnyBitValue rotateLeft(AnyBitValue first, AnyIntValue second) {
        AnyBitValue anyBitValue = first;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LWordValue.class, DWordValue.class, WordValue.class, ByteValue.class}, (Object)anyBitValue, 0)) {
            case 0 -> {
                LWordValue lwordValue = (LWordValue)anyBitValue;
                yield LWordValue.toLWordValue(Long.rotateLeft(first.longValue(), second.intValue()));
            }
            case 1 -> {
                DWordValue dwordValue = (DWordValue)anyBitValue;
                yield DWordValue.toDWordValue(Integer.rotateLeft(first.intValue(), second.intValue()));
            }
            case 2 -> {
                WordValue wordValue = (WordValue)anyBitValue;
                yield WordValue.toWordValue((short)(first.intValue() << second.intValue() | first.intValue() >>> 16 - second.intValue()));
            }
            case 3 -> {
                ByteValue byteValue = (ByteValue)anyBitValue;
                yield ByteValue.toByteValue((byte)(first.intValue() << second.intValue() | first.intValue() >>> 8 - second.intValue()));
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_RotateLeft, first, second);
        };
    }

    public static Value rotateRight(Value first, Value second) {
        if (first instanceof AnyBitValue) {
            AnyBitValue firstAnyBitValue = (AnyBitValue)first;
            if (second instanceof AnyIntValue) {
                AnyIntValue secondAnyIntValue = (AnyIntValue)second;
                return ValueOperations.rotateRight(firstAnyBitValue, secondAnyIntValue);
            }
        }
        throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_RotateRight, first, second);
    }

    private static AnyBitValue rotateRight(AnyBitValue first, AnyIntValue second) {
        AnyBitValue anyBitValue = first;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LWordValue.class, DWordValue.class, WordValue.class, ByteValue.class}, (Object)anyBitValue, 0)) {
            case 0 -> {
                LWordValue lwordValue = (LWordValue)anyBitValue;
                yield LWordValue.toLWordValue(Long.rotateRight(first.longValue(), second.intValue()));
            }
            case 1 -> {
                DWordValue dwordValue = (DWordValue)anyBitValue;
                yield DWordValue.toDWordValue(Integer.rotateRight(first.intValue(), second.intValue()));
            }
            case 2 -> {
                WordValue wordValue = (WordValue)anyBitValue;
                yield WordValue.toWordValue((short)(first.intValue() >>> second.intValue() | first.intValue() << 16 - second.intValue()));
            }
            case 3 -> {
                ByteValue byteValue = (ByteValue)anyBitValue;
                yield ByteValue.toByteValue((byte)(first.intValue() >>> second.intValue() | first.intValue() << 8 - second.intValue()));
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_RotateRight, first, second);
        };
    }

    public static boolean equals(Value first, Value second) {
        if (first instanceof AnyDurationValue) {
            AnyDurationValue firstAnyDurationValue = (AnyDurationValue)first;
            if (second instanceof AnyDurationValue) {
                AnyDurationValue secondAnyDurationValue = (AnyDurationValue)second;
                return ValueOperations.equals(firstAnyDurationValue, secondAnyDurationValue);
            }
        }
        if (first instanceof AnyNumValue) {
            AnyNumValue firstAnyNumValue = (AnyNumValue)first;
            if (second instanceof AnyNumValue) {
                AnyNumValue secondAnyNumValue = (AnyNumValue)second;
                return ValueOperations.equals(firstAnyNumValue, secondAnyNumValue);
            }
        }
        if (first instanceof AnyBitValue) {
            AnyBitValue firstAnyBitValue = (AnyBitValue)first;
            if (second instanceof AnyBitValue) {
                AnyBitValue secondAnyBitValue = (AnyBitValue)second;
                return ValueOperations.equals(firstAnyBitValue, secondAnyBitValue);
            }
        }
        if (first instanceof AnyIntValue) {
            AnyIntValue firstAnyIntValue = (AnyIntValue)first;
            if (second instanceof AnyBitValue) {
                AnyBitValue secondAnyBitValue = (AnyBitValue)second;
                return ValueOperations.equals(firstAnyIntValue, secondAnyBitValue);
            }
        }
        if (first instanceof AnyBitValue) {
            AnyBitValue firstAnyBitValue = (AnyBitValue)first;
            if (second instanceof AnyIntValue) {
                AnyIntValue secondAnyIntValue = (AnyIntValue)second;
                return ValueOperations.equals(firstAnyBitValue, secondAnyIntValue);
            }
        }
        if (first instanceof AnyCharsValue) {
            AnyCharsValue firstAnyCharsValue = (AnyCharsValue)first;
            if (second instanceof AnyCharsValue) {
                AnyCharsValue secondAnyCharsValue = (AnyCharsValue)second;
                return ValueOperations.equals(firstAnyCharsValue, secondAnyCharsValue);
            }
        }
        if (first instanceof AnyDateValue) {
            AnyDateValue firstAnyDateValue = (AnyDateValue)first;
            if (second instanceof AnyDateValue) {
                AnyDateValue secondAnyDateValue = (AnyDateValue)second;
                return ValueOperations.equals(firstAnyDateValue, secondAnyDateValue);
            }
        }
        return Objects.equals(first, second);
    }

    private static boolean equals(AnyNumValue first, AnyNumValue second) {
        DataType dataType = ValueOperations.resultType((DataType)first.getType(), (DataType)second.getType());
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LrealType.class, RealType.class, LintType.class, UlintType.class, DintType.class, UdintType.class, IntType.class, UintType.class, SintType.class, UsintType.class}, (Object)dataType, 0)) {
            case 0 -> {
                LrealType unused = (LrealType)dataType;
                if (first.doubleValue() == second.doubleValue()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                RealType unused = (RealType)dataType;
                if (first.floatValue() == second.floatValue()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                LintType unused = (LintType)dataType;
                if (first.longValue() == second.longValue()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                UlintType unused = (UlintType)dataType;
                if (first.longValue() == second.longValue()) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                DintType unused = (DintType)dataType;
                if (first.intValue() == second.intValue()) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                UdintType unused = (UdintType)dataType;
                if (first.intValue() == second.intValue()) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                IntType unused = (IntType)dataType;
                if (first.shortValue() == second.shortValue()) {
                    yield true;
                }
                yield false;
            }
            case 7 -> {
                UintType unused = (UintType)dataType;
                if (first.shortValue() == second.shortValue()) {
                    yield true;
                }
                yield false;
            }
            case 8 -> {
                SintType unused = (SintType)dataType;
                if (first.byteValue() == second.byteValue()) {
                    yield true;
                }
                yield false;
            }
            case 9 -> {
                UsintType unused = (UsintType)dataType;
                if (first.byteValue() == second.byteValue()) {
                    yield true;
                }
                yield false;
            }
            default -> first.bigDecimalValue().equals(second.bigDecimalValue());
        };
    }

    private static boolean equals(AnyBitValue first, AnyBitValue second) {
        DataType dataType = ValueOperations.resultType((DataType)first.getType(), (DataType)second.getType());
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LwordType.class, DwordType.class, WordType.class, ByteType.class, BoolType.class}, (Object)dataType, 0)) {
            case 0 -> {
                LwordType unused = (LwordType)dataType;
                if (first.longValue() == second.longValue()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                DwordType unused = (DwordType)dataType;
                if (first.intValue() == second.intValue()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                WordType unused = (WordType)dataType;
                if (first.shortValue() == second.shortValue()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                ByteType unused = (ByteType)dataType;
                if (first.byteValue() == second.byteValue()) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                BoolType unused = (BoolType)dataType;
                if (first.boolValue() == second.boolValue()) {
                    yield true;
                }
                yield false;
            }
            default -> first.bigIntegerValue().equals(second.bigIntegerValue());
        };
    }

    private static boolean equals(AnyIntValue first, AnyBitValue second) {
        return first.bigIntegerValue().equals(second.bigIntegerValue());
    }

    private static boolean equals(AnyBitValue first, AnyIntValue second) {
        return first.bigIntegerValue().equals(second.bigIntegerValue());
    }

    private static boolean equals(AnyDurationValue first, AnyDurationValue second) {
        return first.longValue() == second.longValue();
    }

    private static boolean equals(AnyCharsValue first, AnyCharsValue second) {
        return first.stringValue().equals(second.stringValue());
    }

    private static boolean equals(AnyDateValue first, AnyDateValue second) {
        return first.toNanos() == second.toNanos();
    }

    public static boolean lessThan(Value first, Value second) {
        if (first instanceof AnyMagnitudeValue) {
            AnyMagnitudeValue firstAnyMagnitudeValue = (AnyMagnitudeValue)first;
            if (second instanceof AnyMagnitudeValue) {
                AnyMagnitudeValue secondAnyMagnitudeValue = (AnyMagnitudeValue)second;
                return ValueOperations.lessThan(firstAnyMagnitudeValue, secondAnyMagnitudeValue);
            }
        }
        if (first instanceof AnyBitValue) {
            AnyBitValue firstAnyBitValue = (AnyBitValue)first;
            if (second instanceof AnyBitValue) {
                AnyBitValue secondAnyBitValue = (AnyBitValue)second;
                return ValueOperations.compareTo(firstAnyBitValue, secondAnyBitValue) < 0;
            }
        }
        if (first instanceof AnyCharsValue) {
            AnyCharsValue firstAnyCharsValue = (AnyCharsValue)first;
            if (second instanceof AnyCharsValue) {
                AnyCharsValue secondAnyCharsValue = (AnyCharsValue)second;
                return ValueOperations.compareTo(firstAnyCharsValue, secondAnyCharsValue) < 0;
            }
        }
        if (first instanceof AnyDateValue) {
            AnyDateValue firstAnyDateValue = (AnyDateValue)first;
            if (second instanceof AnyDateValue) {
                AnyDateValue secondAnyDateValue = (AnyDateValue)second;
                return ValueOperations.compareTo(firstAnyDateValue, secondAnyDateValue) < 0;
            }
        }
        throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Compare, first, second);
    }

    private static boolean lessThan(AnyMagnitudeValue first, AnyMagnitudeValue second) {
        DataType dataType = ValueOperations.resultType((DataType)first.getType(), (DataType)second.getType());
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LrealType.class, RealType.class, LintType.class, DintType.class, IntType.class, SintType.class, UlintType.class, UdintType.class, UintType.class, UsintType.class, LtimeType.class, TimeType.class}, (Object)dataType, 0)) {
            case 0 -> {
                LrealType unused = (LrealType)dataType;
                if (first.doubleValue() < second.doubleValue()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                RealType unused = (RealType)dataType;
                if (first.floatValue() < second.floatValue()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                LintType unused = (LintType)dataType;
                if (first.longValue() < second.longValue()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                DintType unused = (DintType)dataType;
                if (first.intValue() < second.intValue()) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                IntType unused = (IntType)dataType;
                if (first.shortValue() < second.shortValue()) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                SintType unused = (SintType)dataType;
                if (first.byteValue() < second.byteValue()) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                UlintType unused = (UlintType)dataType;
                if (Long.compareUnsigned(first.longValue(), second.longValue()) < 0) {
                    yield true;
                }
                yield false;
            }
            case 7 -> {
                UdintType unused = (UdintType)dataType;
                if (Integer.compareUnsigned(first.intValue(), second.intValue()) < 0) {
                    yield true;
                }
                yield false;
            }
            case 8 -> {
                UintType unused = (UintType)dataType;
                if (Integer.compareUnsigned(first.intValue(), second.intValue()) < 0) {
                    yield true;
                }
                yield false;
            }
            case 9 -> {
                UsintType unused = (UsintType)dataType;
                if (Integer.compareUnsigned(first.intValue(), second.intValue()) < 0) {
                    yield true;
                }
                yield false;
            }
            case 10 -> {
                LtimeType unused = (LtimeType)dataType;
                if (first.longValue() < second.longValue()) {
                    yield true;
                }
                yield false;
            }
            case 11 -> {
                TimeType unused = (TimeType)dataType;
                if (first.longValue() < second.longValue()) {
                    yield true;
                }
                yield false;
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Compare, first, second);
        };
    }

    public static boolean lessEquals(Value first, Value second) {
        if (first instanceof AnyMagnitudeValue) {
            AnyMagnitudeValue firstAnyMagnitudeValue = (AnyMagnitudeValue)first;
            if (second instanceof AnyMagnitudeValue) {
                AnyMagnitudeValue secondAnyMagnitudeValue = (AnyMagnitudeValue)second;
                return ValueOperations.lessEquals(firstAnyMagnitudeValue, secondAnyMagnitudeValue);
            }
        }
        if (first instanceof AnyBitValue) {
            AnyBitValue firstAnyBitValue = (AnyBitValue)first;
            if (second instanceof AnyBitValue) {
                AnyBitValue secondAnyBitValue = (AnyBitValue)second;
                return ValueOperations.compareTo(firstAnyBitValue, secondAnyBitValue) <= 0;
            }
        }
        if (first instanceof AnyCharsValue) {
            AnyCharsValue firstAnyCharsValue = (AnyCharsValue)first;
            if (second instanceof AnyCharsValue) {
                AnyCharsValue secondAnyCharsValue = (AnyCharsValue)second;
                return ValueOperations.compareTo(firstAnyCharsValue, secondAnyCharsValue) <= 0;
            }
        }
        if (first instanceof AnyDateValue) {
            AnyDateValue firstAnyDateValue = (AnyDateValue)first;
            if (second instanceof AnyDateValue) {
                AnyDateValue secondAnyDateValue = (AnyDateValue)second;
                return ValueOperations.compareTo(firstAnyDateValue, secondAnyDateValue) <= 0;
            }
        }
        throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Compare, first, second);
    }

    private static boolean lessEquals(AnyMagnitudeValue first, AnyMagnitudeValue second) {
        DataType dataType = ValueOperations.resultType((DataType)first.getType(), (DataType)second.getType());
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LrealType.class, RealType.class, LintType.class, DintType.class, IntType.class, SintType.class, UlintType.class, UdintType.class, UintType.class, UsintType.class, LtimeType.class, TimeType.class}, (Object)dataType, 0)) {
            case 0 -> {
                LrealType unused = (LrealType)dataType;
                if (first.doubleValue() <= second.doubleValue()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                RealType unused = (RealType)dataType;
                if (first.floatValue() <= second.floatValue()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                LintType unused = (LintType)dataType;
                if (first.longValue() <= second.longValue()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                DintType unused = (DintType)dataType;
                if (first.intValue() <= second.intValue()) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                IntType unused = (IntType)dataType;
                if (first.shortValue() <= second.shortValue()) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                SintType unused = (SintType)dataType;
                if (first.byteValue() <= second.byteValue()) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                UlintType unused = (UlintType)dataType;
                if (Long.compareUnsigned(first.longValue(), second.longValue()) <= 0) {
                    yield true;
                }
                yield false;
            }
            case 7 -> {
                UdintType unused = (UdintType)dataType;
                if (Integer.compareUnsigned(first.intValue(), second.intValue()) <= 0) {
                    yield true;
                }
                yield false;
            }
            case 8 -> {
                UintType unused = (UintType)dataType;
                if (Integer.compareUnsigned(first.intValue(), second.intValue()) <= 0) {
                    yield true;
                }
                yield false;
            }
            case 9 -> {
                UsintType unused = (UsintType)dataType;
                if (Integer.compareUnsigned(first.intValue(), second.intValue()) <= 0) {
                    yield true;
                }
                yield false;
            }
            case 10 -> {
                LtimeType unused = (LtimeType)dataType;
                if (first.longValue() <= second.longValue()) {
                    yield true;
                }
                yield false;
            }
            case 11 -> {
                TimeType unused = (TimeType)dataType;
                if (first.longValue() <= second.longValue()) {
                    yield true;
                }
                yield false;
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Compare, first, second);
        };
    }

    public static boolean greaterThan(Value first, Value second) {
        if (first instanceof AnyMagnitudeValue) {
            AnyMagnitudeValue firstAnyMagnitudeValue = (AnyMagnitudeValue)first;
            if (second instanceof AnyMagnitudeValue) {
                AnyMagnitudeValue secondAnyMagnitudeValue = (AnyMagnitudeValue)second;
                return ValueOperations.greaterThan(firstAnyMagnitudeValue, secondAnyMagnitudeValue);
            }
        }
        if (first instanceof AnyBitValue) {
            AnyBitValue firstAnyBitValue = (AnyBitValue)first;
            if (second instanceof AnyBitValue) {
                AnyBitValue secondAnyBitValue = (AnyBitValue)second;
                return ValueOperations.compareTo(firstAnyBitValue, secondAnyBitValue) > 0;
            }
        }
        if (first instanceof AnyCharsValue) {
            AnyCharsValue firstAnyCharsValue = (AnyCharsValue)first;
            if (second instanceof AnyCharsValue) {
                AnyCharsValue secondAnyCharsValue = (AnyCharsValue)second;
                return ValueOperations.compareTo(firstAnyCharsValue, secondAnyCharsValue) > 0;
            }
        }
        if (first instanceof AnyDateValue) {
            AnyDateValue firstAnyDateValue = (AnyDateValue)first;
            if (second instanceof AnyDateValue) {
                AnyDateValue secondAnyDateValue = (AnyDateValue)second;
                return ValueOperations.compareTo(firstAnyDateValue, secondAnyDateValue) > 0;
            }
        }
        throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Compare, first, second);
    }

    private static boolean greaterThan(AnyMagnitudeValue first, AnyMagnitudeValue second) {
        DataType dataType = ValueOperations.resultType((DataType)first.getType(), (DataType)second.getType());
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LrealType.class, RealType.class, LintType.class, DintType.class, IntType.class, SintType.class, UlintType.class, UdintType.class, UintType.class, UsintType.class, LtimeType.class, TimeType.class}, (Object)dataType, 0)) {
            case 0 -> {
                LrealType unused = (LrealType)dataType;
                if (first.doubleValue() > second.doubleValue()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                RealType unused = (RealType)dataType;
                if (first.floatValue() > second.floatValue()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                LintType unused = (LintType)dataType;
                if (first.longValue() > second.longValue()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                DintType unused = (DintType)dataType;
                if (first.intValue() > second.intValue()) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                IntType unused = (IntType)dataType;
                if (first.shortValue() > second.shortValue()) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                SintType unused = (SintType)dataType;
                if (first.byteValue() > second.byteValue()) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                UlintType unused = (UlintType)dataType;
                if (Long.compareUnsigned(first.longValue(), second.longValue()) > 0) {
                    yield true;
                }
                yield false;
            }
            case 7 -> {
                UdintType unused = (UdintType)dataType;
                if (Integer.compareUnsigned(first.intValue(), second.intValue()) > 0) {
                    yield true;
                }
                yield false;
            }
            case 8 -> {
                UintType unused = (UintType)dataType;
                if (Integer.compareUnsigned(first.intValue(), second.intValue()) > 0) {
                    yield true;
                }
                yield false;
            }
            case 9 -> {
                UsintType unused = (UsintType)dataType;
                if (Integer.compareUnsigned(first.intValue(), second.intValue()) > 0) {
                    yield true;
                }
                yield false;
            }
            case 10 -> {
                LtimeType unused = (LtimeType)dataType;
                if (first.longValue() > second.longValue()) {
                    yield true;
                }
                yield false;
            }
            case 11 -> {
                TimeType unused = (TimeType)dataType;
                if (first.longValue() > second.longValue()) {
                    yield true;
                }
                yield false;
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Compare, first, second);
        };
    }

    public static boolean greaterEquals(Value first, Value second) {
        if (first instanceof AnyMagnitudeValue) {
            AnyMagnitudeValue firstAnyMagnitudeValue = (AnyMagnitudeValue)first;
            if (second instanceof AnyMagnitudeValue) {
                AnyMagnitudeValue secondAnyMagnitudeValue = (AnyMagnitudeValue)second;
                return ValueOperations.greaterEquals(firstAnyMagnitudeValue, secondAnyMagnitudeValue);
            }
        }
        if (first instanceof AnyBitValue) {
            AnyBitValue firstAnyBitValue = (AnyBitValue)first;
            if (second instanceof AnyBitValue) {
                AnyBitValue secondAnyBitValue = (AnyBitValue)second;
                return ValueOperations.compareTo(firstAnyBitValue, secondAnyBitValue) >= 0;
            }
        }
        if (first instanceof AnyCharsValue) {
            AnyCharsValue firstAnyCharsValue = (AnyCharsValue)first;
            if (second instanceof AnyCharsValue) {
                AnyCharsValue secondAnyCharsValue = (AnyCharsValue)second;
                return ValueOperations.compareTo(firstAnyCharsValue, secondAnyCharsValue) >= 0;
            }
        }
        if (first instanceof AnyDateValue) {
            AnyDateValue firstAnyDateValue = (AnyDateValue)first;
            if (second instanceof AnyDateValue) {
                AnyDateValue secondAnyDateValue = (AnyDateValue)second;
                return ValueOperations.compareTo(firstAnyDateValue, secondAnyDateValue) >= 0;
            }
        }
        throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Compare, first, second);
    }

    private static boolean greaterEquals(AnyMagnitudeValue first, AnyMagnitudeValue second) {
        DataType dataType = ValueOperations.resultType((DataType)first.getType(), (DataType)second.getType());
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LrealType.class, RealType.class, LintType.class, DintType.class, IntType.class, SintType.class, UlintType.class, UdintType.class, UintType.class, UsintType.class, LtimeType.class, TimeType.class}, (Object)dataType, 0)) {
            case 0 -> {
                LrealType unused = (LrealType)dataType;
                if (first.doubleValue() >= second.doubleValue()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                RealType unused = (RealType)dataType;
                if (first.floatValue() >= second.floatValue()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                LintType unused = (LintType)dataType;
                if (first.longValue() >= second.longValue()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                DintType unused = (DintType)dataType;
                if (first.intValue() >= second.intValue()) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                IntType unused = (IntType)dataType;
                if (first.shortValue() >= second.shortValue()) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                SintType unused = (SintType)dataType;
                if (first.byteValue() >= second.byteValue()) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                UlintType unused = (UlintType)dataType;
                if (Long.compareUnsigned(first.longValue(), second.longValue()) >= 0) {
                    yield true;
                }
                yield false;
            }
            case 7 -> {
                UdintType unused = (UdintType)dataType;
                if (Integer.compareUnsigned(first.intValue(), second.intValue()) >= 0) {
                    yield true;
                }
                yield false;
            }
            case 8 -> {
                UintType unused = (UintType)dataType;
                if (Integer.compareUnsigned(first.intValue(), second.intValue()) >= 0) {
                    yield true;
                }
                yield false;
            }
            case 9 -> {
                UsintType unused = (UsintType)dataType;
                if (Integer.compareUnsigned(first.intValue(), second.intValue()) >= 0) {
                    yield true;
                }
                yield false;
            }
            case 10 -> {
                LtimeType unused = (LtimeType)dataType;
                if (first.longValue() >= second.longValue()) {
                    yield true;
                }
                yield false;
            }
            case 11 -> {
                TimeType unused = (TimeType)dataType;
                if (first.longValue() >= second.longValue()) {
                    yield true;
                }
                yield false;
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Compare, first, second);
        };
    }

    public static int compareTo(Value first, Value second) {
        if (first instanceof AnyBitValue) {
            AnyBitValue firstAnyBitValue = (AnyBitValue)first;
            if (second instanceof AnyBitValue) {
                AnyBitValue secondAnyBitValue = (AnyBitValue)second;
                return ValueOperations.compareTo(firstAnyBitValue, secondAnyBitValue);
            }
        }
        if (first instanceof AnyCharsValue) {
            AnyCharsValue firstAnyCharsValue = (AnyCharsValue)first;
            if (second instanceof AnyCharsValue) {
                AnyCharsValue secondAnyCharsValue = (AnyCharsValue)second;
                return ValueOperations.compareTo(firstAnyCharsValue, secondAnyCharsValue);
            }
        }
        if (first instanceof AnyDateValue) {
            AnyDateValue firstAnyDateValue = (AnyDateValue)first;
            if (second instanceof AnyDateValue) {
                AnyDateValue secondAnyDateValue = (AnyDateValue)second;
                return ValueOperations.compareTo(firstAnyDateValue, secondAnyDateValue);
            }
        }
        if (first instanceof AnyMagnitudeValue) {
            AnyMagnitudeValue firstAnyMagnitudeValue = (AnyMagnitudeValue)first;
            if (second instanceof AnyMagnitudeValue) {
                AnyMagnitudeValue secondAnyMagnitudeValue = (AnyMagnitudeValue)second;
                return ValueOperations.compareTo(firstAnyMagnitudeValue, secondAnyMagnitudeValue);
            }
        }
        throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Compare, first, second);
    }

    private static int compareTo(AnyMagnitudeValue first, AnyMagnitudeValue second) {
        DataType dataType = ValueOperations.resultType((DataType)first.getType(), (DataType)second.getType());
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LrealType.class, RealType.class, LintType.class, DintType.class, IntType.class, SintType.class, UlintType.class, UdintType.class, UintType.class, UsintType.class, LtimeType.class, TimeType.class}, (Object)dataType, 0)) {
            case 0 -> {
                LrealType unused = (LrealType)dataType;
                yield Double.compare(first.doubleValue(), second.doubleValue());
            }
            case 1 -> {
                RealType unused = (RealType)dataType;
                yield Float.compare(first.floatValue(), second.floatValue());
            }
            case 2 -> {
                LintType unused = (LintType)dataType;
                yield Long.compare(first.longValue(), second.longValue());
            }
            case 3 -> {
                DintType unused = (DintType)dataType;
                yield Integer.compare(first.intValue(), second.intValue());
            }
            case 4 -> {
                IntType unused = (IntType)dataType;
                yield Short.compare(first.shortValue(), second.shortValue());
            }
            case 5 -> {
                SintType unused = (SintType)dataType;
                yield Byte.compare(first.byteValue(), second.byteValue());
            }
            case 6 -> {
                UlintType unused = (UlintType)dataType;
                yield Long.compareUnsigned(first.longValue(), second.longValue());
            }
            case 7 -> {
                UdintType unused = (UdintType)dataType;
                yield Integer.compareUnsigned(first.intValue(), second.intValue());
            }
            case 8 -> {
                UintType unused = (UintType)dataType;
                yield Integer.compareUnsigned(first.intValue(), second.intValue());
            }
            case 9 -> {
                UsintType unused = (UsintType)dataType;
                yield Integer.compareUnsigned(first.intValue(), second.intValue());
            }
            case 10 -> {
                LtimeType unused = (LtimeType)dataType;
                yield Long.compare(first.longValue(), second.longValue());
            }
            case 11 -> {
                TimeType unused = (TimeType)dataType;
                yield Long.compare(first.longValue(), second.longValue());
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Compare, first, second);
        };
    }

    private static int compareTo(AnyBitValue first, AnyBitValue second) {
        DataType dataType = ValueOperations.resultType((DataType)first.getType(), (DataType)second.getType());
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LwordType.class, DwordType.class, WordType.class, ByteType.class, BoolType.class}, (Object)dataType, 0)) {
            case 0 -> {
                LwordType unused = (LwordType)dataType;
                yield Long.compareUnsigned(first.longValue(), second.longValue());
            }
            case 1 -> {
                DwordType unused = (DwordType)dataType;
                yield Integer.compareUnsigned(first.intValue(), second.intValue());
            }
            case 2 -> {
                WordType unused = (WordType)dataType;
                yield Integer.compareUnsigned(first.intValue(), second.intValue());
            }
            case 3 -> {
                ByteType unused = (ByteType)dataType;
                yield Integer.compareUnsigned(first.intValue(), second.intValue());
            }
            case 4 -> {
                BoolType unused = (BoolType)dataType;
                yield Boolean.compare(first.boolValue(), second.boolValue());
            }
            default -> throw ValueOperations.createUnsupportedBinaryOperationException(Messages.ValueOperations_Compare, first, second);
        };
    }

    private static int compareTo(AnyCharsValue first, AnyCharsValue second) {
        return first.stringValue().compareTo(second.stringValue());
    }

    private static int compareTo(AnyDateValue first, AnyDateValue second) {
        return Long.compare(first.toNanos(), second.toNanos());
    }

    public static Value partial(Value value, DataType type, int index) {
        if (value instanceof ByteValue) {
            ByteValue byteValue = (ByteValue)value;
            return ValueOperations.partial(byteValue, type, index);
        }
        if (value instanceof DWordValue) {
            DWordValue dwordValue = (DWordValue)value;
            return ValueOperations.partial(dwordValue, type, index);
        }
        if (value instanceof LWordValue) {
            LWordValue lwordValue = (LWordValue)value;
            return ValueOperations.partial(lwordValue, type, index);
        }
        if (value instanceof WordValue) {
            WordValue wordValue = (WordValue)value;
            return ValueOperations.partial(wordValue, type, index);
        }
        throw ValueOperations.createUnsupportedPartialOperationException(value, type);
    }

    private static Value partial(ByteValue value, DataType type, int index) {
        DataType dataType = type;
        return BoolValue.toBoolValue(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BoolType.class}, (Object)dataType, 0)) {
            case 0 -> {
                BoolType unused = (BoolType)dataType;
                if ((value.byteValue() >>> index & 1) != 0) {
                    yield true;
                }
                yield false;
            }
            default -> throw ValueOperations.createUnsupportedPartialOperationException(value, type);
        });
    }

    private static Value partial(WordValue value, DataType type, int index) {
        DataType dataType = type;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BoolType.class, ByteType.class}, (Object)dataType, 0)) {
            case 0 -> {
                BoolType unused = (BoolType)dataType;
                yield BoolValue.toBoolValue((value.shortValue() >>> index & 1) != 0);
            }
            case 1 -> {
                ByteType unused = (ByteType)dataType;
                yield ByteValue.toByteValue((byte)(value.shortValue() >>> index * 8));
            }
            default -> throw ValueOperations.createUnsupportedPartialOperationException(value, type);
        };
    }

    private static Value partial(DWordValue value, DataType type, int index) {
        DataType dataType = type;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BoolType.class, ByteType.class, WordType.class}, (Object)dataType, 0)) {
            case 0 -> {
                BoolType unused = (BoolType)dataType;
                yield BoolValue.toBoolValue((value.intValue() >>> index & 1) != 0);
            }
            case 1 -> {
                ByteType unused = (ByteType)dataType;
                yield ByteValue.toByteValue((byte)(value.intValue() >>> index * 8));
            }
            case 2 -> {
                WordType unused = (WordType)dataType;
                yield WordValue.toWordValue((short)(value.intValue() >>> index * 16));
            }
            default -> throw ValueOperations.createUnsupportedPartialOperationException(value, type);
        };
    }

    private static Value partial(LWordValue value, DataType type, int index) {
        DataType dataType = type;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BoolType.class, ByteType.class, WordType.class, DwordType.class}, (Object)dataType, 0)) {
            case 0 -> {
                BoolType unused = (BoolType)dataType;
                yield BoolValue.toBoolValue((value.longValue() >>> index & 1L) != 0L);
            }
            case 1 -> {
                ByteType unused = (ByteType)dataType;
                yield ByteValue.toByteValue((byte)(value.longValue() >>> index * 8));
            }
            case 2 -> {
                WordType unused = (WordType)dataType;
                yield WordValue.toWordValue((short)(value.longValue() >>> index * 16));
            }
            case 3 -> {
                DwordType unused = (DwordType)dataType;
                yield DWordValue.toDWordValue((int)(value.longValue() >>> index * 32));
            }
            default -> throw ValueOperations.createUnsupportedPartialOperationException(value, type);
        };
    }

    public static Value partial(Value value, DataType type, int index, Value partial) {
        LibraryElement libraryElement = value.getType();
        if (libraryElement instanceof AnyBitType) {
            AnyBitType valueType = (AnyBitType)libraryElement;
            if (type instanceof AnyBitType) {
                AnyBitType partialType = (AnyBitType)type;
                if (partial instanceof AnyBitValue) {
                    AnyBitValue partialValue = (AnyBitValue)partial;
                    if (type != value.getType() && valueType.isAssignableFrom((DataType)partialType)) {
                        if (value instanceof ByteValue) {
                            ByteValue byteValue = (ByteValue)value;
                            return ValueOperations.partial(byteValue, partialType, index, partialValue);
                        }
                        if (value instanceof DWordValue) {
                            DWordValue dwordValue = (DWordValue)value;
                            return ValueOperations.partial(dwordValue, partialType, index, partialValue);
                        }
                        if (value instanceof LWordValue) {
                            LWordValue lwordValue = (LWordValue)value;
                            return ValueOperations.partial(lwordValue, partialType, index, partialValue);
                        }
                        if (value instanceof WordValue) {
                            WordValue wordValue = (WordValue)value;
                            return ValueOperations.partial(wordValue, partialType, index, partialValue);
                        }
                    }
                }
            }
        }
        throw ValueOperations.createUnsupportedPartialOperationException(value, type);
    }

    private static Value partial(ByteValue value, AnyBitType type, int index, AnyBitValue partial) {
        return ByteValue.toByteValue(ValueOperations.combine(value.byteValue(), (byte)(partial.byteValue() << index * type.getBitSize()), (byte)(ValueOperations.bitMask(type) << index * type.getBitSize())));
    }

    private static Value partial(WordValue value, AnyBitType type, int index, AnyBitValue partial) {
        return WordValue.toWordValue(ValueOperations.combine(value.shortValue(), (short)(partial.shortValue() << index * type.getBitSize()), (short)(ValueOperations.bitMask(type) << index * type.getBitSize())));
    }

    private static Value partial(DWordValue value, AnyBitType type, int index, AnyBitValue partial) {
        return DWordValue.toDWordValue(ValueOperations.combine(value.intValue(), partial.intValue() << index * type.getBitSize(), (int)(ValueOperations.bitMask(type) << index * type.getBitSize())));
    }

    private static Value partial(LWordValue value, AnyBitType type, int index, AnyBitValue partial) {
        return LWordValue.toLWordValue(ValueOperations.combine(value.longValue(), partial.longValue() << index * type.getBitSize(), ValueOperations.bitMask(type) << index * type.getBitSize()));
    }

    private static byte combine(byte value, byte partial, byte mask) {
        return (byte)(value ^ (value ^ partial) & mask);
    }

    private static short combine(short value, short partial, short mask) {
        return (short)(value ^ (value ^ partial) & mask);
    }

    private static int combine(int value, int partial, int mask) {
        return value ^ (value ^ partial) & mask;
    }

    private static long combine(long value, long partial, long mask) {
        return value ^ (value ^ partial) & mask;
    }

    public static long bitMask(AnyBitType type) {
        return -1L >>> 64 - type.getBitSize();
    }

    public static Value defaultValue(LibraryElement type) {
        LibraryElement libraryElement = type;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LrealType.class, RealType.class, LintType.class, DintType.class, IntType.class, SintType.class, UlintType.class, UdintType.class, UintType.class, UsintType.class, LtimeType.class, TimeType.class, LwordType.class, DwordType.class, WordType.class, ByteType.class, BoolType.class, WstringType.class, StringType.class, WcharType.class, CharType.class, LdtType.class, DateAndTimeType.class, LtodType.class, TimeOfDayType.class, LdateType.class, DateType.class, AnyDateType.class, AnyCharType.class, AnyStringType.class, AnyCharsType.class, AnyBitType.class, AnyDurationType.class, AnyRealType.class, AnyUnsignedType.class, AnySignedType.class, AnyIntType.class, AnyNumType.class, AnyMagnitudeType.class, AnyElementaryType.class, ArrayType.class, StructuredType.class, EnumeratedType.class, AnyType.class, FBType.class}, (Object)libraryElement, 0)) {
            case -1 -> null;
            case 0 -> {
                LrealType unused = (LrealType)libraryElement;
                yield LRealValue.DEFAULT;
            }
            case 1 -> {
                RealType unused = (RealType)libraryElement;
                yield RealValue.DEFAULT;
            }
            case 2 -> {
                LintType unused = (LintType)libraryElement;
                yield LIntValue.DEFAULT;
            }
            case 3 -> {
                DintType unused = (DintType)libraryElement;
                yield DIntValue.DEFAULT;
            }
            case 4 -> {
                IntType unused = (IntType)libraryElement;
                yield IntValue.DEFAULT;
            }
            case 5 -> {
                SintType unused = (SintType)libraryElement;
                yield SIntValue.DEFAULT;
            }
            case 6 -> {
                UlintType unused = (UlintType)libraryElement;
                yield ULIntValue.DEFAULT;
            }
            case 7 -> {
                UdintType unused = (UdintType)libraryElement;
                yield UDIntValue.DEFAULT;
            }
            case 8 -> {
                UintType unused = (UintType)libraryElement;
                yield UIntValue.DEFAULT;
            }
            case 9 -> {
                UsintType unused = (UsintType)libraryElement;
                yield USIntValue.DEFAULT;
            }
            case 10 -> {
                LtimeType unused = (LtimeType)libraryElement;
                yield LTimeValue.DEFAULT;
            }
            case 11 -> {
                TimeType unused = (TimeType)libraryElement;
                yield TimeValue.DEFAULT;
            }
            case 12 -> {
                LwordType unused = (LwordType)libraryElement;
                yield LWordValue.DEFAULT;
            }
            case 13 -> {
                DwordType unused = (DwordType)libraryElement;
                yield DWordValue.DEFAULT;
            }
            case 14 -> {
                WordType unused = (WordType)libraryElement;
                yield WordValue.DEFAULT;
            }
            case 15 -> {
                ByteType unused = (ByteType)libraryElement;
                yield ByteValue.DEFAULT;
            }
            case 16 -> {
                BoolType unused = (BoolType)libraryElement;
                yield BoolValue.DEFAULT;
            }
            case 17 -> {
                WstringType unused = (WstringType)libraryElement;
                yield WStringValue.DEFAULT;
            }
            case 18 -> {
                StringType unused = (StringType)libraryElement;
                yield StringValue.DEFAULT;
            }
            case 19 -> {
                WcharType unused = (WcharType)libraryElement;
                yield WCharValue.DEFAULT;
            }
            case 20 -> {
                CharType unused = (CharType)libraryElement;
                yield CharValue.DEFAULT;
            }
            case 21 -> {
                LdtType unused = (LdtType)libraryElement;
                yield LDateAndTimeValue.DEFAULT;
            }
            case 22 -> {
                DateAndTimeType unused = (DateAndTimeType)libraryElement;
                yield DateAndTimeValue.DEFAULT;
            }
            case 23 -> {
                LtodType unused = (LtodType)libraryElement;
                yield LTimeOfDayValue.DEFAULT;
            }
            case 24 -> {
                TimeOfDayType unused = (TimeOfDayType)libraryElement;
                yield TimeOfDayValue.DEFAULT;
            }
            case 25 -> {
                LdateType unused = (LdateType)libraryElement;
                yield LDateValue.DEFAULT;
            }
            case 26 -> {
                DateType unused = (DateType)libraryElement;
                yield DateValue.DEFAULT;
            }
            case 27 -> {
                AnyDateType unused = (AnyDateType)libraryElement;
                yield LDateAndTimeValue.DEFAULT;
            }
            case 28 -> {
                AnyCharType unused = (AnyCharType)libraryElement;
                yield WCharValue.DEFAULT;
            }
            case 29 -> {
                AnyStringType unused = (AnyStringType)libraryElement;
                yield WStringValue.DEFAULT;
            }
            case 30 -> {
                AnyCharsType unused = (AnyCharsType)libraryElement;
                yield WStringValue.DEFAULT;
            }
            case 31 -> {
                AnyBitType unused = (AnyBitType)libraryElement;
                yield DWordValue.DEFAULT;
            }
            case 32 -> {
                AnyDurationType unused = (AnyDurationType)libraryElement;
                yield LTimeValue.DEFAULT;
            }
            case 33 -> {
                AnyRealType unused = (AnyRealType)libraryElement;
                yield LRealValue.DEFAULT;
            }
            case 34 -> {
                AnyUnsignedType unused = (AnyUnsignedType)libraryElement;
                yield UDIntValue.DEFAULT;
            }
            case 35 -> {
                AnySignedType unused = (AnySignedType)libraryElement;
                yield DIntValue.DEFAULT;
            }
            case 36 -> {
                AnyIntType unused = (AnyIntType)libraryElement;
                yield DIntValue.DEFAULT;
            }
            case 37 -> {
                AnyNumType unused = (AnyNumType)libraryElement;
                yield DIntValue.DEFAULT;
            }
            case 38 -> {
                AnyMagnitudeType unused = (AnyMagnitudeType)libraryElement;
                yield DIntValue.DEFAULT;
            }
            case 39 -> {
                AnyElementaryType unused = (AnyElementaryType)libraryElement;
                yield DIntValue.DEFAULT;
            }
            case 40 -> {
                ArrayType arrayType = (ArrayType)libraryElement;
                yield new ArrayValue(arrayType);
            }
            case 41 -> {
                StructuredType structType = (StructuredType)libraryElement;
                yield new StructValue(structType);
            }
            case 42 -> {
                EnumeratedType enumeratedType = (EnumeratedType)libraryElement;
                yield new EnumValue(enumeratedType);
            }
            case 43 -> {
                AnyType unused = (AnyType)libraryElement;
                yield DIntValue.DEFAULT;
            }
            case 44 -> {
                FBType fbType = (FBType)libraryElement;
                yield new FBValue(fbType);
            }
            default -> throw ValueOperations.createUnsupportedTypeException(type);
        };
    }

    public static Value castValue(Value value, LibraryElement type) {
        if (value == null) {
            return null;
        }
        if (type == null) {
            return value;
        }
        if (value.getType() == type) {
            return value;
        }
        Value value2 = value;
        Objects.requireNonNull(value2);
        Value value3 = value2;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BoolValue.class, AnyBitValue.class, AnyCharsValue.class, AnyDateValue.class, AnyMagnitudeValue.class, AnyDerivedValue.class}, (Object)value3, 0)) {
            case 0 -> {
                BoolValue boolValue = (BoolValue)value3;
                yield ValueOperations.castValue(boolValue, type);
            }
            case 1 -> {
                AnyBitValue anyBitValue = (AnyBitValue)value3;
                yield ValueOperations.castValue(anyBitValue, type);
            }
            case 2 -> {
                AnyCharsValue anyCharsValue = (AnyCharsValue)value3;
                yield ValueOperations.castValue(anyCharsValue, type);
            }
            case 3 -> {
                AnyDateValue anyDateValue = (AnyDateValue)value3;
                yield ValueOperations.castValue(anyDateValue, type);
            }
            case 4 -> {
                AnyMagnitudeValue anyMagnitudeValue = (AnyMagnitudeValue)value3;
                yield ValueOperations.castValue(anyMagnitudeValue, type);
            }
            case 5 -> {
                AnyDerivedValue anyDerivedValue = (AnyDerivedValue)value3;
                yield ValueOperations.castValue(anyDerivedValue, type);
            }
            default -> throw ValueOperations.createCastException(value, type);
        };
    }

    private static Value castValue(BoolValue value, LibraryElement type) {
        AnyBitValue anyBitValue;
        LibraryElement libraryElement;
        LibraryElement libraryElement2 = libraryElement = type;
        int n = 0;
        block7: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LwordType.class, DwordType.class, WordType.class, ByteType.class, DataType.class}, (Object)libraryElement2, n)) {
                case 0: {
                    LwordType unused = (LwordType)libraryElement;
                    anyBitValue = LWordValue.toLWordValue(value.longValue());
                    break block7;
                }
                case 1: {
                    DwordType unused = (DwordType)libraryElement;
                    anyBitValue = DWordValue.toDWordValue(value.intValue());
                    break block7;
                }
                case 2: {
                    WordType unused = (WordType)libraryElement;
                    anyBitValue = WordValue.toWordValue(value.shortValue());
                    break block7;
                }
                case 3: {
                    ByteType unused = (ByteType)libraryElement;
                    anyBitValue = ByteValue.toByteValue(value.byteValue());
                    break block7;
                }
                case 4: {
                    DataType dataType = (DataType)libraryElement;
                    if (!dataType.isAssignableFrom((DataType)value.getType())) {
                        libraryElement2 = libraryElement;
                        n = 5;
                        continue block7;
                    }
                    anyBitValue = value;
                    break block7;
                }
                default: {
                    throw ValueOperations.createCastException(value, type);
                }
            }
            break;
        }
        return anyBitValue;
    }

    private static Value castValue(AnyMagnitudeValue value, LibraryElement type) {
        AnyElementaryValue anyElementaryValue;
        LibraryElement libraryElement;
        LibraryElement libraryElement2 = libraryElement = type;
        int n = 0;
        block19: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LrealType.class, RealType.class, LintType.class, DintType.class, IntType.class, SintType.class, UlintType.class, UdintType.class, UintType.class, UsintType.class, LtimeType.class, TimeType.class, LwordType.class, DwordType.class, WordType.class, ByteType.class, DataType.class}, (Object)libraryElement2, n)) {
                case 0: {
                    LrealType unused = (LrealType)libraryElement;
                    anyElementaryValue = LRealValue.toLRealValue(value);
                    break block19;
                }
                case 1: {
                    RealType unused = (RealType)libraryElement;
                    anyElementaryValue = RealValue.toRealValue(value);
                    break block19;
                }
                case 2: {
                    LintType unused = (LintType)libraryElement;
                    anyElementaryValue = LIntValue.toLIntValue(value);
                    break block19;
                }
                case 3: {
                    DintType unused = (DintType)libraryElement;
                    anyElementaryValue = DIntValue.toDIntValue(value);
                    break block19;
                }
                case 4: {
                    IntType unused = (IntType)libraryElement;
                    anyElementaryValue = IntValue.toIntValue(value);
                    break block19;
                }
                case 5: {
                    SintType unused = (SintType)libraryElement;
                    anyElementaryValue = SIntValue.toSIntValue(value);
                    break block19;
                }
                case 6: {
                    UlintType unused = (UlintType)libraryElement;
                    anyElementaryValue = ULIntValue.toULIntValue(value);
                    break block19;
                }
                case 7: {
                    UdintType unused = (UdintType)libraryElement;
                    anyElementaryValue = UDIntValue.toUDIntValue(value);
                    break block19;
                }
                case 8: {
                    UintType unused = (UintType)libraryElement;
                    anyElementaryValue = UIntValue.toUIntValue(value);
                    break block19;
                }
                case 9: {
                    UsintType unused = (UsintType)libraryElement;
                    anyElementaryValue = USIntValue.toUSIntValue(value);
                    break block19;
                }
                case 10: {
                    LtimeType unused = (LtimeType)libraryElement;
                    anyElementaryValue = LTimeValue.toLTimeValue(value);
                    break block19;
                }
                case 11: {
                    TimeType unused = (TimeType)libraryElement;
                    anyElementaryValue = TimeValue.toTimeValue(value);
                    break block19;
                }
                case 12: {
                    LwordType unused = (LwordType)libraryElement;
                    anyElementaryValue = LWordValue.toLWordValue(value.longValue());
                    break block19;
                }
                case 13: {
                    DwordType unused = (DwordType)libraryElement;
                    anyElementaryValue = DWordValue.toDWordValue(value.intValue());
                    break block19;
                }
                case 14: {
                    WordType unused = (WordType)libraryElement;
                    anyElementaryValue = WordValue.toWordValue(value.shortValue());
                    break block19;
                }
                case 15: {
                    ByteType unused = (ByteType)libraryElement;
                    anyElementaryValue = ByteValue.toByteValue(value.byteValue());
                    break block19;
                }
                case 16: {
                    DataType dataType = (DataType)libraryElement;
                    if (!dataType.isAssignableFrom((DataType)value.getType())) {
                        libraryElement2 = libraryElement;
                        n = 17;
                        continue block19;
                    }
                    anyElementaryValue = value;
                    break block19;
                }
                default: {
                    throw ValueOperations.createCastException(value, type);
                }
            }
            break;
        }
        return anyElementaryValue;
    }

    private static Value castValue(AnyBitValue value, LibraryElement type) {
        AnyElementaryValue anyElementaryValue;
        LibraryElement libraryElement;
        LibraryElement libraryElement2 = libraryElement = type;
        int n = 0;
        block18: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LrealType.class, RealType.class, LintType.class, DintType.class, IntType.class, SintType.class, UlintType.class, UdintType.class, UintType.class, UsintType.class, LwordType.class, DwordType.class, WordType.class, ByteType.class, BoolType.class, DataType.class}, (Object)libraryElement2, n)) {
                case 0: {
                    LrealType unused = (LrealType)libraryElement;
                    anyElementaryValue = LRealValue.toLRealValue(value.longValue());
                    break block18;
                }
                case 1: {
                    RealType unused = (RealType)libraryElement;
                    anyElementaryValue = RealValue.toRealValue(value.longValue());
                    break block18;
                }
                case 2: {
                    LintType unused = (LintType)libraryElement;
                    anyElementaryValue = LIntValue.toLIntValue(value.longValue());
                    break block18;
                }
                case 3: {
                    DintType unused = (DintType)libraryElement;
                    anyElementaryValue = DIntValue.toDIntValue(value.intValue());
                    break block18;
                }
                case 4: {
                    IntType unused = (IntType)libraryElement;
                    anyElementaryValue = IntValue.toIntValue(value.shortValue());
                    break block18;
                }
                case 5: {
                    SintType unused = (SintType)libraryElement;
                    anyElementaryValue = SIntValue.toSIntValue(value.byteValue());
                    break block18;
                }
                case 6: {
                    UlintType unused = (UlintType)libraryElement;
                    anyElementaryValue = ULIntValue.toULIntValue(value.longValue());
                    break block18;
                }
                case 7: {
                    UdintType unused = (UdintType)libraryElement;
                    anyElementaryValue = UDIntValue.toUDIntValue(value.intValue());
                    break block18;
                }
                case 8: {
                    UintType unused = (UintType)libraryElement;
                    anyElementaryValue = UIntValue.toUIntValue(value.shortValue());
                    break block18;
                }
                case 9: {
                    UsintType unused = (UsintType)libraryElement;
                    anyElementaryValue = USIntValue.toUSIntValue(value.byteValue());
                    break block18;
                }
                case 10: {
                    LwordType unused = (LwordType)libraryElement;
                    anyElementaryValue = LWordValue.toLWordValue(value);
                    break block18;
                }
                case 11: {
                    DwordType unused = (DwordType)libraryElement;
                    anyElementaryValue = DWordValue.toDWordValue(value);
                    break block18;
                }
                case 12: {
                    WordType unused = (WordType)libraryElement;
                    anyElementaryValue = WordValue.toWordValue(value);
                    break block18;
                }
                case 13: {
                    ByteType unused = (ByteType)libraryElement;
                    anyElementaryValue = ByteValue.toByteValue(value);
                    break block18;
                }
                case 14: {
                    BoolType unused = (BoolType)libraryElement;
                    anyElementaryValue = BoolValue.toBoolValue(value);
                    break block18;
                }
                case 15: {
                    DataType dataType = (DataType)libraryElement;
                    if (!dataType.isAssignableFrom((DataType)value.getType())) {
                        libraryElement2 = libraryElement;
                        n = 16;
                        continue block18;
                    }
                    anyElementaryValue = value;
                    break block18;
                }
                default: {
                    throw ValueOperations.createCastException(value, type);
                }
            }
            break;
        }
        return anyElementaryValue;
    }

    private static Value castValue(AnyCharsValue value, LibraryElement type) {
        AnyCharsValue anyCharsValue;
        LibraryElement libraryElement;
        LibraryElement libraryElement2 = libraryElement = type;
        int n = 0;
        block7: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WstringType.class, StringType.class, WcharType.class, CharType.class, DataType.class}, (Object)libraryElement2, n)) {
                case 0: {
                    WstringType wstringType = (WstringType)libraryElement;
                    if (wstringType.isSetMaxLength()) {
                        anyCharsValue = WStringValue.toWStringValue(value, wstringType.getMaxLength());
                        break block7;
                    }
                    anyCharsValue = WStringValue.toWStringValue(value);
                    break block7;
                }
                case 1: {
                    StringType stringType = (StringType)libraryElement;
                    if (stringType.isSetMaxLength()) {
                        anyCharsValue = StringValue.toStringValue(value, stringType.getMaxLength());
                        break block7;
                    }
                    anyCharsValue = StringValue.toStringValue(value);
                    break block7;
                }
                case 2: {
                    WcharType unused = (WcharType)libraryElement;
                    anyCharsValue = WCharValue.toWCharValue(value);
                    break block7;
                }
                case 3: {
                    CharType unused = (CharType)libraryElement;
                    anyCharsValue = CharValue.toCharValue(value);
                    break block7;
                }
                case 4: {
                    DataType dataType = (DataType)libraryElement;
                    if (!dataType.isAssignableFrom((DataType)value.getType())) {
                        libraryElement2 = libraryElement;
                        n = 5;
                        continue block7;
                    }
                    anyCharsValue = value;
                    break block7;
                }
                default: {
                    throw ValueOperations.createCastException(value, type);
                }
            }
            break;
        }
        return anyCharsValue;
    }

    private static Value castValue(AnyDateValue value, LibraryElement type) {
        AnyDateValue anyDateValue;
        LibraryElement libraryElement;
        LibraryElement libraryElement2 = libraryElement = type;
        int n = 0;
        block9: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LdtType.class, DateAndTimeType.class, LtodType.class, TimeOfDayType.class, LdateType.class, DateType.class, DataType.class}, (Object)libraryElement2, n)) {
                case 0: {
                    LdtType unused = (LdtType)libraryElement;
                    anyDateValue = LDateAndTimeValue.toLDateAndTimeValue(value);
                    break block9;
                }
                case 1: {
                    DateAndTimeType unused = (DateAndTimeType)libraryElement;
                    anyDateValue = DateAndTimeValue.toDateAndTimeValue(value);
                    break block9;
                }
                case 2: {
                    LtodType unused = (LtodType)libraryElement;
                    anyDateValue = LTimeOfDayValue.toLTimeOfDayValue(value);
                    break block9;
                }
                case 3: {
                    TimeOfDayType unused = (TimeOfDayType)libraryElement;
                    anyDateValue = TimeOfDayValue.toTimeOfDayValue(value);
                    break block9;
                }
                case 4: {
                    LdateType unused = (LdateType)libraryElement;
                    anyDateValue = LDateValue.toLDateValue(value);
                    break block9;
                }
                case 5: {
                    DateType unused = (DateType)libraryElement;
                    anyDateValue = DateValue.toDateValue(value);
                    break block9;
                }
                case 6: {
                    DataType dataType = (DataType)libraryElement;
                    if (!dataType.isAssignableFrom((DataType)value.getType())) {
                        libraryElement2 = libraryElement;
                        n = 7;
                        continue block9;
                    }
                    anyDateValue = value;
                    break block9;
                }
                default: {
                    throw ValueOperations.createCastException(value, type);
                }
            }
            break;
        }
        return anyDateValue;
    }

    private static Value castValue(AnyDerivedValue value, LibraryElement type) {
        LibraryElement libraryElement;
        LibraryElement libraryElement2 = libraryElement = type;
        int n = 0;
        block3: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataType.class}, (Object)libraryElement2, n)) {
                case 0: {
                    DataType dataType = (DataType)libraryElement;
                    if (dataType.isAssignableFrom((DataType)value.getType())) break block3;
                    libraryElement2 = libraryElement;
                    n = 1;
                    continue block3;
                }
                default: {
                    throw ValueOperations.createCastException(value, type);
                }
            }
            break;
        }
        return value;
    }

    public static Value wrapValue(Object value, LibraryElement type) {
        if (value == null) {
            return ValueOperations.defaultValue(type);
        }
        if (value instanceof TypedValue) {
            TypedValue typedValue = (TypedValue)value;
            return ValueOperations.castValue(ValueOperations.wrapValue(typedValue.value(), (LibraryElement)typedValue.type()), type);
        }
        LibraryElement libraryElement = type;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LrealType.class, RealType.class, LintType.class, DintType.class, IntType.class, SintType.class, UlintType.class, UdintType.class, UintType.class, UsintType.class, LtimeType.class, TimeType.class, LwordType.class, DwordType.class, WordType.class, ByteType.class, BoolType.class, WstringType.class, StringType.class, WcharType.class, CharType.class, LdtType.class, DateAndTimeType.class, LtodType.class, TimeOfDayType.class, LdateType.class, DateType.class, AnyDateType.class, AnyCharType.class, AnyStringType.class, AnyCharsType.class, AnyBitType.class, AnyDurationType.class, AnyRealType.class, AnyUnsignedType.class, AnySignedType.class, AnyIntType.class, ArrayType.class, StructuredType.class, EnumeratedType.class, AnyType.class, FBType.class}, (Object)libraryElement, 0)) {
            case -1 -> null;
            case 0 -> {
                LrealType unused = (LrealType)libraryElement;
                Object v1 = value;
                Objects.requireNonNull(v1);
                Object var5_5 = v1;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class}, (Object)var5_5, 0)) {
                    case 0: {
                        Number number = (Number)var5_5;
                        yield LRealValue.toLRealValue(number);
                    }
                }
                yield LRealValue.toLRealValue(value.toString());
            }
            case 1 -> {
                RealType unused = (RealType)libraryElement;
                Object v2 = value;
                Objects.requireNonNull(v2);
                Object number = v2;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield RealValue.toRealValue(number);
                    }
                }
                yield RealValue.toRealValue(value.toString());
            }
            case 2 -> {
                LintType unused = (LintType)libraryElement;
                Object v3 = value;
                Objects.requireNonNull(v3);
                Object number = v3;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield LIntValue.toLIntValue(number);
                    }
                }
                yield LIntValue.toLIntValue(value.toString());
            }
            case 3 -> {
                DintType unused = (DintType)libraryElement;
                Object v4 = value;
                Objects.requireNonNull(v4);
                Object number = v4;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield DIntValue.toDIntValue(number);
                    }
                }
                yield DIntValue.toDIntValue(value.toString());
            }
            case 4 -> {
                IntType unused = (IntType)libraryElement;
                Object v5 = value;
                Objects.requireNonNull(v5);
                Object number = v5;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield IntValue.toIntValue(number);
                    }
                }
                yield IntValue.toIntValue(value.toString());
            }
            case 5 -> {
                SintType unused = (SintType)libraryElement;
                Object v6 = value;
                Objects.requireNonNull(v6);
                Object number = v6;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield SIntValue.toSIntValue(number);
                    }
                }
                yield SIntValue.toSIntValue(value.toString());
            }
            case 6 -> {
                UlintType unused = (UlintType)libraryElement;
                Object v7 = value;
                Objects.requireNonNull(v7);
                Object number = v7;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield ULIntValue.toULIntValue(number);
                    }
                }
                yield ULIntValue.toULIntValue(value.toString());
            }
            case 7 -> {
                UdintType unused = (UdintType)libraryElement;
                Object v8 = value;
                Objects.requireNonNull(v8);
                Object number = v8;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield UDIntValue.toUDIntValue(number);
                    }
                }
                yield UDIntValue.toUDIntValue(value.toString());
            }
            case 8 -> {
                UintType unused = (UintType)libraryElement;
                Object v9 = value;
                Objects.requireNonNull(v9);
                Object number = v9;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield UIntValue.toUIntValue(number);
                    }
                }
                yield UIntValue.toUIntValue(value.toString());
            }
            case 9 -> {
                UsintType unused = (UsintType)libraryElement;
                Object v10 = value;
                Objects.requireNonNull(v10);
                Object number = v10;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield USIntValue.toUSIntValue(number);
                    }
                }
                yield USIntValue.toUSIntValue(value.toString());
            }
            case 10 -> {
                LtimeType unused = (LtimeType)libraryElement;
                Object v11 = value;
                Objects.requireNonNull(v11);
                Object number = v11;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, Duration.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield LTimeValue.toLTimeValue(number);
                    }
                    case 1: {
                        Duration duration = (Duration)number;
                        yield LTimeValue.toLTimeValue(duration);
                    }
                }
                yield LTimeValue.toLTimeValue(value.toString());
            }
            case 11 -> {
                TimeType unused = (TimeType)libraryElement;
                Object v12 = value;
                Objects.requireNonNull(v12);
                Object number = v12;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, Duration.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield TimeValue.toTimeValue(number);
                    }
                    case 1: {
                        Duration duration = (Duration)number;
                        yield TimeValue.toTimeValue(duration);
                    }
                }
                yield TimeValue.toTimeValue(value.toString());
            }
            case 12 -> {
                LwordType unused = (LwordType)libraryElement;
                Object v13 = value;
                Objects.requireNonNull(v13);
                Object number = v13;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield LWordValue.toLWordValue(number);
                    }
                }
                yield LWordValue.toLWordValue(value.toString());
            }
            case 13 -> {
                DwordType unused = (DwordType)libraryElement;
                Object v14 = value;
                Objects.requireNonNull(v14);
                Object number = v14;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield DWordValue.toDWordValue(number);
                    }
                }
                yield DWordValue.toDWordValue(value.toString());
            }
            case 14 -> {
                WordType unused = (WordType)libraryElement;
                Object v15 = value;
                Objects.requireNonNull(v15);
                Object number = v15;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield WordValue.toWordValue(number);
                    }
                }
                yield WordValue.toWordValue(value.toString());
            }
            case 15 -> {
                ByteType unused = (ByteType)libraryElement;
                Object v16 = value;
                Objects.requireNonNull(v16);
                Object number = v16;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield ByteValue.toByteValue(number);
                    }
                }
                yield ByteValue.toByteValue(value.toString());
            }
            case 16 -> {
                BoolType unused = (BoolType)libraryElement;
                Object v17 = value;
                Objects.requireNonNull(v17);
                Object number = v17;
                boolean v18 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Number.class}, (Object)number, 0)) {
                    case 0 -> {
                        Boolean bool = (Boolean)number;
                        yield bool;
                    }
                    case 1 -> {
                        Number number = (Number)number;
                        if (number.longValue() != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> true;
                };
                yield BoolValue.toBoolValue(v18);
            }
            case 17 -> {
                WstringType wstringType = (WstringType)libraryElement;
                if (wstringType.isSetMaxLength()) {
                    yield WStringValue.toWStringValue(value.toString(), wstringType.getMaxLength());
                }
                yield WStringValue.toWStringValue(value.toString());
            }
            case 18 -> {
                StringType stringType = (StringType)libraryElement;
                if (stringType.isSetMaxLength()) {
                    yield StringValue.toStringValue(value.toString(), stringType.getMaxLength());
                }
                yield StringValue.toStringValue(value.toString());
            }
            case 19 -> {
                WcharType unused = (WcharType)libraryElement;
                Object v19 = value;
                Objects.requireNonNull(v19);
                Object var24_61 = v19;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Character.class}, (Object)var24_61, 0)) {
                    case 0: {
                        Character character = (Character)var24_61;
                        yield WCharValue.toWCharValue(character.charValue());
                    }
                }
                yield WCharValue.toWCharValue(value.toString());
            }
            case 20 -> {
                CharType unused = (CharType)libraryElement;
                Object v20 = value;
                Objects.requireNonNull(v20);
                Object character = v20;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Character.class}, (Object)character, 0)) {
                    case 0: {
                        Byte byteValue = (Byte)character;
                        yield CharValue.toCharValue(byteValue);
                    }
                    case 1: {
                        Character character = (Character)character;
                        yield CharValue.toCharValue((byte)character.charValue());
                    }
                }
                yield CharValue.toCharValue(value.toString());
            }
            case 21 -> {
                LdtType unused = (LdtType)libraryElement;
                Object v21 = value;
                Objects.requireNonNull(v21);
                Object byteValue = v21;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, LocalDateTime.class}, (Object)byteValue, 0)) {
                    case 0: {
                        Number number = (Number)byteValue;
                        yield LDateAndTimeValue.toLDateAndTimeValue(number);
                    }
                    case 1: {
                        LocalDateTime localDateTime = (LocalDateTime)byteValue;
                        yield LDateAndTimeValue.toLDateAndTimeValue(localDateTime);
                    }
                }
                yield LDateAndTimeValue.toLDateAndTimeValue(value.toString());
            }
            case 22 -> {
                DateAndTimeType unused = (DateAndTimeType)libraryElement;
                Object v22 = value;
                Objects.requireNonNull(v22);
                Object number = v22;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, LocalDateTime.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield DateAndTimeValue.toDateAndTimeValue(number);
                    }
                    case 1: {
                        LocalDateTime localDateTime = (LocalDateTime)number;
                        yield DateAndTimeValue.toDateAndTimeValue(localDateTime);
                    }
                }
                yield DateAndTimeValue.toDateAndTimeValue(value.toString());
            }
            case 23 -> {
                LtodType unused = (LtodType)libraryElement;
                Object v23 = value;
                Objects.requireNonNull(v23);
                Object number = v23;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, LocalTime.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield LTimeOfDayValue.toLTimeOfDayValue(number);
                    }
                    case 1: {
                        LocalTime localTime = (LocalTime)number;
                        yield LTimeOfDayValue.toLTimeOfDayValue(localTime);
                    }
                }
                yield LTimeOfDayValue.toLTimeOfDayValue(value.toString());
            }
            case 24 -> {
                TimeOfDayType unused = (TimeOfDayType)libraryElement;
                Object v24 = value;
                Objects.requireNonNull(v24);
                Object number = v24;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, LocalTime.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield TimeOfDayValue.toTimeOfDayValue(number);
                    }
                    case 1: {
                        LocalTime localTime = (LocalTime)number;
                        yield TimeOfDayValue.toTimeOfDayValue(localTime);
                    }
                }
                yield TimeOfDayValue.toTimeOfDayValue(value.toString());
            }
            case 25 -> {
                LdateType unused = (LdateType)libraryElement;
                Object v25 = value;
                Objects.requireNonNull(v25);
                Object number = v25;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, LocalDate.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield LDateValue.toLDateValue(number);
                    }
                    case 1: {
                        LocalDate localDate = (LocalDate)number;
                        yield LDateValue.toLDateValue(localDate);
                    }
                }
                yield LDateValue.toLDateValue(value.toString());
            }
            case 26 -> {
                DateType unused = (DateType)libraryElement;
                Object v26 = value;
                Objects.requireNonNull(v26);
                Object number = v26;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, LocalDate.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield DateValue.toDateValue(number);
                    }
                    case 1: {
                        LocalDate localDate = (LocalDate)number;
                        yield DateValue.toDateValue(localDate);
                    }
                }
                yield DateValue.toDateValue(value.toString());
            }
            case 27 -> {
                AnyDateType unused = (AnyDateType)libraryElement;
                Object v27 = value;
                Objects.requireNonNull(v27);
                Object number = v27;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, LocalDateTime.class, LocalTime.class, LocalDate.class}, (Object)number, 0)) {
                    case 0: {
                        Number number = (Number)number;
                        yield LDateAndTimeValue.toLDateAndTimeValue(number);
                    }
                    case 1: {
                        LocalDateTime localDateTime = (LocalDateTime)number;
                        yield LDateAndTimeValue.toLDateAndTimeValue(localDateTime);
                    }
                    case 2: {
                        LocalTime localTime = (LocalTime)number;
                        yield LTimeOfDayValue.toLTimeOfDayValue(localTime);
                    }
                    case 3: {
                        LocalDate localDate = (LocalDate)number;
                        yield LDateValue.toLDateValue(localDate);
                    }
                }
                yield LDateAndTimeValue.toLDateAndTimeValue(value.toString());
            }
            case 28 -> {
                AnyCharType unused = (AnyCharType)libraryElement;
                Object v28 = value;
                Objects.requireNonNull(v28);
                Object number = v28;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Character.class}, (Object)number, 0)) {
                    case 0: {
                        Byte byteValue = (Byte)number;
                        yield CharValue.toCharValue(byteValue);
                    }
                    case 1: {
                        Character character = (Character)number;
                        yield WCharValue.toWCharValue(character.charValue());
                    }
                }
                yield WCharValue.toWCharValue(value.toString());
            }
            case 29 -> {
                AnyStringType unused = (AnyStringType)libraryElement;
                yield WStringValue.toWStringValue(value.toString());
            }
            case 30 -> {
                AnyCharsType unused = (AnyCharsType)libraryElement;
                yield WStringValue.toWStringValue(value.toString());
            }
            case 31 -> {
                AnyBitType unused = (AnyBitType)libraryElement;
                Object v29 = value;
                Objects.requireNonNull(v29);
                Object localDate = v29;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Character.class, Integer.class, Long.class, Number.class}, (Object)localDate, 0)) {
                    case 0: {
                        Byte byteValue = (Byte)localDate;
                        yield ByteValue.toByteValue(byteValue);
                    }
                    case 1: {
                        Short shortValue = (Short)localDate;
                        yield WordValue.toWordValue(shortValue);
                    }
                    case 2: {
                        Character character = (Character)localDate;
                        yield WordValue.toWordValue((short)character.charValue());
                    }
                    case 3: {
                        Integer integer = (Integer)localDate;
                        yield DWordValue.toDWordValue(integer);
                    }
                    case 4: {
                        Long longValue = (Long)localDate;
                        yield LWordValue.toLWordValue(longValue);
                    }
                    case 5: {
                        Number number = (Number)localDate;
                        yield DWordValue.toDWordValue(number);
                    }
                }
                yield DWordValue.toDWordValue(value.toString());
            }
            case 32 -> {
                AnyDurationType unused = (AnyDurationType)libraryElement;
                Object v30 = value;
                Objects.requireNonNull(v30);
                Object byteValue = v30;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, Duration.class}, (Object)byteValue, 0)) {
                    case 0: {
                        Number number = (Number)byteValue;
                        yield LTimeValue.toLTimeValue(number);
                    }
                    case 1: {
                        Duration duration = (Duration)byteValue;
                        yield LTimeValue.toLTimeValue(duration);
                    }
                }
                yield LTimeValue.toLTimeValue(value.toString());
            }
            case 33 -> {
                AnyRealType unused = (AnyRealType)libraryElement;
                Object v31 = value;
                Objects.requireNonNull(v31);
                Object number = v31;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Float.class, Number.class}, (Object)number, 0)) {
                    case 0: {
                        Float floatValue = (Float)number;
                        yield RealValue.toRealValue(floatValue);
                    }
                    case 1: {
                        Number number = (Number)number;
                        yield LRealValue.toLRealValue(number);
                    }
                }
                yield LRealValue.toLRealValue(value.toString());
            }
            case 34 -> {
                AnyUnsignedType unused = (AnyUnsignedType)libraryElement;
                Object v32 = value;
                Objects.requireNonNull(v32);
                Object floatValue = v32;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Character.class, Integer.class, Long.class, Number.class}, (Object)floatValue, 0)) {
                    case 0: {
                        Byte byteValue = (Byte)floatValue;
                        yield USIntValue.toUSIntValue(byteValue);
                    }
                    case 1: {
                        Short shortValue = (Short)floatValue;
                        yield UIntValue.toUIntValue(shortValue);
                    }
                    case 2: {
                        Character character = (Character)floatValue;
                        yield UIntValue.toUIntValue((short)character.charValue());
                    }
                    case 3: {
                        Integer integer = (Integer)floatValue;
                        yield UDIntValue.toUDIntValue(integer);
                    }
                    case 4: {
                        Long longValue = (Long)floatValue;
                        yield ULIntValue.toULIntValue(longValue);
                    }
                    case 5: {
                        Number number = (Number)floatValue;
                        yield UDIntValue.toUDIntValue(number);
                    }
                }
                yield UDIntValue.toUDIntValue(value.toString());
            }
            case 35 -> {
                AnySignedType unused = (AnySignedType)libraryElement;
                Object v33 = value;
                Objects.requireNonNull(v33);
                Object byteValue = v33;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Character.class, Integer.class, Long.class, Number.class}, (Object)byteValue, 0)) {
                    case 0: {
                        Byte byteValue = (Byte)byteValue;
                        yield SIntValue.toSIntValue(byteValue);
                    }
                    case 1: {
                        Short shortValue = (Short)byteValue;
                        yield IntValue.toIntValue(shortValue);
                    }
                    case 2: {
                        Character character = (Character)byteValue;
                        yield IntValue.toIntValue((short)character.charValue());
                    }
                    case 3: {
                        Integer integer = (Integer)byteValue;
                        yield DIntValue.toDIntValue(integer);
                    }
                    case 4: {
                        Long longValue = (Long)byteValue;
                        yield LIntValue.toLIntValue(longValue);
                    }
                    case 5: {
                        Number number = (Number)byteValue;
                        yield DIntValue.toDIntValue(number);
                    }
                }
                yield DIntValue.toDIntValue(value.toString());
            }
            case 36 -> {
                AnyIntType unused = (AnyIntType)libraryElement;
                Object v34 = value;
                Objects.requireNonNull(v34);
                Object byteValue = v34;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Character.class, Integer.class, Long.class, Number.class}, (Object)byteValue, 0)) {
                    case 0: {
                        Byte byteValue = (Byte)byteValue;
                        yield SIntValue.toSIntValue(byteValue);
                    }
                    case 1: {
                        Short shortValue = (Short)byteValue;
                        yield IntValue.toIntValue(shortValue);
                    }
                    case 2: {
                        Character character = (Character)byteValue;
                        yield UIntValue.toUIntValue((short)character.charValue());
                    }
                    case 3: {
                        Integer integer = (Integer)byteValue;
                        yield DIntValue.toDIntValue(integer);
                    }
                    case 4: {
                        Long longValue = (Long)byteValue;
                        yield LIntValue.toLIntValue(longValue);
                    }
                    case 5: {
                        Number number = (Number)byteValue;
                        yield DIntValue.toDIntValue(number);
                    }
                }
                yield DIntValue.toDIntValue(value.toString());
            }
            case 37 -> {
                ArrayType arrayType = (ArrayType)libraryElement;
                yield new ArrayValue(arrayType, (List)value);
            }
            case 38 -> {
                StructuredType structType = (StructuredType)libraryElement;
                yield new StructValue(structType, ValueOperations.castMemberMap((Map)value));
            }
            case 39 -> {
                EnumeratedType enumeratedType = (EnumeratedType)libraryElement;
                yield new EnumValue((EnumeratedValue)value);
            }
            case 40 -> {
                AnyType unused = (AnyType)libraryElement;
                Object v35 = value;
                Objects.requireNonNull(v35);
                Object integer = v35;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class, BigDecimal.class, Number.class}, (Object)integer, 0)) {
                    case 0: {
                        Byte byteValue = (Byte)integer;
                        yield SIntValue.toSIntValue(byteValue);
                    }
                    case 1: {
                        Short shortValue = (Short)integer;
                        yield IntValue.toIntValue(shortValue);
                    }
                    case 2: {
                        Character character = (Character)integer;
                        yield UIntValue.toUIntValue((short)character.charValue());
                    }
                    case 3: {
                        Integer integer = (Integer)integer;
                        yield DIntValue.toDIntValue(integer);
                    }
                    case 4: {
                        Long longValue = (Long)integer;
                        yield LIntValue.toLIntValue(longValue);
                    }
                    case 5: {
                        Float floatValue = (Float)integer;
                        yield RealValue.toRealValue(floatValue);
                    }
                    case 6: {
                        Double doubleValue = (Double)integer;
                        yield LRealValue.toLRealValue(doubleValue);
                    }
                    case 7: {
                        BigDecimal bigDecimal = (BigDecimal)integer;
                        yield LRealValue.toLRealValue(bigDecimal);
                    }
                    case 8: {
                        Number number = (Number)integer;
                        yield DIntValue.toDIntValue(number);
                    }
                }
                yield DIntValue.toDIntValue(value.toString());
            }
            case 41 -> {
                FBType fbType = (FBType)libraryElement;
                yield new FBValue(fbType, ValueOperations.castMemberMap((Map)value));
            }
            default -> throw ValueOperations.createUnsupportedTypeException(type);
        };
    }

    public static Value parseValue(String value, LibraryElement type) {
        return ValueOperations.parseValue(value, type, null);
    }

    public static Value parseValue(String value, LibraryElement type, DataTypeLibrary typeLibrary) {
        if (value == null || value.isEmpty()) {
            return ValueOperations.defaultValue(type);
        }
        if (type instanceof DataType) {
            DataType dataType = (DataType)type;
            return ValueOperations.wrapValue(new TypedValueConverter(dataType, typeLibrary).toTypedValue(value), type);
        }
        throw ValueOperations.createUnsupportedTypeException(type);
    }

    public static Class<? extends Value> valueType(LibraryElement type) {
        LibraryElement libraryElement = type;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LrealType.class, RealType.class, LintType.class, DintType.class, IntType.class, SintType.class, UlintType.class, UdintType.class, UintType.class, UsintType.class, LtimeType.class, TimeType.class, LwordType.class, DwordType.class, WordType.class, ByteType.class, BoolType.class, WstringType.class, StringType.class, WcharType.class, CharType.class, LdtType.class, DateAndTimeType.class, LtodType.class, TimeOfDayType.class, LdateType.class, DateType.class, AnySignedType.class, AnyUnsignedType.class, AnyIntType.class, AnyRealType.class, AnyNumType.class, AnyDurationType.class, AnyMagnitudeType.class, AnyBitType.class, AnyCharType.class, AnyStringType.class, AnyCharsType.class, AnyDateType.class, AnyElementaryType.class, ArrayType.class, StructuredType.class, EnumeratedType.class, AnyDerivedType.class, AnyType.class}, (Object)libraryElement, 0)) {
            case 0 -> {
                LrealType unused = (LrealType)libraryElement;
                yield LRealValue.class;
            }
            case 1 -> {
                RealType unused = (RealType)libraryElement;
                yield RealValue.class;
            }
            case 2 -> {
                LintType unused = (LintType)libraryElement;
                yield LIntValue.class;
            }
            case 3 -> {
                DintType unused = (DintType)libraryElement;
                yield DIntValue.class;
            }
            case 4 -> {
                IntType unused = (IntType)libraryElement;
                yield IntValue.class;
            }
            case 5 -> {
                SintType unused = (SintType)libraryElement;
                yield SIntValue.class;
            }
            case 6 -> {
                UlintType unused = (UlintType)libraryElement;
                yield ULIntValue.class;
            }
            case 7 -> {
                UdintType unused = (UdintType)libraryElement;
                yield UDIntValue.class;
            }
            case 8 -> {
                UintType unused = (UintType)libraryElement;
                yield UIntValue.class;
            }
            case 9 -> {
                UsintType unused = (UsintType)libraryElement;
                yield USIntValue.class;
            }
            case 10 -> {
                LtimeType unused = (LtimeType)libraryElement;
                yield LTimeValue.class;
            }
            case 11 -> {
                TimeType unused = (TimeType)libraryElement;
                yield TimeValue.class;
            }
            case 12 -> {
                LwordType unused = (LwordType)libraryElement;
                yield LWordValue.class;
            }
            case 13 -> {
                DwordType unused = (DwordType)libraryElement;
                yield DWordValue.class;
            }
            case 14 -> {
                WordType unused = (WordType)libraryElement;
                yield WordValue.class;
            }
            case 15 -> {
                ByteType unused = (ByteType)libraryElement;
                yield ByteValue.class;
            }
            case 16 -> {
                BoolType unused = (BoolType)libraryElement;
                yield BoolValue.class;
            }
            case 17 -> {
                WstringType unused = (WstringType)libraryElement;
                yield WStringValue.class;
            }
            case 18 -> {
                StringType unused = (StringType)libraryElement;
                yield StringValue.class;
            }
            case 19 -> {
                WcharType unused = (WcharType)libraryElement;
                yield WCharValue.class;
            }
            case 20 -> {
                CharType unused = (CharType)libraryElement;
                yield CharValue.class;
            }
            case 21 -> {
                LdtType unused = (LdtType)libraryElement;
                yield LDateAndTimeValue.class;
            }
            case 22 -> {
                DateAndTimeType unused = (DateAndTimeType)libraryElement;
                yield DateAndTimeValue.class;
            }
            case 23 -> {
                LtodType unused = (LtodType)libraryElement;
                yield LTimeOfDayValue.class;
            }
            case 24 -> {
                TimeOfDayType unused = (TimeOfDayType)libraryElement;
                yield TimeOfDayValue.class;
            }
            case 25 -> {
                LdateType unused = (LdateType)libraryElement;
                yield LDateValue.class;
            }
            case 26 -> {
                DateType unused = (DateType)libraryElement;
                yield DateValue.class;
            }
            case 27 -> {
                AnySignedType unused = (AnySignedType)libraryElement;
                yield AnySignedValue.class;
            }
            case 28 -> {
                AnyUnsignedType unused = (AnyUnsignedType)libraryElement;
                yield AnyUnsignedValue.class;
            }
            case 29 -> {
                AnyIntType unused = (AnyIntType)libraryElement;
                yield AnyIntValue.class;
            }
            case 30 -> {
                AnyRealType unused = (AnyRealType)libraryElement;
                yield AnyRealValue.class;
            }
            case 31 -> {
                AnyNumType unused = (AnyNumType)libraryElement;
                yield AnyNumValue.class;
            }
            case 32 -> {
                AnyDurationType unused = (AnyDurationType)libraryElement;
                yield AnyDurationValue.class;
            }
            case 33 -> {
                AnyMagnitudeType unused = (AnyMagnitudeType)libraryElement;
                yield AnyMagnitudeValue.class;
            }
            case 34 -> {
                AnyBitType unused = (AnyBitType)libraryElement;
                yield AnyBitValue.class;
            }
            case 35 -> {
                AnyCharType unused = (AnyCharType)libraryElement;
                yield AnyCharValue.class;
            }
            case 36 -> {
                AnyStringType unused = (AnyStringType)libraryElement;
                yield AnyStringValue.class;
            }
            case 37 -> {
                AnyCharsType unused = (AnyCharsType)libraryElement;
                yield AnyCharsValue.class;
            }
            case 38 -> {
                AnyDateType unused = (AnyDateType)libraryElement;
                yield AnyDateValue.class;
            }
            case 39 -> {
                AnyElementaryType unused = (AnyElementaryType)libraryElement;
                yield AnyElementaryValue.class;
            }
            case 40 -> {
                ArrayType unused = (ArrayType)libraryElement;
                yield ArrayValue.class;
            }
            case 41 -> {
                StructuredType unused = (StructuredType)libraryElement;
                yield StructValue.class;
            }
            case 42 -> {
                EnumeratedType unused = (EnumeratedType)libraryElement;
                yield EnumValue.class;
            }
            case 43 -> {
                AnyDerivedType unused = (AnyDerivedType)libraryElement;
                yield AnyDerivedValue.class;
            }
            case 44 -> {
                AnyType unused = (AnyType)libraryElement;
                yield AnyValue.class;
            }
            default -> null;
        };
    }

    public static DataType dataType(Class<?> type) {
        if (type == null || !Value.class.isAssignableFrom(type)) {
            return null;
        }
        String string = type.getSimpleName();
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"LRealValue", "RealValue", "LIntValue", "DIntValue", "IntValue", "SIntValue", "ULIntValue", "UDIntValue", "UIntValue", "USIntValue", "LTimeValue", "TimeValue", "LWordValue", "DWordValue", "WordValue", "ByteValue", "BoolValue", "WStringValue", "StringValue", "WCharValue", "CharValue", "LDateAndTimeValue", "DateAndTimeValue", "LTimeOfDayValue", "TimeOfDayValue", "LDateValue", "DateValue", "AnySignedValue", "AnyUnsignedValue", "AnyIntValue", "AnyRealValue", "AnyNumValue", "AnyDurationValue", "AnyMagnitudeValue", "AnyBitValue", "AnyCharValue", "AnyStringValue", "AnySCharsValue", "AnyWCharsValue", "AnyCharsValue", "AnyDateValue", "AnyElementaryValue", "ArrayValue", "StructValue", "EnumValue", "AnyDerivedValue", "AnyValue"}, (Object)string, 0)) {
            case 0 -> IecTypes.ElementaryTypes.LREAL;
            case 1 -> IecTypes.ElementaryTypes.REAL;
            case 2 -> IecTypes.ElementaryTypes.LINT;
            case 3 -> IecTypes.ElementaryTypes.DINT;
            case 4 -> IecTypes.ElementaryTypes.INT;
            case 5 -> IecTypes.ElementaryTypes.SINT;
            case 6 -> IecTypes.ElementaryTypes.ULINT;
            case 7 -> IecTypes.ElementaryTypes.UDINT;
            case 8 -> IecTypes.ElementaryTypes.UINT;
            case 9 -> IecTypes.ElementaryTypes.USINT;
            case 10 -> IecTypes.ElementaryTypes.LTIME;
            case 11 -> IecTypes.ElementaryTypes.TIME;
            case 12 -> IecTypes.ElementaryTypes.LWORD;
            case 13 -> IecTypes.ElementaryTypes.DWORD;
            case 14 -> IecTypes.ElementaryTypes.WORD;
            case 15 -> IecTypes.ElementaryTypes.BYTE;
            case 16 -> IecTypes.ElementaryTypes.BOOL;
            case 17 -> IecTypes.ElementaryTypes.WSTRING;
            case 18 -> IecTypes.ElementaryTypes.STRING;
            case 19 -> IecTypes.ElementaryTypes.WCHAR;
            case 20 -> IecTypes.ElementaryTypes.CHAR;
            case 21 -> IecTypes.ElementaryTypes.LDATE_AND_TIME;
            case 22 -> IecTypes.ElementaryTypes.DATE_AND_TIME;
            case 23 -> IecTypes.ElementaryTypes.LTIME_OF_DAY;
            case 24 -> IecTypes.ElementaryTypes.TIME_OF_DAY;
            case 25 -> IecTypes.ElementaryTypes.LDATE;
            case 26 -> IecTypes.ElementaryTypes.DATE;
            case 27 -> IecTypes.GenericTypes.ANY_SIGNED;
            case 28 -> IecTypes.GenericTypes.ANY_UNSIGNED;
            case 29 -> IecTypes.GenericTypes.ANY_INT;
            case 30 -> IecTypes.GenericTypes.ANY_REAL;
            case 31 -> IecTypes.GenericTypes.ANY_NUM;
            case 32 -> IecTypes.GenericTypes.ANY_DURATION;
            case 33 -> IecTypes.GenericTypes.ANY_MAGNITUDE;
            case 34 -> IecTypes.GenericTypes.ANY_BIT;
            case 35 -> IecTypes.GenericTypes.ANY_CHAR;
            case 36 -> IecTypes.GenericTypes.ANY_STRING;
            case 37 -> IecTypes.GenericTypes.ANY_SCHARS;
            case 38 -> IecTypes.GenericTypes.ANY_WCHARS;
            case 39 -> IecTypes.GenericTypes.ANY_CHARS;
            case 40 -> IecTypes.GenericTypes.ANY_DATE;
            case 41 -> IecTypes.GenericTypes.ANY_ELEMENTARY;
            case 42 -> IecTypes.GenericTypes.ANY_DERIVED;
            case 43 -> IecTypes.GenericTypes.ANY_STRUCT;
            case 44 -> IecTypes.GenericTypes.ANY_DERIVED;
            case 45 -> IecTypes.GenericTypes.ANY_DERIVED;
            case 46 -> IecTypes.GenericTypes.ANY;
            default -> null;
        };
    }

    public static boolean asBoolean(Value value) {
        Value value2 = value;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnyBitValue.class, AnyMagnitudeValue.class}, (Object)value2, 0)) {
            case 0 -> {
                AnyBitValue anyBitValue = (AnyBitValue)value2;
                yield anyBitValue.boolValue();
            }
            case 1 -> {
                AnyMagnitudeValue anyMagnitudeValue = (AnyMagnitudeValue)value2;
                if (anyMagnitudeValue.intValue() != 0) {
                    yield true;
                }
                yield false;
            }
            default -> throw ValueOperations.createUnsupportedTypeException(value);
        };
    }

    public static int asInteger(Value value) {
        Value value2 = value;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnyMagnitudeValue.class, AnyBitValue.class}, (Object)value2, 0)) {
            case 0 -> {
                AnyMagnitudeValue anyMagnitudeValue = (AnyMagnitudeValue)value2;
                yield anyMagnitudeValue.intValue();
            }
            case 1 -> {
                AnyBitValue anyBitValue = (AnyBitValue)value2;
                yield anyBitValue.intValue();
            }
            default -> throw ValueOperations.createUnsupportedTypeException(value);
        };
    }

    public static DataType resultType(DataType first, DataType second) {
        if (first instanceof AnyDurationType && second instanceof AnyNumType) {
            return first;
        }
        if (first.isAssignableFrom(second)) {
            return first;
        }
        if (second.isAssignableFrom(first)) {
            return second;
        }
        return null;
    }

    private static RuntimeException createUnsupportedUnaryOperationException(String operation, Value value) {
        return new UnsupportedOperationException(MessageFormat.format(Messages.ValueOperations_UnsupportedUnaryOperation, operation, ValueOperations.typeName(value)));
    }

    private static RuntimeException createUnsupportedBinaryOperationException(String operation, Value first, Value second) {
        return new UnsupportedOperationException(MessageFormat.format(Messages.ValueOperations_UnsupportedBinaryOperation, operation, ValueOperations.typeName(first), ValueOperations.typeName(second)));
    }

    private static RuntimeException createUnsupportedPartialOperationException(Value value, DataType type) {
        return new UnsupportedOperationException(MessageFormat.format(Messages.ValueOperations_UnsupportedPartialOperation, ValueOperations.typeName(value), ValueOperations.typeName((LibraryElement)type)));
    }

    private static RuntimeException createUnsupportedTypeException(Value value) {
        return new UnsupportedOperationException(MessageFormat.format(Messages.ValueOperations_UnsupportedType, ValueOperations.typeName(value)));
    }

    private static RuntimeException createUnsupportedTypeException(LibraryElement type) {
        return new UnsupportedOperationException(MessageFormat.format(Messages.ValueOperations_UnsupportedType, ValueOperations.typeName(type)));
    }

    private static RuntimeException createCastException(Value value, LibraryElement type) {
        return new ClassCastException(MessageFormat.format(Messages.ValueOperations_UnsupportedCast, value, ValueOperations.typeName(value), ValueOperations.typeName(type)));
    }

    private static String typeName(Value value) {
        return value != null ? ValueOperations.typeName(value.getType()) : null;
    }

    private static String typeName(LibraryElement type) {
        return PackageNameHelper.getFullTypeName((LibraryElement)type);
    }

    private static Map<String, ?> castMemberMap(Map<?, ?> map) {
        map.keySet().stream().filter(Predicate.not(String.class::isInstance)).findAny().ifPresent(key -> {
            throw new ClassCastException(MessageFormat.format(Messages.ValueOperations_MemberMapCastMessage, key, key.getClass(), String.class));
        });
        return map;
    }

    private ValueOperations() {
        throw new UnsupportedOperationException();
    }
}

