/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.editparts.ZoomManager;

public class AdvancedZoomManager
extends ZoomManager {
    AdvancedZoomManager(ScalableFigure pane, Viewport viewport) {
        super(pane, viewport);
    }

    public void setZoomAsText(String zoomString) {
        super.setZoomAsText(zoomString);
        if (FIT_HEIGHT.equalsIgnoreCase(zoomString) || FIT_ALL.equalsIgnoreCase(zoomString) || FIT_WIDTH.equalsIgnoreCase(zoomString)) {
            Point scrollPoint = new Point(AdvancedZoomManager.calculateCenterScrollPos(this.getViewport().getHorizontalRangeModel()), AdvancedZoomManager.calculateCenterScrollPos(this.getViewport().getVerticalRangeModel()));
            this.setViewLocation(scrollPoint);
        }
    }

    private static int calculateCenterScrollPos(RangeModel rangeModel) {
        int center = (rangeModel.getMaximum() + rangeModel.getMinimum()) / 2;
        return center - rangeModel.getExtent() / 2;
    }

    protected double getFitHeightZoomLevel() {
        return this.getFitXZoomLevelBounds(1);
    }

    protected double getFitPageZoomLevel() {
        return this.getFitXZoomLevelBounds(2);
    }

    protected double getFitWidthZoomLevel() {
        return this.getFitXZoomLevelBounds(0);
    }

    private double getFitXZoomLevelBounds(int which) {
        Dimension desired;
        ScalableFigure fig = this.getScalableFigure();
        Dimension available = this.getViewport().getClientArea().getSize();
        if (fig instanceof FreeformFigure) {
            FreeformFigure ff = (FreeformFigure)fig;
            desired = ff.getBounds().getSize();
        } else {
            desired = fig.getPreferredSize().getCopy();
        }
        desired.width -= fig.getInsets().getWidth();
        desired.height -= fig.getInsets().getHeight();
        while (fig != this.getViewport()) {
            available.width -= fig.getInsets().getWidth();
            available.height -= fig.getInsets().getHeight();
            fig = fig.getParent();
        }
        double scaleX = Math.min((double)available.width * this.getZoom() / (double)desired.width, this.getMaxZoom());
        double scaleY = Math.min((double)available.height * this.getZoom() / (double)desired.height, this.getMaxZoom());
        if (which == 0) {
            return scaleX;
        }
        if (which == 1) {
            return scaleY;
        }
        return Math.min(scaleX, scaleY);
    }
}

