/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.draw2d.ITransparencyFigure;
import org.eclipse.fordiac.ide.gef.editparts.AbstractConnectableEditPart;
import org.eclipse.fordiac.ide.gef.editparts.LabelDirectEditManager;
import org.eclipse.fordiac.ide.gef.policies.AbstractViewRenameEditPolicy;
import org.eclipse.fordiac.ide.gef.policies.EmptyXYLayoutEditPolicy;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.util.ColorManager;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractViewEditPart
extends AbstractConnectableEditPart {
    private static final String ERROR_IN_CREATE_FIGURE = Messages.AbstractViewEditPart_ERROR_createFigure;
    private Adapter adapter;
    private final Adapter iNamedElementContentAdapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            if (notification.getNotifier().equals(AbstractViewEditPart.this.getINamedElement())) {
                Object feature = notification.getFeature();
                if (LibraryElementPackage.eINSTANCE.getINamedElement_Name().equals(feature)) {
                    AbstractViewEditPart.this.refreshName();
                }
                if (LibraryElementPackage.eINSTANCE.getINamedElement_Comment().equals(feature)) {
                    AbstractViewEditPart.this.refreshComment();
                }
                super.notifyChanged(notification);
            }
        }
    };

    private Adapter getContentAdapter() {
        if (this.adapter == null) {
            this.adapter = this.createContentAdapter();
            Assert.isNotNull((Object)this.adapter);
        }
        return this.adapter;
    }

    protected void backgroundColorChanged(IFigure figure) {
        this.setColor(figure, null);
    }

    protected void setColor(IFigure figure, Color fordiacColor) {
        org.eclipse.swt.graphics.Color newColor = fordiacColor != null ? ColorManager.getColor((RGB)new RGB(fordiacColor.getRed(), fordiacColor.getGreen(), fordiacColor.getBlue())) : null;
        figure.setBackgroundColor(newColor);
    }

    public abstract INamedElement getINamedElement();

    public abstract Label getNameLabel();

    protected void refreshName() {
        this.getNameLabel().setText(this.getINamedElement().getName());
    }

    protected void refreshComment() {
    }

    protected abstract Adapter createContentAdapter();

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            if (this.getINamedElement() != null) {
                this.getINamedElement().eAdapters().add((Object)this.iNamedElementContentAdapter);
            }
            ((Notifier)this.getModel()).eAdapters().add((Object)this.getContentAdapter());
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            if (this.getINamedElement() != null) {
                this.getINamedElement().eAdapters().remove((Object)this.iNamedElementContentAdapter);
            }
            ((Notifier)this.getModel()).eAdapters().remove((Object)this.getContentAdapter());
        }
    }

    protected abstract IFigure createFigureForModel();

    protected IFigure createFigure() {
        IFigure f = null;
        try {
            f = this.createFigureForModel();
            if (f != null) {
                this.backgroundColorChanged(f);
            }
        }
        catch (IllegalArgumentException e) {
            FordiacLogHelper.logError((String)ERROR_IN_CREATE_FIGURE, (Throwable)e);
        }
        return f;
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EmptyXYLayoutEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new AbstractViewRenameEditPolicy());
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" || request.getType() == "open") {
            this.performDirectEdit();
        } else {
            super.performRequest(request);
        }
    }

    protected DirectEditManager createDirectEditManager() {
        return new LabelDirectEditManager((GraphicalEditPart)this, this.getNameLabel());
    }

    protected void performDirectEdit() {
        this.createDirectEditManager().show();
    }

    public void setTransparency(int value) {
        IFigure iFigure = this.getFigure();
        if (iFigure instanceof ITransparencyFigure) {
            ITransparencyFigure transparancyFigure = (ITransparencyFigure)iFigure;
            transparancyFigure.setTransparency(value);
        }
    }
}

