/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.export;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.export.ExportConfigAttributes;
import org.eclipse.nebula.widgets.nattable.export.IExportFormatter;
import org.eclipse.nebula.widgets.nattable.export.IExporter;
import org.eclipse.nebula.widgets.nattable.export.ILayerExporter;
import org.eclipse.nebula.widgets.nattable.export.ITableExporter;
import org.eclipse.nebula.widgets.nattable.formula.command.DisableFormulaEvaluationCommand;
import org.eclipse.nebula.widgets.nattable.formula.command.EnableFormulaEvaluationCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.print.command.PrintEntireGridCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOffCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOnCommand;
import org.eclipse.nebula.widgets.nattable.resize.AutoResizeHelper;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.summaryrow.command.CalculateSummaryRowValuesCommand;
import org.eclipse.nebula.widgets.nattable.ui.ExceptionDialog;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;
import org.eclipse.nebula.widgets.nattable.util.PlatformHelper;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NatExporter {
    private static final Logger LOG = LoggerFactory.getLogger(NatExporter.class);
    protected final Shell shell;
    protected boolean openResult = true;
    protected boolean exportSucceeded = true;
    protected boolean preRender = true;
    private boolean runAsynchronously = true;
    private boolean useProgressDialog = false;
    private Runnable successRunnable;

    public NatExporter(Shell shell) {
        this(shell, false);
    }

    public NatExporter(Shell shell, boolean executeSynchronously) {
        this(shell, executeSynchronously, false);
    }

    public NatExporter(Shell shell, boolean executeSynchronously, boolean useProgressDialog) {
        this(shell, executeSynchronously, useProgressDialog, true, null);
    }

    public NatExporter(Shell shell, boolean executeSynchronously, boolean useProgressDialog, boolean openResult, Runnable successRunnable) {
        this.shell = shell;
        this.runAsynchronously = !executeSynchronously;
        this.useProgressDialog = useProgressDialog;
        this.openResult = openResult;
        this.successRunnable = successRunnable;
    }

    public void exportSingleLayer(ILayer layer, IConfigRegistry configRegistry) {
        ILayerExporter exporter = configRegistry.getConfigAttribute(ExportConfigAttributes.EXPORTER, DisplayMode.NORMAL, new String[0]);
        this.exportSingleLayer(exporter, layer, configRegistry);
    }

    public void exportSingleLayer(ILayerExporter exporter, ILayer layer, IConfigRegistry configRegistry) {
        if (this.useProgressDialog && this.shell != null) {
            ProgressMonitorDialog dialog = this.getProgressMonitorDialog();
            try {
                dialog.run(true, true, monitor -> this.exportSingle(exporter, monitor, (exp, outputStream, m) -> {
                    try {
                        exp.exportBegin((OutputStream)outputStream);
                        this.exportLayer((ILayerExporter)exp, (OutputStream)outputStream, (IProgressMonitor)m, "", layer, configRegistry, true);
                        exp.exportEnd((OutputStream)outputStream);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.exportSingle(exporter, null, (exp, outputStream, monitor) -> {
                try {
                    exp.exportBegin((OutputStream)outputStream);
                    this.exportLayer((ILayerExporter)exp, (OutputStream)outputStream, "", layer, configRegistry);
                    exp.exportEnd((OutputStream)outputStream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    protected ProgressMonitorDialog getProgressMonitorDialog() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.shell){

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText(Messages.getString("NatExporter.exporting"));
            }
        };
        return dialog;
    }

    public void exportSingleTable(ILayer layer, IConfigRegistry configRegistry) {
        ITableExporter exporter = configRegistry.getConfigAttribute(ExportConfigAttributes.TABLE_EXPORTER, DisplayMode.NORMAL, new String[0]);
        this.exportSingleTable(exporter, layer, configRegistry);
    }

    public void exportSingleTable(ITableExporter exporter, ILayer layer, IConfigRegistry configRegistry) {
        if (this.useProgressDialog && this.shell != null) {
            ProgressMonitorDialog dialog = this.getProgressMonitorDialog();
            try {
                dialog.run(true, true, monitor -> this.exportSingle(exporter, monitor, (exp, outputStream, m) -> this.exportLayer((ITableExporter)exp, (OutputStream)outputStream, (IProgressMonitor)m, layer, configRegistry)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.exportSingle(exporter, null, (exp, outputStream, m) -> this.exportLayer((ITableExporter)exp, (OutputStream)outputStream, (IProgressMonitor)m, layer, configRegistry));
        }
    }

    private <T extends IExporter> void exportSingle(T exporter, IProgressMonitor monitor, TriConsumer<T, OutputStream, IProgressMonitor> executable) {
        Runnable exportRunnable = () -> {
            OutputStream outputStream = this.getOutputStream(exporter);
            if (outputStream != null) {
                block12: {
                    try {
                        try {
                            executable.accept(exporter, outputStream, monitor);
                            this.exportSucceeded = true;
                        }
                        catch (Exception e1) {
                            this.exportSucceeded = false;
                            this.handleExportException(e1);
                            try {
                                outputStream.close();
                            }
                            catch (IOException e2) {
                                LOG.error("Failed to close the output stream", (Throwable)e2);
                            }
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException e2) {
                            LOG.error("Failed to close the output stream", (Throwable)e2);
                        }
                        throw throwable;
                    }
                    try {
                        outputStream.close();
                    }
                    catch (IOException e2) {
                        LOG.error("Failed to close the output stream", (Throwable)e2);
                    }
                }
                this.openExport(exporter);
            }
        };
        if (this.shell != null && monitor == null) {
            if (this.runAsynchronously) {
                this.shell.getDisplay().asyncExec(exportRunnable);
            } else {
                this.shell.getDisplay().syncExec(exportRunnable);
            }
        } else {
            exportRunnable.run();
        }
    }

    public void exportMultipleNatTables(ILayerExporter exporter, Map<String, NatTable> natTablesMap) {
        this.exportMultipleNatTables(exporter, natTablesMap, false, null);
    }

    public void exportMultipleNatTables(ILayerExporter exporter, Map<String, NatTable> natTablesMap, boolean exportOnSameSheet, String sheetName) {
        Runnable exportRunnable = () -> {
            block19: {
                OutputStream outputStream = this.getOutputStream(exporter);
                if (outputStream != null) {
                    try {
                        try {
                            exporter.exportBegin(outputStream);
                            exporter.setExportOnSameSheet(exportOnSameSheet);
                            if (exportOnSameSheet) {
                                exporter.exportLayerBegin(outputStream, sheetName);
                            }
                            if (this.useProgressDialog && this.shell != null) {
                                ProgressMonitorDialog dialog = this.getProgressMonitorDialog();
                                try {
                                    dialog.run(true, true, monitor -> {
                                        for (String name : natTablesMap.keySet()) {
                                            NatTable natTable = (NatTable)natTablesMap.get(name);
                                            this.exportLayer(exporter, outputStream, monitor, name, natTable, natTable.getConfigRegistry(), !exportOnSameSheet);
                                        }
                                    });
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                            } else {
                                for (String name : natTablesMap.keySet()) {
                                    NatTable natTable = (NatTable)natTablesMap.get(name);
                                    this.exportLayer(exporter, outputStream, null, name, natTable, natTable.getConfigRegistry(), !exportOnSameSheet);
                                }
                            }
                            if (exportOnSameSheet) {
                                exporter.exportLayerEnd(outputStream, sheetName);
                            }
                            exporter.exportEnd(outputStream);
                            this.exportSucceeded = true;
                        }
                        catch (Exception e1) {
                            this.exportSucceeded = false;
                            this.handleExportException(e1);
                            try {
                                outputStream.close();
                            }
                            catch (IOException e2) {
                                LOG.error("Failed to close the output stream", (Throwable)e2);
                            }
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException e2) {
                            LOG.error("Failed to close the output stream", (Throwable)e2);
                        }
                        throw throwable;
                    }
                    try {
                        outputStream.close();
                    }
                    catch (IOException e2) {
                        LOG.error("Failed to close the output stream", (Throwable)e2);
                    }
                }
            }
            this.openExport(exporter);
        };
        if (this.shell != null) {
            if (this.runAsynchronously) {
                this.shell.getDisplay().asyncExec(exportRunnable);
            } else {
                this.shell.getDisplay().syncExec(exportRunnable);
            }
        } else {
            exportRunnable.run();
        }
    }

    protected void exportLayer(ILayerExporter exporter, OutputStream outputStream, String layerName, ILayer layer, IConfigRegistry configRegistry) {
        this.exportLayer(exporter, outputStream, layerName, layer, configRegistry, true);
    }

    protected void exportLayer(ILayerExporter exporter, OutputStream outputStream, String layerName, ILayer layer, IConfigRegistry configRegistry, boolean initExportLayer) {
        this.exportLayer(exporter, outputStream, null, layerName, layer, configRegistry, initExportLayer);
    }

    protected void exportLayer(final ILayerExporter exporter, OutputStream outputStream, final IProgressMonitor monitor, final String layerName, ILayer layer, IConfigRegistry configRegistry, final boolean initExportLayer) {
        this.exportLayer(new ITableExporter(){

            @Override
            public void exportTable(Shell shell, ProgressBar progressBar, OutputStream outputStream, ILayer layer, IConfigRegistry configRegistry) throws IOException {
                if (initExportLayer) {
                    exporter.exportLayerBegin(outputStream, layerName);
                }
                int layerHeight = layer.getHeight();
                int rowPosition = 0;
                while (rowPosition < layer.getRowCount()) {
                    if (layer.getRowHeightByPosition(rowPosition) > 0 && layer.getStartYOfRowPosition(rowPosition) < layerHeight) {
                        exporter.exportRowBegin(outputStream, rowPosition);
                        if (progressBar != null) {
                            progressBar.setSelection(rowPosition);
                        }
                        int columnPosition = 0;
                        while (columnPosition < layer.getColumnCount()) {
                            ILayerCell cell = layer.getCellByPosition(columnPosition, rowPosition);
                            if (cell != null) {
                                IExportFormatter exportFormatter = configRegistry.getConfigAttribute(ExportConfigAttributes.EXPORT_FORMATTER, cell.getDisplayMode(), (List<String>)cell.getConfigLabels());
                                Object exportDisplayValue = exportFormatter.formatForExport(cell, configRegistry);
                                exporter.exportCell(outputStream, exportDisplayValue, cell, configRegistry);
                                if (monitor != null && monitor.isCanceled()) break;
                            }
                            ++columnPosition;
                        }
                        exporter.exportRowEnd(outputStream, rowPosition);
                        if (monitor != null) {
                            monitor.worked(1);
                            if (monitor.isCanceled()) break;
                        }
                    }
                    ++rowPosition;
                }
                if (initExportLayer) {
                    exporter.exportLayerEnd(outputStream, layerName);
                }
            }

            @Override
            public OutputStream getOutputStream(Shell shell) {
                return exporter.getOutputStream(shell);
            }

            @Override
            public Object getResult() {
                return exporter.getResult();
            }
        }, outputStream, monitor, layer, configRegistry);
    }

    protected void exportLayer(ITableExporter exporter, OutputStream outputStream, ILayer layer, IConfigRegistry configRegistry) {
        this.exportLayer(exporter, outputStream, null, layer, configRegistry);
    }

    protected void exportLayer(ITableExporter exporter, OutputStream outputStream, IProgressMonitor monitor, ILayer layer, IConfigRegistry configRegistry) {
        ProgressBar progressBar;
        IClientAreaProvider originalClientAreaProvider;
        block24: {
            block27: {
                block25: {
                    originalClientAreaProvider = layer.getClientAreaProvider();
                    progressBar = null;
                    if (this.shell != null && monitor == null) {
                        Shell childShell = new Shell(this.shell.getDisplay(), 67680);
                        childShell.setText(Messages.getString("NatExporter.exporting"));
                        int endRow = layer.getRowCount() - 1;
                        progressBar = new ProgressBar((Composite)childShell, 65536);
                        progressBar.setMinimum(0);
                        progressBar.setMaximum(endRow);
                        progressBar.setBounds(0, 0, 400, 25);
                        progressBar.setFocus();
                        childShell.pack();
                        childShell.open();
                    }
                    if (monitor != null) {
                        monitor.beginTask(" ", layer.getRowCount() + 1);
                        monitor.subTask(this.getPrepareSubTaskName());
                    }
                    if (this.shell != null) {
                        this.shell.getDisplay().syncExec(() -> this.prepareExportProcess(layer, configRegistry));
                    } else {
                        this.prepareExportProcess(layer, configRegistry);
                    }
                    if (monitor == null) break block24;
                    monitor.worked(1);
                    if (!monitor.isCanceled()) break block24;
                    if (this.shell == null) break block25;
                    this.shell.getDisplay().syncExec(() -> this.finalizeExportProcess(layer, originalClientAreaProvider));
                    break block27;
                }
                this.finalizeExportProcess(layer, originalClientAreaProvider);
            }
            if (progressBar != null) {
                Shell childShell = progressBar.getShell();
                progressBar.dispose();
                childShell.dispose();
            }
            return;
        }
        try {
            try {
                try {
                    try {
                        if (monitor != null) {
                            monitor.subTask(this.getExportSubTaskName());
                        }
                        exporter.exportTable(this.shell, progressBar, outputStream, layer, configRegistry);
                        if (monitor != null) {
                            monitor.worked(1);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    if (monitor != null) {
                        monitor.done();
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            if (this.shell != null) {
                this.shell.getDisplay().syncExec(() -> this.finalizeExportProcess(layer, originalClientAreaProvider));
            } else {
                this.finalizeExportProcess(layer, originalClientAreaProvider);
            }
            if (progressBar != null) {
                Shell childShell = progressBar.getShell();
                progressBar.dispose();
                childShell.dispose();
            }
            throw throwable;
        }
        if (this.shell != null) {
            this.shell.getDisplay().syncExec(() -> this.finalizeExportProcess(layer, originalClientAreaProvider));
        } else {
            this.finalizeExportProcess(layer, originalClientAreaProvider);
        }
        if (progressBar != null) {
            Shell childShell = progressBar.getShell();
            progressBar.dispose();
            childShell.dispose();
        }
    }

    protected void prepareExportProcess(ILayer layer, IConfigRegistry configRegistry) {
        if (this.preRender && !PlatformHelper.isRAP()) {
            AutoResizeHelper.autoResize(layer, configRegistry);
        }
        layer.doCommand(new TurnViewportOffCommand());
        this.setClientAreaToMaximum(layer);
        layer.doCommand(new CalculateSummaryRowValuesCommand());
        layer.doCommand(new DisableFormulaEvaluationCommand());
    }

    protected void finalizeExportProcess(ILayer layer, IClientAreaProvider originalClientAreaProvider) {
        layer.setClientAreaProvider(originalClientAreaProvider);
        layer.doCommand(new TurnViewportOnCommand());
        layer.doCommand(new EnableFormulaEvaluationCommand());
    }

    protected String getPrepareSubTaskName() {
        return Messages.getString("NatExporter.subtask.prepare");
    }

    protected String getExportSubTaskName() {
        return Messages.getString("NatExporter.subtask.export");
    }

    protected void setClientAreaToMaximum(ILayer layer) {
        Rectangle maxClientArea = new Rectangle(0, 0, layer.getWidth(), layer.getHeight());
        layer.setClientAreaProvider(() -> maxClientArea);
        layer.doCommand(new PrintEntireGridCommand());
    }

    protected void openExport(IExporter exporter) {
        if (this.exportSucceeded) {
            if (this.successRunnable != null) {
                if (this.shell != null) {
                    this.shell.getDisplay().syncExec(() -> this.successRunnable.run());
                } else {
                    this.successRunnable.run();
                }
            }
            if (this.openResult && exporter.getResult() != null && exporter.getResult() instanceof File) {
                try {
                    Class<?> program = Class.forName("org.eclipse.swt.program.Program");
                    Method launch = program.getMethod("launch", String.class);
                    launch.invoke(null, ((File)exporter.getResult()).getAbsolutePath());
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    LOG.info("Could not open the export because org.eclipse.swt.program.Program, you are probably running a RAP application.");
                }
            }
        }
    }

    public void setOpenResult(boolean openResult) {
        this.openResult = openResult;
    }

    protected OutputStream getOutputStream(IExporter exporter) {
        OutputStream outputStream = null;
        try {
            outputStream = exporter.getOutputStream(this.shell);
        }
        catch (Exception e) {
            this.handleExportException(e);
        }
        return outputStream;
    }

    protected void handleExportException(Exception e) {
        LOG.error("Failed to export.", (Throwable)e);
        ExceptionDialog.open(this.shell, Messages.getString("ErrorDialog.title"), Messages.getString("NatExporter.errorMessagePrefix", e.getLocalizedMessage()), e);
    }

    public void enablePreRendering() {
        this.preRender = true;
    }

    public void disablePreRendering() {
        this.preRender = false;
    }

    public boolean isUseProgressDialog() {
        return this.useProgressDialog;
    }

    public void setUseProgressDialog(boolean useProgressDialog) {
        this.useProgressDialog = useProgressDialog;
    }

    public void setSuccessRunnable(Runnable successRunnable) {
        this.successRunnable = successRunnable;
    }

    private static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }
}

