/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts;

import java.util.OptionalDouble;
import org.eclipse.fordiac.ide.Utils;
import org.eclipse.fordiac.ide.contractSpec.Interval;
import org.eclipse.fordiac.ide.contractSpec.TimeExpr;
import org.eclipse.fordiac.ide.contractSpec.Unit;

class CInterval {
    private final double lb;
    private final double ub;
    private final boolean lbOpen;
    private final boolean ubOpen;

    CInterval(Interval interval) {
        OptionalDouble d = Utils.timeExpr2Ns((TimeExpr)interval.getTime());
        if (d.isPresent()) {
            this.ub = this.lb = d.getAsDouble();
            this.lbOpen = false;
            this.ubOpen = false;
        } else {
            this.lb = Utils.getInNs((double)interval.getLbValue(), (Unit)interval.getUnit());
            this.ub = Utils.getInNs((double)interval.getUbValue(), (Unit)interval.getUnit());
            this.lbOpen = interval.getLBound().equals("]");
            this.ubOpen = interval.getUBound().equals("[");
        }
    }

    CInterval(char lbBracket, double lb, double ub, char ubBracket) {
        this(lbBracket != '[', lb, ub, ubBracket != ']');
    }

    CInterval(boolean lbOpen, double lb, double ub, boolean ubOpen) {
        this.lbOpen = lbOpen;
        this.lb = lb;
        this.ub = ub;
        this.ubOpen = ubOpen;
    }

    CInterval add(CInterval other) {
        return new CInterval(this.lbOpen || other.lbOpen, this.lb + other.lb, this.ub + other.ub, this.ubOpen || other.ubOpen);
    }

    CInterval addJitter(double jitter) {
        return new CInterval(this.lbOpen, Math.max(0.0, this.lb - jitter), this.ub + jitter, this.ubOpen);
    }

    CInterval translate(double amount) {
        return new CInterval(this.lbOpen, this.lb + amount, this.ub + amount, this.ubOpen);
    }

    boolean contains(double value) {
        return (value > this.lb || !this.lbOpen && value >= this.lb) && (value < this.ub || !this.ubOpen && value <= this.ub);
    }

    boolean contains(CInterval other) {
        return !(other.lb < this.lb || other.ub > this.ub || other.lb == this.lb && !other.lbOpen && this.lbOpen || other.ub == this.ub && !other.ubOpen && this.ubOpen);
    }

    double getLowerBound() {
        return this.lb;
    }

    double getUpperBound() {
        return this.ub;
    }

    double getDiameter() {
        return this.ub - this.lb;
    }

    public String toString() {
        if (this.ub == this.lb && !this.ubOpen && !this.lbOpen) {
            return Utils.nsToString((double)this.lb);
        }
        Unit unit = Utils.getFittingUnit((double)this.ub);
        double div = Utils.getInNs((double)1.0, (Unit)unit);
        double lbConv = this.lb / div;
        double ubConv = this.ub / div;
        StringBuilder sb = new StringBuilder();
        sb.append(this.lbOpen ? (char)']' : '[');
        sb.append(lbConv);
        sb.append(", ");
        sb.append(ubConv);
        sb.append(this.ubOpen ? (char)'[' : ']');
        sb.append(unit);
        return sb.toString();
    }
}

