/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.codemining;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.globalconstantseditor.globalConstants.STVarGlobalDeclarationBlock;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.services.STCoreGrammarAccess;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayAccessExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STMultibitPartialExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STNumericLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStringLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.ui.codemining.STCoreCodeMiningPreferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.codemining.AbstractXtextCodeMiningProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class STCoreCodeMiningProvider
extends AbstractXtextCodeMiningProvider {
    @Inject
    @Extension
    private STCoreGrammarAccess _sTCoreGrammarAccess;
    @Inject
    @Extension
    private STCoreCodeMiningPreferences _sTCoreCodeMiningPreferences;

    public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
        CompletableFuture _xifexpression = null;
        boolean _isEnableCodeMinings = this._sTCoreCodeMiningPreferences.isEnableCodeMinings();
        _xifexpression = _isEnableCodeMinings ? super.provideCodeMinings(viewer, monitor) : CompletableFuture.completedFuture(Collections.emptyList());
        return _xifexpression;
    }

    public void createCodeMinings(IDocument document, XtextResource resource, CancelIndicator indicator, IAcceptor<? super ICodeMining> acceptor) throws BadLocationException {
        Procedures.Procedure1 _function = it -> {
            try {
                this.createCodeMinings((EObject)it, document, acceptor);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        IteratorExtensions.forEach((Iterator)EcoreUtil.getAllProperContents((Resource)resource, (boolean)true), (Procedures.Procedure1)_function);
    }

    protected void _createCodeMinings(EObject element, IDocument document, IAcceptor<? super ICodeMining> acceptor) throws BadLocationException {
    }

    protected void _createCodeMinings(STNumericLiteral literal, IDocument document, IAcceptor<? super ICodeMining> acceptor) throws BadLocationException {
        LibraryElement inferredType;
        if (this._sTCoreCodeMiningPreferences.isEnableLiteralTypeCodeMinings() && literal.getType() == null && STCoreCodeMiningProvider.isShowLiteralTypeCodeMining((STExpression)literal) && (inferredType = literal.getResultType()) != null) {
            Functions.Function1 _function = it -> this._sTCoreGrammarAccess.getSTNumericLiteralAccess().getValueNumericParserRuleCall_1_1_0().equals(it.getGrammarElement()) || this._sTCoreGrammarAccess.getSTNumericLiteralAccess().getValueSignedNumericParserRuleCall_0_2_0().equals(it.getGrammarElement()) || this._sTCoreGrammarAccess.getSTSignedNumericLiteralAccess().getValueSignedNumericParserRuleCall_0().equals(it.getGrammarElement());
            Consumer<INode> _function_1 = value -> {
                int _offset = value.getOffset();
                StringConcatenation _builder = new StringConcatenation();
                String _name = inferredType.getName();
                _builder.append(_name);
                _builder.append("#");
                acceptor.accept((Object)this.createNewLineContentCodeMining(_offset, _builder.toString()));
            };
            IterableExtensions.filter((Iterable)NodeModelUtils.findActualNodeFor((EObject)literal).getAsTreeIterable(), (Functions.Function1)_function).forEach(_function_1);
        }
    }

    protected void _createCodeMinings(STStringLiteral literal, IDocument document, IAcceptor<? super ICodeMining> acceptor) throws BadLocationException {
        LibraryElement inferredType;
        if (this._sTCoreCodeMiningPreferences.isEnableLiteralTypeCodeMinings() && literal.getType() == null && STCoreCodeMiningProvider.isShowLiteralTypeCodeMining((STExpression)literal) && (inferredType = literal.getResultType()) != null) {
            Functions.Function1 _function = it -> this._sTCoreGrammarAccess.getSTStringLiteralAccess().getValueSTRINGTerminalRuleCall_1_0().equals(it.getGrammarElement());
            Consumer<INode> _function_1 = value -> {
                int _offset = value.getOffset();
                StringConcatenation _builder = new StringConcatenation();
                String _name = inferredType.getName();
                _builder.append(_name);
                _builder.append("#");
                acceptor.accept((Object)this.createNewLineContentCodeMining(_offset, _builder.toString()));
            };
            IterableExtensions.filter((Iterable)NodeModelUtils.findActualNodeFor((EObject)literal).getAsTreeIterable(), (Functions.Function1)_function).forEach(_function_1);
        }
    }

    public static boolean isShowLiteralTypeCodeMining(STExpression expression) {
        boolean _contains;
        EObject _eContainer;
        boolean _switchResult = false;
        EObject it = _eContainer = expression.eContainer();
        boolean _matched = false;
        if (it instanceof STVarDeclaration && (_contains = ((STVarDeclaration)it).getRanges().contains((Object)expression))) {
            _matched = true;
        }
        if (!_matched && it instanceof STArrayAccessExpression && (_contains = ((STArrayAccessExpression)it).getIndex().contains((Object)expression))) {
            _matched = true;
        }
        if (!_matched && it instanceof STMultibitPartialExpression) {
            _matched = true;
        }
        if (_matched) {
            _switchResult = false;
        }
        if (!_matched && it instanceof STExpression) {
            _matched = true;
            _switchResult = STCoreCodeMiningProvider.isShowLiteralTypeCodeMining((STExpression)it);
        }
        if (!_matched) {
            _switchResult = true;
        }
        return _switchResult;
    }

    protected void _createCodeMinings(STFeatureExpression expression, IDocument document, IAcceptor<? super ICodeMining> acceptor) throws BadLocationException {
        if (this._sTCoreCodeMiningPreferences.isEnableReferencedVariablesCodeMinings() && expression.isCall()) {
            ICompositeNode node;
            boolean _not;
            Set<INamedElement> referencedVariables = this.findReferencedNonLocalVariables(expression);
            boolean _isEmpty = referencedVariables.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not && (node = NodeModelUtils.findActualNodeFor((EObject)expression)) != null) {
                Functions.Function1 _function = it -> it.getName();
                acceptor.accept((Object)this.createNewLineHeaderCodeMining(node.getStartLine(), document, IterableExtensions.join((Iterable)IterableExtensions.map(referencedVariables, (Functions.Function1)_function), (CharSequence)", ")));
            }
        }
    }

    protected Set<INamedElement> findReferencedNonLocalVariables(STFeatureExpression expression) {
        HashSet _xblockexpression = null;
        HashSet visitedCallables = CollectionLiterals.newHashSet();
        HashSet referencedVariables = CollectionLiterals.newHashSet();
        this.findReferencedNonLocalVariables(expression, visitedCallables, referencedVariables);
        _xblockexpression = referencedVariables;
        return _xblockexpression;
    }

    protected void findReferencedNonLocalVariables(STFeatureExpression expression, Set<ICallable> visitedCallables, Set<INamedElement> result) {
        EObject _eContainer;
        INamedElement _feature;
        INamedElement feature = _feature = expression.getFeature();
        boolean _matched = false;
        if (feature instanceof VarDeclaration) {
            _matched = true;
        }
        if (!_matched && feature instanceof STVarDeclaration && (_eContainer = ((STVarDeclaration)feature).eContainer()) instanceof STVarGlobalDeclarationBlock) {
            _matched = true;
        }
        if (_matched) {
            result.add((INamedElement)((ITypedElement)feature));
        }
        if (!_matched && feature instanceof ICallable && expression.isCall() && Objects.equals(((ICallable)feature).eResource(), expression.eResource())) {
            _matched = true;
            boolean _add = visitedCallables.add((ICallable)feature);
            if (_add) {
                Consumer<STFeatureExpression> _function = it -> this.findReferencedNonLocalVariables((STFeatureExpression)it, visitedCallables, result);
                EcoreUtil2.getAllContentsOfType((EObject)feature, STFeatureExpression.class).forEach(_function);
            }
        }
    }

    @XbaseGenerated
    public void createCodeMinings(EObject expression, IDocument document, IAcceptor<? super ICodeMining> acceptor) throws BadLocationException {
        if (expression instanceof STFeatureExpression) {
            this._createCodeMinings((STFeatureExpression)expression, document, acceptor);
            return;
        }
        if (expression instanceof STNumericLiteral) {
            this._createCodeMinings((STNumericLiteral)expression, document, acceptor);
            return;
        }
        if (expression instanceof STStringLiteral) {
            this._createCodeMinings((STStringLiteral)expression, document, acceptor);
            return;
        }
        if (expression != null) {
            this._createCodeMinings(expression, document, acceptor);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expression, document, acceptor).toString());
    }
}

