/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extra;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirUnusedCheckerBase;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J2\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirUnusedExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedCheckerBase;", "<init>", "()V", "isEnabled", "", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reportUnusedExpressionIfNeeded", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "hasSideEffects", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkers"})
public final class FirUnusedExpressionChecker
extends FirUnusedCheckerBase {
    @NotNull
    public static final FirUnusedExpressionChecker INSTANCE = new FirUnusedExpressionChecker();

    private FirUnusedExpressionChecker() {
    }

    @Override
    public boolean isEnabled(@NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        return true;
    }

    @Override
    public boolean reportUnusedExpressionIfNeeded(@NotNull FirExpression expression2, boolean hasSideEffects, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @Nullable KtSourceElement source) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (hasSideEffects) {
            return false;
        }
        KtDiagnosticFactory0 factory = expression2 instanceof FirAnonymousFunctionExpression && ((FirAnonymousFunctionExpression)expression2).getAnonymousFunction().isLambda() ? FirErrors.INSTANCE.getUNUSED_LAMBDA_EXPRESSION() : FirErrors.INSTANCE.getUNUSED_EXPRESSION();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, factory, (DiagnosticContext)context2, null, 8, null);
        return true;
    }
}

