/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.stream.input;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import uk.org.webcompere.systemstubs.stream.input.AltInputStream;

public class LinesAltStream
extends AltInputStream {
    private Iterator<Byte> byteIterator;

    public LinesAltStream(String ... lines) {
        this(Arrays.stream(lines), true);
    }

    public LinesAltStream(Stream<String> lines) {
        this(lines, true);
    }

    public LinesAltStream(Stream<String> lines, boolean addLineBreak) {
        Stream<String> source = addLineBreak ? lines.flatMap(line -> Stream.of(line, System.lineSeparator())) : lines;
        this.byteIterator = source.flatMap(LinesAltStream::toByteArrayStream).iterator();
    }

    @Override
    public int read() throws IOException {
        return this.byteIterator.hasNext() ? (int)this.byteIterator.next().byteValue() : -1;
    }

    private static Stream<Byte> toByteArrayStream(String s) {
        byte[] bytes = s.getBytes(Charset.defaultCharset());
        return IntStream.range(0, bytes.length).mapToObj(i -> bytes[i]);
    }
}

