/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.properties;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import uk.org.webcompere.systemstubs.properties.PropertiesUtils;
import uk.org.webcompere.systemstubs.resource.NameValuePairSetter;
import uk.org.webcompere.systemstubs.resource.SingularTestResource;

public class SystemPropertiesImpl<T extends SystemPropertiesImpl<T>>
extends SingularTestResource
implements NameValuePairSetter<T> {
    private Properties originalProperties;
    private Properties properties;
    private Set<String> propertiesToRemove = new HashSet<String>();

    public SystemPropertiesImpl() {
        this.properties = new Properties();
    }

    public SystemPropertiesImpl(Properties properties) {
        this.properties = PropertiesUtils.copyOf(properties);
    }

    public SystemPropertiesImpl(String name, String value, String ... nameValues) {
        this();
        if (nameValues.length % 2 != 0) {
            throw new IllegalArgumentException("Must have pairs of values");
        }
        this.properties.setProperty(name, value);
        for (int i = 0; i < nameValues.length; i += 2) {
            this.properties.setProperty(nameValues[i], nameValues[i + 1]);
        }
    }

    @Override
    public T set(String name, String value) {
        this.properties.setProperty(name, value);
        if (this.isActive()) {
            System.setProperty(name, value);
        }
        return (T)this;
    }

    @Override
    public T remove(String name) {
        this.propertiesToRemove.add(name);
        if (this.isActive()) {
            System.getProperties().remove(name);
        }
        return (T)this;
    }

    @Override
    protected void doSetup() throws Exception {
        this.originalProperties = System.getProperties();
        Properties copyProperties = PropertiesUtils.copyOf(this.originalProperties);
        this.propertiesToRemove.forEach(copyProperties::remove);
        copyProperties.putAll((Map<?, ?>)this.properties);
        System.setProperties(copyProperties);
    }

    @Override
    protected void doTeardown() throws Exception {
        System.setProperties(this.originalProperties);
    }
}

