/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.formatting;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.eclipse.virgo.kernel.model.management.ManageableCompositeArtifact;
import org.eclipse.virgo.shell.internal.formatting.AbstractInstallArtifactCommandFormatter;

public final class CompositeInstallArtifactCommandFormatter
extends AbstractInstallArtifactCommandFormatter<ManageableCompositeArtifact> {
    private static final String CHILD_FORMAT = "    %s %s %s";

    @Override
    public List<String> formatExamine(ManageableCompositeArtifact artifact) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(String.format("State:  %s", artifact.getState()));
        lines.add(String.format("Scoped: %s", artifact.isScoped()));
        lines.add(String.format("Atomic: %s", artifact.isAtomic()));
        lines.add("");
        lines.add("Children:");
        ObjectName[] objectNameArray = artifact.getDependents();
        int n = objectNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectName child = objectNameArray[n2];
            lines.add(String.format(CHILD_FORMAT, child.getKeyProperty("artifact-type"), child.getKeyProperty("name"), child.getKeyProperty("version")));
            ++n2;
        }
        return lines;
    }
}

