/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal;

import java.util.Arrays;
import java.util.List;
import org.eclipse.virgo.shell.internal.CommandInvoker;
import org.eclipse.virgo.shell.internal.CommandNotFoundException;
import org.eclipse.virgo.shell.internal.CommandSession;
import org.eclipse.virgo.shell.internal.ParametersMismatchException;
import org.eclipse.virgo.shell.internal.parsing.ParsedCommand;
import org.eclipse.virgo.shell.internal.parsing.ParsingUtils;

final class StandardCommandSession
implements CommandSession {
    private final CommandInvoker commandInvoker;

    StandardCommandSession(CommandInvoker commandInvoker) {
        this.commandInvoker = commandInvoker;
    }

    @Override
    public List<String> execute(CharSequence commandLine) {
        ParsedCommand command = ParsingUtils.parseCommand(commandLine);
        if (command == null) {
            return null;
        }
        try {
            return this.commandInvoker.invokeCommand(command);
        }
        catch (CommandNotFoundException commandNotFoundException) {
            return Arrays.asList(String.format("No command found for input %s", command));
        }
        catch (ParametersMismatchException pme) {
            return Arrays.asList(pme.getMessage());
        }
    }
}

