/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.menuitemkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.util.MnemonicUtil;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.menuitemkit.MenuItemOperationHandler;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public final class MenuItemLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.MenuItem";
    private static final String[] ALLOWED_STYLES = new String[]{"CHECK", "CASCADE", "PUSH", "RADIO", "SEPARATOR"};
    private static final String PROP_TEXT = "text";
    private static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_MENU = "menu";
    private static final String PROP_ENABLED = "enabled";
    private static final String PROP_SELECTION = "selection";
    private static final String PROP_SELECTION_LISTENER = "Selection";

    public void preserveValues(Widget widget) {
        MenuItem item = (MenuItem)widget;
        WidgetLCAUtil.preserveCustomVariant(item);
        WidgetLCAUtil.preserveData(item);
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_TEXT, item.getText());
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_IMAGE, item.getImage());
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_MENU, item.getMenu());
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_ENABLED, item.getEnabled());
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_SELECTION, item.getSelection());
        WidgetLCAUtil.preserveListener(item, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(item, 13));
        WidgetLCAUtil.preserveHelpListener(item);
    }

    public void renderInitialization(Widget widget) throws IOException {
        MenuItem item = (MenuItem)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(item, TYPE);
        remoteObject.setHandler(new MenuItemOperationHandler(item));
        Menu parent = item.getParent();
        remoteObject.set("parent", WidgetUtil.getId(parent));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(item, ALLOWED_STYLES)));
        remoteObject.set("index", parent.indexOf(item));
    }

    public void renderChanges(Widget widget) throws IOException {
        MenuItem item = (MenuItem)widget;
        WidgetLCAUtil.renderCustomVariant(item);
        WidgetLCAUtil.renderData(item);
        MenuItemLCA.renderText(item);
        MenuItemLCA.renderMnemonicIndex(item);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_IMAGE, item.getImage(), null);
        WidgetLCAUtil.renderMenu(item, item.getMenu());
        WidgetLCAUtil.renderProperty((Widget)item, PROP_ENABLED, item.getEnabled(), true);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_SELECTION, item.getSelection(), false);
        WidgetLCAUtil.renderListener(item, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(item, 13), false);
        WidgetLCAUtil.renderListenHelp(item);
    }

    private static void renderText(MenuItem item) {
        String newValue = item.getText();
        if (WidgetLCAUtil.hasChanged(item, PROP_TEXT, newValue, "")) {
            String text = MnemonicUtil.removeAmpersandControlCharacters(newValue);
            RemoteObjectFactory.getRemoteObject(item).set(PROP_TEXT, text);
        }
    }

    private static void renderMnemonicIndex(MenuItem item) {
        int mnemonicIndex;
        String text;
        if ((item.getStyle() & 2) == 0 && WidgetLCAUtil.hasChanged(item, PROP_TEXT, text = item.getText(), "") && (mnemonicIndex = MnemonicUtil.findMnemonicCharacterIndex(text)) != -1) {
            RemoteObjectFactory.getRemoteObject(item).set(PROP_MNEMONIC_INDEX, mnemonicIndex);
        }
    }
}

