/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.engine;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.internal.service.UISessionBuilder;
import org.eclipse.rap.rwt.internal.service.UISessionImpl;
import org.eclipse.rap.rwt.service.ServiceHandler;

public class RWTServlet
extends HttpServlet {
    private ApplicationContextImpl applicationContext;

    public String getServletInfo() {
        return "RWT Servlet";
    }

    public void init() throws ServletException {
        ServletContext servletContext = this.getServletContext();
        this.applicationContext = ApplicationContextImpl.getFrom(servletContext);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!this.applicationContext.allowsRequests()) {
            response.sendError(503);
        } else if (request.getPathInfo() == null) {
            this.handleValidRequest(request, response);
        } else if ("/".equals(request.getPathInfo()) && "".equals(request.getServletPath())) {
            this.handleValidRequest(request, response);
        } else {
            response.sendError(404);
        }
    }

    private void handleValidRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServiceContext serviceContext = this.createServiceContext(request, response);
        ContextProvider.setContext(serviceContext);
        try {
            RWTServlet.ensureUISession(serviceContext);
            this.getServiceHandler().service(request, response);
        }
        finally {
            ContextProvider.disposeContext();
        }
    }

    private ServiceContext createServiceContext(HttpServletRequest request, HttpServletResponse response) {
        ServiceContext context = new ServiceContext(request, response, this.applicationContext);
        context.setServiceStore(new ServiceStore());
        return context;
    }

    private ServiceHandler getServiceHandler() {
        return this.applicationContext.getServiceManager().getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void ensureUISession(ServiceContext serviceContext) {
        Class<RWTServlet> clazz = RWTServlet.class;
        synchronized (RWTServlet.class) {
            HttpServletRequest request = serviceContext.getRequest();
            HttpSession httpSession = request.getSession(true);
            String connectionId = request.getParameter("cid");
            UISessionImpl uiSession = UISessionImpl.getInstanceFromSession(httpSession, connectionId);
            if (uiSession == null) {
                uiSession = new UISessionBuilder(serviceContext).buildUISession();
            }
            serviceContext.setUISession(uiSession);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

