/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.tomcat;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.InstanceManager;
import org.apache.webbeans.web.tomcat.TomcatUtil;

public class TomcatInstanceManager
implements InstanceManager {
    private static final Log log = LogFactory.getLog(TomcatInstanceManager.class);
    private InstanceManager processor;
    private ClassLoader loader;
    private Map<Object, Object> objects = new ConcurrentHashMap<Object, Object>();

    public TomcatInstanceManager(ClassLoader loader, InstanceManager processor) {
        this.processor = processor;
        this.loader = loader;
    }

    public void destroyInstance(Object instance) throws IllegalAccessException, InvocationTargetException {
        Object injectorInstance = this.objects.get(instance);
        if (injectorInstance != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Destroying the OpenWebBeans injector instance");
                }
                TomcatUtil.destroy(injectorInstance, this.loader);
            }
            catch (Exception e) {
                log.error((Object)"Erros is occured while destroying the OpenWebBeans injector instance", (Throwable)e);
            }
        }
        this.processor.destroyInstance(instance);
    }

    public Object newInstance(String str) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        Object object = this.processor.newInstance(str);
        this.inject(object);
        return object;
    }

    public void newInstance(Object object) throws IllegalAccessException, InvocationTargetException, NamingException {
        this.inject(object);
    }

    public Object newInstance(String str, ClassLoader cl) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        Object object = this.processor.newInstance(str, cl);
        this.inject(object);
        return object;
    }

    public Object newInstance(Class<?> clazz) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException {
        Object object = this.processor.newInstance(clazz);
        this.inject(object);
        return object;
    }

    private void inject(Object object) {
        try {
            Object injectorInstance;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Injecting the dependencies for OpenWebBeans, instance : " + object));
            }
            if ((injectorInstance = TomcatUtil.inject(object, this.loader)) != null) {
                this.objects.put(object, injectorInstance);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error is occured while injecting the OpenWebBeans dependencies for instance " + object), (Throwable)e);
        }
    }
}

