/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import javax.enterprise.event.Event;
import javax.enterprise.util.TypeLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.OwbCustomObjectInputStream;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventImpl<T>
implements Event<T>,
Serializable {
    private static final long serialVersionUID = -9035218380365451350L;
    private Annotation[] injectedBindings;
    private Type eventType;
    private transient WebBeansContext webBeansContext;

    public EventImpl(Annotation[] injectedBindings, Type eventType, WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.injectedBindings = injectedBindings;
        this.eventType = eventType;
    }

    public void fire(T event) {
        this.webBeansContext.getBeanManagerImpl().fireEvent(event, this.injectedBindings);
    }

    private Annotation[] getEventBindings(Annotation ... annotations) {
        this.webBeansContext.getAnnotationManager().checkQualifierConditions(annotations);
        HashSet<Annotation> eventBindings = new HashSet<Annotation>();
        for (Annotation ann : this.injectedBindings) {
            eventBindings.add(ann);
        }
        Annotation[] anns = null;
        for (Annotation binding : annotations) {
            eventBindings.add(binding);
        }
        anns = new Annotation[eventBindings.size()];
        anns = eventBindings.toArray(anns);
        return anns;
    }

    public Event<T> select(Annotation ... bindings) {
        EventImpl<T> sub = new EventImpl<T>(this.getEventBindings(bindings), this.eventType, this.webBeansContext);
        return sub;
    }

    public <U extends T> Event<U> select(Class<U> subtype, Annotation ... bindings) {
        if (ClassUtil.isDefinitionContainsTypeVariables(subtype)) {
            throw new IllegalArgumentException("Class : " + subtype + " cannot contain type variable");
        }
        Type sub = subtype;
        if (sub == null) {
            sub = this.eventType;
        }
        EventImpl<T> subEvent = new EventImpl<T>(this.getEventBindings(bindings), sub, this.webBeansContext);
        return subEvent;
    }

    public <U extends T> Event<U> select(TypeLiteral<U> subtype, Annotation ... bindings) {
        return this.select(subtype.getRawType(), bindings);
    }

    private void writeObject(ObjectOutputStream op) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(op);
        oos.writeObject(this.eventType);
        oos.writeObject(this.injectedBindings);
        oos.flush();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        OwbCustomObjectInputStream inputStream = new OwbCustomObjectInputStream(in, WebBeansUtil.getCurrentClassLoader());
        this.eventType = (Type)inputStream.readObject();
        this.injectedBindings = (Annotation[])inputStream.readObject();
        this.webBeansContext = WebBeansContext.currentInstance();
    }
}

