/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.rap.rwt.internal.theme.IThemeCssElement;
import org.eclipse.rap.rwt.internal.theme.QxType;
import org.eclipse.rap.rwt.internal.theme.StyleSheetBuilder;
import org.eclipse.rap.rwt.internal.theme.ThemeCssValuesMap;
import org.eclipse.rap.rwt.internal.theme.ThemeManagerException;
import org.eclipse.rap.rwt.internal.theme.ThemeResource;
import org.eclipse.rap.rwt.internal.theme.ThemeStoreWriter;
import org.eclipse.rap.rwt.internal.theme.ThemeableWidget;
import org.eclipse.rap.rwt.internal.theme.css.CssElementHolder;
import org.eclipse.rap.rwt.internal.theme.css.StyleSheet;
import org.eclipse.rap.rwt.service.ApplicationContext;
import org.eclipse.rap.rwt.service.ResourceManager;

public class Theme {
    private static final String JS_THEME_PREFIX = "rwt.theme.";
    private final String id;
    private final String jsId;
    private final String name;
    private StyleSheetBuilder styleSheetBuilder;
    private ThemeCssValuesMap valuesMap;
    private String registeredLocation;
    private IThemeCssElement[] elements;

    public Theme(String id, String name, StyleSheet styleSheet) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.id = id;
        this.name = name != null ? name : "Unnamed Theme";
        this.jsId = Theme.createUniqueJsId(id);
        this.valuesMap = null;
        this.styleSheetBuilder = new StyleSheetBuilder();
        if (styleSheet != null) {
            this.styleSheetBuilder.addStyleSheet(styleSheet);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getJsId() {
        return this.jsId;
    }

    public String getName() {
        return this.name;
    }

    public void addStyleSheet(StyleSheet styleSheet) {
        if (this.valuesMap != null) {
            throw new IllegalStateException("Theme is already initialized");
        }
        this.styleSheetBuilder.addStyleSheet(styleSheet);
    }

    public void initialize(ThemeableWidget[] themeableWidgets) {
        this.elements = this.extractElements(themeableWidgets);
        if (this.valuesMap != null) {
            throw new IllegalStateException("Theme is already initialized");
        }
        StyleSheet styleSheet = this.styleSheetBuilder.getStyleSheet();
        this.valuesMap = new ThemeCssValuesMap(this, styleSheet, themeableWidgets);
        this.styleSheetBuilder = null;
    }

    private IThemeCssElement[] extractElements(ThemeableWidget[] themeableWidgets) {
        CssElementHolder elements = new CssElementHolder();
        ThemeableWidget[] themeableWidgetArray = themeableWidgets;
        int n = themeableWidgets.length;
        int n2 = 0;
        while (n2 < n) {
            ThemeableWidget themeableWidget = themeableWidgetArray[n2];
            if (themeableWidget.elements != null) {
                IThemeCssElement[] iThemeCssElementArray = themeableWidget.elements;
                int n3 = themeableWidget.elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IThemeCssElement element = iThemeCssElementArray[n4];
                    elements.addElement(element);
                    ++n4;
                }
            }
            ++n2;
        }
        return elements.getAllElements();
    }

    public StyleSheet getStyleSheet() {
        return this.styleSheetBuilder.getStyleSheet();
    }

    public ThemeCssValuesMap getValuesMap() {
        if (this.valuesMap == null) {
            throw new IllegalStateException("Theme is not initialized");
        }
        return this.valuesMap;
    }

    public String getRegisteredLocation() {
        return this.registeredLocation;
    }

    public void registerResources(ApplicationContext applicationContext) {
        try {
            this.registerThemeResources(applicationContext);
            this.registerThemeStoreFile(applicationContext);
        }
        catch (IOException ioe) {
            throw new ThemeManagerException("Failed to register theme resources for theme " + this.id, ioe);
        }
    }

    private void registerThemeResources(ApplicationContext applicationContext) throws IOException {
        QxType[] values;
        QxType[] qxTypeArray = values = this.valuesMap.getAllValues();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            QxType value = qxTypeArray[n2];
            if (value instanceof ThemeResource) {
                Theme.registerResource(applicationContext, (ThemeResource)((Object)value));
            }
            ++n2;
        }
    }

    private void registerThemeStoreFile(ApplicationContext applicationContext) {
        ThemeStoreWriter storeWriter = new ThemeStoreWriter(applicationContext, this, this.elements);
        String name = "rap-" + this.jsId + ".json";
        String code = storeWriter.createJson();
        this.registeredLocation = Theme.registerResource(applicationContext, name, code);
    }

    private static void registerResource(ApplicationContext applicationContext, ThemeResource value) throws IOException {
        String registerPath = value.getResourcePath(applicationContext);
        if (registerPath != null) {
            InputStream inputStream = value.getResourceAsStream();
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource not found for theme property: " + value);
            }
            try {
                applicationContext.getResourceManager().register(registerPath, inputStream);
            }
            finally {
                inputStream.close();
            }
        }
    }

    private static String registerResource(ApplicationContext applicationContext, String name, String content) {
        byte[] buffer;
        try {
            buffer = content.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException shouldNotHappen) {
            throw new RuntimeException(shouldNotHappen);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer);
        ResourceManager resourceManager = applicationContext.getResourceManager();
        resourceManager.register(name, inputStream);
        return resourceManager.getLocation(name);
    }

    private static String createUniqueJsId(String id) {
        String result;
        if ("org.eclipse.rap.rwt.theme.Default".equals(id)) {
            result = "rwt.theme.Default";
        } else if ("org.eclipse.rap.rwt.theme.Fallback".equals(id)) {
            result = "rwt.theme.Fallback";
        } else {
            String hash = Integer.toHexString(id.hashCode());
            result = "rwt.theme.Custom_" + hash;
        }
        return result;
    }
}

