/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.protocol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.internal.protocol.Message;
import org.eclipse.rap.rwt.internal.protocol.Operation;
import org.eclipse.rap.rwt.internal.protocol.RequestMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientMessage
extends RequestMessage {
    private Map<String, List<Operation>> index;

    public ClientMessage(JsonObject json) {
        super(json);
        this.createOperationsIndex();
    }

    public ClientMessage(Message message) {
        super(message.getHead(), message.getOperations());
        this.createOperationsIndex();
    }

    private void createOperationsIndex() {
        this.index = new HashMap<String, List<Operation>>();
        for (Operation operation : this.getOperations()) {
            String target = operation.getTarget();
            List<Operation> targetOperations = this.index.get(target);
            if (targetOperations == null) {
                targetOperations = new ArrayList<Operation>();
            }
            targetOperations.add(operation);
            this.index.put(target, targetOperations);
        }
    }

    public List<Operation> getAllOperationsFor(String target) {
        List<Operation> operations = this.index.get(target);
        if (operations == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(operations);
    }

    public List<Operation.CallOperation> getAllCallOperationsFor(String target, String methodName) {
        List<Operation> selected;
        ArrayList<Operation.CallOperation> result = new ArrayList<Operation.CallOperation>();
        List<Operation> list = selected = target == null ? this.getOperations() : this.index.get(target);
        if (selected != null) {
            for (Operation operation : selected) {
                if (!(operation instanceof Operation.CallOperation)) continue;
                Operation.CallOperation currentOperation = (Operation.CallOperation)operation;
                if (methodName != null && !currentOperation.getMethodName().equals(methodName)) continue;
                result.add(currentOperation);
            }
        }
        return result;
    }

    public Operation.SetOperation getLastSetOperationFor(String target, String property) {
        List<Operation> selected;
        Operation.SetOperation result = null;
        List<Operation> list = selected = target == null ? this.getOperations() : this.index.get(target);
        if (selected != null) {
            for (Operation operation : selected) {
                if (!(operation instanceof Operation.SetOperation)) continue;
                Operation.SetOperation setOperation = (Operation.SetOperation)operation;
                if (property != null && setOperation.getProperties().get(property) == null) continue;
                result = setOperation;
            }
        }
        return result;
    }

    public Operation.NotifyOperation getLastNotifyOperationFor(String target, String eventName) {
        List<Operation> selected;
        Operation.NotifyOperation result = null;
        List<Operation> list = selected = target == null ? this.getOperations() : this.index.get(target);
        if (selected != null) {
            for (Operation operation : selected) {
                if (!(operation instanceof Operation.NotifyOperation)) continue;
                Operation.NotifyOperation currentOperation = (Operation.NotifyOperation)operation;
                if (eventName != null && !currentOperation.getEventName().equals(eventName)) continue;
                result = currentOperation;
            }
        }
        return result;
    }
}

