/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.plugins.OpenWebBeansEjbLCAPlugin;
import org.apache.webbeans.plugins.OpenWebBeansJmsPlugin;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.spi.plugins.OpenWebBeansJavaEEPlugin;
import org.apache.webbeans.spi.plugins.OpenWebBeansPlugin;
import org.apache.webbeans.spi.plugins.OpenWebBeansWebPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginLoader {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(PluginLoader.class);
    private List<OpenWebBeansPlugin> plugins = null;
    private AtomicBoolean started = new AtomicBoolean(false);

    public void startUp() throws WebBeansConfigurationException {
        if (this.started.compareAndSet(false, true)) {
            logger.fine("PluginLoader startUp called.");
            ArrayList<OpenWebBeansPlugin> ps = new ArrayList<OpenWebBeansPlugin>();
            List pluginList = WebBeansContext.getInstance().getLoaderService().load(OpenWebBeansPlugin.class);
            for (OpenWebBeansPlugin plugin : pluginList) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "INFO_0004", plugin.getClass().getSimpleName());
                }
                try {
                    plugin.startUp();
                }
                catch (Exception e) {
                    PluginLoader.throwsException(e);
                }
                ps.add(plugin);
            }
            this.plugins = Collections.unmodifiableList(ps);
        } else {
            logger.fine("PluginLoader is already started.");
        }
    }

    public static void throwsException(Exception e) throws WebBeansConfigurationException {
        if (e instanceof WebBeansConfigurationException) {
            throw (WebBeansConfigurationException)e;
        }
        throw new WebBeansConfigurationException(e);
    }

    public void shutDown() throws WebBeansConfigurationException {
        if (this.started.compareAndSet(true, false)) {
            logger.fine("PluginLoader shutDown called.");
            if (this.plugins == null) {
                logger.warning("WARN_0001");
                return;
            }
            ArrayList<String> failedShutdown = new ArrayList<String>();
            for (OpenWebBeansPlugin plugin : this.plugins) {
                try {
                    plugin.shutDown();
                }
                catch (Exception e) {
                    String pluginName = plugin.getClass().getSimpleName();
                    logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage("ERROR_0009", pluginName), e);
                    failedShutdown.add(pluginName);
                }
            }
            if (!failedShutdown.isEmpty()) {
                throw new WebBeansConfigurationException(WebBeansLoggerFacade.getTokenString("EXCEPT_0006") + failedShutdown.toString());
            }
        } else {
            logger.fine("PluginLoader is already shut down.");
        }
    }

    public List<OpenWebBeansPlugin> getPlugins() {
        return this.plugins;
    }

    public OpenWebBeansEjbPlugin getEjbPlugin() {
        if (!this.pluginsExist()) {
            return null;
        }
        for (OpenWebBeansPlugin plugin : this.plugins) {
            if (!(plugin instanceof OpenWebBeansEjbPlugin)) continue;
            return (OpenWebBeansEjbPlugin)plugin;
        }
        return null;
    }

    public OpenWebBeansEjbLCAPlugin getEjbLCAPlugin() {
        if (!this.pluginsExist()) {
            return null;
        }
        for (OpenWebBeansPlugin plugin : this.plugins) {
            if (!(plugin instanceof OpenWebBeansEjbLCAPlugin)) continue;
            return (OpenWebBeansEjbLCAPlugin)plugin;
        }
        return null;
    }

    public OpenWebBeansJmsPlugin getJmsPlugin() {
        if (!this.pluginsExist()) {
            return null;
        }
        for (OpenWebBeansPlugin plugin : this.plugins) {
            if (!(plugin instanceof OpenWebBeansJmsPlugin)) continue;
            return (OpenWebBeansJmsPlugin)plugin;
        }
        return null;
    }

    public OpenWebBeansJavaEEPlugin getJavaEEPlugin() {
        if (!this.pluginsExist()) {
            return null;
        }
        for (OpenWebBeansPlugin plugin : this.plugins) {
            if (!(plugin instanceof OpenWebBeansJavaEEPlugin)) continue;
            return (OpenWebBeansJavaEEPlugin)plugin;
        }
        return null;
    }

    public OpenWebBeansWebPlugin getWebPlugin() {
        if (!this.pluginsExist()) {
            return null;
        }
        for (OpenWebBeansPlugin plugin : this.plugins) {
            if (!(plugin instanceof OpenWebBeansWebPlugin)) continue;
            return (OpenWebBeansWebPlugin)plugin;
        }
        return null;
    }

    private boolean pluginsExist() {
        return this.plugins != null;
    }
}

