/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.tracecompass.analysis.profiling.core.base.ICallStackGroupDescriptor;
import org.eclipse.tracecompass.analysis.profiling.core.callstack2.CallStackSeries;
import org.eclipse.tracecompass.analysis.profiling.core.tests.CallStackTestBase2;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs2.CallStackAnalysisStub;
import org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented.InstrumentedGroupDescriptor;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.statesystem.core.tests.shared.utils.StateIntervalStub;
import org.eclipse.tracecompass.statesystem.core.tests.shared.utils.StateSystemTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class CallStackStateSystemTest
extends CallStackTestBase2 {
    @Test
    public void testCallStackProvider() {
        CallStackAnalysisStub module = this.getModule();
        Assert.assertNotNull((Object)((Object)module));
        CallStackSeries callstack = module.getCallStackSeries();
        Assert.assertNotNull((Object)callstack);
        List<String[]> patterns = module.getPatterns();
        Assert.assertEquals((long)2L, (long)patterns.size());
        ICallStackGroupDescriptor nextLevel = callstack.getRootGroup();
        Assert.assertTrue((boolean)(nextLevel instanceof InstrumentedGroupDescriptor));
        Object[] subPattern = ((InstrumentedGroupDescriptor)nextLevel).getSubPattern();
        Assert.assertArrayEquals((Object[])patterns.get(0), (Object[])subPattern);
        nextLevel = nextLevel.getNextGroup();
        Assert.assertTrue((boolean)(nextLevel instanceof InstrumentedGroupDescriptor));
        subPattern = ((InstrumentedGroupDescriptor)nextLevel).getSubPattern();
        Assert.assertArrayEquals((Object[])patterns.get(1), (Object[])subPattern);
        nextLevel = nextLevel.getNextGroup();
        Assert.assertNull((Object)nextLevel);
    }

    @Test
    public void testCallStackContent() throws AttributeNotFoundException {
        CallStackAnalysisStub module = this.getModule();
        Assert.assertNotNull((Object)((Object)module));
        CallStackSeries callstack = module.getCallStackSeries();
        Assert.assertNotNull((Object)callstack);
        ITmfStateSystem ss = module.getStateSystem();
        Assert.assertNotNull((Object)ss);
        List<String[]> patterns = module.getPatterns();
        List quarks = ss.getQuarks(patterns.get(0));
        Assert.assertEquals((String)"Number of processes", (long)2L, (long)quarks.size());
        for (Integer processQuark : quarks) {
            List threadQuarks = ss.getQuarks(processQuark.intValue(), patterns.get(1));
            switch (ss.getAttributeName(processQuark.intValue())) {
                case "1": {
                    CallStackStateSystemTest.verifyProcess1(ss, threadQuarks);
                    break;
                }
                case "5": {
                    CallStackStateSystemTest.verifyProcess5(ss, threadQuarks);
                    break;
                }
                default: {
                    Assert.fail((String)"Unknown process in callstack");
                }
            }
        }
    }

    private static void verifyProcess1(ITmfStateSystem ss, List<Integer> threadQuarks) throws AttributeNotFoundException {
        for (Integer threadQuark : threadQuarks) {
            int csQuark = ss.getQuarkRelative(threadQuark.intValue(), new String[]{"CallStack"});
            String[] csPathArray = ss.getFullAttributePathArray(csQuark);
            ArrayList<String> pathList = new ArrayList<String>();
            pathList.addAll(Arrays.asList(csPathArray));
            switch (ss.getAttributeName(threadQuark.intValue())) {
                case "2": {
                    List subAttributes = ss.getSubAttributes(csQuark, false);
                    Assert.assertEquals((long)3L, (long)subAttributes.size());
                    ArrayList<StateIntervalStub> expected = new ArrayList<StateIntervalStub>();
                    pathList.add("1");
                    expected.add(new StateIntervalStub(1, 9, (ITmfStateValue)TmfStateValue.newValueString((String)"op1")));
                    expected.add(new StateIntervalStub(10, 11, (ITmfStateValue)TmfStateValue.nullValue()));
                    expected.add(new StateIntervalStub(12, 19, (ITmfStateValue)TmfStateValue.newValueString((String)"op4")));
                    expected.add(new StateIntervalStub(20, 20, (ITmfStateValue)TmfStateValue.nullValue()));
                    StateSystemTestUtils.testIntervalForAttributes((ITmfStateSystem)ss, expected, (String[])pathList.toArray(new String[pathList.size()]));
                    pathList.remove(pathList.size() - 1);
                    pathList.add("2");
                    expected.clear();
                    expected.add(new StateIntervalStub(1, 2, (ITmfStateValue)TmfStateValue.nullValue()));
                    expected.add(new StateIntervalStub(3, 6, (ITmfStateValue)TmfStateValue.newValueString((String)"op2")));
                    expected.add(new StateIntervalStub(7, 20, (ITmfStateValue)TmfStateValue.nullValue()));
                    StateSystemTestUtils.testIntervalForAttributes((ITmfStateSystem)ss, expected, (String[])pathList.toArray(new String[pathList.size()]));
                    pathList.remove(pathList.size() - 1);
                    pathList.add("3");
                    expected.clear();
                    expected.add(new StateIntervalStub(1, 3, (ITmfStateValue)TmfStateValue.nullValue()));
                    expected.add(new StateIntervalStub(4, 4, (ITmfStateValue)TmfStateValue.newValueString((String)"op3")));
                    expected.add(new StateIntervalStub(5, 20, (ITmfStateValue)TmfStateValue.nullValue()));
                    StateSystemTestUtils.testIntervalForAttributes((ITmfStateSystem)ss, expected, (String[])pathList.toArray(new String[pathList.size()]));
                    break;
                }
                case "3": {
                    List subAttributes = ss.getSubAttributes(csQuark, false);
                    Assert.assertEquals((long)2L, (long)subAttributes.size());
                    ArrayList<StateIntervalStub> expected = new ArrayList();
                    pathList.add("1");
                    expected.add(new StateIntervalStub(1, 2, (ITmfStateValue)TmfStateValue.nullValue()));
                    expected.add(new StateIntervalStub(3, 19, (ITmfStateValue)TmfStateValue.newValueString((String)"op2")));
                    expected.add(new StateIntervalStub(20, 20, (ITmfStateValue)TmfStateValue.nullValue()));
                    StateSystemTestUtils.testIntervalForAttributes((ITmfStateSystem)ss, expected, (String[])pathList.toArray(new String[pathList.size()]));
                    pathList.remove(pathList.size() - 1);
                    pathList.add("2");
                    expected.clear();
                    expected.add(new StateIntervalStub(1, 4, (ITmfStateValue)TmfStateValue.nullValue()));
                    expected.add(new StateIntervalStub(5, 5, (ITmfStateValue)TmfStateValue.newValueString((String)"op3")));
                    expected.add(new StateIntervalStub(6, 6, (ITmfStateValue)TmfStateValue.nullValue()));
                    expected.add(new StateIntervalStub(7, 12, (ITmfStateValue)TmfStateValue.newValueString((String)"op2")));
                    expected.add(new StateIntervalStub(13, 20, (ITmfStateValue)TmfStateValue.nullValue()));
                    StateSystemTestUtils.testIntervalForAttributes((ITmfStateSystem)ss, expected, (String[])pathList.toArray(new String[pathList.size()]));
                    break;
                }
                default: {
                    Assert.fail((String)"Unknown thread child of process 5");
                }
            }
        }
    }

    private static void verifyProcess5(ITmfStateSystem ss, List<Integer> threadQuarks) throws AttributeNotFoundException {
        for (Integer threadQuark : threadQuarks) {
            int csQuark = ss.getQuarkRelative(threadQuark.intValue(), new String[]{"CallStack"});
            String[] csPathArray = ss.getFullAttributePathArray(csQuark);
            ArrayList<String> pathList = new ArrayList<String>();
            pathList.addAll(Arrays.asList(csPathArray));
            switch (ss.getAttributeName(threadQuark.intValue())) {
                case "6": {
                    List subAttributes = ss.getSubAttributes(csQuark, false);
                    Assert.assertEquals((long)3L, (long)subAttributes.size());
                    ArrayList<StateIntervalStub> expected = new ArrayList<StateIntervalStub>();
                    pathList.add("1");
                    expected.add(new StateIntervalStub(1, 19, (ITmfStateValue)TmfStateValue.newValueString((String)"op1")));
                    expected.add(new StateIntervalStub(20, 20, (ITmfStateValue)TmfStateValue.nullValue()));
                    StateSystemTestUtils.testIntervalForAttributes((ITmfStateSystem)ss, expected, (String[])pathList.toArray(new String[pathList.size()]));
                    pathList.remove(pathList.size() - 1);
                    pathList.add("2");
                    expected.clear();
                    expected.add(new StateIntervalStub(1, 1, (ITmfStateValue)TmfStateValue.nullValue()));
                    expected.add(new StateIntervalStub(2, 6, (ITmfStateValue)TmfStateValue.newValueString((String)"op3")));
                    expected.add(new StateIntervalStub(7, 7, (ITmfStateValue)TmfStateValue.nullValue()));
                    expected.add(new StateIntervalStub(8, 10, (ITmfStateValue)TmfStateValue.newValueString((String)"op2")));
                    expected.add(new StateIntervalStub(11, 11, (ITmfStateValue)TmfStateValue.nullValue()));
                    expected.add(new StateIntervalStub(12, 19, (ITmfStateValue)TmfStateValue.newValueString((String)"op4")));
                    expected.add(new StateIntervalStub(20, 20, (ITmfStateValue)TmfStateValue.nullValue()));
                    StateSystemTestUtils.testIntervalForAttributes((ITmfStateSystem)ss, expected, (String[])pathList.toArray(new String[pathList.size()]));
                    pathList.remove(pathList.size() - 1);
                    pathList.add("3");
                    expected.clear();
                    expected.add(new StateIntervalStub(1, 3, (ITmfStateValue)TmfStateValue.nullValue()));
                    expected.add(new StateIntervalStub(4, 5, (ITmfStateValue)TmfStateValue.newValueString((String)"op1")));
                    expected.add(new StateIntervalStub(6, 8, (ITmfStateValue)TmfStateValue.nullValue()));
                    expected.add(new StateIntervalStub(9, 9, (ITmfStateValue)TmfStateValue.newValueString((String)"op3")));
                    expected.add(new StateIntervalStub(10, 20, (ITmfStateValue)TmfStateValue.nullValue()));
                    StateSystemTestUtils.testIntervalForAttributes((ITmfStateSystem)ss, expected, (String[])pathList.toArray(new String[pathList.size()]));
                    break;
                }
                case "7": {
                    List subAttributes = ss.getSubAttributes(csQuark, false);
                    Assert.assertEquals((long)3L, (long)subAttributes.size());
                    ArrayList<StateIntervalStub> expected = new ArrayList();
                    pathList.add("1");
                    expected.add(new StateIntervalStub(1, 19, (ITmfStateValue)TmfStateValue.newValueString((String)"op5")));
                    expected.add(new StateIntervalStub(20, 20, (ITmfStateValue)TmfStateValue.nullValue()));
                    StateSystemTestUtils.testIntervalForAttributes((ITmfStateSystem)ss, expected, (String[])pathList.toArray(new String[pathList.size()]));
                    pathList.remove(pathList.size() - 1);
                    pathList.add("2");
                    expected.clear();
                    expected.add(new StateIntervalStub(1, 1, (ITmfStateValue)TmfStateValue.nullValue()));
                    expected.add(new StateIntervalStub(2, 5, (ITmfStateValue)TmfStateValue.newValueString((String)"op2")));
                    expected.add(new StateIntervalStub(6, 8, (ITmfStateValue)TmfStateValue.nullValue()));
                    expected.add(new StateIntervalStub(9, 12, (ITmfStateValue)TmfStateValue.newValueString((String)"op2")));
                    expected.add(new StateIntervalStub(13, 14, (ITmfStateValue)TmfStateValue.nullValue()));
                    expected.add(new StateIntervalStub(15, 18, (ITmfStateValue)TmfStateValue.newValueString((String)"op2")));
                    expected.add(new StateIntervalStub(19, 20, (ITmfStateValue)TmfStateValue.nullValue()));
                    StateSystemTestUtils.testIntervalForAttributes((ITmfStateSystem)ss, expected, (String[])pathList.toArray(new String[pathList.size()]));
                    pathList.remove(pathList.size() - 1);
                    pathList.add("3");
                    expected.clear();
                    expected.add(new StateIntervalStub(1, 9, (ITmfStateValue)TmfStateValue.nullValue()));
                    expected.add(new StateIntervalStub(10, 10, (ITmfStateValue)TmfStateValue.newValueString((String)"op3")));
                    expected.add(new StateIntervalStub(11, 20, (ITmfStateValue)TmfStateValue.nullValue()));
                    StateSystemTestUtils.testIntervalForAttributes((ITmfStateSystem)ss, expected, (String[])pathList.toArray(new String[pathList.size()]));
                    break;
                }
                default: {
                    Assert.fail((String)"Unknown thread child of process 5");
                }
            }
        }
    }
}

