/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.utils;

import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

final class GenericReadOnlyListIterator<E>
implements ListIterator<E> {
    private int fCursor;
    private final List<E> fList;

    public GenericReadOnlyListIterator(List<E> list, int start) {
        this.fList = list;
        this.fCursor = start - 1;
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex() < this.fList.size();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        E next = this.fList.get(this.nextIndex());
        ++this.fCursor;
        return next;
    }

    @Override
    public boolean hasPrevious() {
        return this.previousIndex() >= 0;
    }

    @Override
    public E previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        E prev = this.fList.get(this.previousIndex());
        --this.fCursor;
        return prev;
    }

    @Override
    public int nextIndex() {
        return this.fCursor + 1;
    }

    @Override
    public int previousIndex() {
        return this.fCursor;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(E e) {
        throw new UnsupportedOperationException();
    }
}

