/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.variableresolvers.PathVariableResolver;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ProjectVariableProviderManager {
    private static final Map<String, Descriptor> descriptors = ProjectVariableProviderManager.getDescriptorMap();
    private static final Descriptor[] descriptorsArray = (Descriptor[])descriptors.values().toArray(Descriptor[]::new);
    private static final ProjectVariableProviderManager instance = new ProjectVariableProviderManager();

    public static ProjectVariableProviderManager getDefault() {
        return instance;
    }

    public Descriptor[] getDescriptors() {
        return descriptorsArray;
    }

    private static Map<String, Descriptor> getDescriptorMap() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources", "variableResolvers");
        IExtension[] extensions = point.getExtensions();
        HashMap<String, Descriptor> d = new HashMap<String, Descriptor>(extensions.length * 2 + 1);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                String elementName = element.getName();
                if (elementName.equalsIgnoreCase("variableResolver")) {
                    Descriptor desc = null;
                    try {
                        desc = new Descriptor(extension, element);
                    }
                    catch (CoreException e) {
                        Policy.log(e);
                    }
                    if (desc != null) {
                        d.put(desc.getName(), desc);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return Map.copyOf(d);
    }

    public Descriptor findDescriptor(String name) {
        Descriptor result = descriptors.get(name);
        return result;
    }

    public static class Descriptor {
        private final PathVariableResolver provider;
        private final String name;
        private final String value;

        public Descriptor(IExtension extension, IConfigurationElement element) throws RuntimeException, CoreException {
            this.name = element.getAttribute("variable");
            this.value = element.getAttribute("value");
            PathVariableResolver p = null;
            try {
                String classAttribute = "class";
                if (element.getAttribute(classAttribute) != null) {
                    p = (PathVariableResolver)element.createExecutableExtension(classAttribute);
                }
            }
            catch (CoreException e) {
                Policy.log(e);
            }
            this.provider = p;
            if (this.name == null) {
                this.fail(NLS.bind((String)Messages.mapping_invalidDef, (Object)extension.getUniqueIdentifier()));
            }
        }

        protected void fail(String reason) throws CoreException {
            throw new ResourceException((IStatus)new Status(4, "org.eclipse.core.resources", 1, reason, null));
        }

        public String getName() {
            return this.name;
        }

        public String getValue(String variable, IResource resource) {
            if (this.value != null) {
                return this.value;
            }
            return this.provider.getValue(variable, resource);
        }

        public String[] getVariableNames(String variable, IResource resource) {
            if (this.provider != null) {
                return this.provider.getVariableNames(variable, resource);
            }
            if (this.name.equals(variable)) {
                return new String[]{variable};
            }
            return null;
        }
    }
}

