/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.verify;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.trace4cps.analysis.mtl.InformativePrefix;
import org.eclipse.trace4cps.analysis.mtl.MtlFormula;
import org.eclipse.trace4cps.tl.VerificationResult;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.verify.CheckNode;

public class ResultNode {
    private final TraceView view;
    private final InformativePrefix type;
    private final List<CheckNode> checks = new ArrayList<CheckNode>();

    public ResultNode(InformativePrefix type, TraceView view) {
        this.type = type;
        this.view = view;
    }

    public InformativePrefix getType() {
        return this.type;
    }

    public List<CheckNode> getChecks() {
        return this.checks;
    }

    public void add(VerificationResult res) {
        long timeStamp = System.currentTimeMillis();
        boolean updated = false;
        for (MtlFormula phi : res.getChecks()) {
            if (res.getResult(phi).informative() != this.type) continue;
            String name = res.getName(phi);
            CheckNode n = this.getOrCreateNode(name);
            n.set(timeStamp, phi, res);
            updated = true;
        }
        if (updated) {
            Collections.sort(this.checks, new Comparator<CheckNode>(){

                @Override
                public int compare(CheckNode o1, CheckNode o2) {
                    return o1.getCheckName().compareTo(o2.getCheckName());
                }
            });
        }
    }

    private CheckNode getOrCreateNode(String name) {
        CheckNode n = null;
        for (CheckNode cn : this.checks) {
            if (!cn.getCheckName().equals(name)) continue;
            n = cn;
            break;
        }
        if (n == null) {
            n = new CheckNode(this.view);
            this.checks.add(n);
        }
        return n;
    }

    public boolean refresh(long lastModified) {
        ArrayList<CheckNode> toRemoveCn = new ArrayList<CheckNode>();
        for (CheckNode cn : this.checks) {
            if (cn.getCheckTime() > lastModified) continue;
            toRemoveCn.add(cn);
        }
        this.checks.removeAll(toRemoveCn);
        return this.checks.isEmpty();
    }
}

