/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.ui.gantt;

import java.awt.event.MouseEvent;
import org.eclipse.trace4cps.common.jfreechart.ui.gantt.XYGanttDataItem;
import org.eclipse.trace4cps.common.jfreechart.ui.gantt.XYGanttMeasurement;
import org.eclipse.trace4cps.common.jfreechart.ui.gantt.XYGanttMeasurementAnnotation;
import org.eclipse.trace4cps.common.jfreechart.ui.viewers.BackReferenceProvider;
import org.eclipse.trace4cps.common.jfreechart.ui.viewers.BackReferenceResolver;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYMeasurementAnnotation;
import org.jfree.chart.geom.Point2DNumber;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYMeasureWithAnnotations;
import org.jfree.chart.plot.XYPlot;

public class XYGanttMeasureWithAnnotations
extends XYMeasureWithAnnotations {
    private static final long serialVersionUID = -6750408735004577024L;
    private final XYMeasureWithAnnotations.MeasurementAxis measurementAxis;
    private BackReferenceResolver backReferenceResolver = BackReferenceResolver.DEFAULT;

    public static XYGanttMeasureWithAnnotations addToChartPanel(ChartPanel chartPanel, XYMeasureWithAnnotations.MeasurementAxis axis) {
        XYGanttMeasureWithAnnotations instance = new XYGanttMeasureWithAnnotations(axis);
        instance.addToChartPanel(chartPanel);
        return instance;
    }

    public XYGanttMeasureWithAnnotations(XYMeasureWithAnnotations.MeasurementAxis measurementAxis) {
        super(measurementAxis);
        this.measurementAxis = measurementAxis;
    }

    protected XYMeasureWithAnnotations.MeasurementAxis getMeasurementAxis() {
        return this.measurementAxis;
    }

    public BackReferenceResolver getBackReferenceResolver() {
        return this.backReferenceResolver;
    }

    public void setBackReferenceResolver(BackReferenceResolver backReferenceResolver) {
        this.backReferenceResolver = backReferenceResolver;
    }

    protected Point2DNumber getCrosshairPoint(ChartMouseEvent event) {
        BackReferenceProvider<?> backReferenceProvider = this.backReferenceResolver.resolveBackReferenceProvider(event);
        if (backReferenceProvider instanceof XYGanttDataItem) {
            return new XYGanttPoint((XYGanttDataItem)backReferenceProvider, this.calculateCrosshairPoint(event));
        }
        return null;
    }

    protected Point2DNumber calculateCrosshairPoint(ChartMouseEvent event) {
        return super.getCrosshairPoint(event);
    }

    protected void addAnnotation(XYPlot plot, Point2DNumber first, Point2DNumber second, MouseEvent event) {
        XYMeasurementAnnotation.Orientation orientation;
        String label;
        if (this.measurementAxis == XYMeasureWithAnnotations.MeasurementAxis.DOMAIN) {
            label = this.createMeasurementLabel(first.getX(), second.getX(), event);
            orientation = plot.getOrientation() == PlotOrientation.VERTICAL ? XYMeasurementAnnotation.Orientation.HORIZONTAL : XYMeasurementAnnotation.Orientation.VERTICAL;
        } else {
            label = this.createMeasurementLabel(first.getY(), second.getY(), event);
            orientation = plot.getOrientation() == PlotOrientation.VERTICAL ? XYMeasurementAnnotation.Orientation.VERTICAL : XYMeasurementAnnotation.Orientation.HORIZONTAL;
        }
        XYAnnotation measurementAnnotation = this.createMeasurementAnnotation(orientation, label, first, second);
        if (measurementAnnotation != null) {
            plot.addAnnotation(measurementAnnotation);
        }
    }

    protected XYAnnotation createMeasurementAnnotation(XYMeasurementAnnotation.Orientation orientation, String label, Point2DNumber first, Point2DNumber second) {
        if (first instanceof XYGanttPoint && second instanceof XYGanttPoint) {
            XYGanttDataItem<?> firstDataItem = ((XYGanttPoint)first).getDataItem();
            XYGanttMeasurement.Snap firstSnap = this.getSnap((XYGanttPoint)first);
            XYGanttDataItem<?> secondDataItem = ((XYGanttPoint)second).getDataItem();
            XYGanttMeasurement.Snap secondSnap = this.getSnap((XYGanttPoint)second);
            return this.createMeasurementAnnotation(orientation, label, firstDataItem, firstSnap, secondDataItem, secondSnap);
        }
        return super.createMeasurementAnnotation(orientation, label, first, second);
    }

    protected XYAnnotation createMeasurementAnnotation(XYMeasurementAnnotation.Orientation orientation, String label, XYGanttDataItem<?> firstDataItem, XYGanttMeasurement.Snap firstSnap, XYGanttDataItem<?> secondDataItem, XYGanttMeasurement.Snap secondSnap) {
        if (label == null) {
            return null;
        }
        return new XYGanttMeasurementAnnotation(orientation, label, firstDataItem, firstSnap, secondDataItem, secondSnap);
    }

    protected XYGanttMeasurement.Snap getSnap(XYGanttPoint xyGanttPoint) {
        boolean snapToStart = this.measurementAxis == XYMeasureWithAnnotations.MeasurementAxis.DOMAIN ? xyGanttPoint.getX() == xyGanttPoint.getDataItem().getXLowValue() : xyGanttPoint.getY() == xyGanttPoint.getDataItem().getYLowValue();
        return snapToStart ? XYGanttMeasurement.Snap.START : XYGanttMeasurement.Snap.END;
    }

    protected static class XYGanttPoint
    extends Point2DNumber {
        private final XYGanttDataItem<?> dataItem;

        public XYGanttPoint(XYGanttDataItem<?> dataItem, Point2DNumber point) {
            super(point.x, point.y);
            this.dataItem = dataItem;
        }

        public XYGanttDataItem<?> getDataItem() {
            return this.dataItem;
        }
    }
}

