/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import com.google.gson.Gson;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CUCorrectionProposalCore;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.core.manipulation.OrganizeImportsOperation;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.text.correction.SourceAssistProcessor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public final class OrganizeImportsHandler {
    public static final String CLIENT_COMMAND_ID_CHOOSEIMPORTS = "java.action.organizeImports.chooseImports";

    public static TextEdit organizeImports(ICompilationUnit unit, Function<ImportSelection[], ImportCandidate[]> chooseImports) {
        return OrganizeImportsHandler.organizeImports(unit, chooseImports, false, (IProgressMonitor)new NullProgressMonitor());
    }

    public static TextEdit organizeImports(ICompilationUnit unit, Function<ImportSelection[], ImportCandidate[]> chooseImports, boolean restoreExistingImports, IProgressMonitor monitor) {
        TextEdit edit;
        block5: {
            if (unit == null) {
                return null;
            }
            CompilationUnit astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, monitor);
            if (astRoot == null) {
                return null;
            }
            OrganizeImportsOperation op = new OrganizeImportsOperation(unit, astRoot, true, false, true, chooseImports != null ? (openChoices, ranges) -> {
                ArrayList<ImportSelection> selections = new ArrayList<ImportSelection>();
                int i = 0;
                while (i < openChoices.length) {
                    ImportCandidate[] candidates = (ImportCandidate[])Stream.of(openChoices[i]).map(choice -> new ImportCandidate((TypeNameMatch)choice)).toArray(ImportCandidate[]::new);
                    Range range = null;
                    try {
                        range = JDTUtils.toRange((IOpenable)unit, ranges[i].getOffset(), ranges[i].getLength());
                    }
                    catch (JavaModelException e) {
                        range = JDTUtils.newRange();
                    }
                    selections.add(new ImportSelection(candidates, range));
                    ++i;
                }
                ImportCandidate[] chosens = (ImportCandidate[])chooseImports.apply(selections.toArray(new ImportSelection[0]));
                if (chosens == null) {
                    return null;
                }
                HashMap typeMaps = new HashMap();
                Stream.of(openChoices).flatMap(x -> Arrays.stream(x)).forEach(x -> typeMaps.put(x.getFullyQualifiedName() + "@" + x.hashCode(), x));
                return (TypeNameMatch[])Stream.of(chosens).filter(chosen -> chosen != null && typeMaps.containsKey(chosen.id)).map(chosen -> (TypeNameMatch)typeMaps.get(chosen.id)).toArray(TypeNameMatch[]::new);
            } : null, restoreExistingImports);
            JobHelpers.waitForJobs("DocumentLifeCycleJobs", monitor);
            edit = op.createTextEdit(null);
            if (!(edit instanceof MultiTextEdit) || edit.getOffset() != 0 || edit.getLength() != 0 || ((MultiTextEdit)edit).getChildrenSize() != 0) break block5;
            return null;
        }
        try {
            return edit;
        }
        catch (CoreException | OperationCanceledException e) {
            JavaLanguageServerPlugin.logException("Failed to resolve organize imports source action", e);
            return null;
        }
    }

    public static WorkspaceEdit organizeImports(JavaClientConnection connection, CodeActionParams params, IProgressMonitor monitor) {
        String uri = params.getTextDocument().getUri();
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (unit == null) {
            return null;
        }
        TextEdit edit = OrganizeImportsHandler.organizeImports(unit, OrganizeImportsHandler.getChooseImportsFunction(uri, false), false, monitor);
        return SourceAssistProcessor.convertToWorkspaceEdit(unit, edit);
    }

    public static Function<ImportSelection[], ImportCandidate[]> getChooseImportsFunction(String documentUri, boolean restoreExistingImports) {
        return selections -> {
            Object commandResult = JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isExecuteClientCommandSupport() ? JavaLanguageServerPlugin.getInstance().getClientConnection().executeClientCommand(CLIENT_COMMAND_ID_CHOOSEIMPORTS, documentUri, selections, restoreExistingImports) : null;
            String json = commandResult == null ? null : new Gson().toJson(commandResult);
            return JSONUtility.toModel(json, ImportCandidate[].class);
        };
    }

    public static CUCorrectionProposalCore getOrganizeImportsProposal(String label, final ICompilationUnit cu, int relevance, CompilationUnit astRoot, final boolean supportsChooseImports, final boolean restoreExistingImports) {
        IResource resource = cu.getResource();
        if (resource == null) {
            return null;
        }
        final URI uri = resource.getLocationURI();
        if (uri == null) {
            return null;
        }
        return new CUCorrectionProposalCore(label, cu, null, relevance){

            public void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
                TextEdit edit = OrganizeImportsHandler.organizeImports(cu, supportsChooseImports ? OrganizeImportsHandler.getChooseImportsFunction(uri.toString(), restoreExistingImports) : null, restoreExistingImports, (IProgressMonitor)new NullProgressMonitor());
                if (edit != null) {
                    editRoot.addChild(edit);
                }
            }
        };
    }

    public static class ImportCandidate {
        public String fullyQualifiedName;
        public String id;

        public ImportCandidate() {
        }

        public ImportCandidate(TypeNameMatch typeMatch) {
            this.fullyQualifiedName = typeMatch.getFullyQualifiedName();
            this.id = typeMatch.getFullyQualifiedName() + "@" + typeMatch.hashCode();
        }
    }

    public static class ImportSelection {
        public ImportCandidate[] candidates;
        public Range range;

        public ImportSelection(ImportCandidate[] candidates, Range range) {
            this.candidates = candidates;
            this.range = range;
        }
    }
}

