"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_filesystem_lib_browser_breadcrumbs_filepath-breadcrumbs-contributi-e72399"],{

/***/ "../../node_modules/@theia/core/lib/common/selection-command-handler.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/common/selection-command-handler.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SelectionCommandHandler = void 0;
class SelectionCommandHandler {
    constructor(selectionService, toSelection, options) {
        this.selectionService = selectionService;
        this.toSelection = toSelection;
        this.options = options;
    }
    execute(...args) {
        const selection = this.getSelection(...args);
        return selection ? this.options.execute(selection, ...args) : undefined;
    }
    isVisible(...args) {
        const selection = this.getSelection(...args);
        return !!selection && (!this.options.isVisible || this.options.isVisible(selection, ...args));
    }
    isEnabled(...args) {
        const selection = this.getSelection(...args);
        return !!selection && (!this.options.isEnabled || this.options.isEnabled(selection, ...args));
    }
    isMulti() {
        return this.options && !!this.options.multi;
    }
    getSelection(...args) {
        const givenSelection = args.length && this.toSelection(args[0]);
        if (givenSelection) {
            return this.isMulti() ? [givenSelection] : givenSelection;
        }
        const globalSelection = this.getSingleSelection(this.selectionService.selection);
        if (this.isMulti()) {
            return this.getMultiSelection(globalSelection);
        }
        return this.getSingleSelection(globalSelection);
    }
    getSingleSelection(arg) {
        let selection = this.toSelection(arg);
        if (selection) {
            return selection;
        }
        if (Array.isArray(arg)) {
            for (const element of arg) {
                selection = this.toSelection(element);
                if (selection) {
                    return selection;
                }
            }
        }
        return undefined;
    }
    getMultiSelection(arg) {
        let selection = this.toSelection(arg);
        if (selection) {
            return [selection];
        }
        const result = [];
        if (Array.isArray(arg)) {
            for (const element of arg) {
                selection = this.toSelection(element);
                if (selection) {
                    result.push(selection);
                }
            }
        }
        return result.length ? result : undefined;
    }
}
exports.SelectionCommandHandler = SelectionCommandHandler;


/***/ }),

/***/ "../../node_modules/@theia/filesystem/lib/browser/breadcrumbs/filepath-breadcrumb.js":
/*!*******************************************************************************************!*\
  !*** ../../node_modules/@theia/filesystem/lib/browser/breadcrumbs/filepath-breadcrumb.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FilepathBreadcrumb = void 0;
const filepath_breadcrumbs_contribution_1 = __webpack_require__(/*! ./filepath-breadcrumbs-contribution */ "../../node_modules/@theia/filesystem/lib/browser/breadcrumbs/filepath-breadcrumbs-contribution.js");
class FilepathBreadcrumb {
    constructor(uri, label, longLabel, iconClass, containerClass) {
        this.uri = uri;
        this.label = label;
        this.longLabel = longLabel;
        this.iconClass = iconClass;
        this.containerClass = containerClass;
    }
    get id() {
        return this.type.toString() + '_' + this.uri.toString();
    }
    get type() {
        return filepath_breadcrumbs_contribution_1.FilepathBreadcrumbType;
    }
}
exports.FilepathBreadcrumb = FilepathBreadcrumb;
(function (FilepathBreadcrumb) {
    function is(breadcrumb) {
        return 'uri' in breadcrumb;
    }
    FilepathBreadcrumb.is = is;
})(FilepathBreadcrumb || (exports.FilepathBreadcrumb = FilepathBreadcrumb = {}));


/***/ }),

/***/ "../../node_modules/@theia/filesystem/lib/browser/breadcrumbs/filepath-breadcrumbs-container.js":
/*!******************************************************************************************************!*\
  !*** ../../node_modules/@theia/filesystem/lib/browser/breadcrumbs/filepath-breadcrumbs-container.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BreadcrumbsFileTreeWidget = exports.createFileTreeBreadcrumbsWidget = exports.createFileTreeBreadcrumbsContainer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const file_tree_1 = __webpack_require__(/*! ../file-tree */ "../../node_modules/@theia/filesystem/lib/browser/file-tree/index.js");
const BREADCRUMBS_FILETREE_CLASS = 'theia-FilepathBreadcrumbFileTree';
function createFileTreeBreadcrumbsContainer(parent) {
    const child = (0, file_tree_1.createFileTreeContainer)(parent);
    child.unbind(file_tree_1.FileTreeWidget);
    child.rebind(browser_1.TreeProps).toConstantValue({ ...browser_1.defaultTreeProps, virtualized: false });
    child.bind(BreadcrumbsFileTreeWidget).toSelf();
    return child;
}
exports.createFileTreeBreadcrumbsContainer = createFileTreeBreadcrumbsContainer;
function createFileTreeBreadcrumbsWidget(parent) {
    return createFileTreeBreadcrumbsContainer(parent).get(BreadcrumbsFileTreeWidget);
}
exports.createFileTreeBreadcrumbsWidget = createFileTreeBreadcrumbsWidget;
let BreadcrumbsFileTreeWidget = class BreadcrumbsFileTreeWidget extends file_tree_1.FileTreeWidget {
    constructor(props, model, contextMenuRenderer) {
        super(props, model, contextMenuRenderer);
        this.model = model;
        this.addClass(BREADCRUMBS_FILETREE_CLASS);
    }
    createNodeAttributes(node, props) {
        const elementAttrs = super.createNodeAttributes(node, props);
        return {
            ...elementAttrs,
            draggable: false
        };
    }
    tapNode(node) {
        if (file_tree_1.FileStatNode.is(node) && !node.fileStat.isDirectory) {
            (0, browser_1.open)(this.openerService, node.uri, { preview: true });
        }
        else {
            super.tapNode(node);
        }
    }
};
exports.BreadcrumbsFileTreeWidget = BreadcrumbsFileTreeWidget;
exports.BreadcrumbsFileTreeWidget = BreadcrumbsFileTreeWidget = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__param(0, (0, inversify_1.inject)(browser_1.TreeProps)),
    tslib_1.__param(1, (0, inversify_1.inject)(file_tree_1.FileTreeModel)),
    tslib_1.__param(2, (0, inversify_1.inject)(browser_1.ContextMenuRenderer)),
    tslib_1.__metadata("design:paramtypes", [Object, file_tree_1.FileTreeModel,
        browser_1.ContextMenuRenderer])
], BreadcrumbsFileTreeWidget);


/***/ }),

/***/ "../../node_modules/@theia/filesystem/lib/browser/breadcrumbs/filepath-breadcrumbs-contribution.js":
/*!*********************************************************************************************************!*\
  !*** ../../node_modules/@theia/filesystem/lib/browser/breadcrumbs/filepath-breadcrumbs-contribution.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FilepathBreadcrumbsContribution = exports.FilepathBreadcrumbType = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const filepath_breadcrumb_1 = __webpack_require__(/*! ./filepath-breadcrumb */ "../../node_modules/@theia/filesystem/lib/browser/breadcrumbs/filepath-breadcrumb.js");
const filepath_breadcrumbs_container_1 = __webpack_require__(/*! ./filepath-breadcrumbs-container */ "../../node_modules/@theia/filesystem/lib/browser/breadcrumbs/filepath-breadcrumbs-container.js");
const file_tree_1 = __webpack_require__(/*! ../file-tree */ "../../node_modules/@theia/filesystem/lib/browser/file-tree/index.js");
const file_service_1 = __webpack_require__(/*! ../file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
exports.FilepathBreadcrumbType = Symbol('FilepathBreadcrumb');
let FilepathBreadcrumbsContribution = class FilepathBreadcrumbsContribution {
    constructor() {
        this.onDidChangeBreadcrumbsEmitter = new core_1.Emitter();
        this.type = exports.FilepathBreadcrumbType;
        this.priority = 100;
    }
    get onDidChangeBreadcrumbs() {
        return this.onDidChangeBreadcrumbsEmitter.event;
    }
    async computeBreadcrumbs(uri) {
        if (uri.scheme !== 'file') {
            return [];
        }
        const getContainerClass = this.getContainerClassCreator(uri);
        const getIconClass = this.getIconClassCreator(uri);
        return uri.allLocations
            .map((location, index) => {
            const icon = getIconClass(location, index);
            const containerClass = getContainerClass(location, index);
            return new filepath_breadcrumb_1.FilepathBreadcrumb(location, this.labelProvider.getName(location), this.labelProvider.getLongName(location), icon, containerClass);
        })
            .filter(b => this.filterBreadcrumbs(uri, b))
            .reverse();
    }
    getContainerClassCreator(fileURI) {
        return (location, index) => location.isEqual(fileURI) ? 'file' : 'folder';
    }
    getIconClassCreator(fileURI) {
        return (location, index) => location.isEqual(fileURI) ? this.labelProvider.getIcon(location) + ' file-icon' : '';
    }
    filterBreadcrumbs(_, breadcrumb) {
        return !breadcrumb.uri.path.isRoot;
    }
    async attachPopupContent(breadcrumb, parent) {
        if (!filepath_breadcrumb_1.FilepathBreadcrumb.is(breadcrumb)) {
            return undefined;
        }
        const folderFileStat = await this.fileSystem.resolve(breadcrumb.uri.parent);
        if (folderFileStat) {
            const rootNode = await this.createRootNode(folderFileStat);
            if (rootNode) {
                const { model } = this.breadcrumbsFileTreeWidget;
                await model.navigateTo({ ...rootNode, visible: false });
                browser_1.Widget.attach(this.breadcrumbsFileTreeWidget, parent);
                const toDisposeOnTreePopulated = model.onChanged(() => {
                    if (browser_1.CompositeTreeNode.is(model.root) && model.root.children.length > 0) {
                        toDisposeOnTreePopulated.dispose();
                        const targetNode = model.getNode(breadcrumb.uri.path.toString());
                        if (targetNode && browser_1.SelectableTreeNode.is(targetNode)) {
                            model.selectNode(targetNode);
                        }
                        this.breadcrumbsFileTreeWidget.activate();
                    }
                });
                return {
                    dispose: () => {
                        // Clear model otherwise the next time a popup is opened the old model is rendered first
                        // and is shown for a short time period.
                        toDisposeOnTreePopulated.dispose();
                        this.breadcrumbsFileTreeWidget.model.root = undefined;
                        browser_1.Widget.detach(this.breadcrumbsFileTreeWidget);
                    }
                };
            }
        }
    }
    async createRootNode(folderToOpen) {
        const folderUri = folderToOpen.resource;
        const rootUri = folderToOpen.isDirectory ? folderUri : folderUri.parent;
        const rootStat = await this.fileSystem.resolve(rootUri);
        if (rootStat) {
            return file_tree_1.DirNode.createRoot(rootStat);
        }
    }
};
exports.FilepathBreadcrumbsContribution = FilepathBreadcrumbsContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.LabelProvider),
    tslib_1.__metadata("design:type", browser_1.LabelProvider)
], FilepathBreadcrumbsContribution.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], FilepathBreadcrumbsContribution.prototype, "fileSystem", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(filepath_breadcrumbs_container_1.BreadcrumbsFileTreeWidget),
    tslib_1.__metadata("design:type", filepath_breadcrumbs_container_1.BreadcrumbsFileTreeWidget)
], FilepathBreadcrumbsContribution.prototype, "breadcrumbsFileTreeWidget", void 0);
exports.FilepathBreadcrumbsContribution = FilepathBreadcrumbsContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], FilepathBreadcrumbsContribution);


/***/ }),

/***/ "../../node_modules/@theia/filesystem/lib/browser/file-selection.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@theia/filesystem/lib/browser/file-selection.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileSelection = void 0;
const selection_command_handler_1 = __webpack_require__(/*! @theia/core/lib/common/selection-command-handler */ "../../node_modules/@theia/core/lib/common/selection-command-handler.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const files_1 = __webpack_require__(/*! ../common/files */ "../../node_modules/@theia/filesystem/lib/common/files.js");
var FileSelection;
(function (FileSelection) {
    function is(arg) {
        return (0, common_1.isObject)(arg) && files_1.FileStat.is(arg.fileStat);
    }
    FileSelection.is = is;
    class CommandHandler extends selection_command_handler_1.SelectionCommandHandler {
        constructor(selectionService, options) {
            super(selectionService, arg => FileSelection.is(arg) ? arg : undefined, options);
            this.selectionService = selectionService;
            this.options = options;
        }
    }
    FileSelection.CommandHandler = CommandHandler;
})(FileSelection || (exports.FileSelection = FileSelection = {}));


/***/ }),

/***/ "../../node_modules/@theia/filesystem/lib/browser/filesystem-frontend-contribution.js":
/*!********************************************************************************************!*\
  !*** ../../node_modules/@theia/filesystem/lib/browser/filesystem-frontend-contribution.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileSystemFrontendContribution = exports.FileSystemCommands = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const mime_service_1 = __webpack_require__(/*! @theia/core/lib/browser/mime-service */ "../../node_modules/@theia/core/lib/browser/mime-service.js");
const tree_widget_selection_1 = __webpack_require__(/*! @theia/core/lib/browser/tree/tree-widget-selection */ "../../node_modules/@theia/core/lib/browser/tree/tree-widget-selection.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const command_1 = __webpack_require__(/*! @theia/core/lib/common/command */ "../../node_modules/@theia/core/lib/common/command.js");
const promise_util_1 = __webpack_require__(/*! @theia/core/lib/common/promise-util */ "../../node_modules/@theia/core/lib/common/promise-util.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const environment_1 = __webpack_require__(/*! @theia/core/shared/@theia/application-package/lib/environment */ "../../node_modules/@theia/core/shared/@theia/application-package/lib/environment/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const user_working_directory_provider_1 = __webpack_require__(/*! @theia/core/lib/browser/user-working-directory-provider */ "../../node_modules/@theia/core/lib/browser/user-working-directory-provider.js");
const file_dialog_1 = __webpack_require__(/*! ./file-dialog */ "../../node_modules/@theia/filesystem/lib/browser/file-dialog/index.js");
const file_selection_1 = __webpack_require__(/*! ./file-selection */ "../../node_modules/@theia/filesystem/lib/browser/file-selection.js");
const file_service_1 = __webpack_require__(/*! ./file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const file_upload_service_1 = __webpack_require__(/*! ./file-upload-service */ "../../node_modules/@theia/filesystem/lib/browser/file-upload-service.js");
const filesystem_preferences_1 = __webpack_require__(/*! ./filesystem-preferences */ "../../node_modules/@theia/filesystem/lib/browser/filesystem-preferences.js");
var FileSystemCommands;
(function (FileSystemCommands) {
    FileSystemCommands.UPLOAD = command_1.Command.toLocalizedCommand({
        id: 'file.upload',
        category: browser_1.CommonCommands.FILE_CATEGORY,
        label: 'Upload Files...'
    }, 'theia/filesystem/uploadFiles', browser_1.CommonCommands.FILE_CATEGORY_KEY);
})(FileSystemCommands || (exports.FileSystemCommands = FileSystemCommands = {}));
let FileSystemFrontendContribution = class FileSystemFrontendContribution {
    constructor() {
        this.onDidChangeEditorFileEmitter = new common_1.Emitter();
        this.onDidChangeEditorFile = this.onDidChangeEditorFileEmitter.event;
        this.userOperations = new Map();
        this.pendingOperation = Promise.resolve();
        this.moveSnapshots = new Map();
        this.deletedSuffix = `(${core_1.nls.localizeByDefault('Deleted')})`;
    }
    queueUserOperation(event) {
        const moveOperation = new promise_util_1.Deferred();
        this.userOperations.set(event.correlationId, moveOperation);
        this.run(() => moveOperation.promise);
    }
    resolveUserOperation(event) {
        const operation = this.userOperations.get(event.correlationId);
        if (operation) {
            this.userOperations.delete(event.correlationId);
            operation.resolve();
        }
    }
    initialize() {
        this.fileService.onDidFilesChange(event => this.run(() => this.updateWidgets(event)));
        this.fileService.onWillRunUserOperation(event => {
            this.queueUserOperation(event);
            event.waitUntil(this.runEach((uri, widget) => this.pushMove(uri, widget, event)));
        });
        this.fileService.onDidFailUserOperation(event => event.waitUntil((async () => {
            await this.runEach((uri, widget) => this.revertMove(uri, widget, event));
            this.resolveUserOperation(event);
        })()));
        this.fileService.onDidRunUserOperation(event => event.waitUntil((async () => {
            await this.runEach((uri, widget) => this.applyMove(uri, widget, event));
            this.resolveUserOperation(event);
        })()));
        this.uploadService.onDidUpload(files => {
            this.doHandleUpload(files);
        });
    }
    onStart(app) {
        this.updateAssociations();
        this.preferences.onPreferenceChanged(e => {
            if (e.preferenceName === 'files.associations') {
                this.updateAssociations();
            }
        });
    }
    registerCommands(commands) {
        commands.registerCommand(FileSystemCommands.UPLOAD, {
            isEnabled: (...args) => {
                const selection = this.getSelection(...args);
                return !!selection && !environment_1.environment.electron.is();
            },
            isVisible: () => !environment_1.environment.electron.is(),
            execute: (...args) => {
                const selection = this.getSelection(...args);
                if (selection) {
                    return this.upload(selection);
                }
            }
        });
        commands.registerCommand(browser_1.CommonCommands.NEW_FILE, {
            execute: (...args) => {
                this.handleNewFileCommand(args);
            }
        });
    }
    async upload(selection) {
        try {
            const source = tree_widget_selection_1.TreeWidgetSelection.getSource(this.selectionService.selection);
            const fileUploadResult = await this.uploadService.upload(selection.fileStat.isDirectory ? selection.fileStat.resource : selection.fileStat.resource.parent);
            if (browser_1.ExpandableTreeNode.is(selection) && source) {
                await source.model.expandNode(selection);
            }
            return fileUploadResult;
        }
        catch (e) {
            if (!(0, common_1.isCancelled)(e)) {
                console.error(e);
            }
        }
    }
    async doHandleUpload(uploads) {
        // Only handle single file uploads
        if (uploads.length === 1) {
            const uri = new uri_1.default(uploads[0]);
            // Close all existing widgets for this URI
            const widgets = this.shell.widgets.filter(widget => { var _a; return (_a = browser_1.NavigatableWidget.getUri(widget)) === null || _a === void 0 ? void 0 : _a.isEqual(uri); });
            await this.shell.closeMany(widgets, {
                // Don't ask to save the file if it's dirty
                // The user has already confirmed the file overwrite
                save: false
            });
            // Open a new editor for this URI
            (0, browser_1.open)(this.openerService, uri);
        }
    }
    /**
     * Opens a save dialog to create a new file.
     *
     * @param args The first argument is the name of the new file. The second argument is the parent directory URI.
     */
    async handleNewFileCommand(args) {
        const fileName = (args !== undefined && typeof args[0] === 'string') ? args[0] : undefined;
        const title = core_1.nls.localizeByDefault('Create File');
        const props = { title, saveLabel: title, inputValue: fileName };
        const dirUri = (args[1] instanceof uri_1.default) ? args[1] : await this.workingDirectory.getUserWorkingDir();
        const directory = await this.fileService.resolve(dirUri);
        const filePath = await this.fileDialogService.showSaveDialog(props, directory.isDirectory ? directory : undefined);
        if (filePath) {
            const file = await this.fileService.createFile(filePath);
            (0, browser_1.open)(this.openerService, file.resource);
        }
    }
    getSelection(...args) {
        var _a;
        const { selection } = this.selectionService;
        return (_a = this.toSelection(args[0])) !== null && _a !== void 0 ? _a : (Array.isArray(selection) ? selection.find(file_selection_1.FileSelection.is) : this.toSelection(selection));
    }
    ;
    toSelection(arg) {
        return file_selection_1.FileSelection.is(arg) ? arg : undefined;
    }
    run(operation) {
        return this.pendingOperation = this.pendingOperation.then(async () => {
            try {
                await operation();
            }
            catch (e) {
                console.error(e);
            }
        });
    }
    async runEach(participant) {
        const promises = [];
        for (const [resourceUri, widget] of browser_1.NavigatableWidget.get(this.shell.widgets)) {
            promises.push(participant(resourceUri, widget));
        }
        await Promise.all(promises);
    }
    popMoveSnapshot(resourceUri) {
        const snapshotKey = resourceUri.toString();
        const snapshot = this.moveSnapshots.get(snapshotKey);
        if (snapshot) {
            this.moveSnapshots.delete(snapshotKey);
        }
        return snapshot;
    }
    applyMoveSnapshot(widget, snapshot) {
        if (!snapshot) {
            return undefined;
        }
        if (snapshot.dirty) {
            const saveable = browser_1.Saveable.get(widget);
            if (saveable && saveable.applySnapshot) {
                saveable.applySnapshot(snapshot.dirty);
            }
        }
        if (snapshot.view && browser_1.StatefulWidget.is(widget)) {
            widget.restoreState(snapshot.view);
        }
    }
    async pushMove(resourceUri, widget, event) {
        const newResourceUri = this.createMoveToUri(resourceUri, widget, event);
        if (!newResourceUri) {
            return;
        }
        const snapshot = {};
        const saveable = browser_1.Saveable.get(widget);
        if (browser_1.StatefulWidget.is(widget)) {
            snapshot.view = widget.storeState();
        }
        if (saveable && saveable.dirty) {
            if (saveable.createSnapshot) {
                snapshot.dirty = saveable.createSnapshot();
            }
            if (saveable.revert) {
                await saveable.revert({ soft: true });
            }
        }
        this.moveSnapshots.set(newResourceUri.toString(), snapshot);
    }
    async revertMove(resourceUri, widget, event) {
        const newResourceUri = this.createMoveToUri(resourceUri, widget, event);
        if (!newResourceUri) {
            return;
        }
        const snapshot = this.popMoveSnapshot(newResourceUri);
        this.applyMoveSnapshot(widget, snapshot);
    }
    async applyMove(resourceUri, widget, event) {
        const newResourceUri = this.createMoveToUri(resourceUri, widget, event);
        if (!newResourceUri) {
            return;
        }
        const snapshot = this.popMoveSnapshot(newResourceUri);
        const description = this.widgetManager.getDescription(widget);
        if (!description) {
            return;
        }
        const { factoryId, options } = description;
        if (!browser_1.NavigatableWidgetOptions.is(options)) {
            return;
        }
        const newWidget = await this.widgetManager.getOrCreateWidget(factoryId, {
            ...options,
            uri: newResourceUri.toString()
        });
        this.applyMoveSnapshot(newWidget, snapshot);
        const area = this.shell.getAreaFor(widget) || 'main';
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        const pending = [this.shell.addWidget(newWidget, {
                area, ref: widget
            })];
        if (this.shell.activeWidget === widget) {
            pending.push(this.shell.activateWidget(newWidget.id));
        }
        else if (widget.isVisible) {
            pending.push(this.shell.revealWidget(newWidget.id));
        }
        pending.push(this.shell.closeWidget(widget.id, { save: false }));
        await Promise.all(pending);
    }
    createMoveToUri(resourceUri, widget, event) {
        var _a;
        if (event.operation !== 2 /* FileOperation.MOVE */) {
            return undefined;
        }
        const path = (_a = event.source) === null || _a === void 0 ? void 0 : _a.relative(resourceUri);
        const targetUri = path && event.target.resolve(path);
        return targetUri && widget.createMoveToUri(targetUri);
    }
    async updateWidgets(event) {
        if (!event.gotDeleted() && !event.gotAdded()) {
            return;
        }
        const dirty = new Set();
        const toClose = new Map();
        for (const [uri, widget] of browser_1.NavigatableWidget.get(this.shell.widgets)) {
            this.updateWidget(uri, widget, event, { dirty, toClose: toClose });
        }
        if (this.corePreferences['workbench.editor.closeOnFileDelete']) {
            const doClose = [];
            for (const [uri, widgets] of toClose.entries()) {
                if (!dirty.has(uri)) {
                    doClose.push(...widgets);
                }
            }
            await this.shell.closeMany(doClose);
        }
    }
    updateWidget(uri, widget, event, { dirty, toClose }) {
        const label = widget.title.label;
        const deleted = label.endsWith(this.deletedSuffix);
        if (event.contains(uri, 2 /* FileChangeType.DELETED */)) {
            const uriString = uri.toString();
            if (browser_1.Saveable.isDirty(widget)) {
                dirty.add(uriString);
            }
            if (!deleted) {
                widget.title.label += this.deletedSuffix;
                this.onDidChangeEditorFileEmitter.fire({ editor: widget, type: 2 /* FileChangeType.DELETED */ });
            }
            const widgets = toClose.get(uriString) || [];
            widgets.push(widget);
            toClose.set(uriString, widgets);
        }
        else if (event.contains(uri, 1 /* FileChangeType.ADDED */)) {
            if (deleted) {
                widget.title.label = widget.title.label.substring(0, label.length - this.deletedSuffix.length);
                this.onDidChangeEditorFileEmitter.fire({ editor: widget, type: 1 /* FileChangeType.ADDED */ });
            }
        }
    }
    updateAssociations() {
        const fileAssociations = this.preferences['files.associations'];
        const mimeAssociations = Object.keys(fileAssociations).map(filepattern => ({ id: fileAssociations[filepattern], filepattern }));
        this.mimeService.setAssociations(mimeAssociations);
    }
};
exports.FileSystemFrontendContribution = FileSystemFrontendContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ApplicationShell),
    tslib_1.__metadata("design:type", browser_1.ApplicationShell)
], FileSystemFrontendContribution.prototype, "shell", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.WidgetManager),
    tslib_1.__metadata("design:type", browser_1.WidgetManager)
], FileSystemFrontendContribution.prototype, "widgetManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(mime_service_1.MimeService),
    tslib_1.__metadata("design:type", mime_service_1.MimeService)
], FileSystemFrontendContribution.prototype, "mimeService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(filesystem_preferences_1.FileSystemPreferences),
    tslib_1.__metadata("design:type", Object)
], FileSystemFrontendContribution.prototype, "preferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.CorePreferences),
    tslib_1.__metadata("design:type", Object)
], FileSystemFrontendContribution.prototype, "corePreferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.SelectionService),
    tslib_1.__metadata("design:type", common_1.SelectionService)
], FileSystemFrontendContribution.prototype, "selectionService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_upload_service_1.FileUploadService),
    tslib_1.__metadata("design:type", file_upload_service_1.FileUploadService)
], FileSystemFrontendContribution.prototype, "uploadService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], FileSystemFrontendContribution.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_dialog_1.FileDialogService),
    tslib_1.__metadata("design:type", Object)
], FileSystemFrontendContribution.prototype, "fileDialogService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], FileSystemFrontendContribution.prototype, "openerService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(user_working_directory_provider_1.UserWorkingDirectoryProvider),
    tslib_1.__metadata("design:type", user_working_directory_provider_1.UserWorkingDirectoryProvider)
], FileSystemFrontendContribution.prototype, "workingDirectory", void 0);
exports.FileSystemFrontendContribution = FileSystemFrontendContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], FileSystemFrontendContribution);


/***/ }),

/***/ "../../node_modules/@theia/filesystem/lib/browser/filesystem-saveable-service.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@theia/filesystem/lib/browser/filesystem-saveable-service.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2022 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FilesystemSaveableService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const saveable_service_1 = __webpack_require__(/*! @theia/core/lib/browser/saveable-service */ "../../node_modules/@theia/core/lib/browser/saveable-service.js");
const file_service_1 = __webpack_require__(/*! ./file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const file_dialog_1 = __webpack_require__(/*! ./file-dialog */ "../../node_modules/@theia/filesystem/lib/browser/file-dialog/index.js");
const buffer_1 = __webpack_require__(/*! @theia/core/lib/common/buffer */ "../../node_modules/@theia/core/lib/common/buffer.js");
let FilesystemSaveableService = class FilesystemSaveableService extends saveable_service_1.SaveableService {
    /**
     * This method ensures a few things about `widget`:
     * - `widget.getResourceUri()` actually returns a URI.
     * - `widget.saveable.createSnapshot` or `widget.saveable.serialize` is defined.
     * - `widget.saveable.revert` is defined.
     */
    canSaveAs(widget) {
        return widget !== undefined
            && browser_1.Saveable.isSource(widget)
            && (typeof widget.saveable.createSnapshot === 'function' || typeof widget.saveable.serialize === 'function' || typeof widget.saveable.saveAs === 'function')
            && typeof widget.saveable.revert === 'function'
            && browser_1.Navigatable.is(widget)
            && widget.getResourceUri() !== undefined;
    }
    /**
     * Save `sourceWidget` to a new file picked by the user.
     */
    async saveAs(sourceWidget, options) {
        let exist = false;
        let overwrite = false;
        let selected;
        const canSave = this.canSaveNotSaveAs(sourceWidget);
        const uri = sourceWidget.getResourceUri();
        do {
            selected = await this.fileDialogService.showSaveDialog({
                title: browser_1.CommonCommands.SAVE_AS.label,
                filters: {},
                inputValue: uri.path.base
            });
            if (selected) {
                exist = await this.fileService.exists(selected);
                if (exist) {
                    overwrite = await this.confirmOverwrite(selected);
                }
            }
        } while ((selected && exist && !overwrite) || ((selected === null || selected === void 0 ? void 0 : selected.isEqual(uri)) && !canSave));
        if (selected && selected.isEqual(uri)) {
            return this.save(sourceWidget, options);
        }
        else if (selected) {
            try {
                await this.saveSnapshot(sourceWidget, selected, overwrite);
                return selected;
            }
            catch (e) {
                console.warn(e);
            }
        }
    }
    /**
     * Saves the current snapshot of the {@link sourceWidget} to the target file
     * and replaces the widget with a new one that contains the snapshot content
     *
     * @param sourceWidget widget to save as `target`.
     * @param target The new URI for the widget.
     * @param overwrite
     */
    async saveSnapshot(sourceWidget, target, overwrite) {
        var _a;
        const saveable = sourceWidget.saveable;
        if (saveable.saveAs) {
            // Some widgets have their own "Save As" implementation, such as the custom plugin editors
            await saveable.saveAs({
                target
            });
        }
        else {
            // Most other editors simply allow us to serialize the content and write it to the target file.
            let buffer;
            if (saveable.serialize) {
                buffer = await saveable.serialize();
            }
            else if (saveable.createSnapshot) {
                const snapshot = saveable.createSnapshot();
                const content = (_a = browser_1.Saveable.Snapshot.read(snapshot)) !== null && _a !== void 0 ? _a : '';
                buffer = buffer_1.BinaryBuffer.fromString(content);
            }
            else {
                throw new Error('Cannot save the widget as the saveable does not provide a snapshot or a serialize method.');
            }
            if (await this.fileService.exists(target)) {
                // Do not fire the `onDidCreate` event as the file already exists.
                await this.fileService.writeFile(target, buffer);
            }
            else {
                // Ensure to actually call `create` as that fires the `onDidCreate` event.
                await this.fileService.createFile(target, buffer, { overwrite });
            }
        }
        await saveable.revert();
        await (0, browser_1.open)(this.openerService, target, { widgetOptions: { ref: sourceWidget, mode: 'tab-replace' } });
    }
    async confirmOverwrite(uri) {
        // Electron already handles the confirmation so do not prompt again.
        if (this.isElectron()) {
            return true;
        }
        // Prompt users for confirmation before overwriting.
        const confirmed = await new browser_1.ConfirmDialog({
            title: core_1.nls.localizeByDefault('Overwrite'),
            msg: core_1.nls.localizeByDefault('{0} already exists. Are you sure you want to overwrite it?', this.labelProvider.getName(uri))
        }).open();
        return !!confirmed;
    }
    isElectron() {
        return core_1.environment.electron.is();
    }
};
exports.FilesystemSaveableService = FilesystemSaveableService;
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.MessageService),
    tslib_1.__metadata("design:type", core_1.MessageService)
], FilesystemSaveableService.prototype, "messageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], FilesystemSaveableService.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_dialog_1.FileDialogService),
    tslib_1.__metadata("design:type", Object)
], FilesystemSaveableService.prototype, "fileDialogService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], FilesystemSaveableService.prototype, "openerService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.LabelProvider),
    tslib_1.__metadata("design:type", browser_1.LabelProvider)
], FilesystemSaveableService.prototype, "labelProvider", void 0);
exports.FilesystemSaveableService = FilesystemSaveableService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], FilesystemSaveableService);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_filesystem_lib_browser_breadcrumbs_filepath-breadcrumbs-contributi-e72399.js.map