"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getGdbVersion = void 0;
/*********************************************************************
 * Copyright (c) 2022 Kichwa Coders Canada, Inc. and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
const child_process_1 = require("child_process");
const util_1 = require("util");
const createEnvValues_1 = require("./createEnvValues");
const parseGdbVersionOutput_1 = require("./parseGdbVersionOutput");
/**
 * This method actually launches 'gdb --version' to determine the version of
 * the GDB that is being used.
 *
 * @param gdbPath the path to the GDB executable to be called
 * @return the detected version of GDB at gdbPath
 */
function getGdbVersion(gdbPath, gdbCwd, environment) {
    return __awaiter(this, void 0, void 0, function* () {
        const gdbEnvironment = environment
            ? (0, createEnvValues_1.createEnvValues)(process.env, environment)
            : process.env;
        const { stdout, stderr } = yield (0, util_1.promisify)(child_process_1.execFile)(gdbPath, ['--version'], { cwd: gdbCwd, env: gdbEnvironment });
        const gdbVersion = (0, parseGdbVersionOutput_1.parseGdbVersionOutput)(stdout);
        if (!gdbVersion) {
            throw new Error(`Failed to get version number from GDB. GDB returned:\nstdout:\n${stdout}\nstderr:\n${stderr}`);
        }
        return gdbVersion;
    });
}
exports.getGdbVersion = getGdbVersion;
//# sourceMappingURL=getGdbVersion.js.map