"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_ai-openai_lib_browser_openai-frontend-module_js"],{

/***/ "../../node_modules/@theia/ai-core/lib/browser/ai-core-preferences.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/browser/ai-core-preferences.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getRequestSettingSpecificity = exports.bindAICorePreferences = exports.AICorePreferences = exports.aiCorePreferenceSchema = exports.PREFERENCE_NAME_REQUEST_SETTINGS = exports.PREFERENCE_NAME_PROMPT_TEMPLATES = exports.PREFERENCE_NAME_ENABLE_AI = exports.AI_CORE_PREFERENCES_TITLE = void 0;
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const injectable_preference_proxy_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences/injectable-preference-proxy */ "../../node_modules/@theia/core/lib/browser/preferences/injectable-preference-proxy.js");
exports.AI_CORE_PREFERENCES_TITLE = core_1.nls.localize('theia/ai/core/prefs/title', '✨ AI Features [Alpha]');
exports.PREFERENCE_NAME_ENABLE_AI = 'ai-features.AiEnable.enableAI';
exports.PREFERENCE_NAME_PROMPT_TEMPLATES = 'ai-features.promptTemplates.promptTemplatesFolder';
exports.PREFERENCE_NAME_REQUEST_SETTINGS = 'ai-features.modelSettings.requestSettings';
exports.aiCorePreferenceSchema = {
    type: 'object',
    properties: {
        [exports.PREFERENCE_NAME_ENABLE_AI]: {
            title: exports.AI_CORE_PREFERENCES_TITLE,
            markdownDescription: core_1.nls.localize('theia/ai/core/enableAI/mdDescription', '❗ This setting allows you to access the latest AI capabilities (Alpha version).\
            \n\
            Please note that these features are in an alpha phase, which means they may \
            undergo changes and will be further improved. It is important to be aware that these features may generate\
            continuous requests to the language models (LLMs) you provide access to. This might incur costs that you\
            need to monitor closely. By enabling this option, you acknowledge these risks.\
            \n\
            **Please note! The settings below in this section will only take effect\n\
            once the main feature setting is enabled. After enabling the feature, you need to configure at least one\
            LLM provider below. Also see [the documentation](https://theia-ide.org/docs/user_ai/)**.'),
            type: 'boolean',
            default: false,
        },
        [exports.PREFERENCE_NAME_PROMPT_TEMPLATES]: {
            title: exports.AI_CORE_PREFERENCES_TITLE,
            description: core_1.nls.localize('theia/ai/core/promptTemplates/description', 'Folder for storing customized prompt templates. If not customized the user config directory is used. Please consider to use a folder, which is\
            under version control to manage your variants of prompt templates.'),
            type: 'string',
            default: '',
            typeDetails: {
                isFilepath: true,
                selectionProps: {
                    openLabel: 'Select Folder',
                    canSelectFiles: false,
                    canSelectFolders: true,
                    canSelectMany: false
                }
            },
        },
        [exports.PREFERENCE_NAME_REQUEST_SETTINGS]: {
            title: core_1.nls.localize('theia/ai/core/requestSettings/title', 'Custom Request Settings'),
            markdownDescription: core_1.nls.localize('theia/ai/core/requestSettings/mdDescription', 'Allows specifying custom request settings for multiple models.\n\
            Each setting consists of:\n\
            - `scope`: Defines when the setting applies:\n\
              - `modelId` (optional): The model ID to match\n\
              - `providerId` (optional): The provider ID to match (e.g., huggingface, openai, ollama, llamafile)\n\
              - `agentId` (optional): The agent ID to match\n\
            - `requestSettings`: Model-specific settings as key-value pairs\n\
            - `clientSettings`: Client-side message handling settings:\n\
              - `keepToolCalls` (boolean): Whether to keep tool calls in the context\n\
              - `keepThinking` (boolean): Whether to keep thinking messages\n\
            Settings are matched based on specificity (agent: 100, model: 10, provider: 1 points).\n\
            Refer to [our documentation](https://theia-ide.org/docs/user_ai/#custom-request-settings) for more information.'),
            type: 'array',
            items: {
                type: 'object',
                properties: {
                    scope: {
                        type: 'object',
                        properties: {
                            modelId: {
                                type: 'string',
                                description: 'The (optional) model id'
                            },
                            providerId: {
                                type: 'string',
                                description: 'The (optional) provider id to apply the settings to.',
                            }, agentId: {
                                type: 'string',
                                description: 'The (optional) agent id to apply the settings to.',
                            },
                        }
                    },
                    requestSettings: {
                        type: 'object',
                        additionalProperties: true,
                        description: 'Settings for the specific model ID.',
                    },
                    clientSettings: {
                        type: 'object',
                        additionalProperties: false,
                        description: 'Client settings for how to handle messages that are send back to the llm.',
                        properties: {
                            keepToolCalls: {
                                type: 'boolean',
                                default: true,
                                description: 'If set to false, all tool request and tool responses will be filtered \
                                before sending the next user request in a multi-turn conversation.'
                            },
                            keepThinking: {
                                type: 'boolean',
                                default: true,
                                description: 'If set to false, all thinking output will be filtered before sending the next user request in a multi-turn conversation.'
                            }
                        }
                    },
                },
                additionalProperties: false
            },
            default: [],
        }
    }
};
exports.AICorePreferences = Symbol('AICorePreferences');
function bindAICorePreferences(bind) {
    bind(exports.AICorePreferences).toDynamicValue(ctx => {
        const factory = ctx.container.get(injectable_preference_proxy_1.PreferenceProxyFactory);
        return factory(exports.aiCorePreferenceSchema);
    }).inSingletonScope();
    bind(browser_1.PreferenceContribution).toConstantValue({ schema: exports.aiCorePreferenceSchema });
}
exports.bindAICorePreferences = bindAICorePreferences;
/**
 * Calculates the specificity score of a RequestSetting for a given scope.
 * The score is calculated based on matching criteria:
 * - Agent match: 100 points
 * - Model match: 10 points
 * - Provider match: 1 point
 *
 * @param setting RequestSetting object to check against
 * @param scope Optional scope object containing modelId, providerId, and agentId
 * @returns Specificity score (-1 for non-match, or sum of matching criteria points)
 */
const getRequestSettingSpecificity = (setting, scope) => {
    // If no scope is defined in the setting, return default specificity
    if (!setting.scope) {
        return 0;
    }
    // If no matching criteria are defined in the scope, return default specificity
    if (!setting.scope.modelId && !setting.scope.providerId && !setting.scope.agentId) {
        return 0;
    }
    // Check for explicit non-matches (return -1)
    if ((scope === null || scope === void 0 ? void 0 : scope.modelId) && setting.scope.modelId && setting.scope.modelId !== scope.modelId) {
        return -1;
    }
    if ((scope === null || scope === void 0 ? void 0 : scope.providerId) && setting.scope.providerId && setting.scope.providerId !== scope.providerId) {
        return -1;
    }
    if ((scope === null || scope === void 0 ? void 0 : scope.agentId) && setting.scope.agentId && setting.scope.agentId !== scope.agentId) {
        return -1;
    }
    let specificity = 0;
    // Check provider match (1 point)
    if ((scope === null || scope === void 0 ? void 0 : scope.providerId) && setting.scope.providerId === scope.providerId) {
        specificity += 1;
    }
    // Check model match (10 points)
    if ((scope === null || scope === void 0 ? void 0 : scope.modelId) && setting.scope.modelId === scope.modelId) {
        specificity += 10;
    }
    // Check agent match (100 points)
    if ((scope === null || scope === void 0 ? void 0 : scope.agentId) && setting.scope.agentId === scope.agentId) {
        specificity += 100;
    }
    return specificity;
};
exports.getRequestSettingSpecificity = getRequestSettingSpecificity;


/***/ }),

/***/ "../../node_modules/@theia/ai-openai/lib/browser/openai-frontend-application-contribution.js":
/*!***************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-openai/lib/browser/openai-frontend-application-contribution.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OpenAiFrontendApplicationContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! ../common */ "../../node_modules/@theia/ai-openai/lib/common/index.js");
const openai_preferences_1 = __webpack_require__(/*! ./openai-preferences */ "../../node_modules/@theia/ai-openai/lib/browser/openai-preferences.js");
const OPENAI_PROVIDER_ID = 'openai';
let OpenAiFrontendApplicationContribution = class OpenAiFrontendApplicationContribution {
    constructor() {
        this.prevModels = [];
        this.prevCustomModels = [];
    }
    onStart() {
        this.preferenceService.ready.then(() => {
            const apiKey = this.preferenceService.get(openai_preferences_1.API_KEY_PREF, undefined);
            this.manager.setApiKey(apiKey);
            const models = this.preferenceService.get(openai_preferences_1.MODELS_PREF, []);
            this.manager.createOrUpdateLanguageModels(...models.map(modelId => this.createOpenAIModelDescription(modelId)));
            this.prevModels = [...models];
            const customModels = this.preferenceService.get(openai_preferences_1.CUSTOM_ENDPOINTS_PREF, []);
            this.manager.createOrUpdateLanguageModels(...this.createCustomModelDescriptionsFromPreferences(customModels));
            this.prevCustomModels = [...customModels];
            this.preferenceService.onPreferenceChanged(event => {
                if (event.preferenceName === openai_preferences_1.API_KEY_PREF) {
                    this.manager.setApiKey(event.newValue);
                }
                else if (event.preferenceName === openai_preferences_1.MODELS_PREF) {
                    this.handleModelChanges(event.newValue);
                }
                else if (event.preferenceName === openai_preferences_1.CUSTOM_ENDPOINTS_PREF) {
                    this.handleCustomModelChanges(event.newValue);
                }
            });
        });
    }
    handleModelChanges(newModels) {
        const oldModels = new Set(this.prevModels);
        const updatedModels = new Set(newModels);
        const modelsToRemove = [...oldModels].filter(model => !updatedModels.has(model));
        const modelsToAdd = [...updatedModels].filter(model => !oldModels.has(model));
        this.manager.removeLanguageModels(...modelsToRemove.map(model => `openai/${model}`));
        this.manager.createOrUpdateLanguageModels(...modelsToAdd.map(modelId => this.createOpenAIModelDescription(modelId)));
        this.prevModels = newModels;
    }
    handleCustomModelChanges(newCustomModels) {
        const oldModels = this.createCustomModelDescriptionsFromPreferences(this.prevCustomModels);
        const newModels = this.createCustomModelDescriptionsFromPreferences(newCustomModels);
        const modelsToRemove = oldModels.filter(model => !newModels.some(newModel => newModel.id === model.id));
        const modelsToAddOrUpdate = newModels.filter(newModel => !oldModels.some(model => model.id === newModel.id &&
            model.model === newModel.model &&
            model.url === newModel.url &&
            model.apiKey === newModel.apiKey &&
            model.apiVersion === newModel.apiVersion &&
            model.developerMessageSettings === newModel.developerMessageSettings &&
            model.supportsStructuredOutput === newModel.supportsStructuredOutput &&
            model.enableStreaming === newModel.enableStreaming));
        this.manager.removeLanguageModels(...modelsToRemove.map(model => model.id));
        this.manager.createOrUpdateLanguageModels(...modelsToAddOrUpdate);
        this.prevCustomModels = [...newCustomModels];
    }
    createOpenAIModelDescription(modelId) {
        const id = `${OPENAI_PROVIDER_ID}/${modelId}`;
        return {
            id: id,
            model: modelId,
            apiKey: true,
            apiVersion: true,
            developerMessageSettings: openAIModelsNotSupportingDeveloperMessages.includes(modelId) ? 'user' : 'developer',
            enableStreaming: !openAIModelsWithDisabledStreaming.includes(modelId),
            supportsStructuredOutput: !openAIModelsWithoutStructuredOutput.includes(modelId)
        };
    }
    createCustomModelDescriptionsFromPreferences(preferences) {
        return preferences.reduce((acc, pref) => {
            var _a, _b, _c;
            if (!pref.model || !pref.url || typeof pref.model !== 'string' || typeof pref.url !== 'string') {
                return acc;
            }
            return [
                ...acc,
                {
                    id: pref.id && typeof pref.id === 'string' ? pref.id : pref.model,
                    model: pref.model,
                    url: pref.url,
                    apiKey: typeof pref.apiKey === 'string' || pref.apiKey === true ? pref.apiKey : undefined,
                    apiVersion: typeof pref.apiVersion === 'string' || pref.apiVersion === true ? pref.apiVersion : undefined,
                    developerMessageSettings: (_a = pref.developerMessageSettings) !== null && _a !== void 0 ? _a : 'developer',
                    supportsStructuredOutput: (_b = pref.supportsStructuredOutput) !== null && _b !== void 0 ? _b : true,
                    enableStreaming: (_c = pref.enableStreaming) !== null && _c !== void 0 ? _c : true
                }
            ];
        }, []);
    }
};
exports.OpenAiFrontendApplicationContribution = OpenAiFrontendApplicationContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], OpenAiFrontendApplicationContribution.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.OpenAiLanguageModelsManager),
    tslib_1.__metadata("design:type", Object)
], OpenAiFrontendApplicationContribution.prototype, "manager", void 0);
exports.OpenAiFrontendApplicationContribution = OpenAiFrontendApplicationContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], OpenAiFrontendApplicationContribution);
const openAIModelsWithDisabledStreaming = [];
const openAIModelsNotSupportingDeveloperMessages = ['o1-preview', 'o1-mini'];
const openAIModelsWithoutStructuredOutput = ['o1-preview', 'gpt-4-turbo', 'gpt-4', 'gpt-3.5-turbo', 'o1-mini', 'gpt-4o-2024-05-13'];


/***/ }),

/***/ "../../node_modules/@theia/ai-openai/lib/browser/openai-frontend-module.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-openai/lib/browser/openai-frontend-module.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const openai_preferences_1 = __webpack_require__(/*! ./openai-preferences */ "../../node_modules/@theia/ai-openai/lib/browser/openai-preferences.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const openai_frontend_application_contribution_1 = __webpack_require__(/*! ./openai-frontend-application-contribution */ "../../node_modules/@theia/ai-openai/lib/browser/openai-frontend-application-contribution.js");
const common_1 = __webpack_require__(/*! ../common */ "../../node_modules/@theia/ai-openai/lib/common/index.js");
exports["default"] = new inversify_1.ContainerModule(bind => {
    bind(browser_1.PreferenceContribution).toConstantValue({ schema: openai_preferences_1.OpenAiPreferencesSchema });
    bind(openai_frontend_application_contribution_1.OpenAiFrontendApplicationContribution).toSelf().inSingletonScope();
    bind(browser_1.FrontendApplicationContribution).toService(openai_frontend_application_contribution_1.OpenAiFrontendApplicationContribution);
    bind(common_1.OpenAiLanguageModelsManager).toDynamicValue(ctx => {
        const provider = ctx.container.get(browser_1.RemoteConnectionProvider);
        return provider.createProxy(common_1.OPENAI_LANGUAGE_MODELS_MANAGER_PATH);
    }).inSingletonScope();
});


/***/ }),

/***/ "../../node_modules/@theia/ai-openai/lib/browser/openai-preferences.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@theia/ai-openai/lib/browser/openai-preferences.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OpenAiPreferencesSchema = exports.CUSTOM_ENDPOINTS_PREF = exports.MODELS_PREF = exports.API_KEY_PREF = void 0;
const ai_core_preferences_1 = __webpack_require__(/*! @theia/ai-core/lib/browser/ai-core-preferences */ "../../node_modules/@theia/ai-core/lib/browser/ai-core-preferences.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
exports.API_KEY_PREF = 'ai-features.openAiOfficial.openAiApiKey';
exports.MODELS_PREF = 'ai-features.openAiOfficial.officialOpenAiModels';
exports.CUSTOM_ENDPOINTS_PREF = 'ai-features.openAiCustom.customOpenAiModels';
exports.OpenAiPreferencesSchema = {
    type: 'object',
    properties: {
        [exports.API_KEY_PREF]: {
            type: 'string',
            markdownDescription: core_1.nls.localize('theia/ai/openai/apiKey/mdDescription', 'Enter an API Key of your official OpenAI Account. **Please note:** By using this preference the Open AI API key will be stored in clear text \
on the machine running Theia. Use the environment variable `OPENAI_API_KEY` to set the key securely.'),
            title: ai_core_preferences_1.AI_CORE_PREFERENCES_TITLE,
        },
        [exports.MODELS_PREF]: {
            type: 'array',
            description: core_1.nls.localize('theia/ai/openai/models/description', 'Official OpenAI models to use'),
            title: ai_core_preferences_1.AI_CORE_PREFERENCES_TITLE,
            default: [
                'gpt-4o',
                'gpt-4.1',
                'gpt-4.1-nano',
                'gpt-4.1-mini',
                'gpt-4o-2024-11-20',
                'gpt-4o-2024-08-06',
                'gpt-4o-mini',
                'o3',
                'o3-mini',
                'o4-mini',
                'o4-mini-high',
                'gpt-4.5-preview'
            ],
            items: {
                type: 'string'
            }
        },
        [exports.CUSTOM_ENDPOINTS_PREF]: {
            type: 'array',
            title: ai_core_preferences_1.AI_CORE_PREFERENCES_TITLE,
            markdownDescription: core_1.nls.localize('theia/ai/openai/customEndpoints/mdDescription', 'Integrate custom models compatible with the OpenAI API, for example via `vllm`. The required attributes are `model` and `url`.\
            \n\
            Optionally, you can\
            \n\
            - specify a unique `id` to identify the custom model in the UI. If none is given `model` will be used as `id`.\
            \n\
            - provide an `apiKey` to access the API served at the given url. Use `true` to indicate the use of the global OpenAI API key.\
            \n\
            - provide an `apiVersion` to access the API served at the given url in Azure. Use `true` to indicate the use of the global OpenAI API version.\
            \n\
            - set `developerMessageSettings` to one of `user`, `system`, `developer`, `mergeWithFollowingUserMessage`, or `skip` to control how the developer message is\
            included (where `user`, `system`, and `developer` will be used as a role, `mergeWithFollowingUserMessage` will prefix the following user message with the system\
            message or convert the system message to user message if the next message is not a user message. `skip` will just remove the system message).\
            Defaulting to `developer`.\
            \n\
            - specify `supportsStructuredOutput: false` to indicate that structured output shall not be used.\
            \n\
            - specify `enableStreaming: false` to indicate that streaming shall not be used.\
            \n\
            Refer to [our documentation](https://theia-ide.org/docs/user_ai/#openai-compatible-models-eg-via-vllm) for more information.'),
            default: [],
            items: {
                type: 'object',
                properties: {
                    model: {
                        type: 'string',
                        title: core_1.nls.localize('theia/ai/openai/customEndpoints/modelId/title', 'Model ID')
                    },
                    url: {
                        type: 'string',
                        title: core_1.nls.localize('theia/ai/openai/customEndpoints/url/title', 'The Open AI API compatible endpoint where the model is hosted')
                    },
                    id: {
                        type: 'string',
                        title: core_1.nls.localize('theia/ai/openai/customEndpoints/id/title', 'A unique identifier which is used in the UI to identify the custom model'),
                    },
                    apiKey: {
                        type: ['string', 'boolean'],
                        title: core_1.nls.localize('theia/ai/openai/customEndpoints/apiKey/title', 'Either the key to access the API served at the given url or `true` to use the global OpenAI API key'),
                    },
                    apiVersion: {
                        type: ['string', 'boolean'],
                        title: core_1.nls.localize('theia/ai/openai/customEndpoints/apiVersion/title', 'Either the version to access the API served at the given url in Azure or `true` to use the global OpenAI API version'),
                    },
                    developerMessageSettings: {
                        type: 'string',
                        enum: ['user', 'system', 'developer', 'mergeWithFollowingUserMessage', 'skip'],
                        default: 'developer',
                        title: core_1.nls.localize('theia/ai/openai/customEndpoints/developerMessageSettings/title', 'Controls the handling of system messages: `user`, `system`, and `developer` will be used as a role, `mergeWithFollowingUserMessage` will prefix\
                         the following user message with the system message or convert the system message to user message if the next message is not a user message.\
                         `skip` will just remove the system message), defaulting to `developer`.')
                    },
                    supportsStructuredOutput: {
                        type: 'boolean',
                        title: core_1.nls.localize('theia/ai/openai/customEndpoints/supportsStructuredOutput/title', 'Indicates whether the model supports structured output. `true` by default.'),
                    },
                    enableStreaming: {
                        type: 'boolean',
                        title: core_1.nls.localize('theia/ai/openai/customEndpoints/enableStreaming/title', 'Indicates whether the streaming API shall be used. `true` by default.'),
                    }
                }
            }
        }
    }
};


/***/ }),

/***/ "../../node_modules/@theia/ai-openai/lib/common/index.js":
/*!***************************************************************!*\
  !*** ../../node_modules/@theia/ai-openai/lib/common/index.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
tslib_1.__exportStar(__webpack_require__(/*! ./openai-language-models-manager */ "../../node_modules/@theia/ai-openai/lib/common/openai-language-models-manager.js"), exports);


/***/ }),

/***/ "../../node_modules/@theia/ai-openai/lib/common/openai-language-models-manager.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-openai/lib/common/openai-language-models-manager.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OpenAiLanguageModelsManager = exports.OPENAI_LANGUAGE_MODELS_MANAGER_PATH = void 0;
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
exports.OPENAI_LANGUAGE_MODELS_MANAGER_PATH = '/services/open-ai/language-model-manager';
exports.OpenAiLanguageModelsManager = Symbol('OpenAiLanguageModelsManager');


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_ai-openai_lib_browser_openai-frontend-module_js.js.map