/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.test.lib.JDKToolLauncher;
import jdk.test.lib.Platform;
import jdk.test.lib.process.OutputAnalyzer;
import jdk.test.lib.process.ProcessTools;

public class SecurityTools {
    public static final String RESPONSE_FILE = "security_tools_response.txt";

    private SecurityTools() {
    }

    public static ProcessBuilder getProcessBuilder(String tool, List<String> args) {
        JDKToolLauncher launcher = JDKToolLauncher.createUsingTestJDK(tool).addVMArg("-Duser.language=en").addVMArg("-Duser.country=US");
        for (String arg : args) {
            if (arg.startsWith("-J")) {
                launcher.addVMArg(arg.substring(2));
                continue;
            }
            if (Platform.isWindows() && arg.isEmpty()) {
                launcher.addToolArg("\"\"");
                continue;
            }
            if (arg.length() > 1 && arg.charAt(0) == '$') {
                launcher.addToolArg(System.getProperty(arg.substring(1)));
                continue;
            }
            launcher.addToolArg(arg);
        }
        return new ProcessBuilder(launcher.getCommand());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputAnalyzer keytool(List<String> args) throws Exception {
        ProcessBuilder pb = SecurityTools.getProcessBuilder("keytool", args);
        Path p = Paths.get(RESPONSE_FILE, new String[0]);
        if (!Files.exists(p, new LinkOption[0])) {
            Files.createFile(p, new FileAttribute[0]);
        }
        pb.redirectInput(ProcessBuilder.Redirect.from(new File(RESPONSE_FILE)));
        try {
            OutputAnalyzer outputAnalyzer = SecurityTools.execute(pb);
            return outputAnalyzer;
        }
        finally {
            Files.delete(p);
        }
    }

    public static OutputAnalyzer keytool(String args) throws Exception {
        return SecurityTools.keytool(SecurityTools.makeList(args));
    }

    public static OutputAnalyzer keytool(String ... args) throws Exception {
        return SecurityTools.keytool(List.of(args));
    }

    public static void setResponse(String ... responses) throws IOException {
        String text = responses.length > 0 ? Stream.of(responses).collect(Collectors.joining("\n", "", "\n")) : "";
        Files.write(Paths.get(RESPONSE_FILE, new String[0]), text.getBytes(), new OpenOption[0]);
    }

    public static OutputAnalyzer jarsigner(List<String> args) throws Exception {
        return SecurityTools.execute(SecurityTools.getProcessBuilder("jarsigner", args));
    }

    private static OutputAnalyzer execute(ProcessBuilder pb) throws Exception {
        try {
            OutputAnalyzer oa = ProcessTools.executeCommand(pb);
            System.out.println("Exit value: " + oa.getExitValue());
            return oa;
        }
        catch (Throwable t) {
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception(t);
        }
    }

    public static OutputAnalyzer jarsigner(String args) throws Exception {
        return SecurityTools.jarsigner(SecurityTools.makeList(args));
    }

    public static OutputAnalyzer jarsigner(String ... args) throws Exception {
        return SecurityTools.jarsigner(List.of(args));
    }

    public static OutputAnalyzer ktab(String args) throws Exception {
        return SecurityTools.execute(SecurityTools.getProcessBuilder("ktab", SecurityTools.makeList(args)));
    }

    public static OutputAnalyzer klist(String args) throws Exception {
        return SecurityTools.execute(SecurityTools.getProcessBuilder("klist", SecurityTools.makeList(args)));
    }

    public static OutputAnalyzer kinit(String args) throws Exception {
        return SecurityTools.execute(SecurityTools.getProcessBuilder("kinit", SecurityTools.makeList(args)));
    }

    public static OutputAnalyzer jar(List<String> args) throws Exception {
        return SecurityTools.execute(SecurityTools.getProcessBuilder("jar", args));
    }

    public static OutputAnalyzer jar(String args) throws Exception {
        return SecurityTools.jar(SecurityTools.makeList(args));
    }

    public static OutputAnalyzer jar(String ... args) throws Exception {
        return SecurityTools.jar(List.of(args));
    }

    public static List<String> makeList(String line) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean inBackTick = false;
        for (char c : line.toCharArray()) {
            if (inBackTick) {
                if (c == '`') {
                    result.add(sb.toString());
                    sb.setLength(0);
                    inBackTick = false;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (sb.length() == 0 && c == '`') {
                inBackTick = true;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (sb.length() == 0) continue;
                result.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() != 0) {
            result.add(sb.toString());
        }
        return result;
    }

    public static class TemporaryKeychain
    implements Closeable {
        private final String newChain;
        private final List<String> oldChains;

        public TemporaryKeychain(String name) {
            Path p = Path.of(name + ".keychain-db", new String[0]);
            this.newChain = p.toAbsolutePath().toString();
            try {
                this.oldChains = ProcessTools.executeProcess("security", "list-keychains").shouldHaveExitValue(0).getStdout().lines().map(String::trim).map(x -> x.startsWith("\"") ? x.substring(1, x.length() - 1) : x).collect(Collectors.toList());
                if (!Files.exists(p, new LinkOption[0])) {
                    ProcessTools.executeProcess("security", "create-keychain", "-p", "changeit", this.newChain).shouldHaveExitValue(0);
                }
                ProcessTools.executeProcess("security", "unlock-keychain", "-p", "changeit", this.newChain).shouldHaveExitValue(0);
                ProcessTools.executeProcess("security", "list-keychains", "-s", this.newChain).shouldHaveExitValue(0);
            }
            catch (Throwable t) {
                if (t instanceof RuntimeException) {
                    RuntimeException re = (RuntimeException)t;
                    throw re;
                }
                throw new RuntimeException(t);
            }
        }

        public String chain() {
            return this.newChain;
        }

        @Override
        public void close() throws IOException {
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.addAll(List.of("security", "list-keychains", "-s"));
            cmds.addAll(this.oldChains);
            try {
                ProcessTools.executeProcess(cmds.toArray(new String[0])).shouldHaveExitValue(0);
            }
            catch (Throwable t) {
                if (t instanceof RuntimeException) {
                    RuntimeException re = (RuntimeException)t;
                    throw re;
                }
                throw new RuntimeException(t);
            }
        }
    }
}

