/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.elements.adapters.DefaultBreakpointsViewInput;
import org.eclipse.debug.internal.ui.model.elements.BreakpointManagerContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ViewerAdapterService;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.progress.WorkbenchJob;

public class BreakpointManagerProxy
extends AbstractModelProxy {
    private final BreakpointManagerContentProvider fProvider;
    private final DefaultBreakpointsViewInput fInput;
    private Job fFireModelChangedJob;
    private final List<DeltaInfo> fPendingDeltas = new LinkedList<DeltaInfo>();

    public BreakpointManagerProxy(Object input, IPresentationContext context) {
        DefaultBreakpointsViewInput bpmInput = null;
        BreakpointManagerContentProvider bpmProvider = null;
        if (input instanceof DefaultBreakpointsViewInput) {
            bpmInput = (DefaultBreakpointsViewInput)input;
            IElementContentProvider provider = ViewerAdapterService.getContentProvider(input);
            if (provider instanceof BreakpointManagerContentProvider) {
                bpmProvider = (BreakpointManagerContentProvider)provider;
            }
        }
        this.fInput = bpmInput;
        this.fProvider = bpmProvider;
    }

    @Override
    public void installed(Viewer viewer) {
        super.installed(viewer);
        if (this.fProvider != null) {
            this.fProvider.registerModelProxy(this.fInput, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.fProvider.unregisterModelProxy(this.fInput, this);
        BreakpointManagerProxy breakpointManagerProxy = this;
        synchronized (breakpointManagerProxy) {
            if (this.fFireModelChangedJob != null) {
                this.fFireModelChangedJob.cancel();
                this.fFireModelChangedJob = null;
            }
            this.fPendingDeltas.clear();
        }
        super.dispose();
    }

    public synchronized void postModelChanged(IModelDelta delta, boolean select) {
        if (this.isDisposed()) {
            return;
        }
        Control viewerControl = this.getViewer().getControl();
        if (viewerControl == null) {
            return;
        }
        if (select) {
            Iterator<DeltaInfo> itr = this.fPendingDeltas.iterator();
            while (itr.hasNext()) {
                if (!itr.next().fSelect) continue;
                itr.remove();
            }
        }
        this.fPendingDeltas.add(new DeltaInfo(select, delta));
        if (this.fFireModelChangedJob == null) {
            this.fFireModelChangedJob = new WorkbenchJob(viewerControl.getDisplay(), "Select Breakpoint Job"){
                {
                    this.setSystem(true);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    Object[] deltas;
                    BreakpointManagerProxy breakpointManagerProxy = BreakpointManagerProxy.this;
                    synchronized (breakpointManagerProxy) {
                        deltas = BreakpointManagerProxy.this.fPendingDeltas.toArray();
                        BreakpointManagerProxy.this.fPendingDeltas.clear();
                        BreakpointManagerProxy.this.fFireModelChangedJob = null;
                    }
                    Object[] objectArray = deltas;
                    int n = deltas.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object pendingDelta = objectArray[n2];
                        BreakpointManagerProxy.this.fireModelChanged(((DeltaInfo)pendingDelta).fDelta);
                        ++n2;
                    }
                    return Status.OK_STATUS;
                }
            };
            this.fFireModelChangedJob.schedule();
        }
    }

    private static class DeltaInfo {
        final boolean fSelect;
        final IModelDelta fDelta;

        DeltaInfo(boolean selectDelta, IModelDelta delta) {
            this.fSelect = selectDelta;
            this.fDelta = delta;
        }
    }
}

