/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.service.policy.ui;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.ws.internal.service.policy.ui.IConManager;
import org.eclipse.wst.ws.internal.service.policy.ui.ScrolledPageContent;
import org.eclipse.wst.ws.internal.service.policy.ui.WstSPUIPluginMessages;
import org.eclipse.wst.ws.service.policy.IDescriptor;
import org.eclipse.wst.ws.service.policy.IPolicyEnumerationList;
import org.eclipse.wst.ws.service.policy.IPolicyRelationship;
import org.eclipse.wst.ws.service.policy.IPolicyState;
import org.eclipse.wst.ws.service.policy.IPolicyStateEnum;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.IStateEnumerationItem;
import org.eclipse.wst.ws.service.policy.ServicePolicyPlatform;
import org.eclipse.wst.ws.service.policy.listeners.IPolicyChildChangeListener;
import org.eclipse.wst.ws.service.policy.listeners.IPolicyStateChangeListener;
import org.eclipse.wst.ws.service.policy.ui.IPolicyOperation;
import org.eclipse.wst.ws.service.policy.ui.ServicePolicyPlatformUI;
import org.eclipse.wst.ws.service.policy.ui.utils.ServiceUtils;
import org.osgi.framework.Bundle;

public class ServicePoliciesComposite
extends Composite
implements SelectionListener,
IPolicyChildChangeListener {
    private ScrolledComposite operationsScrolledComposite;
    private Composite operationsComposite;
    private IWorkbenchHelpSystem helpSystem;
    private Composite masterComposite;
    private Composite detailsComposite;
    private Tree masterPolicyTree;
    private Tree detailsPolicyTree;
    private Text text_DetailsPanel_description;
    private Text text_DetailsPanel_dependencies;
    private Label label_DetailsPanel_description;
    private Label label_detailsPanel_dependancies;
    private Hashtable<String, IStatus> allErrors;
    private IStatus error;
    private boolean bComplexOpCompleted = true;
    private List<ChildChangeEvent> listChildChangeEvents;
    private IConManager iconManager = new IConManager();
    private IProject project = null;
    private SelectionListener listener;
    private ExpandableComposite excomposite;
    private ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
    private ServicePolicyPlatformUI platformUI = ServicePolicyPlatformUI.getInstance();
    private IPolicyStateChangeListener stateChangeListener = new StateChangeListener();
    private boolean stateChangeEnabled = true;
    private HashSet<IServicePolicy> stateChangePolicySet = new HashSet();
    private List<IServicePolicy> lastSelectedSp = null;
    private String INFOPOP_SPPP_PAGE = "org.eclipse.wst.ws.service.policy.ui.SPPP0001";

    private ExpandableComposite createExpandableComposite(Composite parent, int nColumns) {
        ExpandableComposite excomposite = new ExpandableComposite(parent, 0, 18);
        excomposite.setExpanded(false);
        excomposite.setVisible(false);
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        excomposite.setLayoutData((Object)new GridData(4, 4, true, false, nColumns, 1));
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ServicePoliciesComposite.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        this.makeScrollableCompositeAware((Control)excomposite);
        return excomposite;
    }

    private void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite(control);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.adaptChild(control);
        }
    }

    private ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    private final void expandedStateChanged(ExpandableComposite expandable) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite((Control)expandable);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.reflow(true);
        }
    }

    private Composite createDetailsScrollPageContent(Composite parent) {
        int nColumns = 1;
        ScrolledPageContent pageContent = new ScrolledPageContent(parent);
        GridLayout pageContLayout = new GridLayout();
        pageContLayout.numColumns = nColumns;
        pageContLayout.marginHeight = 0;
        pageContLayout.marginWidth = 0;
        Composite composite = pageContent.getBody();
        composite.setLayout((Layout)pageContLayout);
        this.excomposite = this.createExpandableComposite(composite, nColumns);
        Composite inner = new Composite((Composite)this.excomposite, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        this.excomposite.setClient((Control)inner);
        this.detailsPolicyTree = new Tree(inner, 2050);
        this.detailsPolicyTree.addSelectionListener((SelectionListener)this);
        GridData detailsPrefTreeGD = new GridData(768);
        detailsPrefTreeGD.heightHint = 50;
        this.detailsPolicyTree.setLayoutData((Object)detailsPrefTreeGD);
        this.detailsPolicyTree.setToolTipText(WstSPUIPluginMessages.TOOLTIP_PSP_DETAILSTREE);
        this.makeScrollableCompositeAware((Control)this.detailsPolicyTree);
        this.createPolicyOperationsComposite(composite);
        Composite descriptionAndDetailsComposite = new Composite(composite, 0);
        descriptionAndDetailsComposite.setFont(composite.getFont());
        GridLayout layout = new GridLayout(nColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        descriptionAndDetailsComposite.setLayout((Layout)layout);
        GridData detailsGD4 = new GridData(4, 0x1000008, true, true);
        descriptionAndDetailsComposite.setLayoutData((Object)detailsGD4);
        this.makeScrollableCompositeAware((Control)descriptionAndDetailsComposite);
        this.label_DetailsPanel_description = new Label(descriptionAndDetailsComposite, 0);
        GridData detailsGD2 = new GridData(4, 0x1000008, true, true);
        this.label_DetailsPanel_description.setLayoutData((Object)detailsGD2);
        this.label_DetailsPanel_description.setText(WstSPUIPluginMessages.LABEL_SERVICEPOLICIES_DESCRIPTION);
        this.makeScrollableCompositeAware((Control)this.label_DetailsPanel_description);
        this.text_DetailsPanel_description = new Text(descriptionAndDetailsComposite, 2632);
        GridData detailsGD = new GridData(4, 0x1000008, true, true);
        detailsGD.heightHint = 75;
        detailsGD.widthHint = 220;
        this.text_DetailsPanel_description.setLayoutData((Object)detailsGD);
        this.text_DetailsPanel_description.setToolTipText(WstSPUIPluginMessages.TOOLTIP_PSP_DESCRIPTION);
        this.makeScrollableCompositeAware((Control)this.text_DetailsPanel_description);
        this.label_detailsPanel_dependancies = new Label(descriptionAndDetailsComposite, 0);
        GridData detailsGD3 = new GridData(4, 0x1000008, true, true);
        this.label_detailsPanel_dependancies.setLayoutData((Object)detailsGD3);
        this.makeScrollableCompositeAware((Control)this.label_detailsPanel_dependancies);
        this.label_detailsPanel_dependancies.setText(WstSPUIPluginMessages.LABEL_SERVICEPOLICIES_DEPENDENCIES);
        this.text_DetailsPanel_dependencies = new Text(descriptionAndDetailsComposite, 2632);
        this.text_DetailsPanel_dependencies.setToolTipText(WstSPUIPluginMessages.TOOLTIP_PSP_DEPENDENCIES);
        this.makeScrollableCompositeAware((Control)this.text_DetailsPanel_dependencies);
        composite.setLayout((Layout)pageContLayout);
        GridData dependenciesGD = new GridData(4, 0x1000008, true, true);
        dependenciesGD.heightHint = 75;
        dependenciesGD.widthHint = 220;
        this.text_DetailsPanel_dependencies.setLayoutData((Object)dependenciesGD);
        return pageContent;
    }

    private void createPolicyOperationsComposite(Composite parent) {
        this.operationsScrolledComposite = new ScrolledComposite(parent, 768);
        this.operationsScrolledComposite.setExpandHorizontal(true);
        this.operationsScrolledComposite.setExpandVertical(true);
        GridData operationsScrolledCompositeGD = new GridData(768);
        operationsScrolledCompositeGD.heightHint = 75;
        this.operationsScrolledComposite.setLayoutData((Object)operationsScrolledCompositeGD);
        this.operationsComposite = new Composite((Composite)this.operationsScrolledComposite, 0);
        this.operationsScrolledComposite.setContent((Control)this.operationsComposite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.operationsComposite.setLayout((Layout)layout);
        this.operationsScrolledComposite.setMinSize(this.operationsComposite.computeSize(400, 100));
        this.makeScrollableCompositeAware((Control)this.operationsScrolledComposite);
        this.makeScrollableCompositeAware((Control)this.operationsComposite);
    }

    public ServicePoliciesComposite(Composite parent, IProject project, SelectionListener listener) {
        super(parent, 0);
        this.project = project;
        this.listener = listener;
        this.allErrors = new Hashtable();
        this.helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        GridLayout parentLayout = new GridLayout();
        parentLayout.numColumns = 2;
        parentLayout.horizontalSpacing = 0;
        this.setLayout((Layout)parentLayout);
        this.setLayoutData(new GridData(1808));
        Label description = new Label((Composite)this, 0);
        description.setText(WstSPUIPluginMessages.LABEL_SERVICEPOLICIES_PAGE_DESCRIPTION);
        GridData descGD = new GridData(1, 128, false, false, 2, 1);
        description.setLayoutData((Object)descGD);
        this.masterComposite = new Composite((Composite)this, 0);
        GridLayout masterLayout = new GridLayout();
        masterLayout.numColumns = 1;
        masterLayout.horizontalSpacing = 0;
        this.masterComposite.setLayout((Layout)masterLayout);
        this.masterComposite.setLayoutData((Object)new GridData(1808));
        this.detailsComposite = new Composite((Composite)this, 0);
        GridLayout detailsLayout = new GridLayout();
        detailsLayout.numColumns = 1;
        detailsLayout.horizontalSpacing = 0;
        this.detailsComposite.setLayout((Layout)detailsLayout);
        this.detailsComposite.setLayoutData((Object)new GridData(1808));
        this.masterPolicyTree = new Tree(this.masterComposite, 2050);
        this.masterPolicyTree.setLayoutData((Object)new GridData(1808));
        this.masterPolicyTree.setToolTipText(WstSPUIPluginMessages.TOOLTIP_PSP_TREE);
        Composite othersComposite = this.createDetailsScrollPageContent(this.detailsComposite);
        GridData gridData = new GridData(4, 4, true, true);
        othersComposite.setLayoutData((Object)gridData);
        this.masterPolicyTree.addSelectionListener((SelectionListener)this);
        List<IServicePolicy> policyList = this.platform.getRootServicePolicies(null);
        policyList = ServiceUtils.sortList(policyList);
        for (IServicePolicy policy : policyList) {
            this.addPolicy(policy, (Widget)this.masterPolicyTree, true);
        }
        TreeItem[] treeItems = this.masterPolicyTree.getItems();
        if (treeItems.length > 0) {
            this.masterPolicyTree.setSelection(treeItems[0]);
            this.masterPolicyTree.notifyListeners(13, new Event());
        }
    }

    private void setImage(TreeItem ti, IServicePolicy sp, String[] iconOverlays) {
        Image i;
        Image image = i = sp.getChildren().size() == 0 ? this.iconManager.getIconOverlay(this.iconManager.getLeafBaseUrl(), iconOverlays) : this.iconManager.getIconOverlay(this.iconManager.getFolderBaseUrl(), iconOverlays);
        if (sp.getDescriptor() != null) {
            String iconPathBundleID = null;
            String iconPath = null;
            iconPathBundleID = sp.getDescriptor().getIconBundleId();
            iconPath = sp.getDescriptor().getIconPath();
            if (iconPathBundleID != null && iconPath != null && iconPathBundleID.length() > 0 && iconPath.length() > 0) {
                Bundle b = Platform.getBundle((String)iconPathBundleID);
                i = this.iconManager.getIconOverlay(FileLocator.find((Bundle)b, (IPath)new Path(iconPath), null).toString(), iconOverlays);
            }
        }
        ti.setImage(i);
        ti.notifyListeners(24, new Event());
    }

    private boolean is4thLevelOrHigherPolicy(IServicePolicy sp) {
        return sp.getParentPolicy() != null && sp.getParentPolicy().getParentPolicy() != null && sp.getParentPolicy().getParentPolicy().getParentPolicy() != null;
    }

    private boolean is3rdLevelPolInMasterTreeWithChildren(List<IServicePolicy> spListInMasterTree) {
        return spListInMasterTree.get(0).getParentPolicy() != null && spListInMasterTree.get(0).getParentPolicy().getParentPolicy() != null && spListInMasterTree.get(0).getChildren().size() > 0;
    }

    private void addPolicy(IServicePolicy sp, Widget parent, boolean addUpToLevel3Only) {
        sp.addPolicyChildChangeListener((IPolicyChildChangeListener)this);
        this.addStateListener(sp);
        if (addUpToLevel3Only && this.is4thLevelOrHigherPolicy(sp)) {
            return;
        }
        TreeItem ti = parent instanceof TreeItem ? new TreeItem((TreeItem)parent, 0) : new TreeItem((Tree)parent, 0);
        ti.setText(sp.getDescriptor().getLongName());
        ti.setData((Object)sp);
        this.setImage(ti, sp, this.getIconOverlayInfo(sp, false));
        List<IServicePolicy> childrenPolicyList = sp.getChildren();
        childrenPolicyList = ServiceUtils.sortList(childrenPolicyList);
        for (IServicePolicy policy : childrenPolicyList) {
            this.addPolicy(policy, (Widget)ti, addUpToLevel3Only);
        }
    }

    private String[] getIconOverlayInfo(IServicePolicy sp, boolean invalid) {
        IPolicyStateEnum polEnum;
        String[] overLays = new String[4];
        IPolicyState polState = this.project == null ? sp.getPolicyState() : sp.getPolicyState(this.project);
        IPolicyStateEnum iPolicyStateEnum = polEnum = this.project == null ? sp.getPolicyStateEnum() : sp.getPolicyStateEnum(this.project);
        if (!polState.isMutable()) {
            overLays[0] = this.iconManager.lock;
        }
        if (sp.getStatus() != null && sp.getStatus().getSeverity() == 4 || invalid) {
            overLays[1] = this.iconManager.invalid;
        }
        if (sp.getStatus() != null && sp.getStatus().getSeverity() == 2) {
            overLays[2] = this.iconManager.warning;
        }
        if (polEnum != null && polEnum.getEnumId().equals("org.eclipse.wst.service.policy.booleanEnum") && this.policyHasIconSelectionOperationSelected(sp)) {
            overLays[3] = this.iconManager.favorite;
        }
        return overLays;
    }

    private boolean policyHasIconSelectionOperationSelected(IServicePolicy sp) {
        boolean iconSelectionOperationSelected = false;
        List<IPolicyOperation> operationList = this.platformUI.getOperations(sp, this.project == null);
        for (IPolicyOperation operationItem : operationList) {
            String stateID;
            if (!operationItem.getOperationKind().equals((Object)IPolicyOperation.OperationKind.iconSelection) || !(stateID = operationItem.getStateItem(this.project)).equals("org.eclipse.wst.true")) continue;
            return true;
        }
        return iconSelectionOperationSelected;
    }

    public void performDefaults() {
        this.initializeDefaults();
        List<IServicePolicy> policyList = this.platform.getRootServicePolicies(null);
        policyList = ServiceUtils.sortList(policyList);
        this.masterPolicyTree.removeAll();
        for (IServicePolicy policy : policyList) {
            this.addPolicy(policy, (Widget)this.masterPolicyTree, true);
        }
        TreeItem[] treeItems = this.masterPolicyTree.getItems();
        if (treeItems.length > 0) {
            this.masterPolicyTree.setSelection(treeItems[0]);
            this.masterPolicyTree.notifyListeners(13, new Event());
            this.error = this.validateAllPolicies((IServicePolicy)treeItems[0].getData());
        }
    }

    public void childChange(List<IServicePolicy> child, List<Boolean> added) {
        if (!this.bComplexOpCompleted) {
            this.listChildChangeEvents.add(new ChildChangeEvent(child, added));
        }
    }

    private void processChildChangeEvent(ChildChangeEvent cce, Hashtable<String, IServicePolicy> htTopLevelAddtions) {
        List<IServicePolicy> changedServicePolicyList = cce.getChangedChildren();
        List<Boolean> changedServicePolicyAddedList = cce.getAdded();
        int i = 0;
        while (i < changedServicePolicyList.size()) {
            IServicePolicy nextChangedServicePolicy = changedServicePolicyList.get(i);
            boolean added = changedServicePolicyAddedList.get(i);
            if (!added) {
                this.processChildChangeEventRemoveServicePolicy(nextChangedServicePolicy);
            } else if (htTopLevelAddtions.containsKey(nextChangedServicePolicy.getId())) {
                this.processChildChangeEventAddServicePolicy(nextChangedServicePolicy);
            }
            ++i;
        }
    }

    private void processChildChangeEventRemoveServicePolicy(IServicePolicy nextChangedServicePolicy) {
        boolean is4thLevelOrHigher = this.is4thLevelOrHigherPolicy(nextChangedServicePolicy);
        this.removeStateListener(nextChangedServicePolicy);
        if (is4thLevelOrHigher) {
            if (this.detailsPolicyTree.isVisible()) {
                TreeItem[] children = this.detailsPolicyTree.getItems();
                TreeItem found = null;
                int i = 0;
                while (i < children.length) {
                    found = this.findPolicy(nextChangedServicePolicy, children[i]);
                    if (found != null) break;
                    ++i;
                }
                if (found != null && !found.isDisposed()) {
                    this.processChildChangeEventDeleteTreeItem(found);
                }
            }
        } else {
            TreeItem[] children = this.masterPolicyTree.getItems();
            TreeItem found = null;
            int i = 0;
            while (i < children.length) {
                found = this.findPolicy(nextChangedServicePolicy, children[i]);
                if (found != null) break;
                ++i;
            }
            if (found != null && !found.isDisposed()) {
                this.processChildChangeEventDeleteTreeItem(found);
            }
        }
    }

    private void processChildChangeEventDeleteTreeItem(TreeItem deleteItem) {
        int siblingsCount;
        int idx;
        Tree parentTree;
        Tree selectionTree = parentTree = deleteItem.getParent();
        TreeItem parentTreeItem = deleteItem.getParentItem();
        int n = idx = parentTreeItem == null ? parentTree.indexOf(deleteItem) : parentTreeItem.indexOf(deleteItem);
        boolean isLastIndex = parentTreeItem == null ? parentTree.indexOf(deleteItem) == parentTree.getItemCount() - 1 : parentTreeItem.indexOf(deleteItem) == parentTreeItem.getItemCount() - 1;
        int n2 = siblingsCount = parentTreeItem == null ? parentTree.getItemCount() - 1 : parentTreeItem.getItemCount() - 1;
        boolean hasParent = parentTreeItem == null ? parentTree.getItemCount() == 0 : parentTreeItem.getItemCount() == 0;
        deleteItem.dispose();
        parentTree.redraw();
        TreeItem selectItem = null;
        if (siblingsCount == 0) {
            if (hasParent) {
                selectItem = parentTreeItem == null ? parentTree.getItem(0) : parentTreeItem;
            } else if (parentTree == this.detailsPolicyTree && this.masterPolicyTree.getItems().length > 0) {
                selectItem = this.masterPolicyTree.getItem(0);
                selectionTree = this.masterPolicyTree;
            }
        } else {
            selectItem = parentTreeItem == null ? (isLastIndex ? parentTree.getItem(idx - 1) : parentTree.getItem(idx)) : (isLastIndex ? parentTreeItem.getItem(idx - 1) : parentTreeItem.getItem(idx));
        }
        if (selectItem != null) {
            selectionTree.setSelection(selectItem);
            selectionTree.notifyListeners(13, new Event());
        }
    }

    private void processChildChangeEventAddServicePolicy(IServicePolicy policyToAdd) {
        boolean is4thLevelOrHigher = this.is4thLevelOrHigherPolicy(policyToAdd);
        IServicePolicy parent = policyToAdd.getParentPolicy();
        if (is4thLevelOrHigher) {
            if (this.detailsPolicyTree.isVisible()) {
                TreeItem[] children = this.detailsPolicyTree.getItems();
                TreeItem found = null;
                int i = 0;
                while (i < children.length) {
                    found = this.findPolicy(parent, children[i]);
                    if (found != null) break;
                    ++i;
                }
                if (found != null && !found.isDisposed()) {
                    this.addPolicy(policyToAdd, (Widget)found, false);
                }
            }
        } else {
            TreeItem[] children = this.masterPolicyTree.getItems();
            TreeItem found = null;
            int i = 0;
            while (i < children.length) {
                found = this.findPolicy(parent, children[i]);
                if (found != null) break;
                ++i;
            }
            if (found != null && !found.isDisposed()) {
                this.addPolicy(policyToAdd, (Widget)found, false);
            }
        }
    }

    private TreeItem findPolicy(IServicePolicy policyToFind, TreeItem ti) {
        TreeItem toReturn = null;
        if (ti == null || !(ti.getData() instanceof IServicePolicy)) {
            return toReturn;
        }
        IServicePolicy sp = (IServicePolicy)ti.getData();
        if (sp.getId().equals(policyToFind.getId())) {
            return ti;
        }
        TreeItem[] tiChildren = ti.getItems();
        int i = 0;
        while (i < tiChildren.length) {
            toReturn = this.findPolicy(policyToFind, tiChildren[i]);
            if (toReturn != null) break;
            ++i;
        }
        return toReturn;
    }

    private void initializeDefaults() {
        if (this.project == null) {
            this.platform.restoreDefaults();
        } else {
            this.platform.restoreDefaults(this.project);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.masterPolicyTree || e.getSource() == this.detailsPolicyTree) {
            TreeItem[] selectedItems = e.getSource() == this.masterPolicyTree ? this.masterPolicyTree.getSelection() : this.detailsPolicyTree.getSelection();
            if (selectedItems.length <= 0) {
                return;
            }
            Vector<IServicePolicy> sp = new Vector<IServicePolicy>();
            int i = 0;
            while (i < selectedItems.length) {
                sp.add((IServicePolicy)selectedItems[i].getData());
                ++i;
            }
            this.updateCSH(sp);
            this.updateInfoPanels(sp);
            if (e.getSource() == this.masterPolicyTree) {
                if (this.is3rdLevelPolInMasterTreeWithChildren(sp)) {
                    this.populateDetailsPolicyTree(sp);
                } else if (this.excomposite.getVisible()) {
                    this.excomposite.setVisible(false);
                    this.excomposite.setExpanded(false);
                    this.expandedStateChanged(this.excomposite);
                }
            }
            this.addActionButtons(sp);
            this.lastSelectedSp = sp;
        } else {
            Control actionControl = (Control)e.getSource();
            Object oldData = actionControl.getData();
            this.updatePolicy(actionControl);
            if (this.lastSelectedSp != null) {
                this.addActionButtons(this.lastSelectedSp);
            }
            IServicePolicy changedSP = null;
            if (!actionControl.isDisposed()) {
                changedSP = ((ActionControlData)actionControl.getData()).getSpList().get(0);
            }
            this.error = this.validateAllPolicies(changedSP);
            this.listener.widgetSelected(e);
            this.setFocusForLastControl(oldData);
        }
    }

    private void setFocusForLastControl(Object oldData) {
        if (oldData != null && oldData instanceof ActionControlData) {
            Control[] compositeControls;
            ActionControlData controlData = (ActionControlData)oldData;
            IPolicyOperation operation = controlData.getPoList().get(0);
            Control[] controlArray = compositeControls = this.operationsComposite.getChildren();
            int n = compositeControls.length;
            int n2 = 0;
            while (n2 < n) {
                IPolicyOperation newOperation;
                Control newControl = controlArray[n2];
                Object newData = newControl.getData();
                if (newData != null && newData instanceof ActionControlData && (newOperation = ((ActionControlData)newData).poList.get(0)) == operation) {
                    newControl.setFocus();
                    break;
                }
                ++n2;
            }
        }
    }

    private void populateDetailsPolicyTree(List<IServicePolicy> sp) {
        List childpolicyList = sp.get(0).getChildren();
        this.detailsPolicyTree.removeAll();
        for (IServicePolicy policy : childpolicyList) {
            this.addPolicy(policy, (Widget)this.detailsPolicyTree, false);
        }
        TreeItem[] treeItems = this.detailsPolicyTree.getItems();
        int i = 0;
        while (i < treeItems.length) {
            this.updateValidStates(treeItems[i], true);
            ++i;
        }
        this.excomposite.setVisible(true);
        this.excomposite.setText(sp.get(0).getDescriptor().getLongName() + " (" + WstSPUIPluginMessages.TEXT_DETAILS + ")");
        this.excomposite.layout();
    }

    private void updateInfoPanels(List<IServicePolicy> spList) {
        String desc = spList.get(0) == null || spList.get(0).getDescriptor() == null || spList.get(0).getDescriptor().getDescription() == null ? "" : spList.get(0).getDescriptor().getDescription();
        this.text_DetailsPanel_description.setText(desc);
        this.text_DetailsPanel_dependencies.setText(this.getDependanciesText(spList.get(0)));
    }

    private void updateCSH(List<IServicePolicy> spList) {
        String CSH_ID = spList.get(0) == null || spList.get(0).getDescriptor() == null ? null : spList.get(0).getDescriptor().getContextHelpId();
        IServicePolicy parentSP = spList.get(0);
        while (CSH_ID == null || CSH_ID.length() == 0) {
            if ((parentSP = parentSP.getParentPolicy()) == null) break;
            String string = CSH_ID = parentSP.getDescriptor() == null ? null : parentSP.getDescriptor().getContextHelpId();
        }
        if (CSH_ID == null) {
            CSH_ID = this.INFOPOP_SPPP_PAGE;
        }
        this.helpSystem.setHelp((Control)this, CSH_ID);
    }

    private IStatus validateAllPolicies(IServicePolicy focusPolicy) {
        IStatus error;
        this.allErrors.clear();
        List servicePolicyList = this.platform.getRootServicePolicies(null);
        for (IServicePolicy servicePolicyItem : servicePolicyList) {
            this.validatePolicy(servicePolicyItem);
        }
        IStatus iStatus = error = focusPolicy == null ? null : this.allErrors.get(focusPolicy.getId());
        if (error == null && !this.allErrors.isEmpty()) {
            error = this.allErrors.get(this.allErrors.keys().nextElement());
        }
        TreeItem[] treeItems = this.masterPolicyTree.getItems();
        int i = 0;
        while (i < treeItems.length) {
            this.updateValidStates(treeItems[i], false);
            ++i;
        }
        if (this.detailsPolicyTree.isVisible()) {
            treeItems = this.detailsPolicyTree.getItems();
            i = 0;
            while (i < treeItems.length) {
                this.updateValidStates(treeItems[i], false);
                ++i;
            }
        }
        return error;
    }

    private void updateValidStates(TreeItem ti, boolean updateDetailsOnly) {
        IServicePolicy sp = (IServicePolicy)ti.getData();
        this.setValidPolicyState(ti);
        if (this.allErrors.containsKey(sp.getId())) {
            this.setInvalidPolicyState(ti, updateDetailsOnly);
        }
        TreeItem[] treeItems = ti.getItems();
        if (ti.getItems().length == 0) {
            if (sp.getChildren().size() != 0 && this.policyChildrenInvalid(sp)) {
                this.setInvalidPolicyState(ti, updateDetailsOnly);
            }
        } else {
            int i = 0;
            while (i < treeItems.length) {
                this.updateValidStates(treeItems[i], updateDetailsOnly);
                ++i;
            }
        }
    }

    private boolean policyChildrenInvalid(IServicePolicy sp) {
        boolean toReturn = false;
        List servicePolicyList = sp.getChildren();
        for (IServicePolicy servicePolicyItem : servicePolicyList) {
            if (this.allErrors.containsKey(servicePolicyItem.getId())) {
                return true;
            }
            toReturn = this.policyChildrenInvalid(servicePolicyItem);
        }
        return toReturn;
    }

    private void validatePolicy(IServicePolicy sp) {
        List relationShipList = sp.getRelationships();
        String currentValueID = null;
        if (relationShipList != null && relationShipList.size() > 0) {
            for (IPolicyRelationship relationShipItem : relationShipList) {
                List<IPolicyOperation> policyOperationsList = this.platformUI.getOperations(relationShipItem.getPolicyEnumerationList().getPolicy(), this.project == null);
                String operationLongName = "";
                for (IPolicyOperation policyOperationItem : policyOperationsList) {
                    if (!policyOperationItem.isUseDefaultData()) continue;
                    operationLongName = policyOperationItem.getDescriptor().getLongName();
                    currentValueID = policyOperationItem.getStateItem(this.project);
                    break;
                }
                List spStateEnumerationList = relationShipItem.getPolicyEnumerationList().getEnumerationList();
                List relatedPolicies = relationShipItem.getRelatedPolicies();
                for (IStateEnumerationItem stateEnumerationItem : spStateEnumerationList) {
                    if (stateEnumerationItem.getId() != currentValueID) continue;
                    String operationSelectionLongName = stateEnumerationItem.getLongName();
                    for (IPolicyEnumerationList relatedPolicyEnumerationItem : relatedPolicies) {
                        String dependantPolicyShortName = relatedPolicyEnumerationItem.getPolicy().getDescriptor().getShortName();
                        List relatedSPStateEnumerationList = relatedPolicyEnumerationItem.getEnumerationList();
                        Vector<String> validIds = new Vector<String>();
                        int i = 0;
                        while (i < relatedSPStateEnumerationList.size()) {
                            validIds.add(((IStateEnumerationItem)relatedSPStateEnumerationList.get(i)).getId());
                            ++i;
                        }
                        String currentItemID = "";
                        List<IPolicyOperation> relatedServicePolicyPolicyOperationsList = this.platformUI.getOperations(relatedPolicyEnumerationItem.getPolicy(), this.project == null);
                        IPolicyOperation relatedPolicyOperationItem = null;
                        for (IPolicyOperation relatedServicePolicyPolicyOperationItem : relatedServicePolicyPolicyOperationsList) {
                            if (!relatedServicePolicyPolicyOperationItem.isUseDefaultData()) continue;
                            currentItemID = relatedServicePolicyPolicyOperationItem.getStateItem(this.project);
                            relatedPolicyOperationItem = relatedServicePolicyPolicyOperationItem;
                            break;
                        }
                        if (validIds.contains(currentItemID)) continue;
                        IStatus error = this.createUnsatisfiedRelationshipError(sp, operationLongName, operationSelectionLongName, dependantPolicyShortName, relatedPolicyOperationItem, relatedSPStateEnumerationList);
                        this.allErrors.put(sp.getId(), error);
                    }
                }
            }
        }
        List servicePolicyChildrenList = sp.getChildren();
        for (IServicePolicy servicePolicyChildrenItem : servicePolicyChildrenList) {
            this.validatePolicy(servicePolicyChildrenItem);
        }
    }

    private void setValidPolicyState(TreeItem ti) {
        IServicePolicy sp = (IServicePolicy)ti.getData();
        this.setImage(ti, sp, this.getIconOverlayInfo(sp, false));
    }

    private void setInvalidPolicyState(TreeItem ti, boolean updateDetailsOnly) {
        IServicePolicy SP = (IServicePolicy)ti.getData();
        this.setImage(ti, SP, this.getIconOverlayInfo(SP, true));
        TreeItem parent = ti.getParent() == this.masterPolicyTree || updateDetailsOnly ? ti.getParentItem() : (ti.getParentItem() == null && SP.getParentPolicy() != null ? this.getParentInMasterTree(SP.getId()) : ti.getParentItem());
        while (parent != null) {
            this.setImage(parent, (IServicePolicy)parent.getData(), this.getIconOverlayInfo((IServicePolicy)parent.getData(), true));
            if (updateDetailsOnly) {
                parent = parent.getParentItem();
                continue;
            }
            TreeItem treeItem = parent = parent.getParentItem() == null && ((IServicePolicy)parent.getData()).getParentPolicy() != null ? this.getParentInMasterTree(((IServicePolicy)parent.getData()).getParentPolicy().getId()) : parent.getParentItem();
        }
    }

    private IStatus createUnsatisfiedRelationshipError(IServicePolicy sp, String operationLongName, String operationSelectionLongName, String dependantPolicyShortName, IPolicyOperation relatedOperation, List<IStateEnumerationItem> relatedOperationAcceptableValues) {
        String dependantOperationShortName = relatedOperation.getDescriptor().getShortName();
        Object dependantOperationSelectionShortNameList = new String();
        int i = 0;
        while (i < relatedOperationAcceptableValues.size()) {
            IStateEnumerationItem item = relatedOperationAcceptableValues.get(i);
            if (i != 0) {
                dependantOperationSelectionShortNameList = (String)dependantOperationSelectionShortNameList + " | ";
            }
            dependantOperationSelectionShortNameList = (String)dependantOperationSelectionShortNameList + item.getShortName();
            ++i;
        }
        Object[] args = new String[]{sp.getDescriptor().getLongName(), operationLongName, operationSelectionLongName, dependantPolicyShortName, dependantOperationShortName, dependantOperationSelectionShortNameList};
        Status error = new Status(4, "org.eclipse.wst.ws.service.policy.ui", NLS.bind((String)WstSPUIPluginMessages.SERVICEPOLICIES_DEPENDENCY_ERROR, (Object[])args));
        return error;
    }

    private TreeItem getParentInMasterTree(String parentID) {
        TreeItem parent = null;
        TreeItem[] rootNodes = this.masterPolicyTree.getItems();
        int i = 0;
        while (i < rootNodes.length) {
            parent = this.findChildNode(rootNodes[i], parentID);
            if (parent != null) break;
            ++i;
        }
        return parent;
    }

    private TreeItem findChildNode(TreeItem ti, String id) {
        TreeItem toReturn = null;
        if (((IServicePolicy)ti.getData()).getId().equals(id)) {
            toReturn = ti;
        } else {
            TreeItem[] childItems = ti.getItems();
            int i = 0;
            while (i < childItems.length) {
                toReturn = this.findChildNode(childItems[i], id);
                ++i;
            }
        }
        return toReturn;
    }

    private String getDependanciesText(IServicePolicy sp) {
        List relationShipList = sp.getRelationships();
        if (relationShipList == null || relationShipList.size() == 0) {
            return WstSPUIPluginMessages.SERVICEPOLICIES_DEPENDENCIES_NONE;
        }
        Object toReturn = new String();
        for (IPolicyRelationship relationShipItem : relationShipList) {
            List<IPolicyOperation> policyOperationsList = this.platformUI.getOperations(relationShipItem.getPolicyEnumerationList().getPolicy(), this.project == null);
            String operationLongName = "";
            for (IPolicyOperation policyOperationItem : policyOperationsList) {
                if (!policyOperationItem.isUseDefaultData()) continue;
                operationLongName = policyOperationItem.getDescriptor().getLongName();
                break;
            }
            List relatedPolicies = relationShipItem.getRelatedPolicies();
            List spStateEnumerationList = relationShipItem.getPolicyEnumerationList().getEnumerationList();
            for (IStateEnumerationItem stateEnumerationItem : spStateEnumerationList) {
                String operationSelectionLongName = stateEnumerationItem.getLongName();
                for (IPolicyEnumerationList relatedPolicyEnumerationItem : relatedPolicies) {
                    IPolicyOperation relatedPolicyOperationItem;
                    String dependantPolicyShortName = relatedPolicyEnumerationItem.getPolicy().getDescriptor().getShortName();
                    List relatedSPStateEnumerationList = relatedPolicyEnumerationItem.getEnumerationList();
                    List<IPolicyOperation> relatedPolicyOperationsList = this.platformUI.getOperations(relatedPolicyEnumerationItem.getPolicy(), this.project == null);
                    String dependantOperationShortName = "";
                    Iterator<IPolicyOperation> iterator = relatedPolicyOperationsList.iterator();
                    if (iterator.hasNext() && (relatedPolicyOperationItem = iterator.next()).isUseDefaultData()) {
                        dependantOperationShortName = relatedPolicyOperationItem.getDescriptor().getShortName();
                    }
                    Object dependantOperationSelectionShortNameList = new String();
                    int i = 0;
                    while (i < relatedSPStateEnumerationList.size()) {
                        IStateEnumerationItem item = (IStateEnumerationItem)relatedSPStateEnumerationList.get(i);
                        if (i != 0) {
                            dependantOperationSelectionShortNameList = (String)dependantOperationSelectionShortNameList + " | ";
                        }
                        dependantOperationSelectionShortNameList = (String)dependantOperationSelectionShortNameList + item.getShortName();
                        ++i;
                    }
                    Object[] args = new String[]{operationLongName, operationSelectionLongName, dependantPolicyShortName, dependantOperationShortName, dependantOperationSelectionShortNameList};
                    toReturn = (String)toReturn + NLS.bind((String)WstSPUIPluginMessages.SERVICEPOLICIES_DEPENDENCIES, (Object[])args) + "\r\n";
                }
            }
        }
        return toReturn;
    }

    private void updatePolicy(Control actionControl) {
        List<IPolicyOperation> policyOperationList = ((ActionControlData)actionControl.getData()).getPoList();
        IPolicyOperation po0 = policyOperationList.get(0);
        List<IServicePolicy> servicePolicyList = ((ActionControlData)actionControl.getData()).getSpList();
        if (actionControl instanceof Button && po0.getOperationKind().equals((Object)IPolicyOperation.OperationKind.complex)) {
            this.updateComplexOperationPreference(po0, servicePolicyList);
        } else {
            for (IPolicyOperation policyOperationItem : policyOperationList) {
                this.updateSelectionOperationPreference(actionControl, policyOperationItem);
            }
        }
    }

    public boolean okToLeave() {
        return this.allErrors.size() == 0;
    }

    private void updateSelectionOperationPreference(Control actionControl, IPolicyOperation po) {
        this.enableStateListener(false);
        if (actionControl instanceof Combo) {
            String selectedValue = ((Combo)actionControl).getText();
            List enumItemList = ServicePolicyPlatform.getInstance().getStateEnumeration(po.getEnumerationId());
            for (IStateEnumerationItem enumItem : enumItemList) {
                if (!enumItem.getLongName().equals(selectedValue)) continue;
                po.setStateItem(this.project, enumItem.getId());
                break;
            }
        } else if (((Button)actionControl).getSelection()) {
            po.setStateItem(this.project, "org.eclipse.wst.true");
        } else {
            po.setStateItem(this.project, "org.eclipse.wst.false");
        }
        this.enableStateListener(true);
    }

    private void addStateListener(IServicePolicy policy) {
        if (this.stateChangePolicySet.contains(policy)) {
            return;
        }
        if (this.project == null) {
            policy.getPolicyState().addPolicyStateChangeListener(this.stateChangeListener, false);
        } else {
            policy.getPolicyState(this.project).addPolicyStateChangeListener(this.stateChangeListener, false);
        }
        this.stateChangePolicySet.add(policy);
    }

    private void removeStateListener(IServicePolicy policy) {
        if (this.stateChangePolicySet.contains(policy)) {
            return;
        }
        if (this.project == null) {
            policy.getPolicyState().removePolicyStateChangeListener(this.stateChangeListener);
        } else {
            policy.getPolicyState(this.project).removePolicyStateChangeListener(this.stateChangeListener);
        }
        this.stateChangePolicySet.remove(policy);
    }

    private void enableStateListener(boolean enabled) {
        this.stateChangeEnabled = enabled;
    }

    /*
     * Unable to fully structure code
     */
    private void updateComplexOperationPreference(IPolicyOperation po, List<IServicePolicy> sps) {
        block8: {
            block7: {
                this.bComplexOpCompleted = false;
                this.listChildChangeEvents = new Vector<ChildChangeEvent>();
                try {
                    try {
                        po.launchOperation(sps);
                        break block7;
                    }
                    catch (RuntimeException v0) {
                        this.bComplexOpCompleted = true;
                        topLevelAdds = this.getHighestLevelChildren(this.listChildChangeEvents, true);
                        ** for (childChangeEventItem : this.listChildChangeEvents)
                    }
                }
                catch (Throwable var3_12) {
                    this.bComplexOpCompleted = true;
                    topLevelAdds = this.getHighestLevelChildren(this.listChildChangeEvents, true);
                    ** for (childChangeEventItem : this.listChildChangeEvents)
                }
lbl-1000:
                // 1 sources

                {
                    this.processChildChangeEvent(childChangeEventItem, topLevelAdds);
                    continue;
lbl13:
                    // 1 sources

                    break block8;
                }
lbl-1000:
                // 1 sources

                {
                    this.processChildChangeEvent(childChangeEventItem, topLevelAdds);
                    continue;
                }
lbl20:
                // 1 sources

                throw var3_12;
            }
            this.bComplexOpCompleted = true;
            topLevelAdds = this.getHighestLevelChildren(this.listChildChangeEvents, true);
            for (ChildChangeEvent childChangeEventItem : this.listChildChangeEvents) {
                this.processChildChangeEvent(childChangeEventItem, topLevelAdds);
            }
        }
    }

    private Hashtable<String, IServicePolicy> getHighestLevelChildren(List<ChildChangeEvent> htChildChangeEvents, boolean forAddOnly) {
        Hashtable<String, IServicePolicy> toReturn = new Hashtable<String, IServicePolicy>();
        Iterator<ChildChangeEvent> elements = htChildChangeEvents.iterator();
        Hashtable<String, IServicePolicy> allSps = new Hashtable<String, IServicePolicy>();
        while (elements.hasNext()) {
            ChildChangeEvent next = elements.next();
            List<IServicePolicy> changedChildrenList = next.getChangedChildren();
            List<Boolean> addedList = next.getAdded();
            int i = 0;
            while (i < changedChildrenList.size()) {
                if (forAddOnly && addedList.get(i).booleanValue()) {
                    allSps.put(changedChildrenList.get(i).getId(), changedChildrenList.get(i));
                }
                ++i;
            }
        }
        Enumeration servicePolicyElements = allSps.elements();
        while (servicePolicyElements.hasMoreElements()) {
            IServicePolicy nextServicePolicyElement = (IServicePolicy)servicePolicyElements.nextElement();
            if (nextServicePolicyElement.getParentPolicy() != null && allSps.containsKey(nextServicePolicyElement.getParentPolicy().getId())) continue;
            toReturn.put(nextServicePolicyElement.getId(), nextServicePolicyElement);
        }
        return toReturn;
    }

    public void dispose() {
        super.dispose();
        this.iconManager.dispose();
        for (IServicePolicy policy : this.stateChangePolicySet) {
            IPolicyState state = this.project == null ? policy.getPolicyState() : policy.getPolicyState(this.project);
            state.removePolicyStateChangeListener(this.stateChangeListener);
        }
    }

    private void addActionButtons(List<IServicePolicy> spList) {
        Control[] toRemove = this.operationsComposite.getChildren();
        int i = 0;
        while (i < toRemove.length) {
            toRemove[i].dispose();
            ++i;
        }
        List<List<IPolicyOperation>> policyOperationListList = this.platformUI.getOperationsList(spList, this.project == null);
        for (List<IPolicyOperation> policyOperationList : policyOperationListList) {
            if (policyOperationList.size() <= 0) continue;
            if (policyOperationList.get(0).getOperationKind() == IPolicyOperation.OperationKind.complex) {
                this.addComplexOperationUI(policyOperationList, spList);
                continue;
            }
            this.addSelectionOperationUI(policyOperationList, spList);
        }
        this.operationsScrolledComposite.setMinSize(this.operationsComposite.computeSize(-1, -1));
        this.operationsComposite.layout();
    }

    private void addSelectionOperationUI(List<IPolicyOperation> pos, List<IServicePolicy> sps) {
        Button selectionControl;
        IPolicyOperation po0 = pos.get(0);
        IDescriptor d = po0.getDescriptor();
        if (po0.getOperationKind() == IPolicyOperation.OperationKind.enumeration) {
            Label l = new Label(this.operationsComposite, 0);
            l.setText(d.getLongName() + ":");
            GridData comboGD = new GridData(4, 4, true, false);
            Combo cb = new Combo(this.operationsComposite, 12);
            cb.setLayoutData((Object)comboGD);
            selectionControl = cb;
            cb.addSelectionListener((SelectionListener)this);
            List enumItemList = ServicePolicyPlatform.getInstance().getStateEnumeration(po0.getEnumerationId());
            for (IStateEnumerationItem enumItem : enumItemList) {
                cb.add(enumItem.getLongName());
            }
            l.setEnabled(po0.isEnabled(sps));
            cb.setEnabled(po0.isEnabled(sps));
            if (cb.isEnabled()) {
                cb.setText(this.getEnumerationOperationCurrentSelection(po0));
            }
        } else {
            Button checkBox;
            selectionControl = checkBox = new Button(this.operationsComposite, 32);
            checkBox.addSelectionListener((SelectionListener)this);
            GridData checkBoxGD = new GridData();
            checkBoxGD.horizontalSpan = 2;
            checkBox.setLayoutData((Object)checkBoxGD);
            checkBox.setText(d.getLongName());
            checkBox.setEnabled(po0.isEnabled(sps));
            if (checkBox.isEnabled()) {
                checkBox.setSelection(this.getSelectionOperationCurrentSelection(po0));
            }
        }
        selectionControl.setData((Object)new ActionControlData(sps, pos));
    }

    private boolean getSelectionOperationCurrentSelection(IPolicyOperation po) {
        return po.getStateItem(this.project).equals("org.eclipse.wst.true");
    }

    private String getEnumerationOperationCurrentSelection(IPolicyOperation po) {
        String currentSelection = "";
        List enumItemList = ServicePolicyPlatform.getInstance().getStateEnumeration(po.getEnumerationId());
        for (IStateEnumerationItem enumItem : enumItemList) {
            if (!enumItem.getId().equals(po.getStateItem(this.project))) continue;
            currentSelection = enumItem.getLongName();
            break;
        }
        return currentSelection;
    }

    private void addComplexOperationUI(List<IPolicyOperation> pos, List<IServicePolicy> sps) {
        IPolicyOperation po0 = pos.get(0);
        IDescriptor d = po0.getDescriptor();
        Button pushButton = new Button(this.operationsComposite, 8);
        GridData pushButtonGD = new GridData();
        pushButtonGD.horizontalSpan = 2;
        pushButton.setLayoutData((Object)pushButtonGD);
        pushButton.setText(d.getLongName());
        pushButton.addSelectionListener((SelectionListener)this);
        pushButton.setData((Object)new ActionControlData(sps, pos));
        pushButton.setEnabled(po0.isEnabled(sps));
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public IStatus getError() {
        return this.error;
    }

    private class ActionControlData {
        private List<IServicePolicy> spList;
        private List<IPolicyOperation> poList;

        public ActionControlData(List<IServicePolicy> spList, List<IPolicyOperation> poList) {
            this.spList = spList;
            this.poList = poList;
        }

        public List<IServicePolicy> getSpList() {
            return this.spList;
        }

        public void setSpList(List<IServicePolicy> spList) {
            this.spList = spList;
        }

        public List<IPolicyOperation> getPoList() {
            return this.poList;
        }

        public void setPoList(List<IPolicyOperation> poList) {
            this.poList = poList;
        }
    }

    private class ChildChangeEvent {
        private List<IServicePolicy> changedChildren;
        private List<Boolean> added;

        public ChildChangeEvent(List<IServicePolicy> changedChildren, List<Boolean> added) {
            this.changedChildren = changedChildren;
            this.added = added;
        }

        public List<IServicePolicy> getChangedChildren() {
            return this.changedChildren;
        }

        public void setChangedChildren(List<IServicePolicy> changedChildren) {
            this.changedChildren = changedChildren;
        }

        public List<Boolean> getAdded() {
            return this.added;
        }

        public void setAdded(List<Boolean> added) {
            this.added = added;
        }
    }

    private class StateChangeListener
    implements IPolicyStateChangeListener {
        private StateChangeListener() {
        }

        public void policyStateChange(IServicePolicy policy, String key, String oldValue, String newValue) {
            if (!ServicePoliciesComposite.this.stateChangeEnabled) {
                return;
            }
            ServicePoliciesComposite.this.error = ServicePoliciesComposite.this.validateAllPolicies(policy);
            ServicePoliciesComposite.this.listener.widgetSelected(null);
        }
    }
}

