/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.filebuffers.IAnnotationModelFactory;
import org.eclipse.core.filebuffers.IDocumentFactory;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.internal.filebuffers.FileBuffersMessages;
import org.eclipse.core.internal.filebuffers.NLSUtility;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public class ExtensionsRegistry {
    protected static final String WILDCARD = "*";
    private final Map<Object, Set<IConfigurationElement>> fFactoryDescriptors = new HashMap<Object, Set<IConfigurationElement>>();
    private final Map<IConfigurationElement, Object> fFactories = new HashMap<IConfigurationElement, Object>();
    private final Map<Object, Set<IConfigurationElement>> fSetupParticipantDescriptors = new HashMap<Object, Set<IConfigurationElement>>();
    private final Map<IConfigurationElement, Object> fSetupParticipants = new HashMap<IConfigurationElement, Object>();
    private final Map<Object, Set<IConfigurationElement>> fAnnotationModelFactoryDescriptors = new HashMap<Object, Set<IConfigurationElement>>();
    private final Map<IConfigurationElement, Object> fAnnotationModelFactories = new HashMap<IConfigurationElement, Object>();
    protected IContentTypeManager fContentTypeManager = Platform.getContentTypeManager();

    public ExtensionsRegistry() {
        this.initialize("documentCreation", "contentTypeId", true, this.fFactoryDescriptors);
        this.initialize("documentCreation", "fileNames", false, this.fFactoryDescriptors);
        this.initialize("documentCreation", "extensions", false, this.fFactoryDescriptors);
        this.initialize("documentSetup", "contentTypeId", true, this.fSetupParticipantDescriptors);
        this.initialize("documentSetup", "fileNames", false, this.fSetupParticipantDescriptors);
        this.initialize("documentSetup", "extensions", false, this.fSetupParticipantDescriptors);
        this.initialize("annotationModelCreation", "contentTypeId", true, this.fAnnotationModelFactoryDescriptors);
        this.initialize("annotationModelCreation", "fileNames", false, this.fAnnotationModelFactoryDescriptors);
        this.initialize("annotationModelCreation", "extensions", false, this.fAnnotationModelFactoryDescriptors);
    }

    private void read(String attributeName, IConfigurationElement element, Map<Object, Set<IConfigurationElement>> map) {
        String value = element.getAttribute(attributeName);
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                Set<IConfigurationElement> s = map.get(token);
                if (s == null) {
                    s = new HashSet<IConfigurationElement>();
                    map.put(token, s);
                }
                s.add(element);
            }
        }
    }

    private void readContentType(String attributeName, IConfigurationElement element, Map<Object, Set<IConfigurationElement>> map) {
        String value = element.getAttribute(attributeName);
        if (value != null) {
            IContentType contentType = this.fContentTypeManager.getContentType(value);
            if (contentType == null) {
                this.log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, NLSUtility.format(FileBuffersMessages.ExtensionsRegistry_error_contentTypeDoesNotExist, value), null));
                return;
            }
            ContentTypeAdapter adapter = new ContentTypeAdapter(contentType);
            Set<IConfigurationElement> s = map.get(adapter);
            if (s == null) {
                s = new HashSet<IConfigurationElement>();
                map.put(adapter, s);
            }
            s.add(element);
        }
    }

    private void log(IStatus status) {
        ILog.of(ExtensionsRegistry.class).log(status);
    }

    private void initialize(String extensionPointName, String childElementName, boolean isContentTypeId, Map<Object, Set<IConfigurationElement>> descriptors) {
        IConfigurationElement[] elements;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.filebuffers", extensionPointName);
        if (extensionPoint == null) {
            this.log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, NLSUtility.format(FileBuffersMessages.ExtensionsRegistry_error_extensionPointNotFound, extensionPointName), null));
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (isContentTypeId) {
                this.readContentType(childElementName, element, descriptors);
            } else {
                this.read(childElementName, element, descriptors);
            }
            ++n2;
        }
    }

    private <T> T getExtension(IConfigurationElement entry, Map<IConfigurationElement, Object> extensions, Class<T> extensionType) {
        Object extension = extensions.get(entry);
        if (extension != null) {
            return (T)extension;
        }
        try {
            extension = entry.createExecutableExtension("class");
        }
        catch (CoreException x) {
            this.log(x.getStatus());
        }
        if (extensionType.isInstance(extension)) {
            extensions.put(entry, extension);
            return (T)extension;
        }
        return null;
    }

    private IConfigurationElement selectConfigurationElement(Set<IConfigurationElement> set) {
        if (set != null && !set.isEmpty()) {
            Iterator<IConfigurationElement> e = set.iterator();
            return e.next();
        }
        return null;
    }

    @Deprecated
    protected IDocumentFactory getDocumentFactory(String nameOrExtension) {
        Set<IConfigurationElement> set = this.fFactoryDescriptors.get(nameOrExtension);
        if (set != null) {
            IConfigurationElement entry = this.selectConfigurationElement(set);
            return this.getExtension(entry, this.fFactories, IDocumentFactory.class);
        }
        return null;
    }

    @Deprecated
    protected IDocumentFactory doGetDocumentFactory(IContentType[] contentTypes) {
        Set<IConfigurationElement> set = null;
        int i = 0;
        while (i < contentTypes.length && set == null) {
            set = this.fFactoryDescriptors.get(new ContentTypeAdapter(contentTypes[i++]));
        }
        if (set != null) {
            IConfigurationElement entry = this.selectConfigurationElement(set);
            return this.getExtension(entry, this.fFactories, IDocumentFactory.class);
        }
        return null;
    }

    @Deprecated
    protected IDocumentFactory getDocumentFactory(IContentType[] contentTypes) {
        IDocumentFactory factory = this.doGetDocumentFactory(contentTypes);
        while (factory == null) {
            if ((contentTypes = this.computeBaseContentTypes(contentTypes)) == null) break;
            factory = this.doGetDocumentFactory(contentTypes);
        }
        return factory;
    }

    protected List<IDocumentSetupParticipant> getDocumentSetupParticipants(String nameOrExtension) {
        Set<IConfigurationElement> set = this.fSetupParticipantDescriptors.get(nameOrExtension);
        if (set == null) {
            return null;
        }
        ArrayList<IDocumentSetupParticipant> participants = new ArrayList<IDocumentSetupParticipant>();
        for (IConfigurationElement entry : set) {
            IDocumentSetupParticipant participant = this.getExtension(entry, this.fSetupParticipants, IDocumentSetupParticipant.class);
            if (participant == null) continue;
            participants.add(participant);
        }
        return participants;
    }

    private List<IDocumentSetupParticipant> doGetDocumentSetupParticipants(IContentType[] contentTypes) {
        HashSet<IConfigurationElement> resultSet = new HashSet<IConfigurationElement>();
        int i = 0;
        while (i < contentTypes.length) {
            Set<IConfigurationElement> set;
            if ((set = this.fSetupParticipantDescriptors.get(new ContentTypeAdapter(contentTypes[i++]))) == null) continue;
            resultSet.addAll(set);
        }
        ArrayList<IDocumentSetupParticipant> participants = new ArrayList<IDocumentSetupParticipant>();
        for (IConfigurationElement entry : resultSet) {
            IDocumentSetupParticipant participant = this.getExtension(entry, this.fSetupParticipants, IDocumentSetupParticipant.class);
            if (participant == null) continue;
            participants.add(participant);
        }
        return participants.isEmpty() ? null : participants;
    }

    protected List<IDocumentSetupParticipant> getDocumentSetupParticipants(IContentType[] contentTypes) {
        List<IDocumentSetupParticipant> participants = this.doGetDocumentSetupParticipants(contentTypes);
        while (participants == null) {
            if ((contentTypes = this.computeBaseContentTypes(contentTypes)) == null) break;
            participants = this.doGetDocumentSetupParticipants(contentTypes);
        }
        return participants;
    }

    private IAnnotationModelFactory doGetAnnotationModelFactory(IContentType[] contentTypes) {
        Set<IConfigurationElement> set = null;
        int i = 0;
        while (i < contentTypes.length && set == null) {
            set = this.fAnnotationModelFactoryDescriptors.get(new ContentTypeAdapter(contentTypes[i++]));
        }
        if (set != null) {
            IConfigurationElement entry = this.selectConfigurationElement(set);
            return this.getExtension(entry, this.fAnnotationModelFactories, IAnnotationModelFactory.class);
        }
        return null;
    }

    protected IAnnotationModelFactory getAnnotationModelFactory(IContentType[] contentTypes) {
        IAnnotationModelFactory factory = this.doGetAnnotationModelFactory(contentTypes);
        while (factory == null) {
            if ((contentTypes = this.computeBaseContentTypes(contentTypes)) == null) break;
            factory = this.doGetAnnotationModelFactory(contentTypes);
        }
        return factory;
    }

    protected IAnnotationModelFactory getAnnotationModelFactory(String extension) {
        Set<IConfigurationElement> set = this.fAnnotationModelFactoryDescriptors.get(extension);
        if (set != null) {
            IConfigurationElement entry = this.selectConfigurationElement(set);
            return this.getExtension(entry, this.fAnnotationModelFactories, IAnnotationModelFactory.class);
        }
        return null;
    }

    protected IContentType[] findContentTypes(IPath location, LocationKind locationKind) {
        Assert.isLegal((locationKind != LocationKind.IFILE ? 1 : 0) != 0);
        return this.fContentTypeManager.findContentTypesFor(location.lastSegment());
    }

    private IContentType[] computeBaseContentTypes(IContentType[] contentTypes) {
        ArrayList<IContentType> baseTypes = new ArrayList<IContentType>();
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            IContentType baseType = contentType.getBaseType();
            if (baseType != null) {
                baseTypes.add(baseType);
            }
            ++n2;
        }
        IContentType[] result = null;
        int size = baseTypes.size();
        if (size > 0) {
            result = new IContentType[size];
            baseTypes.toArray(result);
        }
        return result;
    }

    @Deprecated
    public IDocumentFactory getDocumentFactory(IPath location, LocationKind locationKind) {
        IDocumentFactory factory = this.getDocumentFactory(this.findContentTypes(location, locationKind));
        if (factory == null) {
            factory = this.getDocumentFactory(location.lastSegment());
        }
        if (factory == null) {
            factory = this.getDocumentFactory(location.getFileExtension());
        }
        if (factory == null) {
            factory = this.getDocumentFactory(WILDCARD);
        }
        return factory;
    }

    public IDocumentSetupParticipant[] getDocumentSetupParticipants(IPath location, LocationKind locationKind) {
        HashSet<IDocumentSetupParticipant> participants = new HashSet<IDocumentSetupParticipant>();
        List<IDocumentSetupParticipant> p = this.getDocumentSetupParticipants(this.findContentTypes(location, locationKind));
        if (p != null) {
            participants.addAll(p);
        }
        if ((p = this.getDocumentSetupParticipants(location.lastSegment())) != null) {
            participants.addAll(p);
        }
        if ((p = this.getDocumentSetupParticipants(location.getFileExtension())) != null) {
            participants.addAll(p);
        }
        if ((p = this.getDocumentSetupParticipants(WILDCARD)) != null) {
            participants.addAll(p);
        }
        IDocumentSetupParticipant[] result = new IDocumentSetupParticipant[participants.size()];
        participants.toArray(result);
        return result;
    }

    public IAnnotationModelFactory getAnnotationModelFactory(IPath location, LocationKind locationKind) {
        IAnnotationModelFactory factory = this.getAnnotationModelFactory(this.findContentTypes(location, locationKind));
        if (factory == null) {
            factory = this.getAnnotationModelFactory(location.lastSegment());
        }
        if (factory == null) {
            factory = this.getAnnotationModelFactory(location.getFileExtension());
        }
        if (factory == null) {
            factory = this.getAnnotationModelFactory(WILDCARD);
        }
        return factory;
    }

    private static class ContentTypeAdapter {
        private final IContentType fContentType;

        public ContentTypeAdapter(IContentType contentType) {
            Assert.isNotNull((Object)contentType);
            this.fContentType = contentType;
        }

        public String getId() {
            return this.fContentType.getId();
        }

        public boolean equals(Object obj) {
            return obj instanceof ContentTypeAdapter && this.fContentType.getId().equals(((ContentTypeAdapter)obj).getId());
        }

        public int hashCode() {
            return this.fContentType.getId().hashCode();
        }
    }
}

