/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.clone.GitCloneSourceProviderExtension;
import org.eclipse.egit.ui.internal.clone.RepositoryLocationContentProvider;
import org.eclipse.egit.ui.internal.clone.RepositoryLocationLabelProvider;
import org.eclipse.egit.ui.internal.provisional.wizards.RepositoryServerInfo;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class RepositoryLocationPage
extends WizardPage {
    private final List<GitCloneSourceProviderExtension.CloneSourceProvider> repositoryImports;
    private Map<GitCloneSourceProviderExtension.CloneSourceProvider, WizardPage> resolvedWizardPages;
    private TreeViewer tv;

    public RepositoryLocationPage(List<GitCloneSourceProviderExtension.CloneSourceProvider> cloneSourceProvider) {
        super(RepositoryLocationPage.class.getName());
        this.repositoryImports = cloneSourceProvider;
        this.resolvedWizardPages = new HashMap<GitCloneSourceProviderExtension.CloneSourceProvider, WizardPage>();
        this.setTitle(UIText.RepositoryLocationPage_title);
        this.setMessage(UIText.RepositoryLocationPage_info);
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(main);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        FilteredTree tree = new FilteredTree(main, 2820, new PatternFilter(), true, true);
        this.tv = tree.getViewer();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tree);
        this.tv.setContentProvider((IContentProvider)new RepositoryLocationContentProvider());
        this.tv.setLabelProvider((IBaseLabelProvider)new RepositoryLocationLabelProvider());
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RepositoryLocationPage.this.checkPage();
            }
        });
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RepositoryLocationPage.this.checkPage();
                if (RepositoryLocationPage.this.isPageComplete()) {
                    RepositoryLocationPage.this.getContainer().showPage(RepositoryLocationPage.this.getNextPage());
                }
            }
        });
        this.tv.setInput(this.repositoryImports);
        this.setControl((Control)main);
    }

    private void checkPage() {
        this.setErrorMessage(null);
        boolean complete = false;
        IStructuredSelection selection = (IStructuredSelection)this.tv.getSelection();
        if (selection.size() == 1) {
            Object element = selection.getFirstElement();
            if (element instanceof GitCloneSourceProviderExtension.CloneSourceProvider) {
                GitCloneSourceProviderExtension.CloneSourceProvider repositoryImport = (GitCloneSourceProviderExtension.CloneSourceProvider)element;
                if (repositoryImport.equals(GitCloneSourceProviderExtension.CloneSourceProvider.LOCAL) || repositoryImport.hasFixLocation()) {
                    complete = true;
                }
            } else if (element instanceof RepositoryServerInfo) {
                complete = true;
            }
        }
        this.setPageComplete(complete);
    }

    public IWizardPage getNextPage() {
        IStructuredSelection selection = (IStructuredSelection)this.tv.getSelection();
        if (selection.size() == 1) {
            Object parent;
            Object element = selection.getFirstElement();
            if (element instanceof GitCloneSourceProviderExtension.CloneSourceProvider) {
                return this.getNextPage((GitCloneSourceProviderExtension.CloneSourceProvider)element);
            }
            if (element instanceof RepositoryServerInfo && (parent = ((ITreeContentProvider)this.tv.getContentProvider()).getParent(element)) instanceof GitCloneSourceProviderExtension.CloneSourceProvider) {
                return this.getNextPage((GitCloneSourceProviderExtension.CloneSourceProvider)parent);
            }
        }
        return null;
    }

    private IWizardPage getNextPage(GitCloneSourceProviderExtension.CloneSourceProvider repositoryImport) {
        if (repositoryImport.equals(GitCloneSourceProviderExtension.CloneSourceProvider.LOCAL)) {
            return this.getWizard().getNextPage((IWizardPage)this);
        }
        return this.getWizardPage(repositoryImport);
    }

    private WizardPage getWizardPage(GitCloneSourceProviderExtension.CloneSourceProvider repositoryImport) {
        WizardPage nextPage = this.resolvedWizardPages.get(repositoryImport);
        if (nextPage == null) {
            try {
                nextPage = repositoryImport.getRepositorySearchPage();
            }
            catch (CoreException e) {
                Activator.error(e.getLocalizedMessage(), e);
            }
            if (nextPage != null) {
                nextPage.setWizard(this.getWizard());
                this.resolvedWizardPages.put(repositoryImport, nextPage);
            }
        }
        return nextPage;
    }
}

