/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.tasks.ui.preferences;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.mylyn.internal.wikitext.tasks.ui.preferences.Messages;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.editor.preferences.Preferences;
import org.eclipse.mylyn.internal.wikitext.ui.util.css.editor.CssConfiguration;
import org.eclipse.mylyn.internal.wikitext.ui.util.css.editor.CssPartitioner;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.HtmlTextPresentationParser;
import org.eclipse.mylyn.wikitext.parser.css.CssParser;
import org.eclipse.mylyn.wikitext.ui.viewer.HtmlViewer;
import org.eclipse.mylyn.wikitext.ui.viewer.HtmlViewerConfiguration;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.progress.UIJob;
import org.xml.sax.SAXException;

public class MarkupViewerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String WHITE = "white";
    private SourceViewer sourceViewer;
    private Colors colorRegistry;
    private HtmlViewer previewViewer;
    private UIJob previewUpdateJob;
    private HtmlViewerConfiguration htmlViewerConfiguration;

    public MarkupViewerPreferencePage() {
        super(Messages.MarkupViewerPreferencePage_appearance);
    }

    protected Control createContents(Composite parent) {
        this.colorRegistry = new Colors();
        this.colorRegistry.put(WHITE, new RGB(255, 255, 255));
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(1).applyTo(composite);
        Label label = new Label(composite, 64);
        label.setText(Messages.MarkupViewerPreferencePage_appearanceInfo);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        Preferences preferences = WikiTextUiPlugin.getDefault().getPreferences();
        Composite viewerContainer = new Composite(composite, 2048);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(1).applyTo(viewerContainer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)viewerContainer);
        this.sourceViewer = new SourceViewer(viewerContainer, (IVerticalRuler)new VerticalRuler(0), 576);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.sourceViewer.getControl());
        Document document = new Document(preferences.getMarkupViewerCss());
        CssPartitioner partitioner = new CssPartitioner();
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        this.sourceViewer.setDocument((IDocument)document);
        CssConfiguration configuration = new CssConfiguration((ColorRegistry)this.colorRegistry);
        this.sourceViewer.configure((SourceViewerConfiguration)configuration);
        label = new Label(composite, 64);
        label.setText(Messages.MarkupViewerPreferencePage_preview);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.applyDialogFont(composite);
        Composite previewViewerContainer = new Composite(composite, 2048);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(1).applyTo(previewViewerContainer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)previewViewerContainer);
        this.previewViewer = new HtmlViewer(previewViewerContainer, (IVerticalRuler)new VerticalRuler(0), 576);
        this.previewViewer.getTextWidget().setBackground(this.colorRegistry.get(WHITE));
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.previewViewer.getControl());
        this.htmlViewerConfiguration = new HtmlViewerConfiguration(this.previewViewer);
        this.previewViewer.configure((SourceViewerConfiguration)this.htmlViewerConfiguration);
        this.previewViewer.getTextWidget().setEditable(false);
        this.previewViewer.setStylesheet(preferences.getStylesheet());
        if (JFaceResources.getFontRegistry().hasValueFor("org.eclipse.mylyn.tasks.ui.fonts.task.editor.comment")) {
            this.previewViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.mylyn.tasks.ui.fonts.task.editor.comment"));
        }
        if (JFaceResources.getFontRegistry().hasValueFor("org.eclipse.mylyn.wikitext.tasks.ui.monospaceFont")) {
            this.previewViewer.setDefaultMonospaceFont(JFaceResources.getFontRegistry().get("org.eclipse.mylyn.wikitext.tasks.ui.monospaceFont"));
        }
        this.previewViewer.setHtml(this.createPreviewHtml());
        this.sourceViewer.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                MarkupViewerPreferencePage.this.schedulePreviewUpdate();
            }
        });
        return composite;
    }

    private String createPreviewHtml() {
        return Messages.MarkupViewerPreferencePage_previewHtml;
    }

    private void updatePreview() {
        TextPresentation textPresentation = new TextPresentation();
        HtmlTextPresentationParser parser = new HtmlTextPresentationParser();
        parser.setDefaultFont(this.previewViewer.getTextWidget().getFont());
        parser.setAnnotationModel(this.previewViewer.getAnnotationModel());
        parser.setPresentation(textPresentation);
        parser.setStylesheet(new CssParser().parse(this.sourceViewer.getDocument().get()));
        GC gc = new GC((Drawable)this.previewViewer.getTextWidget());
        try {
            try {
                parser.setGC(gc);
                parser.parse(this.createPreviewHtml());
            }
            catch (IOException | SAXException e) {
                throw new IllegalStateException(e);
            }
        }
        finally {
            gc.dispose();
        }
        this.htmlViewerConfiguration.setTextPresentation(textPresentation);
        this.previewViewer.changeTextPresentation(textPresentation, true);
    }

    public void dispose() {
        if (this.colorRegistry != null) {
            this.colorRegistry.dispose();
            this.colorRegistry = null;
        }
        super.dispose();
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        Preferences preferences = WikiTextUiPlugin.getDefault().getPreferences().clone();
        preferences.setMarkupViewerCss(this.sourceViewer.getDocument().get());
        preferences.save(WikiTextUiPlugin.getDefault().getPreferenceStore(), false);
        return super.performOk();
    }

    protected void performDefaults() {
        this.sourceViewer.getDocument().set(new Preferences().getMarkupViewerCss());
        super.performDefaults();
        this.schedulePreviewUpdate();
    }

    private void schedulePreviewUpdate() {
        if (this.previewUpdateJob != null) {
            this.previewUpdateJob.cancel();
        }
        this.previewUpdateJob = new UIJob(Display.getCurrent(), Messages.MarkupViewerPreferencePage_updatePreview){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                MarkupViewerPreferencePage.this.previewUpdateJob = null;
                MarkupViewerPreferencePage.this.updatePreview();
                return Status.OK_STATUS;
            }
        };
        this.previewUpdateJob.schedule(400L);
    }

    private static class Colors
    extends ColorRegistry {
        public Colors() {
            super(Display.getCurrent(), false);
        }

        public void dispose() {
            super.clearCaches();
        }
    }
}

