/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework.osgi;

import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class OSGIPolicy
extends Policy {
    private Policy policy;
    private URL[] urls;
    private PermissionCollection allPermissions;
    Permission allPermission = new AllPermission();

    OSGIPolicy(Policy policy, URL[] urls) {
        this.policy = policy;
        this.urls = urls;
        this.allPermissions = new PermissionCollection(){
            private static final long serialVersionUID = 3258131349494708277L;

            @Override
            public void add(Permission permission) {
            }

            @Override
            public boolean implies(Permission permission) {
                return true;
            }

            public Enumeration elements() {
                return new Enumeration(){
                    int cur = 0;

                    @Override
                    public boolean hasMoreElements() {
                        return this.cur < 1;
                    }

                    public Object nextElement() {
                        if (this.cur == 0) {
                            this.cur = 1;
                            return (this).OSGIPolicy.this.allPermission;
                        }
                        throw new NoSuchElementException();
                    }
                };
            }
        };
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        if (this.contains(codesource.getLocation())) {
            return this.allPermissions;
        }
        return this.policy == null ? this.allPermissions : this.policy.getPermissions(codesource);
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        if (this.contains(domain.getCodeSource().getLocation())) {
            return this.allPermissions;
        }
        return this.policy == null ? this.allPermissions : this.policy.getPermissions(domain);
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        if (this.contains(domain.getCodeSource().getLocation())) {
            return true;
        }
        return this.policy == null ? true : this.policy.implies(domain, permission);
    }

    @Override
    public void refresh() {
        if (this.policy != null) {
            this.policy.refresh();
        }
    }

    private boolean contains(URL url) {
        int i = 0;
        while (i < this.urls.length) {
            if (this.urls[i] == url) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

