/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.colors;

import org.eclipse.lemminx.extensions.colors.participants.XMLDocumentColorParticipant;
import org.eclipse.lemminx.extensions.colors.settings.XMLColorsSettings;
import org.eclipse.lemminx.services.extensions.IDocumentColorParticipant;
import org.eclipse.lemminx.services.extensions.IXMLExtension;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lsp4j.InitializeParams;

public class XMLColorsPlugin
implements IXMLExtension {
    private final IDocumentColorParticipant documentColorParticipant = new XMLDocumentColorParticipant(this);
    private XMLColorsSettings colorsSettings;

    @Override
    public void doSave(ISaveContext context) {
        if (context.getType() != ISaveContext.SaveContextType.DOCUMENT) {
            this.updateSettings(context);
        }
    }

    private void updateSettings(ISaveContext saveContext) {
        Object initializationOptionsSettings = saveContext.getSettings();
        XMLColorsSettings referencesSettings = XMLColorsSettings.getXMLColorsSettings(initializationOptionsSettings);
        this.updateSettings(referencesSettings, saveContext);
    }

    private void updateSettings(XMLColorsSettings settings, ISaveContext context) {
        this.colorsSettings = settings;
    }

    @Override
    public void start(InitializeParams params, XMLExtensionsRegistry registry) {
        registry.registerDocumentColorParticipant(this.documentColorParticipant);
    }

    @Override
    public void stop(XMLExtensionsRegistry registry) {
        registry.unregisterDocumentColorParticipant(this.documentColorParticipant);
    }

    public XMLColorsSettings getColorsSettings() {
        return this.colorsSettings;
    }
}

