/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.connector.telnet.launcher;

import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.terminal.connector.ISettingsStore;
import org.eclipse.terminal.connector.ITerminalConnector;
import org.eclipse.terminal.connector.InMemorySettingsStore;
import org.eclipse.terminal.connector.TerminalConnectorExtension;
import org.eclipse.terminal.connector.telnet.connector.TelnetSettings;
import org.eclipse.terminal.connector.telnet.controls.TelnetWizardConfigurationPanel;
import org.eclipse.terminal.connector.telnet.launcher.TelnetMementoHandler;
import org.eclipse.terminal.connector.telnet.nls.Messages;
import org.eclipse.terminal.view.ui.IMementoHandler;
import org.eclipse.terminal.view.ui.launcher.AbstractLauncherDelegate;
import org.eclipse.terminal.view.ui.launcher.IConfigurationPanel;
import org.eclipse.terminal.view.ui.launcher.IConfigurationPanelContainer;

public class TelnetLauncherDelegate
extends AbstractLauncherDelegate {
    private final IMementoHandler mementoHandler = new TelnetMementoHandler();

    public boolean needsUserConfiguration() {
        return true;
    }

    public IConfigurationPanel getPanel(IConfigurationPanelContainer container) {
        return new TelnetWizardConfigurationPanel(container);
    }

    public CompletableFuture<?> execute(Map<String, Object> properties) {
        Assert.isNotNull(properties);
        String terminalTitle = this.getTerminalTitle(properties);
        if (terminalTitle != null) {
            properties.put("title", terminalTitle);
        }
        if (!properties.containsKey("terminal.forceNew")) {
            properties.put("terminal.forceNew", Boolean.TRUE);
        }
        try {
            return this.getTerminalService().openConsole(properties);
        }
        catch (RuntimeException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private String getTerminalTitle(Map<String, Object> properties) {
        String title = this.getDefaultTerminalTitle(properties);
        if (title != null) {
            return title;
        }
        String host = (String)properties.get("ip.host");
        if (host != null) {
            DateFormat format = DateFormat.getDateTimeInstance(3, 3);
            String date = format.format(new Date(System.currentTimeMillis()));
            return NLS.bind((String)Messages.TelnetLauncherDelegate_terminalTitle, (Object[])new String[]{host, date});
        }
        return Messages.TelnetLauncherDelegate_terminalTitle_default;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IMementoHandler.class.equals(adapter)) {
            return adapter.cast(this.mementoHandler);
        }
        return (T)super.getAdapter(adapter);
    }

    public ITerminalConnector createTerminalConnector(Map<String, Object> properties) throws CoreException {
        Assert.isNotNull(properties);
        String connectorId = (String)properties.get("tm.terminal.connector.id");
        if (connectorId == null) {
            connectorId = "org.eclipse.terminal.connector.telnet.TelnetConnector";
        }
        String host = (String)properties.get("ip.host");
        Object value = properties.get("ip.port");
        String port = value != null ? value.toString() : null;
        value = properties.get("timeout");
        String timeout = value != null ? value.toString() : null;
        String endOfLine = (String)properties.get("telnet.eol");
        int portOffset = 0;
        if (properties.get("ip.port.offset") instanceof Integer && (portOffset = ((Integer)properties.get("ip.port.offset")).intValue()) < 0) {
            portOffset = 0;
        }
        if (port != null) {
            port = Integer.toString(Integer.decode(port) + portOffset);
        }
        InMemorySettingsStore store = new InMemorySettingsStore();
        TelnetSettings telnetSettings = new TelnetSettings();
        telnetSettings.setHost(host);
        telnetSettings.setNetworkPort(port);
        if (timeout != null) {
            telnetSettings.setTimeout(timeout);
        }
        telnetSettings.setEndOfLine(endOfLine);
        telnetSettings.save((ISettingsStore)store);
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        connector.setDefaultSettings();
        connector.load((ISettingsStore)store);
        return connector;
    }
}

