/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc;

import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.wikitext.asciidoc.AsciiDocMarkupLanguageConfiguration;
import org.eclipse.mylyn.wikitext.asciidoc.internal.AsciiDocContentState;
import org.eclipse.mylyn.wikitext.asciidoc.internal.AsciiDocDocumentBuilder;
import org.eclipse.mylyn.wikitext.asciidoc.internal.AsciiDocIdGenerationStrategy;
import org.eclipse.mylyn.wikitext.asciidoc.internal.block.AttributeDefinitionBlock;
import org.eclipse.mylyn.wikitext.asciidoc.internal.block.CodeBlock;
import org.eclipse.mylyn.wikitext.asciidoc.internal.block.CommentBlock;
import org.eclipse.mylyn.wikitext.asciidoc.internal.block.DefinitionListBlock;
import org.eclipse.mylyn.wikitext.asciidoc.internal.block.HeadingBlock;
import org.eclipse.mylyn.wikitext.asciidoc.internal.block.HorizontalRuleBlock;
import org.eclipse.mylyn.wikitext.asciidoc.internal.block.ListBlock;
import org.eclipse.mylyn.wikitext.asciidoc.internal.block.ParagraphBlock;
import org.eclipse.mylyn.wikitext.asciidoc.internal.block.PreformattedBlock;
import org.eclipse.mylyn.wikitext.asciidoc.internal.block.PropertiesLineBlock;
import org.eclipse.mylyn.wikitext.asciidoc.internal.block.TableBlock;
import org.eclipse.mylyn.wikitext.asciidoc.internal.block.TableOfContentsBlock;
import org.eclipse.mylyn.wikitext.asciidoc.internal.block.TitleLineBlock;
import org.eclipse.mylyn.wikitext.asciidoc.internal.block.UnderlinedHeadingBlock;
import org.eclipse.mylyn.wikitext.asciidoc.internal.phrase.BackslashEscapePhraseModifier;
import org.eclipse.mylyn.wikitext.asciidoc.internal.phrase.CssClassPhraseModifier;
import org.eclipse.mylyn.wikitext.asciidoc.internal.phrase.SimplePhraseModifier;
import org.eclipse.mylyn.wikitext.asciidoc.internal.token.AnchorLinkMacroReplacementToken;
import org.eclipse.mylyn.wikitext.asciidoc.internal.token.AnchorLinkReplacementToken;
import org.eclipse.mylyn.wikitext.asciidoc.internal.token.EmailLinkReplacementToken;
import org.eclipse.mylyn.wikitext.asciidoc.internal.token.ExplicitLinkReplacementToken;
import org.eclipse.mylyn.wikitext.asciidoc.internal.token.ImplicitFormattedLinkReplacementToken;
import org.eclipse.mylyn.wikitext.asciidoc.internal.token.ImplicitLinkReplacementToken;
import org.eclipse.mylyn.wikitext.asciidoc.internal.token.InlineAttributeReplacementToken;
import org.eclipse.mylyn.wikitext.asciidoc.internal.token.InlineCommentReplacementToken;
import org.eclipse.mylyn.wikitext.asciidoc.internal.token.InlineEscapedAttributeReplacementToken;
import org.eclipse.mylyn.wikitext.asciidoc.internal.token.InlineImageReplacementToken;
import org.eclipse.mylyn.wikitext.asciidoc.internal.token.PreserverHtmlEntityToken;
import org.eclipse.mylyn.wikitext.asciidoc.internal.token.XrefMacroReplacementToken;
import org.eclipse.mylyn.wikitext.asciidoc.internal.token.XrefReplacementToken;
import org.eclipse.mylyn.wikitext.asciidoc.internal.util.ReadAheadDispatcher;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.Block;
import org.eclipse.mylyn.wikitext.parser.markup.ContentState;
import org.eclipse.mylyn.wikitext.parser.markup.IdGenerationStrategy;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.token.PatternLineBreakReplacementToken;

public class AsciiDocLanguage
extends AbstractMarkupLanguage {
    public AsciiDocLanguage() {
        this.setName("AsciiDoc");
    }

    protected ContentState createState() {
        Map<String, String> initialAttributes;
        AsciiDocContentState state = new AsciiDocContentState();
        this.putInitialAttributes(state);
        if (this.configuration instanceof AsciiDocMarkupLanguageConfiguration && (initialAttributes = ((AsciiDocMarkupLanguageConfiguration)this.configuration).getInitialAttributes()) != null) {
            for (Map.Entry<String, String> e : initialAttributes.entrySet()) {
                state.putAttribute(e.getKey(), e.getValue());
            }
        }
        return state;
    }

    private void putInitialAttributes(AsciiDocContentState state) {
        state.putAttribute("idprefix", "_");
        state.putAttribute("idseparator", "_");
        state.putAttribute("imagesdir", "");
    }

    public IdGenerationStrategy getIdGenerationStrategy() {
        return new AsciiDocIdGenerationStrategy();
    }

    protected void addStandardTokens(AbstractMarkupLanguage.PatternBasedSyntax tokenSyntax) {
        tokenSyntax.add((PatternBasedElement)new PreserverHtmlEntityToken());
        tokenSyntax.add((PatternBasedElement)new PatternLineBreakReplacementToken("(\\s\\+)\\s*$"));
    }

    protected void addStandardPhraseModifiers(AbstractMarkupLanguage.PatternBasedSyntax phraseModifierSyntax) {
        phraseModifierSyntax.add((PatternBasedElement)new InlineAttributeReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new InlineEscapedAttributeReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new InlineCommentReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new EmailLinkReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new ExplicitLinkReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new ImplicitFormattedLinkReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new ImplicitLinkReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new AnchorLinkReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new AnchorLinkMacroReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new XrefReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new XrefMacroReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("++"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("**"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("__"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("+"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("*"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("_"));
        phraseModifierSyntax.add((PatternBasedElement)new InlineImageReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("+++", DocumentBuilder.SpanType.SPAN, SimplePhraseModifier.Mode.SPECIAL));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("``", DocumentBuilder.SpanType.CODE, SimplePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("++", DocumentBuilder.SpanType.SPAN, SimplePhraseModifier.Mode.NORMAL));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("**", DocumentBuilder.SpanType.STRONG, SimplePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("__", DocumentBuilder.SpanType.EMPHASIS, SimplePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.beginGroup("(?:(?<=\\W)|^)(?:", 0);
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("*", DocumentBuilder.SpanType.STRONG, SimplePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("_", DocumentBuilder.SpanType.EMPHASIS, SimplePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("`", DocumentBuilder.SpanType.CODE, SimplePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("+", DocumentBuilder.SpanType.SPAN, SimplePhraseModifier.Mode.NORMAL));
        phraseModifierSyntax.add((PatternBasedElement)new CssClassPhraseModifier());
        phraseModifierSyntax.endGroup(")(?:(?=\\W)|$)", 0);
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("^", DocumentBuilder.SpanType.SUPERSCRIPT, SimplePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("~", DocumentBuilder.SpanType.SUBSCRIPT, SimplePhraseModifier.Mode.NESTING));
    }

    protected void addStandardBlocks(List<Block> blocks, List<Block> paragraphBreakingBlocks) {
        ListBlock listBlock = new ListBlock();
        blocks.add(listBlock);
        paragraphBreakingBlocks.add(listBlock);
        AttributeDefinitionBlock attributeDefinition = new AttributeDefinitionBlock();
        TitleLineBlock titleLineBlock = new TitleLineBlock();
        PropertiesLineBlock propertiesLineBlock = new PropertiesLineBlock();
        TableBlock tableBlock = new TableBlock();
        PreformattedBlock preformattedBlock = new PreformattedBlock();
        CommentBlock commentBlock = new CommentBlock();
        HeadingBlock headingBlock = new HeadingBlock();
        CodeBlock codeBlock = new CodeBlock();
        HorizontalRuleBlock hrBlock = new HorizontalRuleBlock();
        blocks.add(attributeDefinition);
        blocks.add(titleLineBlock);
        blocks.add(propertiesLineBlock);
        blocks.add(tableBlock);
        blocks.add(preformattedBlock);
        blocks.add(headingBlock);
        blocks.add(codeBlock);
        blocks.add(commentBlock);
        blocks.add(hrBlock);
        paragraphBreakingBlocks.add(codeBlock);
        paragraphBreakingBlocks.add(commentBlock);
        paragraphBreakingBlocks.add(preformattedBlock);
        DefinitionListBlock definitionListBlock = new DefinitionListBlock();
        blocks.add(definitionListBlock);
        paragraphBreakingBlocks.add(definitionListBlock);
        TableOfContentsBlock tocBlock = new TableOfContentsBlock();
        blocks.add((Block)tocBlock);
    }

    protected Block createParagraphBlock() {
        ParagraphBlock paragraphBlock = new ParagraphBlock();
        UnderlinedHeadingBlock headingBlock = new UnderlinedHeadingBlock();
        ReadAheadDispatcher readAheadBlock = new ReadAheadDispatcher(headingBlock, paragraphBlock);
        return readAheadBlock;
    }

    public DocumentBuilder createDocumentBuilder(Writer out, boolean formatting) {
        return new AsciiDocDocumentBuilder(out);
    }
}

