/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.context;

import com.ibm.icu.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.context.ContextRetrieveWizard;
import org.eclipse.mylyn.internal.tasks.ui.context.Messages;
import org.eclipse.mylyn.internal.tasks.ui.context.ProgressContainer;
import org.eclipse.mylyn.internal.tasks.ui.context.TaskAttachmentComparator;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class RetrieveLatestContextDialog
extends MessageDialog {
    private final ITaskAttachment attachment;
    private Link link;
    private ProgressContainer progressContainer;
    private ProgressMonitorPart progressMonitorPart;
    private final ITask task;

    public static boolean openQuestion(Shell shell, ITask task) {
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        List<ITaskAttachment> contextAttachments = AttachmentUtil.getContextAttachments(repository, task);
        Collections.sort(contextAttachments, new TaskAttachmentComparator());
        if (contextAttachments.size() > 0) {
            ITaskAttachment attachment = contextAttachments.get(0);
            String author = null;
            if (attachment.getAuthor() != null) {
                String string = author = attachment.getAuthor().getName() != null ? attachment.getAuthor().getName() : attachment.getAuthor().getPersonId();
            }
            if (author == null) {
                author = Messages.RetrieveLatestContextDialog_Unknown;
            }
            Date date = attachment.getCreationDate();
            String dateString = null;
            if (date != null) {
                dateString = DateFormat.getDateInstance((int)1).format(date);
            }
            if (dateString == null) {
                dateString = Messages.RetrieveLatestContextDialog_Unknown;
            }
            String message = NLS.bind((String)Messages.RetrieveLatestContextDialog_No_local_context_exists, (Object)author, (Object)dateString);
            int kind = 3;
            int style = 0;
            RetrieveLatestContextDialog dialog = new RetrieveLatestContextDialog(shell, Messages.RetrieveLatestContextDialog_Dialog_Title, null, message, kind, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0, task, attachment);
            dialog.setShellStyle(dialog.getShellStyle() | (style &= 0x10000000));
            return dialog.open() == 0;
        }
        return false;
    }

    public RetrieveLatestContextDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, ITask task, ITaskAttachment attachment) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.task = task;
        this.attachment = attachment;
    }

    protected void buttonPressed(int buttonId) {
        if (this.progressContainer.isActive()) {
            return;
        }
        if (buttonId == 0 && !AttachmentUtil.downloadContext(this.task, this.attachment, this.progressContainer)) {
            return;
        }
        super.buttonPressed(buttonId);
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)composite);
        Control control = this.createLink(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(control);
        super.createButtonBar(composite);
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.progressContainer.setCancelButton(this.getButton(1));
        this.getButton(0).setFocus();
        return control;
    }

    protected Control createCustomArea(Composite parent) {
        this.progressMonitorPart = new ProgressMonitorPart(parent, null);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.progressMonitorPart);
        this.progressContainer = new ProgressContainer(this.getShell(), this.progressMonitorPart){

            @Override
            protected void restoreUiState(Map<Object, Object> state) {
                RetrieveLatestContextDialog.this.link.setEnabled(true);
                RetrieveLatestContextDialog.this.getButton(0).setEnabled(true);
                RetrieveLatestContextDialog.this.getButton(1).setEnabled(true);
            }

            @Override
            protected void saveUiState(Map<Object, Object> savedState) {
                RetrieveLatestContextDialog.this.link.setEnabled(false);
                RetrieveLatestContextDialog.this.getButton(0).setEnabled(false);
            }
        };
        return this.progressMonitorPart;
    }

    protected Control createLink(Composite parent) {
        this.link = new Link(parent, 0);
        this.link.setText(Messages.RetrieveLatestContextDialog_Show_All_Contexts_Label);
        this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrieveLatestContextDialog.this.close();
                ContextRetrieveWizard wizard = new ContextRetrieveWizard(RetrieveLatestContextDialog.this.task);
                WizardDialog dialog = new WizardDialog(WorkbenchUtil.getShell(), (IWizard)wizard);
                dialog.create();
                dialog.setBlockOnOpen(true);
                RetrieveLatestContextDialog.this.setReturnCode(dialog.open());
            }
        });
        return this.link;
    }
}

