/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.wizards;

import org.eclipse.cdt.autotools.core.AutotoolsNewProjectNature;
import org.eclipse.cdt.autotools.ui.AutotoolsUIPlugin;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.autotools.core.AutotoolsPropertyConstants;
import org.eclipse.cdt.internal.autotools.core.configure.AutotoolsConfigurationManager;
import org.eclipse.cdt.internal.autotools.ui.wizards.ConvertToAutotoolsProjectWizard;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.ui.wizards.conversion.ConvertProjectWizardPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class ConvertToAutotoolsProjectWizardPage
extends ConvertProjectWizardPage {
    private static final String PREFIX = "WizardAutotoolsProjectConversion";
    private static final String WZ_TITLE = "WizardAutotoolsProjectConversion.title";
    private static final String WZ_DESC = "WizardAutotoolsProjectConversion.description";
    protected static final String MSG_ADD_NATURE = "WizardAutotoolsProjectConversion.message.add_nature";
    protected static final String MSG_ADD_BUILDER = "WizardAutotoolsProjectConversion.message.add_builder";
    protected static final String MSG_SAVE = "WizardAutotoolsProjectConversion.message.save";

    public ConvertToAutotoolsProjectWizardPage(String pageName, ConvertToAutotoolsProjectWizard wizard) {
        super(pageName);
        this.setWizard((IWizard)wizard);
    }

    protected String getWzTitleResource() {
        return AutotoolsUIPlugin.getResourceString(WZ_TITLE);
    }

    protected String getWzDescriptionResource() {
        return AutotoolsUIPlugin.getResourceString(WZ_DESC);
    }

    public boolean isCandidate(IProject project) {
        return true;
    }

    protected IProjectType getProjectType() {
        return ((ConvertToAutotoolsProjectWizard)this.getWizard()).getProjectType();
    }

    protected IConfiguration[] getSelectedConfigurations() {
        return ((ConvertToAutotoolsProjectWizard)this.getWizard()).getSelectedConfigurations();
    }

    protected void applyOptions(IProject project, IProgressMonitor monitor) {
        ((ConvertToAutotoolsProjectWizard)this.getWizard()).applyOptions(project, monitor);
    }

    public void convertProject(IProject project, IProgressMonitor monitor, String projectID) throws CoreException {
        monitor.beginTask(AutotoolsUIPlugin.getResourceString("WizardMakeProjectConversion.monitor.convertingToMakeProject"), 7);
        IConfiguration defaultCfg = null;
        Boolean convertingNewAutotoolsProject = false;
        try {
            super.convertProject(project, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1), projectID);
            if (project.hasNature("org.eclipse.cdt.autotools.core.autotoolsNatureV2")) {
                convertingNewAutotoolsProject = true;
                return;
            }
            monitor.subTask(AutotoolsUIPlugin.getResourceString(MSG_ADD_NATURE));
            ManagedCProjectNature.addManagedNature((IProject)project, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            AutotoolsNewProjectNature.addAutotoolsNature((IProject)project, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            AutotoolsNewProjectNature.removeOldAutotoolsNature((IProject)project, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            monitor.subTask(AutotoolsUIPlugin.getResourceString(MSG_ADD_BUILDER));
            AutotoolsNewProjectNature.addAutotoolsBuilder((IProject)project, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            project.setPersistentProperty(AutotoolsPropertyConstants.SCANNER_USE_MAKE_W, "true");
            CCorePlugin.getDefault().mapCProjectOwner(project, projectID, false);
            IManagedProject newManagedProject = null;
            ManagedBuildInfo info = null;
            try {
                info = ManagedBuildManager.createBuildInfo((IResource)project);
                IProjectType parent = this.getProjectType();
                newManagedProject = ManagedBuildManager.createManagedProject((IResource)project, (IProjectType)parent);
                if (newManagedProject != null) {
                    IConfiguration[] selectedConfigs = this.getSelectedConfigurations();
                    int i = 0;
                    while (i < selectedConfigs.length) {
                        IConfiguration config = selectedConfigs[i];
                        int id = ManagedBuildManager.getRandomNumber();
                        IConfiguration newConfig = newManagedProject.createConfiguration(config, config.getId() + "." + id);
                        newConfig.setArtifactName(newManagedProject.getDefaultArtifactName());
                        ++i;
                    }
                    IConfiguration[] newConfigs = newManagedProject.getConfigurations();
                    int i2 = 0;
                    while (i2 < newConfigs.length) {
                        if (newConfigs[i2].isSupported()) {
                            defaultCfg = newConfigs[i2];
                            break;
                        }
                        ++i2;
                    }
                    if (defaultCfg == null && newConfigs.length > 0) {
                        defaultCfg = newConfigs[0];
                    }
                    if (defaultCfg != null) {
                        ManagedBuildManager.setDefaultConfiguration((IProject)project, defaultCfg);
                        ManagedBuildManager.setSelectedConfiguration((IProject)project, (IConfiguration)defaultCfg);
                    }
                    ManagedBuildManager.setNewProjectVersion((IProject)project);
                }
            }
            catch (BuildException e) {
                AutotoolsUIPlugin.log(e);
            }
            if (project != null) {
                this.applyOptions(project, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)2));
            }
            monitor.subTask(AutotoolsUIPlugin.getResourceString(MSG_SAVE));
            if (info != null) {
                info.setValid(true);
                ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
            }
        }
        finally {
            if (!convertingNewAutotoolsProject.booleanValue()) {
                ICConfigurationDescription cfgd = ManagedBuildManager.getDescriptionForConfiguration(defaultCfg);
                String id = cfgd.getId();
                AutotoolsConfigurationManager.getInstance().getConfiguration(project, id, true);
                AutotoolsConfigurationManager.getInstance().saveConfigs(project);
                IStatus initResult = ManagedBuildManager.initBuildInfoContainer((IResource)project);
                if (initResult.getCode() != 0) {
                    AutotoolsUIPlugin.log(initResult);
                }
            }
            monitor.done();
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        IStructuredSelection sel = ((BasicNewResourceWizard)this.getWizard()).getSelection();
        if (sel != null) {
            this.tableViewer.setCheckedElements(sel.toArray());
            this.setPageComplete(this.validatePage());
        }
    }
}

