/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.analysis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.Activator;

public final class TmfAnalysisOutputManager {
    private static @Nullable TmfAnalysisOutputManager fManager = null;
    private final Map<String, Map<String, Set<String>>> fExclusionList = new HashMap<String, Map<String, Set<String>>>();

    public static TmfAnalysisOutputManager getInstance() {
        TmfAnalysisOutputManager manager = fManager;
        if (manager == null) {
            fManager = manager = new TmfAnalysisOutputManager();
        }
        return manager;
    }

    public void loadExclusion(IConfigurationElement ce) {
        String moduleId = ce.getAttribute("analysis_module");
        String parentPluginId = ((IExtension)ce.getParent()).getNamespaceIdentifier();
        if (moduleId == null) {
            Activator.logWarning(String.format("plugin: %s loadExclusion issue: Analysis module ID not present", parentPluginId));
            return;
        }
        String ttid = ce.getAttribute("tracetype");
        if (ttid == null) {
            Activator.logWarning(String.format("plugin: %s loadExclusion issue: Analysis tracetype not present", parentPluginId));
            return;
        }
        String output = ce.getAttribute("output");
        if (output == null) {
            Activator.logWarning(String.format("plugin: %s loadExclusion issue: output ID not present", parentPluginId));
            return;
        }
        Map map = this.fExclusionList.computeIfAbsent(ttid, s -> new HashMap());
        Set set = map.computeIfAbsent(moduleId, s -> new HashSet());
        Activator.log((IStatus)new Status(1, "org.eclipse.tracecompass.tmf.core", String.format("Plugin: %s is hiding (%s, %s, %s).", parentPluginId, ttid, moduleId, output)));
        set.add(output);
    }

    public boolean isHidden(String tracetype, String analysisId, String outputId) {
        Map<String, Set<String>> map = this.fExclusionList.get(tracetype);
        if (map == null) {
            return false;
        }
        Set<String> set = map.get(analysisId);
        return set != null && set.contains(outputId);
    }
}

