/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.AggregateWorkingSet;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.AbstractWorkingSetDialog;
import org.eclipse.ui.internal.dialogs.WorkingSetFilter;
import org.eclipse.ui.internal.dialogs.WorkingSetLabelProvider;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class WorkingSetSelectionDialog
extends AbstractWorkingSetDialog {
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 50;
    private final ILabelProvider labelProvider;
    private final IStructuredContentProvider contentProvider;
    private CheckboxTableViewer listViewer;
    private final boolean multiSelect;
    private IWorkbenchWindow workbenchWindow;
    private Button buttonWindowSet;
    private Button buttonNoSet;
    private Button buttonSelectedSets;

    public WorkingSetSelectionDialog(Shell parentShell, boolean multi, String[] workingSetIds) {
        super(parentShell, workingSetIds, true);
        this.initWorkbenchWindow();
        this.contentProvider = ArrayContentProvider.getInstance();
        this.labelProvider = new WorkingSetLabelProvider();
        this.multiSelect = multi;
        if (this.multiSelect) {
            this.setTitle(WorkbenchMessages.WorkingSetSelectionDialog_title_multiSelect);
            this.setMessage(WorkbenchMessages.WorkingSetSelectionDialog_message_multiSelect);
        } else {
            this.setTitle(WorkbenchMessages.WorkingSetSelectionDialog_title);
            this.setMessage(WorkbenchMessages.WorkingSetSelectionDialog_message);
        }
    }

    private void initWorkbenchWindow() {
        Shell shellToCheck = this.getShell();
        this.workbenchWindow = Util.getWorkbenchWindowForShell(shellToCheck);
    }

    protected void cancelPressed() {
        this.restoreAddedWorkingSets();
        this.restoreChangedWorkingSets();
        this.restoreRemovedWorkingSets();
        this.setSelection(null);
        super.cancelPressed();
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.working_set_selection_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        ButtonFactory buttonFactory = WidgetFactory.button((int)16).onSelect(e -> this.updateButtonAvailability());
        this.buttonWindowSet = (Button)((ButtonFactory)buttonFactory.text(WorkbenchMessages.WindowWorkingSets).layoutData((Object)new GridData(768))).create((Widget)composite);
        this.buttonNoSet = (Button)((ButtonFactory)buttonFactory.text(WorkbenchMessages.NoWorkingSet).layoutData((Object)new GridData(768))).create((Widget)composite);
        this.buttonSelectedSets = (Button)buttonFactory.text(WorkbenchMessages.SelectedWorkingSets).create((Widget)composite);
        switch (this.getInitialRadioSelection()) {
            case 0: {
                this.buttonWindowSet.setSelection(true);
                break;
            }
            case 1: {
                this.buttonNoSet.setSelection(true);
                break;
            }
            case 2: {
                this.buttonSelectedSets.setSelection(true);
            }
        }
        this.buttonSelectedSets.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        GridData data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 350;
        Composite viewerComposite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)layout)).layoutData((Object)data)).create((Widget)composite);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)viewerComposite, (int)2050);
        data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 50;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.listViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.listViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        this.listViewer.addFilter((ViewerFilter)new WorkingSetFilter(this.getSupportedWorkingSetIds()));
        this.listViewer.addSelectionChangedListener(event -> this.handleSelectionChanged());
        this.listViewer.addDoubleClickListener(event -> {
            Object obj = this.listViewer.getStructuredSelection().getFirstElement();
            this.listViewer.setCheckedElements(new Object[]{obj});
            this.buttonWindowSet.setSelection(false);
            this.buttonNoSet.setSelection(false);
            this.buttonSelectedSets.setSelection(true);
            this.okPressed();
        });
        this.listViewer.addCheckStateListener(event -> {
            this.buttonWindowSet.setSelection(false);
            this.buttonNoSet.setSelection(false);
            this.buttonSelectedSets.setSelection(true);
        });
        this.addModifyButtons(viewerComposite);
        this.addSelectionButtons(composite);
        this.listViewer.setInput(Arrays.asList(WorkbenchPlugin.getDefault().getWorkingSetManager().getWorkingSets()));
        List initialElementSelections = this.getInitialElementSelections();
        if (this.multiSelect) {
            this.listViewer.setCheckedElements(initialElementSelections.toArray());
        } else if (!initialElementSelections.isEmpty()) {
            IWorkingSet set = (IWorkingSet)initialElementSelections.get(0);
            if (set instanceof AggregateWorkingSet) {
                AggregateWorkingSet aggregate = (AggregateWorkingSet)set;
                this.listViewer.setCheckedElements((Object[])aggregate.getComponents());
            } else {
                this.listViewer.setCheckedElements(initialElementSelections.toArray());
            }
        }
        this.availableWorkingSetsChanged();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private int getInitialRadioSelection() {
        IWorkingSet windowSet = this.workbenchWindow.getActivePage().getAggregateWorkingSet();
        int selectionIndex = this.getSelection() != null && this.getSelection().length > 0 ? (windowSet.equals(this.getSelection()[0]) ? 0 : 2) : 1;
        return selectionIndex;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        List selections = this.getInitialElementSelections();
        if (!selections.isEmpty()) {
            this.listViewer.setSelection((ISelection)new StructuredSelection(selections), true);
        }
        this.updateButtonAvailability();
        return control;
    }

    protected List getSelectedWorkingSets() {
        return this.listViewer.getStructuredSelection().toList();
    }

    void handleSelectionChanged() {
        this.updateButtonAvailability();
    }

    protected void okPressed() {
        if (this.buttonWindowSet.getSelection()) {
            IWorkingSet[] windowSet = new IWorkingSet[]{this.workbenchWindow.getActivePage().getAggregateWorkingSet()};
            this.setSelection(windowSet);
            this.setResult(Arrays.asList(this.getSelection()));
        } else if (this.buttonNoSet.getSelection()) {
            this.setSelection(new IWorkingSet[0]);
            this.setResult(Arrays.asList(this.getSelection()));
        } else if (this.buttonSelectedSets.getSelection()) {
            Object[] untypedResult = this.listViewer.getCheckedElements();
            IWorkingSet[] typedResult = new IWorkingSet[untypedResult.length];
            System.arraycopy(untypedResult, 0, typedResult, 0, untypedResult.length);
            if (this.multiSelect || typedResult.length <= 1) {
                this.setSelection(typedResult);
                this.setResult(Arrays.asList(typedResult));
            } else {
                String setId = this.getAggregateIdForSets(typedResult);
                IWorkingSetManager workingSetManager = this.workbenchWindow.getWorkbench().getWorkingSetManager();
                IWorkingSet aggregate = workingSetManager.getWorkingSet(setId);
                if (aggregate != null) {
                    workingSetManager.removeWorkingSet(aggregate);
                }
                aggregate = workingSetManager.createAggregateWorkingSet(setId, WorkbenchMessages.WorkbenchPage_workingSet_multi_label, typedResult);
                workingSetManager.addWorkingSet(aggregate);
                this.setSelection(new IWorkingSet[]{aggregate});
                this.setResult(Collections.singletonList(aggregate));
            }
        }
        super.okPressed();
    }

    private String getAggregateIdForSets(IWorkingSet[] typedResult) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Aggregate:");
        IWorkingSet[] iWorkingSetArray = typedResult;
        int n = typedResult.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet element = iWorkingSetArray[n2];
            buffer.append(element.getName()).append(':');
            ++n2;
        }
        return buffer.toString();
    }

    private void restoreAddedWorkingSets() {
        IWorkingSetManager manager = WorkbenchPlugin.getDefault().getWorkingSetManager();
        Iterator<IWorkingSet> iterator = this.getAddedWorkingSets().iterator();
        while (iterator.hasNext()) {
            manager.removeWorkingSet(iterator.next());
        }
    }

    private void restoreChangedWorkingSets() {
        for (IWorkingSet editedWorkingSet : this.getEditedWorkingSets().keySet()) {
            IWorkingSet originalWorkingSet = this.getEditedWorkingSets().get(editedWorkingSet);
            if (!editedWorkingSet.getName().equals(originalWorkingSet.getName())) {
                editedWorkingSet.setName(originalWorkingSet.getName());
            }
            if (Arrays.equals(editedWorkingSet.getElements(), originalWorkingSet.getElements())) continue;
            editedWorkingSet.setElements(originalWorkingSet.getElements());
        }
    }

    private void restoreRemovedWorkingSets() {
        IWorkingSetManager manager = WorkbenchPlugin.getDefault().getWorkingSetManager();
        Iterator<IWorkingSet> iterator = this.getRemovedWorkingSets().iterator();
        while (iterator.hasNext()) {
            manager.addWorkingSet(iterator.next());
        }
        iterator = this.getRemovedMRUWorkingSets().iterator();
        while (iterator.hasNext()) {
            manager.addRecentWorkingSet(iterator.next());
        }
    }

    @Override
    public void setSelection(IWorkingSet[] workingSets) {
        super.setSelection(workingSets);
        this.setInitialSelections(workingSets == null ? new Object[]{} : workingSets);
    }

    @Override
    protected void availableWorkingSetsChanged() {
        this.listViewer.setInput((Object)PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets());
        super.availableWorkingSetsChanged();
    }

    @Override
    protected void selectAllSets() {
        this.listViewer.setCheckedElements((Object[])PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets());
        this.buttonWindowSet.setSelection(false);
        this.buttonNoSet.setSelection(false);
        this.buttonSelectedSets.setSelection(true);
        this.updateButtonAvailability();
    }

    @Override
    protected void deselectAllSets() {
        this.listViewer.setCheckedElements(new Object[0]);
        this.buttonWindowSet.setSelection(false);
        this.buttonNoSet.setSelection(false);
        this.buttonSelectedSets.setSelection(true);
        this.updateButtonAvailability();
    }
}

